#include "kldap.h"

AttributeListPage::AttributeListPage(QWidget* parent, Kldapw* kldapw) : KldapPage(parent, kldapw)
{

  /*this->kldapw = kldapw;

  this->ldap = kldapw->getLDAP();
  this->dn = kldapw->getSelectedDN();*/

  if(strcmp(dn, "") == 0)
    {
      QMessageBox::warning(this, "kldap", "No Item selected.\n", "OK", 0);
      return;
    }

  QGridLayout* layout = new QGridLayout(this, 9, 4, 5);
  listBox = new QListBox(this);
  valuesListBox = new QListBox(this);
  QLabel* lblDN = new QLabel(dn, this);
  QLabel* lblValues = new QLabel("Values:", this);
  QLabel* lblAttributeName = new QLabel("Attribute:", this);
  QLabel* lblValueName = new QLabel("Value:", this);
  txtNewAttribute = new QLineEdit(this);
  txtNewValue = new QLineEdit(this);
  QPushButton* btnAddAttribute = new QPushButton("Add", this);
  QPushButton* btnDeleteAttribute = new QPushButton("Delete", this);
  QPushButton* btnAddValue = new QPushButton("Add", this);
  QPushButton* btnDeleteValue = new QPushButton("Delete", this);

  lblDN->setMaximumHeight(30);
  lblValues->setMaximumHeight(30);
  lblAttributeName->setMaximumHeight(30);
  lblValueName->setMaximumHeight(30);
  txtNewAttribute->setMaximumHeight(30);
  txtNewValue->setMaximumHeight(30);
  btnAddAttribute->setMaximumHeight(30);
  btnDeleteAttribute->setMaximumHeight(30);
  btnAddValue->setMaximumHeight(30);
  btnDeleteValue->setMaximumHeight(30);
    
  layout->addMultiCellWidget(lblDN, 0, 0, 0, 3);
  layout->addMultiCellWidget(listBox, 1, 3, 0, 3);
  layout->addWidget(lblAttributeName, 4, 0);
  layout->addWidget(txtNewAttribute, 4, 1);
  layout->addWidget(btnAddAttribute, 4, 2);
  layout->addWidget(btnDeleteAttribute, 4, 3);
  layout->addWidget(lblValues, 5, 0);
  layout->addMultiCellWidget(valuesListBox, 6, 7, 0, 3);
  layout->addWidget(lblValueName, 8, 0);
  layout->addWidget(txtNewValue, 8, 1);
  layout->addWidget(btnAddValue, 8, 2);
  layout->addWidget(btnDeleteValue, 8, 3);

  show();

  QObject::connect(listBox, SIGNAL(highlighted(int)), this, SLOT(displayValues(int)));
  QObject::connect(btnAddAttribute, SIGNAL(clicked()), this, SLOT(addAttribute()));
  QObject::connect(btnDeleteAttribute, SIGNAL(clicked()), this, SLOT(deleteAttribute()));
  QObject::connect(btnAddValue, SIGNAL(clicked()), this, SLOT(addValue()));
  QObject::connect(btnDeleteValue, SIGNAL(clicked()), this, SLOT(deleteValue()));

  fillList();
}

void AttributeListPage::fillList()
{
  //LDAP* ldap = kldapw->getLDAP();
  LDAPMessage* result;
  LDAPMessage* ep;
  BerElement* ber;
  char* ap;
  char** entry;
  int error;

  error = ldap_search_s(ldap, dn, LDAP_SCOPE_BASE, "objectClass=*", NULL, 0, &result);

  if(error == 0)
    {
      for(ep = ldap_first_entry(ldap, result); ep != NULL; ep = ldap_next_entry(ldap, ep))
	{
	  for(ap = ldap_first_attribute(ldap, ep, &ber); ap != NULL; ap = ldap_next_attribute(ldap, ep, ber))
	    {
	      listBox->insertItem(ap);
	      entry = (char**)ldap_get_values(ldap, ep, ap);
	    }
	}
    }
  else
    {
      QMessageBox::warning(this, "kldap", ldap_err2string(error), "OK", 0);
    }      
}

void AttributeListPage::displayValues(int index)
{
  //LDAP* ldap = kldapw->getLDAP();
  LDAPMessage* result;
  LDAPMessage* ep;
  char** entry;
  int error;

  valuesListBox->clear();

  error = ldap_search_s(ldap, dn, LDAP_SCOPE_BASE, "objectClass=*", NULL, 0, &result);
  
  if(error == 0)
    {
      for(ep = ldap_first_entry(ldap, result); ep != NULL; ep = ldap_next_entry(ldap, ep))
	{
	  entry = (char**)ldap_get_values(ldap, ep, (char*)listBox->text(index));
	  
	  for(int i = 0; entry && entry[i] != NULL; i++)
	    {
	      valuesListBox->insertItem(entry[i]);
	    }
	}
    }
  else
    {
      QMessageBox::warning(this, "kldap", ldap_err2string(error), "OK", 0);
    }    
}

void AttributeListPage::addAttribute()
{
  char* mod_type;
  char* value;
  int error;

  value  = ""; // value = NULL geht nicht!
  mod_type = (char*)txtNewAttribute->text(); 

  error = kldapw->modify(dn, LDAP_MOD_ADD, mod_type, value);
  
  if(error == 0)
  {
    listBox->insertItem(txtNewAttribute->text()); 
  }
}

void AttributeListPage::deleteAttribute()
{
  char* mod_type;
  char* value;
  int error;

  if(listBox->currentItem() != -1)
    {

      value  = NULL;
      mod_type = (char*)listBox->text(listBox->currentItem());

      error = kldapw->modify(dn, LDAP_MOD_DELETE, mod_type, value);

      if(error == 0)
	{
	  listBox->removeItem(listBox->currentItem());  
	}
    }
  else
    {
      QMessageBox::warning(this, "kldap", "You have to select an item", "OK", 0);
    }
}

void AttributeListPage::addValue()
{
  char* mod_type;
  char* value;
  int error;

  value  = (char*)txtNewValue->text();
  mod_type = (char*)listBox->text(listBox->currentItem());
  cout << "mod_type: " << mod_type << "\n";

  error = kldapw->modify(dn, LDAP_MOD_ADD, mod_type, value);

  if(error == 0)
  {
    valuesListBox->insertItem(txtNewValue->text());  
  }
}

void AttributeListPage::deleteValue()
{
  char* mod_type;
  char* value;
  int error;

  if(valuesListBox->currentItem() != -1)
    {
      value = (char*)valuesListBox->text(valuesListBox->currentItem());
      mod_type = (char*)listBox->text(listBox->currentItem());
      cout << "mod_type: " << mod_type << "\n";
      
      error = kldapw->modify(dn, LDAP_MOD_DELETE, mod_type, value);
      
      if(error == 0)
	{  
	  valuesListBox->removeItem(valuesListBox->currentItem());  
	}
    }
  else
    {
      QMessageBox::warning(this, "kldap", "You have to select an item", "OK", 0);
    }
}
