#include "kldap.h"

ConnectPage::ConnectPage(QWidget* parent, Kldapw* kldapw) : KldapPage(parent, kldapw)
{
  filename = kapp->localconfigdir();
  filename = filename.append("/kldaprc_conn");

  QGridLayout* layout = new QGridLayout(this, 12, 2, 5);

  listBox = new QListBox(this);
  
  txtName = new QLineEdit(this);
  txtHost = new QLineEdit(this);
  txtPort = new QLineEdit(this);
  txtRootDN = new QLineEdit(this);
  txtBindAs = new QLineEdit(this);
  txtPassword = new QLineEdit(this);
  QLabel* lblName = new QLabel("Name", this);
  QLabel* lblHost = new QLabel("Host", this);
  QLabel* lblPort = new QLabel("Port", this);
  QLabel* lblRootDN = new QLabel("Root DN", this);
  QLabel* lblBindAs = new QLabel("Bind as", this);
  QLabel* lblAuth = new QLabel("Authentication", this);
  QLabel* lblPassword = new QLabel("Password", this);
  QPushButton* btnConnect = new QPushButton("Connect", this);
  QPushButton* btnSave = new QPushButton("Save", this);
  QPushButton* btnLoadConfiguration = new QPushButton("Load", this);
  QPushButton* btnRemoveEntry = new QPushButton("Remove", this);
  cmbAuth = new QComboBox(this); 

  cmbAuth->insertItem("Simple", 0);
  cmbAuth->insertItem("Kerberos 4.1", 1);
  cmbAuth->insertItem("Kerberos 4.2", 2);

  txtPort->setText("389");
  
  txtName->setMaximumHeight(30);
  txtHost->setMaximumHeight(30);
  txtPort->setMaximumHeight(30);
  txtRootDN->setMaximumHeight(30);
  txtBindAs->setMaximumHeight(30);
  txtPassword->setMaximumHeight(30);
  lblHost->setMaximumHeight(30);
  lblPort->setMaximumHeight(30);
  lblRootDN->setMaximumHeight(30);
  lblBindAs->setMaximumHeight(30);
  lblAuth->setMaximumHeight(30);
  lblPassword->setMaximumHeight(30);
  btnConnect->setMaximumHeight(30);
  btnSave->setMaximumHeight(30);
  btnLoadConfiguration->setMaximumHeight(30);
  //btnLoadConfiguration->setMaximumWidth(30);
  btnRemoveEntry->setMaximumHeight(30);
  cmbAuth->setMaximumHeight(30);

  txtPassword->setEchoMode(QLineEdit::Password);
  
  layout->addWidget(lblName, 0, 0);
  layout->addWidget(lblHost, 1, 0);
  layout->addWidget(lblPort, 2, 0);
  layout->addWidget(lblRootDN, 3, 0);
  layout->addWidget(lblBindAs, 4, 0);
  layout->addWidget(lblAuth, 5, 0);
  layout->addWidget(lblPassword, 6, 0);
  
  layout->addWidget(txtName, 0, 1);
  layout->addWidget(txtHost, 1, 1);
  layout->addWidget(txtPort, 2, 1);
  layout->addWidget(txtRootDN, 3, 1);
  layout->addWidget(txtBindAs, 4, 1);
  layout->addWidget(cmbAuth, 5, 1);
  layout->addWidget(txtPassword, 6, 1);

  layout->addWidget(btnSave, 7, 1);
  layout->addWidget(btnLoadConfiguration, 8, 1);
  layout->addWidget(btnRemoveEntry, 9, 1);
  layout->addWidget(btnConnect, 11, 1);

  layout->addMultiCellWidget(listBox, 7, 11, 0, 0);
  fillList();

  QObject::connect(btnConnect, SIGNAL(clicked()), this, SLOT(connect()));
  QObject::connect(btnSave, SIGNAL(clicked()), this, SLOT(save()));
  QObject::connect(listBox, SIGNAL(selected(int)), this, SLOT(loadConfiguration(int)));
  QObject::connect(btnLoadConfiguration, SIGNAL(clicked()), this, SLOT(loadConfiguration()));
  QObject::connect(btnRemoveEntry, SIGNAL(clicked()), this, SLOT(removeEntry()));

  show();  
}

void ConnectPage::fillList()
{
  QFile file(filename);
  QString s;
  
  listBox->clear();
  
  if(file.open(IO_ReadOnly))
    {
      QTextStream t(&file);
      while(! t.eof())
	{
	  s = t.readLine();
	  QString temp = s.stripWhiteSpace();
	  int sIndex = 0;
	  int sPos;
	  QString result;

	  if(strcmp(temp.left(1), "#") != 0) // Kein # am Anfang
	    {
	      sPos = s.find("\t", sIndex);
	      result = s.mid(sIndex, (sPos - sIndex));
	      
	      if(strcmp(result, "") != 0 && result != NULL)
		{
		  //listBox->insertItem(result);
		  listBox->inSort(result);
		}
	      sIndex = sPos + 1;
	    }
	}
    }
  file.close();
}

void ConnectPage::loadConfiguration()
{
  int index = listBox->currentItem();
  loadConfiguration(index);
}

void ConnectPage::loadConfiguration(int index)
{
  QFile file(filename);
  QString s;
  QString config[7];
  //int index = listBox->currentItem();
  
  if(file.open(IO_ReadOnly))
    {
      QTextStream t(&file);
      while(! t.eof())
	{
	  s = t.readLine();
	  QString temp = s.stripWhiteSpace();
	  int sIndex = 0;
	  int sPos;
	  QString result;
	  int count = 0;
	  
	  sPos = s.find("\t", sIndex);
	  if(strcmp(s.left(sPos), listBox->text(index))==0)
	    {
	      if(strcmp(temp.left(1), "#")) // Kein # am Anfang
		{
		  if(strcmp(s.right(1), "\t") != 0) s.append("\t");
		  
		  // Schleiffe solange bis kein "\t" mehr gefunden  gefunden
		  while((sPos = s.find("\t", sIndex)) != -1)
		    {
		      result = s.mid(sIndex, (sPos - sIndex));
		      
		      if((strcmp(result, "")!=0 && result != NULL))
			{
			  if(strcmp(result, "*")==0)
			    {
			      config[count] = "";
			    }
			  else
			    {
			      config[count] = result;
			    }
			  count++;
			}
		      sIndex = sPos + 1;
		    }
		}
	    }
	}

      /* Configuration anzeigen */
      txtName->setText(config[0]);
      txtHost->setText(config[1]);
      txtPort->setText(config[2]);
      txtRootDN->setText(config[3]);
      txtBindAs->setText(config[4]);  
      cmbAuth->setCurrentItem(config[5].toInt());
      txtPassword->setText(config[6]);
    }
  file.close();
}

void ConnectPage::removeEntry()
{
  int index = listBox->currentItem();
  removeEntry(index);
}

void ConnectPage::removeEntry(int index)
{
  QFile file(filename);
  QString s;
  QString str;
  //int index = listBox->currentItem();
  QString key = listBox->text(index);
  
  if(file.open(IO_ReadWrite))
    {
      QTextStream t(&file);

      while(! t.eof())
	{
	  s = t.readLine();
	  QString temp = s.stripWhiteSpace();
	  int sIndex = 0;
	  int sPos;
	  QString result;
	  
	  sPos = s.find("\t", sIndex);

	  //cout << "s = " << s;

	  if(strcmp(s.left(sPos), listBox->text(index)) != 0)
	    {
	      //n << s;
	      str.append(s);
	      str.append("\n");
	    }
	}
      file.flush();
    }
  file.close();

  if(file.open(IO_WriteOnly))
    {
      file.writeBlock(str, str.length());
      file.flush();
    }
  file.close();
  fillList();
}

void ConnectPage::connect()
{
  bool success;
  int auth;

  success = kldapw->connect((char*)txtHost->text(), (new QString(txtPort->text()))->toInt(), (char*)txtRootDN->text());

  if(success == true) 
    {
      switch(cmbAuth->currentItem())
	{
	case 0:
	  auth = LDAP_AUTH_SIMPLE;
	  break;
	case 1:
	  auth = LDAP_AUTH_KRBV41;
	  break;
	case 2:
	  auth = LDAP_AUTH_KRBV42;
	  break;
	default:
	  auth = LDAP_AUTH_SIMPLE;
	}

      kldapw->bind((char*)txtBindAs->text(), (char*)txtPassword->text(), auth);
    }
}

void ConnectPage::save()
{
  for(unsigned int i = 0; i < listBox->count(); i++)
    {
      if(strcmp(listBox->text(i), txtName->text())==0) removeEntry(i);
    }

  QFile file(filename);
  
  if(file.open(IO_Append | IO_ReadWrite))
    {
      QTextStream t(&file);

      writeValue(&t, txtName->text());
      writeValue(&t, txtHost->text());
      writeValue(&t, txtPort->text());
      writeValue(&t, txtRootDN->text());
      writeValue(&t, txtBindAs->text());
      writeValue(&t, (QString("")).sprintf("%d", cmbAuth->currentItem())); // Vielleicht ginge es auch etwas weniger kompliziert? Ich will ANSI C++ !!! Bhhhh
      writeValue(&t, txtPassword->text());
      t << "\n";

      file.flush();
      file.close();
      fillList();
      }
}

void ConnectPage::writeValue(QTextStream* t, const char* value)
{
  if(strcmp(value, "")==0) 
    value = "*";

  *t << value << "\t";
}
