/***************************************************************************
                          kmasqdialer.cpp  -  description
                             -------------------
    begin                : Tue Aug 24 01:15:56 BST 1999
    copyright            : (C) 1999 by Darren Poulson
    email                : daz@flapper.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "kmasqdialer.h"

KDockDialer		*dockdialer;


Kmasqdialer::Kmasqdialer(QWidget*parent,const char* name):KTopLevelWidget(){

//Kmasqdialer::Kmasqdialer(){
  config = KApplication::getKApplication()->getConfig();
  KIconLoader *il = kapp->getIconLoader();

	server = new MClient();
	cconfig = new ClientConfig();
  dockdialer = new KDockDialer();
	statusbar = new KStatusBar(this);
	servername = new KLined(this);
	serverport = new KLined(this);
	connections = new QComboBox(this);
	
  KWM::setDockWindow( dockdialer->winId() );

//	dockdialer->setGeometry(100,100,15,15);
	dockdialer->setIcon(il->loadIcon("kmasqdialer-dock1.xpm"));
  dockdialer->dock();


	connect(server, SIGNAL(NewConnection(const char *)), this, SLOT(slotAddConnection(const char *)));
	connect(server, SIGNAL(ServerStatus(const char *)), this, SLOT(slotSetStatusMsg(const char *)));
	connect(server, SIGNAL(DialedOut(bool)), dockdialer, SLOT(slotChangeDialButton(bool)));
	connect(dockdialer, SIGNAL(quitClicked()), this, SLOT( slotFileQuit() ) );
	connect(dockdialer, SIGNAL(dialClicked()), this, SLOT( slotConnectDial() ) );


	/************************************************
	*
	* Set up the menu bar and menus
	*/

	// Server menu...

	servermenu = new QPopupMenu;
	servermenu->insertItem(i18n("&Connect"), this, SLOT( slotServerConnect() ) );
	servermenu->insertItem(i18n("&Disconnect"), this, SLOT( slotServerDisConnect() ) );
	servermenu->insertItem(i18n("&Info"), this, SLOT( slotServerCInfo() ) );
	servermenu->insertItem(i18n("Con&figure"), cconfig, SLOT( show() ) );
	servermenu->insertSeparator();
	servermenu->insertItem(i18n("&Quit") ,this, SLOT( slotFileQuit() ) );

	// Connection menu...

	connectionmenu = new QPopupMenu;
	connectionmenu->insertItem(i18n("&Dial"), this, SLOT( slotConnectDial() ) );
	connectionmenu->insertItem(i18n("&Hangup"), this, SLOT( slotConnectHangup() ) );

	// Help Menu...

  QString aboutstring=kapp->appName()+" "+VERSION+"\nAuthor: Darren Poulson\ndaz@flapper.demon.co.uk";
	helpmenu = new QPopupMenu;
	helpmenu = kapp->getHelpMenu(true, aboutstring );
	helpmenu->insertItem(i18n("About &QT"), this, SLOT(slotAboutQt()));

	// Menu bar...

	menubar = new KMenuBar( this );
	menubar->insertItem(i18n("&Server"), servermenu);
	menubar->insertItem(i18n("&Connection"), connectionmenu);
	menubar->insertSeparator();
	menubar->insertItem(i18n("&Help"), helpmenu);

	serverport->setGeometry(this->width() - 45, menubar->height() + menubar->y() + 10, 35, 20);
	servername->setGeometry(10, serverport->y(), this->width() - ((20) + serverport->width()), 20);

	serverport->setText(config->readEntry("serverport"));
	servername->setText(config->readEntry("servername"));

  connections->setGeometry(10, servername->y() + servername->height(), this->width() - (20), 20);

  /*************************************************
	*
	* Set up the status bar
	*/

	statusbar->setBorderWidth(5);
	statusbar->insertItem("Ready.                          ",1000);
//	setStatusBar(statusbar);
//	enableStatusBar();


	/************************************************
	*
	* Do we want to auto connect to the server?
	*/
  if (config->readBoolEntry("autoconnect"))
  {
	  slotServerConnect();
	}


	/************************************************
	*
	* Do we want to auto dial a connection?
	*/
	if (config->readBoolEntry("autodial"))
	{
		server->Dial(config->readEntry("autodialname"));

	}

}

Kmasqdialer::~Kmasqdialer(){
}

void Kmasqdialer::resizeEvent (QResizeEvent *)
{
  statusbar->setGeometry(0, this->height() - statusbar->height(), this->width(), statusbar->height());
	serverport->setGeometry(this->width() - 45, menubar->height() + menubar->y() + 10, 35, 20);
	servername->setGeometry(10, serverport->y(), this->width() - ((20) + serverport->width()), 20);
  connections->setGeometry(10, servername->y() + servername->height(), this->width() - (20), 20);
	
}



void Kmasqdialer::slotAboutQt(){
	QMessageBox::aboutQt(this , "About Qt");
}


void Kmasqdialer::slotFileQuit()
{
	slotSetStatusMsg("Quitting...");
  int want_quit = KMsgBox::yesNo(this, "Are You Sure?", "Do you Really\n want to quit?");
  switch(want_quit) {
  case 1:
				server->sendQuit();
        kapp->quit();
        break;
  case 2:
        break;
  default:
        break;
 }

}

/**  */
void Kmasqdialer::slotConnectDial(){

if (connections->currentItem() == -1 && connections->count() != 0)
	{
  	connections->setCurrentItem(0);
	}
  server->Dial(connections->text(connections->currentItem()));

}

/**  */
void Kmasqdialer::slotConnectHangup(){

	server->Kill();
}


/**  */
void Kmasqdialer::slotServerConnect(){

	if ( server->isConnected() )
	{
		statusbar->message("Already connected!",1000);
	}
	else
	{
		server->ServerConnect(servername->text(), serverport->text());
		server->List();
		/************************************************
		*
		* Do we want to automatically send user name
		* and password for authorization?
		*/
		if (config->readBoolEntry("autoauth"))
		{
		  server->getAuth(config->readEntry("username"),config->readEntry("userpassword"));
		}		
	}
}

/**  */
void Kmasqdialer::slotServerDisConnect(){

	if ( server->isConnected() )
	{
		server->ServerConnect("","");
		connections->clear();
 	}
	else
	{
		statusbar->message("Not Connected.",1000);
	}
}


/**  */
void Kmasqdialer::slotAddConnection(const char *cname){

        connections->insertItem (cname, -1);

}

void Kmasqdialer::slotSetStatusMsg(const char *msg) {

		statusbar->message(msg,1000);
		dockdialer->setToolTip(msg);

}

/**  */
void Kmasqdialer::slotServerCInfo(){

 	if ( server->isConnected() )
	{
	int i;
	QString *temp = new QString();
	KConnectionInfo *cinfo = new KConnectionInfo(0, "CInfo");
		for ( i = 0 ; i < connections->count() ; i++)
		{
			 temp = server->readCInfo(connections->text(i));
       cinfo->addInfoTab(connections->text(i), temp->data(), i);
		}
	cinfo->showAll();
	
 	}
	else
	{
		statusbar->message("Not Connected.",1000);
	}


}





























