/***************************************************************************
                          knetstartview.cpp  -  A simple netconfig tool
                             -------------------
    begin                : Thu Sep 30 20:48:28 CDT 1999
    copyright            : (C) 1999 by Federico David Sacerdoti
    email                : fds@slinuxmachines.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qregexp.h>
#include <qpalette.h>
#include <qcolor.h>

// application specific includes
#include <iostream.h>
#include <knetstartview.h>
#include "knetstartdoc.h"
#include "knetstart.h"
#include "newwidget.h"
#include "macros.h"
#include "netmap.h"
#include "ipinput.h"
#include <unistd.h>
#include <sys/wait.h>



KnetstartView::KnetstartView(QWidget *parent, const char* name)
	: QWidget(parent, name)
{
	//setBackgroundMode( PaletteBase );
	
 	QGridLayout *t1 = new QGridLayout( this, 5, 3, 10);
	t1->addRowSpacing(0, fontMetrics().lineSpacing() -10); //magic

	if (geteuid() != 0) {
 		QLabel *label1 = newLabel( i18n("This tool must be run as root for safety reasons.\n\n\
You are not root, Sorry."), this);
		MIN_WIDTH(label1);
		FIXED_HEIGHT(label1);
		t1->addWidget (label1, 0, 0);
		emit statusMsg("Not Ready.");
	} else {
	
	QLabel *label0 = newLabel( i18n("Ethernet Setup"), this);
	label0->setFont( QFont( "Times", 18, QFont::Bold ) );
	FIXED_HEIGHT(label0);
	FIXED_WIDTH(label0);
	t1->addWidget (label0, 0, 0);
	
	dhcp = newCheckBox ( i18n("Get info from server (DHCP)"), this);
	dhcp->setChecked(getDocument()->useDhcp());
	//MIN_WIDTH(dhcp);
	//FIXED_WIDTH(dhcp);
	t1->addWidget (dhcp, 0, 1, AlignRight);
	
	connect (dhcp, SIGNAL(toggled(bool)), getDocument(), SLOT(slotDhcp(bool)) );
	
	QLabel *label1 = newLabel( i18n("IP Address:"), this);
	//MIN_WIDTH(label1);
	//FIXED_WIDTH(label1);
	t1->addWidget (label1, 1, 0);
	
	ip = new IPinput( this );
	ip->setText( getDocument()->getIp() );
	//De-activate all fields if DHCP box is checked
	ip->setEnabled( !getDocument()->useDhcp() );
	t1->addWidget(ip, 1, 1);
	
	QLabel *label2 = newLabel(i18n("Gateway (Router):"), this);
	//MIN_WIDTH(label2);
	//FIXED_WIDTH(label2);
	t1->addWidget(label2, 2, 0);
	
	gateway = new IPinput(this);
	gateway->setText( getDocument()->getGateway() );
	gateway->setEnabled( !getDocument()->useDhcp() );
	t1->addWidget(gateway, 2, 1);
	
	QLabel *label3 = newLabel(i18n("Name Server:"), this);
	//MIN_WIDTH(label3);
	//FIXED_WIDTH(label3);
	t1->addWidget(label3, 3, 0);
	
	ns = new IPinput(this);
	ns->setText( getDocument()->getNs() );
	ns->setEnabled( !getDocument()->useDhcp() );
	t1->addWidget(ns, 3, 1);
	
	go = new QPushButton(i18n("Connect to net"), this);
	FIXED_HEIGHT(go);
	MIN_WIDTH(go);
	t1->addWidget(go, 4, 1);
	
	connect (go, SIGNAL(clicked()), SLOT(slotGo()));
	
	//Add netmap widget on right side
	nmap = new netmap(this, "nmap");
	t1->addMultiCellWidget(nmap, 1, 4, 2, 2);

  	//t1->addColSpacing(0, label0->sizeHint().width() + 75);
  	//t1->addColSpacing(1, dhcp->sizeHint().width() + 75);
  	//t1->addColSpacing(2, 500);
  }
  t1->activate();

}

KnetstartView::~KnetstartView(){
}


void KnetstartView::slotGo ()
{
	nmap->resetMap();
	
	if (getDocument()->useDhcp()) {
		 emit statusMsg("If this takes a long time, it means something is wrong with the DHCP server.");
		 getDocument()->pumpUpTheDhcp();
	}
	else {
		//Get IP strings, least important first.
  	QString sIp = ip->getIP();
		if (sIp == "Bad address") {
			emit statusMsg(i18n("That's a bad IP address, check it again."));
			return;
		}
	
		QString sGateway = gateway->getIP();
		if (sGateway == "Bad address") {
			emit statusMsg(i18n("That's a bad Gateway address, check it again."));
			return;
		}
	
		QString sNs = ns->getIP();
		if (sNs == "Bad address") {
			emit statusMsg(i18n("That's a bad Name server address, check it again."));
			return;
		}
		
		//Tell the doc class to punch in the Gateway and Nameserver
		getDocument()->commitNetConfig(sGateway, sNs);
	
		//Configure the ethernet card with the new IP address
		getDocument()->commitEthConfig(sIp);

		//Activate the network settings by running the /etc/rc.d/init.d/network start script
		emit statusMsg("Setting up ethernet, please wait...");
		getDocument()->activateNet();
	}
	
	return;
}


void KnetstartView::slotDhcp (bool dhcpState)
{
	// Enabled state of input lines should be opposide of DHCP
	ip->setEnabled( !dhcpState );
	gateway->setEnabled( !dhcpState );
	ns->setEnabled( !dhcpState );
}	

KnetstartDoc* KnetstartView::getDocument() const
{
	KnetstartApp* theApp=(KnetstartApp*)parentWidget();
	return theApp->getDocument();
}

void KnetstartView::slotUsePubNs (const char* pubns)
{
	ns->setText(pubns);
}

void KnetstartView::print(QPrinter* m_pPrinter)
{
	QPainter printpainter;
	printpainter.begin(m_pPrinter);
	
	// TODO: add your printing code here
	
	printpainter.end();

}










































































































































































































