/* ------------------------------------------------------------- 

    toplevel.cpp (part of K News Grabber)

    (C) 1999 by Cengiz Tuztas

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Cengiz.Tuztas@uni-essen.de

    $Id: toplevel.cpp,v 1.5 1999/05/03 18:04:43 ctuztas Exp $

   ------------------------------------------------------------- */

#include "toplevel.h"

TopLevel::TopLevel()
  : KTMainWindow()
{
  mainView = new View( this );
  setupMenuBar();
  setupStatusBar();
  setupToolBar();
  setView(mainView);
}

void TopLevel::setupMenuBar()
{
  menubar = new KMenuBar(this);

  fileMenu = new QPopupMenu();
  optionsMenu = new QPopupMenu();
  helpMenu = new QPopupMenu();

  // File Menu Entries

  newgrpID = fileMenu->insertItem( i18n( "&New Group" ));
  delgrpID = fileMenu->insertItem( i18n( "&Delete Group"));
  modgrpID = fileMenu->insertItem( i18n( "&Modify Group"));
  fileMenu->insertSeparator();
  prcgrpID = fileMenu->insertItem( i18n( "&Process Group"));
  prcallID = fileMenu->insertItem( i18n( "Process &all"));
  fileMenu->insertSeparator();
  schedID   = fileMenu->insertItem( i18n( "&Schedule" ));
  fileMenu->insertSeparator();
  quitID   = fileMenu->insertItem( i18n("&Quit") );

  // File Menu Connections

  fileMenu->connectItem( newgrpID, mainView, SLOT( newgrp() ) );
  fileMenu->connectItem( delgrpID, mainView, SLOT( delgrp() ) );
  fileMenu->connectItem( modgrpID, mainView, SLOT( modgrp() ) );
  fileMenu->connectItem( prcgrpID, mainView, SLOT( prcgrp() ) );
  fileMenu->connectItem( prcallID, mainView, SLOT( prcall() ) );
  fileMenu->connectItem( schedID,  mainView, SLOT( schedule() ) );
  //  fileMenu->setAccel( CTRL+Key_N, newgrpID );
  //  fileMenu->setAccel( CTRL+Key_D, delgrpID);
  //  fileMenu->setAccel( CTRL+Key_M, modgrpID );
  //  fileMenu->setAccel( CTRL+Key_P, prcgrpID );
  //  fileMenu->setAccel( CTRL+Key_A, prcallID );
  //  fileMenu->setAccel( CTRL+Key_S, schedID );
  //  fileMenu->setAccel( CTRL+Key_Q, quitID );

  fileMenu->connectItem( quitID, this, SLOT(confirmQuit()) );

  menubar->insertItem(i18n("&File"), fileMenu);

  // Options Menu Entries

  settID = optionsMenu->insertItem( i18n( "Settings" ));
  clrID  = optionsMenu->insertItem( i18n( "Clear Hash" ));

  // Options Menu Connections

  optionsMenu->connectItem( settID, mainView, SLOT( settings() ) );
  optionsMenu->connectItem( clrID,  mainView, SLOT( deletehash() ) );
  //  optionsMenu->setAccel( CTRL+Key_E, settID );

  menubar->insertItem( i18n("&Options"), optionsMenu);

  menubar->insertSeparator(-1);

  // Help Menu Entries

  contentsID = helpMenu->insertItem( i18n( "&Contents" )     );
  helpMenu->insertSeparator();
  aboutID    = helpMenu->insertItem( i18n( "&About kng ..." ));
  aboutKDEID = helpMenu->insertItem( i18n( "About &KDE..." ) );

  // Help Menu Connections

  helpMenu->connectItem( contentsID, kapp, SLOT( appHelpActivated() ));
  helpMenu->setAccel(Key_F1,contentsID);
  helpMenu->connectItem( aboutID, this, SLOT( aboutApp() ) );
  helpMenu->connectItem( aboutKDEID, kapp,SLOT( aboutKDE() ));

  menubar->insertItem( i18n("&Help") , helpMenu);

  setMenu(menubar);

}

void TopLevel::setupToolBar()
{
  iconLoader = kapp->getIconLoader();
  toolbar = new KToolBar(this);

  addToolBar(toolbar);

  // Entries from Menu File

  toolbar->insertButton( iconLoader->loadIcon( "exit.xpm" ), ID_QUIT,
                        SIGNAL(clicked()), this, SLOT(confirmQuit()),
                        true, i18n( "Exit kng" ) );
  toolbar->insertButton( iconLoader->loadIcon( "tick.xpm" ), ID_NEWGRP,
                        SIGNAL(clicked()), mainView, SLOT( newgrp() ),
                        true, i18n( "New Group" ) );
  toolbar->insertButton( iconLoader->loadIcon( "delete.xpm" ), ID_DELGRP,
                        SIGNAL(clicked()), mainView, SLOT( delgrp() ),
                        true, i18n( "Delete Group" ) );
  toolbar->insertButton( iconLoader->loadIcon( "tick.xpm" ), ID_MODGRP,
                        SIGNAL(clicked()), mainView, SLOT( modgrp() ),
                        true,i18n( "Modify Group" ) );
  toolbar->insertButton( iconLoader->loadIcon( "rungrp.xpm" ), ID_PRCGRP,
                        SIGNAL(clicked()), mainView, SLOT( prcgrp() ),
                        true, i18n( "Process Group" ) );
  toolbar->insertButton( iconLoader->loadIcon( "kworldwatch.xpm" ), ID_PRCALL,
                        SIGNAL(clicked()), mainView, SLOT( prcall() ),
                        true, i18n( "Process all Groups" ) );
  toolbar->insertButton( iconLoader->loadIcon( "schedule.xpm" ), ID_SCHED,
                        SIGNAL(clicked()), mainView, SLOT( schedule() ),
                        true, i18n( "Schedule for Processing" ) );

  toolbar->insertSeparator();

  // Entries from Menu Options

  toolbar->insertButton( iconLoader->loadIcon( "settings.xpm" ), ID_SETT,
                        SIGNAL(clicked()), mainView, SLOT( settings() ),
                        true, i18n( "Settings" ) );
  toolbar->insertSeparator();

  // Entries from Menu Help

  toolbar->insertButton(iconLoader->loadIcon("help.xpm"),ID_HELP,
                        SIGNAL(pressed()), kapp, SLOT(appHelpActivated()),
                        true, i18n( "Help") );

}

void TopLevel::setupStatusBar()
{
  statusbar = new KStatusBar(this);
  setStatusBar(statusbar);
}


void TopLevel::aboutApp()
{
  QMessageBox::about(this, i18n("About kng 0.1"), i18n("A program by Cengiz Tuztas"));
}

void TopLevel::confirmQuit()
{
  int ret = QMessageBox::warning( this, i18n("K News Grabber"),
                                  i18n("Do you reallay want to quit ?"), "OK", "Cancel" );
  if ( ! ret )
    {
      // Button0 ==> Confirmed
      mainView->writeConfig();
      kapp->quit();
    }
}

void TopLevel::dummy()
{
}
