/***************************************************************************
                          knfiltermanager.h  -  description
                             -------------------
    
    copyright            : (C) 1999 by Christian Thurner
    email                : cthurner@freepage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KNFILTERMANAGER_H
#define KNFILTERMANAGER_H

#include <qobject.h>
#include <qpushbutton.h>
#include <qsemimodal.h>
#include <qpopupmenu.h>
#include "knmessagefilter.h"
#include "knlistbox.h"



class KNFilterListDialog : public QSemiModal {
	
	Q_OBJECT	

	public:
		KNFilterListDialog(QWidget *parent=0, const char *name=0);
		~KNFilterListDialog();
		
		void addItem(KNMessageFilter *f);
		void addMenuItem(KNMessageFilter *f);
		void removeItem(KNMessageFilter *f);
		void removeMenuItem(KNMessageFilter *f);
		void updateItem(KNMessageFilter *f);
		
		int* menuOrder();
				
 	
	protected:
		KNListBox *list1, *list2;
		int findItem(KNListBox *l, KNMessageFilter *f);
			
	protected slots:
		void slotButtons1(int id);
		void slotButtons2(int id);
		
		void slotList1Selected(int id);
		
		void slotCloseBtn();
		void slotHelpBtn();
			
	
	signals:
		void newFilter();
		void delFilter(KNMessageFilter *);
		void editFilter(KNMessageFilter *);
		void dialogDone();
			
};


class KNFilterManager : public QObject{


	Q_OBJECT

	public:
		KNFilterManager();
		~KNFilterManager();
		
		KNMessageFilter* setFilter(const int id);
		KNMessageFilter* currentFilter()	{ return currFilter; }
		void showDialog();
		QPopupMenu* pUpMenu()	{ return menu; }
	
					
	protected:
		void loadFilters();
		void saveMenuOrder();
		void addFilter(KNMessageFilter *f);
		KNMessageFilter* byID(int id);
		void editFilter(KNMessageFilter *f);
		bool nameIsOK(KNMessageFilter *f);
		void updateMenu();
		
		QList<KNMessageFilter> *fList;
		KNFilterListDialog *dlg;
	  int nextID;
	  KNMessageFilter *currFilter;
		QPopupMenu *menu;
		int *menuOrder;
		
	
	protected slots:
		void slotNew();
		void slotDel(KNMessageFilter *f);
		void slotEdit(KNMessageFilter *f);
		void slotEditDone(KNFilterDialog *d);
		void slotDialogDone();
		void slotMenuActivated(int id);
		
			
	signals:
		void filterChanged(KNMessageFilter *f); 		
		
};

#endif

















