/***************************************************************************
                     knfoldermanager.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNFOLDERMANAGER_H
#define KNFOLDERMANAGER_H

#include <qlistview.h>
#include "knfolderentry.h"
#include "knpostheaderlist.h"

class KNPostingManager;


class KNFolderManager {
	
	friend class KNPostingManager;

	public:
		
		KNFolderManager(QListView *v, KNPostingManager *p=0);
		~KNFolderManager();
		void saveYourself();
		void setPManager(KNPostingManager *p)	{ pManager=p; }
				
		bool setCurrent(KNEntryBase *c);
		KNFolderEntry* current()	{ return c_urrent; }
				
		KNFolderEntry* drafts()		{ return fList->at(2); }
		KNFolderEntry* outbox()		{ return fList->at(1); }
		KNFolderEntry* sent()			{ return fList->first(); }
		//KNFolderEntry* trash()		{ return fList->at(3); }
		KNFolderEntry* getFolderById(int id);
				
		void addFolder(KNFolderEntry *folder, bool updList=true);
		void removeFolder(KNFolderEntry *f=0) { }
		void emptyFolder(KNFolderEntry *f=0);
				
		void movePosting(KNPostHeader *h, KNFolderEntry *f=0);
		
		KNPostHeader *initIterator(KNFolderEntry *f=0);
		KNPostHeader *nextInFolder();			
	
	protected:
		void loadIndex();
		void rewriteIndex();
		void syncIndex();
		
		void showListItems();
	
	
		QList<KNFolderEntry> *fList;
		KNFolderEntry *c_urrent;
		KNPostHeaderList hList;
		uint count, itPOS;
		int lastID, itFID;
		KNPostingManager *pManager;
		QListView *view;
		
		
		struct indexData {
			
			void setData(KNPostHeader *h)
			{
				id=h->id;
				fID=h->folderID;
				//isSent=h->isSent;
			}
			
			uint id, fID;
			//bool isSent;
		};		
	
};

#endif
























