/***************************************************************************
                     kngroupentry.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kngroupentry.h"
#include "knentryviewitem.h"
#include "knhdrviewitem.h"
#include "utilities.h"
#include "knglobals.h"
#include "knstringsplitter.h"
#include "knthread.h"
#include "knscoredialog.h"
#include <stdio.h>
#include <ksimpleconfig.h>

//#define CHECKLOOPS

//============== Definition of class KNGroupEntry =============

KNGroupEntry::KNGroupEntry(const QString &name, uint cnt=0, uint re=0, uint la=0, bool thr=true) :
	KNEntryBase(name,cnt)
{
  mRead=re;
	mLast=la;
	mThr=thr;
	mNewCnt=0;	
}



KNGroupEntry::~KNGroupEntry()
{
}



void KNGroupEntry::updListItem()
{
	char tot[10]; char unr[10];
	sprintf(tot,"%d",mCount);
	sprintf(unr,"%d",mCount-mRead);
	
	mLstItem->setFirstColBold((mNewCnt>0));
	
	mLstItem->setText(1,tot);
	mLstItem->setText(2,unr);
	
}



bool KNGroupEntry::loadHdrs()
{
	bool ret=true;	
  			
	if(hList.isEmpty() && mCount > 0){
		if(readHdrsFromFile()==-1) ret=false;
	}
	
	return ret;	
}



void KNGroupEntry::clearHdrList()
{
	hList.clear();	
}



void KNGroupEntry::checkForNewHdrs()
{
	int num=getNewHdrs();
	debug("%d headers fetched\n", num);
	
	
	if(num>0) {
		xTop->setStatusMsg(i18n("sorting ..."));
		sortHdrs(num);
		debug("%d headers wrote to file\n", saveStaticData(num));
	 	saveDynamicData(num);
	 	mNewCnt+=num;
		updateThreadInfo();
		mCount=hList.length();
		updListItem();
		saveInfo();
	}
	
	xTop->setStatusMsg();
			
	
}



int KNGroupEntry::getNewHdrs()
{
	int toFetch=0, cnt=0, maxFetch=300;
	
	KConfig *c=CONF();
	c->setGroup("READNEWS");
	maxFetch=c->readNumEntry("maxFetch", 300);
		
	if(!xClient->cmdGroup(mName)) return 0;
			
	if(mLast==0) {   //first fetch
		if(xClient->firstArtNum()>0) mOlast=xClient->firstArtNum()-1;
		else mOlast=xClient->firstArtNum();
	}
	else mOlast=mLast;
	
	mLast=xClient->lastArtNum();
	
	toFetch=mLast-mOlast;
	debug("last %d  oldlast %d  toFetch %d\n",mLast,mOlast,toFetch);
	
	
	if(toFetch==0) {
		debug("No new Articles in group\n");
		return 0;
	}
	
	QStrList *xoverList;
	KNReadHeader *hdr=0;
	QString tmp;
	
	
	DwDateTime dt;
	
		
	if(toFetch>maxFetch) {
		toFetch=maxFetch;
		debug("Fetching only %d articles\n",maxFetch);
	}
	
	xoverList=xClient->cmdXOver(mLast-toFetch+1,mLast);
	
	if(!xoverList) return 0;
	
	KNStringSplitter split;
	split.setIncludeSep(false);
		
	if(!hList.resize(hList.size()+xoverList->count())) return 0;
	
	for(char *line=xoverList->first(); line; line=xoverList->next()) {
		
	  stripCRLF(line);
		
		split.init(line, "\t");
			
		//new Header-Object
		hdr=new KNReadHeader;
		hdr->setNew(true);
		
		
		
		//Article Number
		split.first();
		hdr->artNr=split.string().toInt();
		
		//Subject
		split.next();
		hdr->subject=decodeRFC1522String(split.string());
		
		
		//From and Email
		split.next();
		hdr->setFromLine(split.string());
		
		
		//Date
		split.next();
		dt.FromString(split.string());
		dt.Parse();
		hdr->time=dt.AsUnixTime();
		//hdr->time=dt.AsCalendarTime();
								
		//Message-ID
		split.next();
		hdr->mID=split.string().simplifyWhiteSpace();
		
		
		//References
		split.next();
		
				
		if(!split.string().isEmpty()){
			
			//debug("ArtNr : %d \t refs : %s\n", hdr->artNr, split.string().data());
		  		
			int RefNr=0;
			KNStringSplitter refs;
			split.setIncludeSep(false);
			
			refs.init(split.string(), " ");
			bool isRef=refs.last();
			
			if(!isRef) {
				hdr->references[0]=split.string().simplifyWhiteSpace();
				//debug("refNr 0 : %s\n", hdr->references[0].data());
			}
			
			else {
			  			
				while(isRef && RefNr < 5) {
					
					tmp=refs.string().simplifyWhiteSpace();	
					
					if(hdr->mID!=tmp) {	
						hdr->references[RefNr]=tmp;
						RefNr++;
					}									
					isRef=refs.prev();
				
				}
			}
			
		}	
					
		
				
		//Lines
		split.next();
		split.next();
		hdr->lines=split.string().toInt();
				
				
		if(hList.append(hdr)) cnt++;
		
		else {
			xoverList->clear();
			delete hdr;
			return cnt;
		}
	}

  xoverList->clear();
	
	return cnt;
}



void KNGroupEntry::sortHdrs(int count)
{
	
	int end=hList.length();
	int start=hList.length()-count;
	int foundCnt_1=0, foundCnt_2=0, bySubCnt=0, refCnt=0,
		resortCnt=0, idx, oldRef;
	
	
	//resort old hdrs
	if(start>0)
		for(idx=0; idx<start; idx++)
		  if(hList[idx]->thrLevel>1) {
				oldRef=hList[idx]->idRef;
				if(findRef(hList[idx], start, end)!=-1) {
					debug("%d : old %d    new %d\n",
						hList[idx]->id, oldRef, hList[idx]->idRef);
					resortCnt++;
					hList[idx]->setHasChanged(true);
				}
			}
		
	
	
	for(idx=start; idx<end; idx++) {
	
	//scan new hdrs
	
		if(hList[idx]->hasReferences() && hList[idx]->idRef==-1){   //hdr has references
			
			refCnt++;
			
			if(findRef(hList[idx], start, end)!=-1)	foundCnt_1++;	
	
	//scan old hdrs
			else if(start!=0)
				if(findRef(hList[idx], 0, start, true)!=-1)
					foundCnt_2++;
		}
		
		else
			if(strncasecmp(hList[idx]->subject,"Re:",3)!=0) {
				hList[idx]->idRef=0; //hdr has no references
				hList[idx]->thrLevel=0;
			}
			else if(hList[idx]->idRef==-1) refCnt++;
			
	}
	
	
	
		
	if((foundCnt_1+foundCnt_2)<refCnt) {    // if some references could not be found
	
	//try to sort by subject
		
		KNReadHeader *hdr, *oldest;		
				
		QList<KNReadHeader> list;
		list.setAutoDelete(false);
			
		//int *idx_arr=new int[end-start+2];
		//int arr_cnt, oldest_idx;
		
		
		for(idx=start; idx<end; idx++) {
			
			hdr=hList[idx];			
				
			if(hdr->idRef==-1) {  //for all not sorted headers
			
				list.clear();
			  list.append(hdr);
				
			  //find all headers with same subject
			  for(uint idx2=0; idx2<hList.length(); idx2++)
			  	if(hList[idx2]==hdr) continue;
			  	else if(hList[idx2]->subject==hdr->subject)
			  		list.append(hList[idx2]);
			
			  if(list.count()==1) {
			  	hdr->idRef=0;
			  	hdr->thrLevel=6;
			  	bySubCnt++;
			  }
			
			  else {
			
			    //find oldest
			    oldest=list.first();
			  	for(KNReadHeader *var=list.next(); var; var=list.next())
			  		if(var->time < oldest->time) oldest=var;
			  	
			  	//oldest gets idRef 0	
			  	if(oldest->idRef==-1) bySubCnt++;
			  	oldest->idRef=0;
			  	oldest->thrLevel=6;		
			  	
			  	for(KNReadHeader *var=list.first(); var; var=list.next())
			  		if(var==oldest) continue;
			  		else if(var->idRef==-1 || (var->idRef!=-1 && var->thrLevel==6)) {
			  			var->idRef=oldest->id;
			  			var->thrLevel=6;
			  			if(var->id >= hList[start]->id) bySubCnt++;
			  			
			  		}
			  }
			}
		}	
	}
	
	
	
	//all not found items get refID 0
	KNReadHeader *en;
	for (int idx=start; idx<end; idx++){
		en=hList[idx];
		if(en->idRef==-1) {
			en->idRef=0;
			en->thrLevel=0;
		}
	}
	
	
	int idRef;
	

#ifdef CHECKLOOPS	
	//check for loops in threads
	int startId;
	bool isLoop;
	for (int idx=start; idx<end; idx++){
		en=hList[idx];
		startId=en->id;
		idRef=en->idRef;
		isLoop=false;
		while(idRef!=0 && !isLoop) {
			en=hList.byID(idRef);
			idRef=en->idRef;
			isLoop=(idRef==startId);
		}
		
		if(isLoop) {
			debug("Sorting : loop in %d", hList[idx]->id);
			hList[idx]->idRef=0;
			hList[idx]->thrLevel=0;
		}
			
	}
#endif	
	
	//set score for new Headers
	
	for(int idx=start; idx<end; idx++) {
		
		en=hList[idx];
		idRef=en->idRef;
		
		if(idRef!=0) {
			
			while(idRef!=0) {
				en=hList.byID(idRef);
				idRef=en->idRef;
			}
	
			if(en) hList[idx]->score=en->score;
		}
	}
	
	
	debug("\nSorting : %d headers resorted\n", resortCnt);
	debug("Sorting : %d references of %d found in step 1\n",foundCnt_1,refCnt);
	debug("Sorting : %d references of %d found in step 2\n",foundCnt_2,refCnt);
	debug("Sorting : %d references of %d sorted by subject\n",bySubCnt,refCnt);
		
}



int KNGroupEntry::findRef(KNReadHeader *h, int from, int to, bool reverse=false)
{
	bool found=false;
	int foundID=-1, idx=0;
	short refNr=0;
		
	if(!reverse){
		
		while(!found && !h->references[refNr].isNull()) {
			
			for(idx=from; idx<to; idx++) {
												
				if(hList[idx]->mID==h->references[refNr]) {
					found=true;
					foundID=hList[idx]->id;
					h->thrLevel=refNr+1;
					break;
				}
			}
			if(++refNr==5) break;
		}
	}
	
	else {
		while(!found && !h->references[refNr].isNull()) {
			for(idx=to; idx>=from; idx--) {
				
				if(hList[idx]->mID==h->references[refNr]){
					found=true;
					foundID=hList[idx]->id;
					h->thrLevel=refNr+1;
					break;
				}
			}
			if(++refNr==5) break;
		}
	}
			
	if(foundID!=-1) h->idRef=foundID;
	return foundID;
}



void KNGroupEntry::updateThreadInfo()
{
	KNReadHeader *ref;
	int idRef;
	bool brokenThread=false;
	
	for(uint idx=0; idx<hList.length(); idx++)
		hList[idx]->unrSubCnt=0;
		
	
	for(uint idx=0; idx<hList.length(); idx++) {
		
		idRef=hList[idx]->idRef;
				
		while(idRef!=0) {
			ref=hList.byID(idRef);
			if(!ref) {
				brokenThread=true;
				break;
			}
			ref->setNewSubs(hList[idx]->isNew());
			if(!hList[idx]->isRead()) ref->unrSubCnt+=1;
			idRef=ref->idRef;
		}
	}

	if(brokenThread) {
		debug("Found broken threading infos !! Restoring ...");
		sortHdrs(hList.length());
		saveDynamicData(hList.length(), true);
		debug("Done");
	  updateThreadInfo();
	}
		
		
			
}



QString KNGroupEntry::path()
{
	QString ret=knDir();
	ret+=mName;
	ret+=".grp/";
	return ret;
}



void KNGroupEntry::saveInfo()
{
	QString fName=path();
	fName+="info";
	
	KSimpleConfig info(fName);
	
	info.writeEntry("name", mName);
	info.writeEntry("lastMsg", mLast);
	info.writeEntry("count", mCount);
	info.writeEntry("read", mRead);
	info.writeEntry("threaded", mThr);
		
}



int KNGroupEntry::saveStaticData(int count, bool ovr=false)
{
	uint idx, cnt=0;
	int mode;
	DwDateTime dt;
	time_t ftime=dt.AsUnixTime();
	QString fName;
	KNReadHeader *hdr;
	QFile f;
	QTextStream s;
	
	if(ovr) mode=IO_WriteOnly;
	else mode=IO_WriteOnly | IO_Append;
	
	fName=path();
	fName+="static";
	
	f.setName(fName);
	
	
	if(f.open(mode)) {
		
	 	s.setDevice(&f);
			
		for(idx=hList.length()-count; idx<hList.length(); idx++) {
		
				
			hdr=hList[idx];		
			
			if(!hdr->hasData()) continue;
						
		
		  char *tmp;
		 	if(hdr->email.nrefs()==1) tmp=hdr->from.data();
			else tmp="0";
			
			s 	<< hdr->artNr << "\t" << hdr->mID << "\t" << hdr->subject << "\t"
					<< hdr->email << "\t" ;
			
			if(hdr->email.nrefs()==1)  s << hdr->from;
			else s << "0";
			
			s 	<< "\n";
				
								  		
			
			if(!hdr->references[0].isNull()) {
			   			
			  s 	<< hdr->references[0] << ";" ;
				
			
				for(int i=1; i<5; i++ )
					if(!hdr->references[i].isNull())
						s << hdr->references[i] << ";" ;
									
					s << "\n";
			}
		
			else s << "0\n";
		
			
			s 	<< hdr->id << " " << hdr->lines << " " << hdr->time << " "
					<< ftime << "\n";
		
			
			cnt++;
			
		}
	
		f.close();
		
	}
	
	return cnt;
}



void KNGroupEntry::dynData::setData(KNReadHeader *h)
{
	id=h->id;
	idRef=h->idRef;
	thrLevel=h->thrLevel;
	read=h->isRead();
	score=h->score;	
}



void KNGroupEntry::saveDynamicData(int count, bool ovr=false)
{
	dynData data;
  int mode;
	QString fName;
	QFile f;
	KNReadHeader *hdr;
	
	if(hList.length()>0) {
	
		fName=path();
		fName+="dynamic";
		
		f.setName(fName);
		
		if(ovr) mode=IO_WriteOnly;
		else mode=IO_WriteOnly | IO_Append;
		
		if(f.open(mode)) {
	  		
			for(uint idx=hList.length()-count; idx<hList.length(); idx++) {		
			
				hdr=hList[idx];	
		
				if(!hdr->hasData()) continue;
				
				data.setData(hdr);
				f.writeBlock((char*)(&data), sizeof(dynData));
				
			}
		
			f.close();
						
		}
	
		else MBox(ferr);
	}
	
}



void KNGroupEntry::syncDynamicData()
{
	dynData data;
  int cnt=0, readCnt=0, sOfData;
	QString fName;
	QFile f;
	KNReadHeader *hdr;
	
	if(hList.length()>0) {
		
		fName=path();
		fName+="dynamic";
		f.setName(fName);
		
		if(f.open(IO_ReadWrite)) {
			
			sOfData=sizeof(dynData);	
		
			for(uint i=0; i<hList.length(); i++) {
				hdr=hList[i];
				
				if(hdr->hasChanged() && hdr->hasData()) {
					
					data.setData(hdr);
					f.at(i*sOfData);
					f.writeBlock((char*) &data, sOfData);
					cnt++;
				}
			
				if(hdr->isRead()) readCnt++;
			}
			
			f.close();
			debug("%s => updated %d entries of dynamic data", mName.data(), cnt);
			mRead=readCnt;
	  }
		
	  else MBox(ferr);
	}
	
}



int KNGroupEntry::readHdrsFromFile()
{
	QString buff;
  QFile f;
  QTextStream s;
  KNStringSplitter split;
  int cnt=0;
  time_t ftime;
  QDateTime dt;
  QDate today=QDate::currentDate();
  KNReadHeader *hdr;

  buff=path();
  buff+="static";	
	
	f.setName(buff);	 	
  		
	
	if(f.open(IO_ReadOnly)) {
			
	
		if(!hList.resize(mCount)) {
			f.close();
			return -1;
		}
	
		s.setDevice(&f);
				
		while(!s.eof()) {
		
		  split.init(s.readLine(), "\t");
		  					
		  hdr=new KNReadHeader;
		
		  split.first();
			hdr->artNr=split.string().toUInt();
					
			split.next();
			hdr->mID=split.string();
		
		  split.next();
			hdr->subject=split.string();
				
			split.next();
			hdr->email=split.string();
		
			split.next();
			if(split.string()!="0") hdr->from=split.string();
			else {
				hdr->from=hdr->email;
			}
		  		
			split.init(s.readLine(), ";");
			
			bool isRef=split.first();	
		
			if(isRef){
								
				int RefNr=0;
				
				while(isRef && RefNr<5) {
					hdr->references[RefNr]=split.string();
					isRef=split.next();
					RefNr++;
				}
			}
		  		
							
			buff=s.readLine();
		  							
			sscanf(buff,"%d %d %d %d", &hdr->id, &hdr->lines, (uint*) &hdr->time, (uint*) &ftime);
			
			
			dt.setTime_t(ftime);
			hdr->age=dt.date().daysTo(today);
			
					
			if(hList.append(hdr)) cnt++;
			else  return cnt; 		
		}
	
	hList.setLastID();
	s.unsetDevice();
	f.close();
	
	}
	
	else {
		MBox(ferr);
		return -1;
	}	
		
	
	buff=path();
	buff+="dynamic";
	
	f.setName(buff);
	
	
	if (f.open(IO_ReadOnly)) {
	
		dynData data;
		KNReadHeader *hdr;
		int readCnt=0;
		
		while(!f.atEnd()) {
			
			f.readBlock((char*)(&data), sizeof(dynData));
			
			hdr=hList.byID(data.id);
			
			if(hdr) {
				hdr->idRef=data.idRef;
				hdr->setRead(data.read);
				hdr->thrLevel=data.thrLevel;
				hdr->score=data.score;
			}
		
			if(data.read) readCnt++;
			
		}
	
		f.close();
		
		mRead=readCnt;
		
	}	
	
	else 	MBox(ferr);
	
	
			
	
	debug("%d articles read from file\n",cnt);
	mCount=hList.length();
	
	updateThreadInfo();
		
	return cnt;
}







