/***************************************************************************
                     knserveroptions.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knserveroptions.h"
#include "knglobals.h"
#include <qlayout.h>
#include <qlabel.h>

#ifdef WITHLOGON	

KNServerOptions::KNServerOptions(QWidget *parent=0, const char *name=0) :
	KNOptionsWidget(parent, name)
{
		

	
	//NNTP
	gNntp=new QGroupBox(i18n("NNTP"), this);
	
	QLabel *l1=new QLabel(i18n("Server:"), gNntp);
	nntp=new QLineEdit(gNntp);
	SIZE(l1); SIZE(nntp);
	
	QLabel *l2=new QLabel(i18n("port:"), gNntp);
	nPort=new KRestrictedLine(gNntp); nPort->setValidChars("0123456789");
	SIZE(l2); WIDTH(nPort, 40);
	
	QLabel *l3=new QLabel(i18n("timout (secs):"),gNntp);
	tOut=new KRestrictedLine(gNntp); tOut->setValidChars("0123456789");
	SIZE(l3);  WIDTH(tOut, 40);
	
	needsLog=new QCheckBox(i18n("logon needed"), gNntp);
	user=new QLineEdit(gNntp);
	pass=new QLineEdit(gNntp);
	QLabel *l4=new QLabel(i18n("username:"), gNntp);
	QLabel *l5=new QLabel(i18n("password:"), gNntp);
	SIZE(needsLog); SIZE(user); SIZE(pass); SIZE(l4); SIZE(l5);
	
	
	//SMTP
	gSmtp=new QGroupBox(i18n("SMTP"), this);
	
	QLabel *l6=new QLabel(i18n("Server:"), gSmtp);
	smtp=new QLineEdit(gSmtp);
	SIZE(l6); SIZE(smtp);
	
	QLabel *l7=new QLabel(i18n("port:"), gSmtp);
	sPort=new KRestrictedLine(gSmtp); sPort->setValidChars("0123456789");
	SIZE(l7);  WIDTH(sPort, 40);
	
	
	//Identity
	
	gIden=new QGroupBox(i18n("Identity"), this);
	
	QLabel *l8=new QLabel(i18n("Name:"), gIden);
	from=new QLineEdit(gIden);
	SIZE(l8); SIZE(from);
	
	QLabel *l9=new QLabel(i18n("Email:"), gIden);
	email=new QLineEdit(gIden);
	SIZE(l9); SIZE(email);
	
	QLabel *l10=new QLabel(i18n("Reply-To:"), gIden);
	replyTo=new QLineEdit(gIden);
	SIZE(l10); SIZE(replyTo);
	
	QLabel *l11=new QLabel(i18n("Organization:"), gIden);
	orga=new QLineEdit(gIden);
	SIZE(l11); SIZE(orga);
	
			
	
	
	QVBoxLayout *topL=new QVBoxLayout(this, 10);
	
	QVBoxLayout *nntL=new QVBoxLayout(gNntp,20);
	QHBoxLayout *nseL=new QHBoxLayout(5);
	QHBoxLayout *nloL=new QHBoxLayout(5);
	
	QHBoxLayout *smtL=new QHBoxLayout(gSmtp, 20);
	//QGridLayout *serL=new QGridLayout(gServer,  4, 4, 20, 15);
	QGridLayout *idL=new QGridLayout(gIden,  7, 2, 20, 5);
	
	topL->addWidget(gNntp);
	topL->addWidget(gSmtp);
	topL->addWidget(gIden,10);
	
	nntL->addLayout(nseL);
	nntL->addLayout(nloL);
	nseL->addWidget(l1);
	nseL->addWidget(nntp,1);
	nseL->addWidget(l2);
	nseL->addWidget(nPort);
	nseL->addWidget(l3);
	nseL->addWidget(tOut);
	nloL->addWidget(needsLog);
	nloL->addWidget(l4);
	nloL->addWidget(user,1);
	nloL->addWidget(l5);
	nloL->addWidget(pass,1);
	
	smtL->addWidget(l6);
	smtL->addWidget(smtp,1);
	smtL->addWidget(l7);
	smtL->addWidget(sPort);
				
	/*serL->addWidget(l1, 0,0);
	serL->addWidget(nntp, 0,1);
	serL->addWidget(l2, 0,2);
	serL->addWidget(nPort, 0,3);
	
	serL->addWidget(l3, 1,2);
	serL->addWidget(tOut, 1,3);
	
	serL->addWidget(l4, 3,0);
	serL->addWidget(smtp, 3,1);
	serL->addWidget(l5, 3,2);
	serL->addWidget(sPort, 3,3);
	
	serL->setColStretch(1,20);
	serL->setColStretch(3,1);
	serL->setRowStretch(2,1);*/
	
	//topL->addSpacing(25);	
	//topL->addWidget(gIden,10);
	
	idL->addWidget(l8, 0,0);
	idL->addWidget(from, 0,1);
	
	idL->addWidget(l9, 2,0);
	idL->addWidget(email, 2,1);
	
	idL->addWidget(l10, 4,0);
	idL->addWidget(replyTo, 4,1);
	
	idL->addWidget(l11, 6,0);
	idL->addWidget(orga, 6,1);
	
	idL->setColStretch(1,1);
	idL->setRowStretch(1,1);
	idL->setRowStretch(3,1);
	idL->setRowStretch(5,1);
	
	topL->activate();

	readConfig();
}



KNServerOptions::~KNServerOptions()
{
}



void KNServerOptions::applyConfig()
{
	KConfig *conf=CONF();
	
	conf->setGroup("SERVER");
	
	conf->writeEntry("Nntp",nntp->text());
	if(strlen(nPort->text())>0)
		conf->writeEntry("nPort",atoi(nPort->text()));
	
	
	conf->writeEntry("Smtp", smtp->text());
	if(strlen(sPort->text())>0)
		conf->writeEntry("sPort",atoi(sPort->text()));
		
	if(strlen(tOut->text())>0)
		conf->writeEntry("Timeout",atoi(tOut->text()));
		
	if(needsLog->isChecked()) {
		conf->writeEntry("needsLogon", true);
		conf->writeEntry("user", user->text());
	  conf->writeEntry("pass", pass->text());
	}
	else conf->writeEntry("needsLogon", false);

	
	conf->setGroup("IDENTITY");
		
	conf->writeEntry("Name",from->text());
	conf->writeEntry("Email",email->text());
	conf->writeEntry("Reply-to",replyTo->text());
	conf->writeEntry("Org",orga->text());
}



void KNServerOptions::readConfig()
{
	KConfig *conf=CONF();
	char tmp[5];
	conf->setGroup("SERVER");
	
	nntp->setText(conf->readEntry("Nntp", "localhost"));
	sprintf(tmp,"%d",conf->readNumEntry("nPort",119));
	nPort->setText(tmp);
	sprintf(tmp,"%d",conf->readNumEntry("Timeout",180));
	tOut->setText(tmp);
	
	smtp->setText(conf->readEntry("Smtp",""));
	sprintf(tmp,"%d",conf->readNumEntry("sPort",25));
	sPort->setText(tmp);
	
	needsLog->setChecked(conf->readBoolEntry("needsLogon", false));
	user->setText(conf->readEntry("user",""));
	pass->setText(conf->readEntry("pass",""));
	
	
	conf->setGroup("IDENTITY");
	from->setText(conf->readEntry("Name"));
	email->setText(conf->readEntry("Email"));
	replyTo->setText(conf->readEntry("Reply-to"));
	orga->setText(conf->readEntry("Org"));
}

#else

	

KNServerOptions::KNServerOptions(QWidget *parent=0, const char *name=0) :
	KNOptionsWidget(parent, name)
{
		

	
	//Server
	gServer=new QGroupBox(i18n("Server"), this);
	
	QLabel *l1=new QLabel(i18n("NNTP:"), gServer);
	nntp=new QLineEdit(gServer);
	SIZE(l1); SIZE(nntp);
	
	QLabel *l2=new QLabel(i18n("port:"), gServer);
	nPort=new KRestrictedLine(gServer); nPort->setValidChars("0123456789");
	SIZE(l2); WIDTH(nPort, 40);
	
	QLabel *l3=new QLabel(i18n("timout (secs):"),gServer);
	tOut=new KRestrictedLine(gServer); tOut->setValidChars("0123456789");
	SIZE(l3);  WIDTH(tOut, 40);
	
	QLabel *l4=new QLabel(i18n("SMTP:"), gServer);
	smtp=new QLineEdit(gServer);
	SIZE(l4); SIZE(smtp);
	
	QLabel *l5=new QLabel(i18n("port:"), gServer);
	sPort=new KRestrictedLine(gServer); sPort->setValidChars("0123456789");
	SIZE(l5);  WIDTH(sPort, 40);
	
	
	//Identity
	
	gIden=new QGroupBox(i18n("Identity"), this);
	
	QLabel *l6=new QLabel(i18n("Name:"), gIden);
	from=new QLineEdit(gIden);
	SIZE(l6); SIZE(from);
	
	QLabel *l7=new QLabel(i18n("Email:"), gIden);
	email=new QLineEdit(gIden);
	SIZE(l7); SIZE(email);
	
	QLabel *l8=new QLabel(i18n("Reply-To:"), gIden);
	replyTo=new QLineEdit(gIden);
	SIZE(l8); SIZE(replyTo);
	
	QLabel *l9=new QLabel(i18n("Organization:"), gIden);
	orga=new QLineEdit(gIden);
	SIZE(l9); SIZE(orga);
	
			
	
	
	QVBoxLayout *topL=new QVBoxLayout(this, 10);
	QGridLayout *serL=new QGridLayout(gServer,  4, 4, 20, 15);
	QGridLayout *idL=new QGridLayout(gIden,  7, 2, 20, 5);
	
	topL->addWidget(gServer,10);
	
	serL->addWidget(l1, 0,0);
	serL->addWidget(nntp, 0,1);
	serL->addWidget(l2, 0,2);
	serL->addWidget(nPort, 0,3);
	
	serL->addWidget(l3, 1,2);
	serL->addWidget(tOut, 1,3);
	
	serL->addWidget(l4, 3,0);
	serL->addWidget(smtp, 3,1);
	serL->addWidget(l5, 3,2);
	serL->addWidget(sPort, 3,3);
	
	serL->setColStretch(1,20);
	serL->setColStretch(3,1);
	serL->setRowStretch(2,1);
	
	//topL->addSpacing(25);	
	topL->addWidget(gIden,10);
	
	idL->addWidget(l6, 0,0);
	idL->addWidget(from, 0,1);
	
	idL->addWidget(l7, 2,0);
	idL->addWidget(email, 2,1);
	
	idL->addWidget(l8, 4,0);
	idL->addWidget(replyTo, 4,1);
	
	idL->addWidget(l9, 6,0);
	idL->addWidget(orga, 6,1);
	
	idL->setColStretch(1,1);
	idL->setRowStretch(1,1);
	idL->setRowStretch(3,1);
	idL->setRowStretch(5,1);
	
	topL->activate();

	readConfig();
}



KNServerOptions::~KNServerOptions()
{
}



void KNServerOptions::applyConfig()
{
	KConfig *conf=CONF();
	
	conf->setGroup("SERVER");
	
	conf->writeEntry("Nntp",nntp->text());
	if(strlen(nPort->text())>0)
		conf->writeEntry("nPort",atoi(nPort->text()));
	
	
	conf->writeEntry("Smtp", smtp->text());
	if(strlen(sPort->text())>0)
		conf->writeEntry("sPort",atoi(sPort->text()));
		
	if(strlen(tOut->text())>0)
		conf->writeEntry("Timeout",atoi(tOut->text()));
	

	
	conf->setGroup("IDENTITY");
		
	conf->writeEntry("Name",from->text());
	conf->writeEntry("Email",email->text());
	conf->writeEntry("Reply-to",replyTo->text());
	conf->writeEntry("Org",orga->text());
}



void KNServerOptions::readConfig()
{
	KConfig *conf=CONF();
	char tmp[5];
	conf->setGroup("SERVER");
	
	nntp->setText(conf->readEntry("Nntp", "localhost"));
	sprintf(tmp,"%d",conf->readNumEntry("nPort",119));
	nPort->setText(tmp);
	sprintf(tmp,"%d",conf->readNumEntry("Timeout",180));
	tOut->setText(tmp);
	
	smtp->setText(conf->readEntry("Smtp",""));
	sprintf(tmp,"%d",conf->readNumEntry("sPort",25));
	sPort->setText(tmp);
	
	conf->setGroup("IDENTITY");
	from->setText(conf->readEntry("Name"));
	email->setText(conf->readEntry("Email"));
	replyTo->setText(conf->readEntry("Reply-to"));
	orga->setText(conf->readEntry("Org"));
}

#endif





















