/***************************************************************************
                     knsmtpclient.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>
#include "knsmtpclient.h"
#include "knglobals.h"

SMTP::SMTP() : DwSmtpClient()
{
	bConnected=false;
}



SMTP::~SMTP()
{
}



bool SMTP::cmdConnect()
{
	
	if(!bConnected) {	

		KConfig *conf=CONF();
		xTop->setStatusMsg(i18n("connecting to smtp-server ..."));
		conf->setGroup("SERVER");
		
		int p=conf->readNumEntry("sPort", 25);
		QString s=conf->readEntry("Smtp", "");	

		if(Open(s, p)!=0)
			if(Helo()==250) bConnected=true;
		xTop->setStatusMsg();
	}
	
	debug(serverResponse());
	return bConnected;	
	
}


bool SMTP::sendMsg(const char *From, const char *To, DwString &msg)
{
	if(Mail(From)==250) {
	  debug(serverResponse());	
		if(Rcpt(To)==250) {
			debug(serverResponse());	
			if(Data()==354){
				debug(serverResponse());	
				if(SendData(msg)==250) {
					debug(serverResponse());
					return true;
				}
	    }
	  }
	}
	debug(serverResponse());			
	return false;	
}



bool SMTP::cmdDisconnect()
{
	if(bConnected) {
		Quit();
		Close();
		bConnected=false;
	}
	
	debug(serverResponse());
	return !bConnected;
	
}


const char* SMTP::serverResponse()
{
	static QString resp;

	
	if(!Response().empty()) resp=Response().c_str();
	else resp=LastErrorStr();
	
	return resp.data();
}













