/***************************************************************************
                          kpopup.cpp  -  description
                          --------------------------
    copyright            : (C) 2000 by Torsten Henschel
    email                : henschel@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <malloc.h>

#include <kapp.h>

#include "make_popup.h"
#include "misc.h"
#include "kpopup.h"


KPopup::KPopup(int argc, char **argv, QWidget *parent=0, const char *name=0)
       : QWidget(parent, name)
{
 if(argc == 3)
   {
    Filename = (char *)malloc(((strlen(argv[1]) +1 ) * (sizeof(char))));
    sprintf(Filename, argv[1]);
    Filename[strlen(argv[1])] = 0;

    Sender = (char *)malloc(((strlen(argv[2]) + 1) * (sizeof(char))));
    sprintf(Sender, argv[2]);
    Sender[strlen(argv[2])] = 0;
   }
  else
   {
    Filename = (char *)malloc(1 * (sizeof(char)));
    Filename[0] = 0;
    Sender = (char *)malloc(1 * (sizeof(char)));
    Sender[0] = 0;
   }

 setMinimumSize(290, 260);
 setMaximumSize(290, 260);
    
 B_Quit = new QPushButton(i18n("Quit"), this, "quit");
 B_Quit -> setGeometry(20, 10, 75, 30);
 B_Quit -> setFont(QFont("Times", 18, QFont::Bold));
 connect(B_Quit, SIGNAL(clicked()), qApp, SLOT(quit()));

 B_Answer_Popup = new QPushButton(i18n("Answer"), this, "answer Popup");
 B_Answer_Popup -> setGeometry(107, 10, 75, 30);
 B_Answer_Popup -> setFont(QFont("Times", 18, QFont::Bold));
 connect(B_Answer_Popup, SIGNAL(clicked()), this, SLOT(AnswerPopup()));

 B_New_Popup = new QPushButton(i18n("New"), this, "new Popup");
 B_New_Popup -> setGeometry(194, 10, 75, 30);
 B_New_Popup -> setFont(QFont("Times", 18, QFont::Bold));
 connect(B_New_Popup, SIGNAL(clicked()), this, SLOT(NewPopup()));

 L_Label_Sender = new QLabel(i18n("Popup from:"), this);
 L_Label_Sender -> setGeometry(22, 53, 98, 20);
 L_Label_Sender -> setAlignment(AlignTop | AlignLeft);

 L_Sender = new QLabel(Sender, this);
 L_Sender -> setGeometry(100, 50, 170, 20);
 L_Sender -> setFrameStyle(QFrame::Panel | QFrame::Sunken);
 L_Sender -> setAlignment(AlignTop | AlignLeft);

 L_Label_DateTime = new QLabel(i18n("Popup time:"), this);
 L_Label_DateTime -> setGeometry(22, 78, 98, 20);
 L_Label_DateTime -> setAlignment(AlignTop | AlignLeft);

 if(strlen(Filename) != 0)
   {
    L_PopupText = new QLabel(File_read(Filename, 41), this);

    Time = new QTime();
    *Time = Time -> currentTime();
    Date = new QDate();
    *Date = Date -> currentDate();
    L_DateTime = new QLabel(Date -> toString() + "  " + Time -> toString(), this);
   }
  else
   {
    L_PopupText = new QLabel("", this);

    L_DateTime = new QLabel("", this);
   }

 L_DateTime -> setGeometry(100, 75, 170, 20);
 L_DateTime -> setFrameStyle(QFrame::Panel | QFrame::Sunken);
 L_DateTime -> setAlignment(AlignTop | AlignLeft);

 L_PopupText -> setGeometry(20, 100, 250, 150);
 L_PopupText -> setFrameStyle(QFrame::Panel | QFrame::Sunken);
 L_PopupText -> setAlignment(AlignTop | AlignLeft);
}

void KPopup::AnswerPopup()
{
 if(strlen(Sender) != 0)
   {
    make_Popup *AnswerPopupView;

    AnswerPopupView = new make_Popup(this, "Blabla");
    AnswerPopupView -> resize(280, 220);
    AnswerPopupView -> setCaption(i18n("Answer Popup"));
    AnswerPopupView -> CB_Receiver -> insertItem(Sender, -1);
    AnswerPopupView -> ReadBrowseList();
    AnswerPopupView -> CB_Receiver -> setCurrentItem(0);
    AnswerPopupView -> exec();
   }
  else
   {
    make_Popup *NewPopupView;

    NewPopupView = new make_Popup(this, "Blabla");
    NewPopupView -> resize(280, 220);
    NewPopupView -> setCaption(i18n("New Popup"));
    NewPopupView -> CB_Receiver -> insertItem("NO HOST", -1);
    NewPopupView -> ReadBrowseList();
    NewPopupView -> CB_Receiver -> setCurrentItem(0);
    NewPopupView -> exec();
   }
}

void KPopup::NewPopup()
{
 make_Popup *NewPopupView;

 NewPopupView = new make_Popup(this, "Blabla");
 NewPopupView -> resize(280, 220);
 NewPopupView -> setCaption(i18n("New Popup"));
 NewPopupView -> CB_Receiver -> insertItem("NO HOST", -1);
 NewPopupView -> ReadBrowseList();
 NewPopupView -> CB_Receiver -> setCurrentItem(0);
 NewPopupView -> exec();
}
