/***************************************************************************
                          kpopup.cpp  -  description
                             -------------------
    copyright            : (C) 2000 by Torsten Henschel
    email                : henschel@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <malloc.h>
#include <stdio.h>

#include <kiconloader.h>

#include <qtimer.h>

#include "kpopup.h"
#include "make_popup.h"
#include "misc.h"
#include "resource.h"

#define i18n(x) tr(x)

Kpopup::Kpopup(int argc, char **argv)
{
 setMinimumSize(282, 260);
 setMaximumSize(282, 260);

 Init();
 InitToolbar();
 InitStatusbar();

 toolbar -> show();
 statusbar -> show();
 addToolBar(toolbar);
 setStatusBar(statusbar);

 SetStatusText(i18n("Welcome to KPopup ") + QString(VERSION));
 timer -> start(3000, TRUE);

 if(argc == 3)
   {
    Filename = (char *)malloc(((strlen(argv[1]) +1 ) * (sizeof(char))));
    sprintf(Filename, argv[1]);
    Filename[strlen(argv[1])] = 0;

    Sender = (char *)malloc(((strlen(argv[2]) + 1) * (sizeof(char))));
    sprintf(Sender, argv[2]);
    Sender[strlen(argv[2])] = 0;
   }
  else
   {
    Filename = (char *)malloc(1 * (sizeof(char)));
    Filename[0] = 0;
    Sender = (char *)malloc(1 * (sizeof(char)));
    Sender[0] = 0;
   }

 L_Label_Sender = new QLabel(i18n("Popup from:"), this);
 L_Label_Sender -> setGeometry(22, 38, 98, 20);
 L_Label_Sender -> setAlignment(AlignTop | AlignLeft);

 L_Sender = new QLabel(Sender, this);
 L_Sender -> setGeometry(100, 35, 170, 20);
 L_Sender -> setFrameStyle(QFrame::Panel | QFrame::Sunken);
 L_Sender -> setAlignment(AlignTop | AlignLeft);

 L_Label_DateTime = new QLabel(i18n("Popup time:"), this);
 L_Label_DateTime -> setGeometry(22, 63, 98, 20);
 L_Label_DateTime -> setAlignment(AlignTop | AlignLeft);

 TV_Text = new QTextView(this);
 TV_Text -> setGeometry(12, 85, 258, 150);

 if(strlen(Filename) != 0)
   {
    TV_Text -> setText(File_read(Filename));
    Time = new QTime();
    *Time = Time -> currentTime();
    Date = new QDate();
    *Date = Date -> currentDate();
    L_DateTime = new QLabel(Date -> toString() + "  " + Time -> toString(), this);
   }
  else
   {
    L_DateTime = new QLabel("", this);
   }

 L_DateTime -> setGeometry(100, 60, 170, 20);
 L_DateTime -> setFrameStyle(QFrame::Panel | QFrame::Sunken);
 L_DateTime -> setAlignment(AlignTop | AlignLeft);
}


Kpopup::~Kpopup()
{
}


void Kpopup::Init()
{
 timer = new QTimer(this);
 connect(timer, SIGNAL(timeout()), this, SLOT(TimerDone()));
}


void Kpopup::InitToolbar()
{
 toolbar = new KToolBar(this);

 toolbar -> insertButton(BarIcon("exit"), ID_EXIT, TRUE, i18n("Quit"));
 toolbar -> insertSeparator();
 toolbar -> insertButton(BarIcon("filenew"), ID_NEW_POPUP, TRUE, i18n("New Popup"));
 toolbar -> insertButton(BarIcon("reload"), ID_ANSWER_POPUP, TRUE, i18n("Answer Popup"));
 toolbar -> insertSeparator();
 toolbar -> insertSeparator();
 toolbar -> insertButton(BarIcon("help"), ID_HELP, TRUE, i18n("Help"));

 connect(toolbar, SIGNAL(clicked(int)), SLOT(commandCallback(int)));
}


void Kpopup::InitStatusbar()
{
 statusbar = new KStatusBar(this);
 statusBar() -> insertItem("", ID_STATUS_TEXT, 1, true);
}


void Kpopup::commandCallback(int id_)
{
 switch(id_)
  {
   case ID_EXIT:
                kapp -> quit();
                break;
   case ID_NEW_POPUP:
                     NewPopup();
                     break;
   case ID_ANSWER_POPUP:
                        AnswerPopup();
                        break;
   case ID_HELP:
								kapp -> invokeHTMLHelp("", "");
                break;
  }
}


void Kpopup::TimerDone()
{
 statusbar -> changeItem("", ID_STATUS_TEXT);
}


void Kpopup::SetStatusText(const char *text)
{
 statusbar -> changeItem(text, ID_STATUS_TEXT);
}


void Kpopup::NewPopup()
{
 make_Popup *NewPopupView;

 NewPopupView = new make_Popup(this, "New Popup");
 NewPopupView -> resize(280, 220);
 NewPopupView -> setCaption(i18n("New Popup"));
 NewPopupView -> CB_Receiver -> insertItem("NO HOST", -1);
 NewPopupView -> ReadBrowseList();
 NewPopupView -> CB_Receiver -> setCurrentItem(0);
 NewPopupView -> exec();
}


void Kpopup::AnswerPopup()
{
 if(strlen(Sender) != 0)
   {
    make_Popup *AnswerPopupView;

    AnswerPopupView = new make_Popup(this, "Answer Popup");
    AnswerPopupView -> resize(280, 220);
    AnswerPopupView -> setCaption(i18n("Answer Popup"));
    AnswerPopupView -> CB_Receiver -> insertItem(Sender, -1);
    AnswerPopupView -> ReadBrowseList();
    AnswerPopupView -> CB_Receiver -> setCurrentItem(0);
    AnswerPopupView -> exec();
   }
  else
   {
    make_Popup *NewPopupView;

    NewPopupView = new make_Popup(this, "Answer Popup");
    NewPopupView -> resize(280, 220);
    NewPopupView -> setCaption(i18n("New Popup"));
    NewPopupView -> CB_Receiver -> insertItem("NO HOST", -1);
    NewPopupView -> ReadBrowseList();
    NewPopupView -> CB_Receiver -> setCurrentItem(0);
    NewPopupView -> exec();
   }
}
