// KPPPLoad - a PPP load monitor
// Copyright (C) 1998  Sean Vyain, svyain@mail.tds.net
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _PPPStats_h_
#define _PPPStats_h_

#include <qobject.h>

class PPPStats : public QObject {
    Q_OBJECT
    int          _s;
    unsigned int _rxTotal;
    unsigned int _txTotal;
    bool         _isUp;
    int          _retryId;
    int          _periodicId;
    int          _retries;
protected:
    virtual void timerEvent( QTimerEvent* e );
public:
    PPPStats();

    bool isUp() { return _isUp; }
signals:
    void changeStats( uint rxDelta, uint txDelta, uint rxTotal, uint txTotal );
    void linkDown();
    void linkUp();
    void retryCount( int retries );
};

#endif
