//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// This file os part of KRN, a newsreader for the KDE project.              //
// KRN is distributed under the GNU General Public License.                 //
// Read the acompanying file COPYING for more info.                         //
//                                                                          //
// KRN wouldn't be possible without these libraries, whose authors have     //
// made free to use on non-commercial software:                             //
//                                                                          //
// MIME++ by Doug Sauder                                                    //
// Qt     by Troll Tech                                                     //
//                                                                          //
// This file is copyright 1997 by                                           //
// Roberto Alsina <ralsina@unl.edu.ar>                                      //
// Magnus Reftel  <d96reftl@dtek.chalmers.se>                               //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
#include "artdlg.h"


#define Inherited KTopLevelWidget


#include <ktopwidget.h>
#include <qdir.h>
#include <qlistbox.h>
#include <qstrlist.h>
#include <qaccel.h>
#include <qevent.h>
#include <qlayout.h>
#include <kapp.h>
#include <qfile.h>
#include <qstring.h>
#include <qtstream.h>
#include <qclipbrd.h>
#include <qregexp.h>
#include <qmsgbox.h>
#include <qstack.h>

#include <kapp.h>
#include <kfm.h>
#include <kspinbox.h>
#include <kiconloader.h>

#include <kmsgbox.h>
#include <html.h>
#include <kconfig.h>
#include <kprocess.h>
#include <kpanner.h>

#include <mimelib/mimepp.h>

#include "groupdlg.h"
#include "rmbpop.h"
#include "fontsDlg.h"
#include "findArtDlg.h"
#include "rulesDlg.h"
#include "sortDlg.h"
#include "article.h"
#include "rules.h"
#include "NNTP.h"
#include "artdlgbehav.h"

#include "kmcomposewin.h"
#include "kmreaderwin.h"
#include "kmmessage.h"
#include "kfileio.h"
#include "artlist.h"
#include "articleitem.h"
#include "gigabase/gigabase.h"

extern dbDatabase db;
extern bool strictdelete;

#include <kfiledialog.h>

extern int key1;
extern int key2;
extern int key3;
extern int key4;

extern int KEY_SUBJECT;
extern int KEY_SCORE;
extern int KEY_SENDER;
extern int KEY_DATE;
extern int KEY_LINES;
extern int KEY_NONE;


#define DO_NOTHING -1
#define LOAD_ART 0
#define REP_MAIL 1
#define FOLLOWUP 2
#define PREV 3
#define NEXT 4
#define ARTLIST 5
#define PAGE_DOWN_ARTICLE 6
#define PAGE_UP_ARTICLE 7
#define DECODE_ARTICLE 8
#define SAVE_ARTICLE 10
#define SCROLL_UP_ARTICLE 11
#define SCROLL_DOWN_ARTICLE 12
#define DECODE 13
#define NO_READ 14
#define PRINT_ARTICLE 15
#define CONFIG_FONTS 16
#define NO_LOCKED 19
#define POSTANDMAIL 20
#define FORWARD 21
#define POST 22
#define FIND_ARTICLE 23
#define EXPUNGE 24
#define DOWNLOAD_ARTICLE 25
#define NO_CACHED 26
#define EDIT_RULES 27
#define UPDATE_SCORES 28
#define CONFIG_SORTING 29
#define LOOKUP_ALTAVISTA 32
#define QUIT 33
#define SCOREFRAME 34
#define FILL_TREE 35
#define CLOSE_WINDOW 36
#define MULTI_SAVE 37
#define COMBO_CONTENTS 38
#define NEXT_THREAD 39
#define PREV_THREAD 40
#define TAG_TOGGLE 41
#define TAG_SET 42
#define TAG_UNSET 43
#define EXPIRE_TOGGLE 44
#define EXPIRE_SET 45
#define EXPIRE_UNSET 46
#define CONFIG_BEHAV 47
#define READ_TOGGLE 48
#define READ_SET 49
#define READ_UNSET 50

extern QString pixpath,cachepath;

extern KConfig *conf;

extern Groupdlg *main_widget;

extern QList <Rule> ruleList;

extern NNTP *server;

QString MultiSavePath;

QStrList artsToDecode;

findArtDlg *FindDlg=0;
rulesDlg *RulesDlg=0;
sortDlg *SortDlg=0;

void decode()
{
    debug ("entered decode()");
    KProcess *proc=new KProcess();
    *proc << "kdecode";
    for (char *art=artsToDecode.first();art!=0;art=artsToDecode.next())
    {
        *proc << art;
    }
    proc->start();
    artsToDecode.clear();
}

Artdlg::Artdlg (NewsGroup *_group)
:Inherited (_group->name)
{
    blocked=0;
    group=0;

    conf->setGroup("Sorting");
    threaded=conf->readNumEntry("Threaded",true);
    key1=conf->readNumEntry("key1",KEY_SUBJECT);
    key2=conf->readNumEntry("key2",KEY_SCORE);
    key3=conf->readNumEntry("key3",KEY_DATE);
    key4=conf->readNumEntry("key4",KEY_SENDER);

    conf->setGroup("ArticleListOptions");
    unread=conf->readNumEntry("ShowOnlyUnread",1);
    showlocked=conf->readNumEntry("ShowLockedArticles");
    showcached=conf->readNumEntry("ShowCachedArticles");


    QPopupMenu *taggedArticles=new QPopupMenu(0);
    taggedArticles->insertItem(klocale->translate("Save"),SAVE_ARTICLE);
    taggedArticles->insertItem(klocale->translate("Download"),DOWNLOAD_ARTICLE);
    taggedArticles->insertSeparator();
    taggedArticles->insertItem(klocale->translate("Decode"),DECODE);
    taggedArticles->insertItem(klocale->translate("UnTag"),TAG_UNSET);
    taggedArticles->insertItem(klocale->translate("Mark as read"), READ_SET);
    taggedArticles->insertItem(klocale->translate("Mark as unread"), READ_UNSET);
    taggedArticles->insertItem(klocale->translate("Don't expire"), EXPIRE_UNSET);
    taggedArticles->insertItem(klocale->translate("Allow expire"), EXPIRE_SET);

    connect (taggedArticles,SIGNAL(activated(int)),this,SLOT(taggedActions(int)));

    article=new QPopupMenu;
    article->setCheckable(true);
    article->insertItem(klocale->translate("Save"),SAVE_ARTICLE);
    article->insertItem(klocale->translate("Download"),DOWNLOAD_ARTICLE);
    article->insertItem(klocale->translate("Find"),FIND_ARTICLE);
    article->insertItem(klocale->translate("Lookup in Altavista"),LOOKUP_ALTAVISTA);
    article->insertSeparator();
    article->insertItem(klocale->translate("Print"),PRINT_ARTICLE);
    article->insertItem(klocale->translate("Post New Article"),POST);
    article->insertItem(klocale->translate("Reply by Mail"),REP_MAIL);
    article->insertItem(klocale->translate("Post Followup"),FOLLOWUP);
    article->insertItem(klocale->translate("Post & Reply"),POSTANDMAIL);
    article->insertItem(klocale->translate("Forward"),FORWARD);
    article->insertSeparator();
    article->insertItem(klocale->translate("Decode"),DECODE);
    article->insertItem(klocale->translate("Toggle Tag"),TAG_TOGGLE);
    article->insertItem(klocale->translate("Tag"),TAG_SET);
    article->insertItem(klocale->translate("UnTag"),TAG_UNSET);
    article->insertItem(klocale->translate("Don't expire"), EXPIRE_UNSET);
    article->insertItem(klocale->translate("Allow expire"), EXPIRE_SET);
    article->insertSeparator(); // robert
    article->insertItem(klocale->translate("Tagged"),taggedArticles);
    article->insertSeparator(); // robert
    article->insertItem(klocale->translate("Close"), CLOSE_WINDOW);
    article->insertItem(klocale->translate("Quit"), QUIT);
    connect (article,SIGNAL(activated(int)),SLOT(defaultActions(int)));



    options=new QPopupMenu;
    options->setCheckable(true);
    options->insertItem(klocale->translate("Show Only Unread Messages"), NO_READ);
    options->setItemChecked(NO_READ,unread);
    options->insertItem(klocale->translate("Show Only Cached Messages"), NO_CACHED);
    options->setItemChecked(NO_CACHED,showcached);
    options->insertItem(klocale->translate("Show Locked Messages"), NO_LOCKED);
    options->setItemChecked(NO_LOCKED,showlocked);
    options->insertItem(klocale->translate("Expunge"), EXPUNGE);
    options->insertItem(klocale->translate("Appearance..."),CONFIG_FONTS);
    options->insertItem(klocale->translate("Sorting..."),CONFIG_SORTING);
    options->insertItem(klocale->translate("Behaviour..."),CONFIG_BEHAV);
    connect (options,SIGNAL(activated(int)),SLOT(defaultActions(int)));

    QPopupMenu *scoring=new QPopupMenu;
    scoring->insertItem(klocale->translate("Edit Rules"),EDIT_RULES);
    scoring->insertItem(klocale->translate("Update"),UPDATE_SCORES);
    connect (scoring,SIGNAL(activated(int)),SLOT(defaultActions(int)));

    menu=new KMenuBar (this);
    setMenu(menu);
    menu = menuBar();
    menu->insertItem (klocale->translate("&Article"), article);
    menu->insertItem (klocale->translate("&Options"), options);
    menu->insertItem (klocale->translate("&Scoring"), scoring);

    KToolBar *t1=new KToolBar(this);
    addToolBar(t1,0);
    QObject::connect (t1, SIGNAL (clicked (int)), this, SLOT (defaultActions (int)));


    t1->insertButton (Icon("left.xpm"), PREV, true, klocale->translate("Previous Message"));

    t1->insertButton (Icon("right.xpm"), NEXT, true, klocale->translate("Next Message"));

    t1->insertButton(Icon("find.xpm"),FIND_ARTICLE,true,klocale->translate("Find Article"));
    t1->insertSeparator ();

    t1->insertButton (Icon("filenew.xpm"), POST, true, klocale->translate("Post New Article"));

    t1->insertButton (Icon("previous.xpm"), ARTLIST, true, klocale->translate("Get Article List"));

    t1->insertButton (Icon("reload.xpm"), FILL_TREE, true, klocale->translate("Refresh Display"));
    t1->alignItemRight(FILL_TREE);
    t1->insertFrame(SCOREFRAME,100);
    t1->alignItemRight(SCOREFRAME);
    minScore= new KNumericSpinBox(t1->getFrame(SCOREFRAME));
    minScore->show();
    minScore->setRange(-25000,25000);
    minScore->setStep(100);
    minScore->setValue(0);
    minScore->setFixedHeight(t1->getFrame(SCOREFRAME)->height()-2);

    KToolBar *t2=new KToolBar(this);
    addToolBar(t2,1);
    QObject::connect (t2, SIGNAL (clicked (int)), this, SLOT (defaultActions (int)));

    QStrList *comboContents=new QStrList();
    comboContents->append(klocale->translate("Current"));
    comboContents->append(klocale->translate("Tagged"));
    comboContents->append(klocale->translate("UnTagged"));
    comboContents->append(klocale->translate("All"));
    comboContents->append(klocale->translate("Read"));
    comboContents->append(klocale->translate("UnRead"));
    t2->insertCombo(comboContents,COMBO_CONTENTS,false,SIGNAL(activated(int)),this,SLOT(setTarget(int)));

    t2->insertButton(Icon("save.xpm"),SAVE_ARTICLE,true,klocale->translate("Save Article"));

    t2->insertButton(Icon("fileprint.xpm"),PRINT_ARTICLE,true,klocale->translate("Print Article"));

    t2->insertButton (Icon("filemail.xpm"), REP_MAIL, true, klocale->translate("Reply by Mail"));

    t2->insertButton (Icon("followup.xpm"), FOLLOWUP, true, klocale->translate("Post a Followup"));

    t2->insertButton (Icon("mailpost.xpm"), POSTANDMAIL, true, klocale->translate("Post & Mail"));

    t2->insertButton (Icon("fileforward.xpm"), FORWARD, true, klocale->translate("Forward"));

    t2->insertSeparator ();

    t2->insertButton (Icon("tagged.xpm"), TAG_TOGGLE, true, klocale->translate("Tag Article"));
    tagPopup=new QPopupMenu (0);
    tagPopup->insertItem (klocale->translate("Tag"),TAG_SET);
    tagPopup->insertItem (klocale->translate("UnTag"),TAG_UNSET);
    t2->setDelayedPopup (TAG_TOGGLE, tagPopup);
    connect (tagPopup,SIGNAL(activated(int)),this,SLOT(defaultActions(int)));

    t2->insertButton (Icon("locked.xpm"), EXPIRE_TOGGLE, true, klocale->translate("Don't expire (keep in cache)"));
    lockPopup=new QPopupMenu (0);
    lockPopup->insertItem (klocale->translate("Don't expire"),EXPIRE_UNSET);
    lockPopup->insertItem (klocale->translate("Allow expire"),EXPIRE_SET);
    t2->setDelayedPopup (EXPIRE_TOGGLE, lockPopup);
    connect (lockPopup,SIGNAL(activated(int)),this,SLOT(defaultActions(int)));

    t2->insertButton (Icon("deco.xpm"), DECODE_ARTICLE, true, klocale->translate("Decode Article"));

    t2->insertButton (Icon("red-bullet.xpm"), READ_SET, true, klocale->translate("Mark Read"));

    t2->insertButton (Icon("green-bullet.xpm"), READ_UNSET, true, klocale->translate("Mark UnRead"));

    t2->insertButton (Icon("down.xpm"), DOWNLOAD_ARTICLE    , true, klocale->translate("Download"));

    if (conf->readNumEntry("VerticalSplit",false))
    {
        debug ("vertical");
        panner=new KPanner (this,"panner",KPanner::O_VERTICAL,33);
    }
    else
    {
        debug ("horizontal");
        panner=new KPanner (this,"panner",KPanner::O_HORIZONTAL,33);
    }
    panner->setSeparator(50);
    setView (panner);

    gl = new QVBoxLayout( panner->child0() );
    list2=new ArtList (panner->child0());
    list2->setRootIsDecorated (true);
    list2->setFocusPolicy(QWidget::TabFocus);
    gl->addWidget( list2, 1);


    connect (list2,SIGNAL(doubleClick(char *)),this,SLOT(slotDoubleClick(const char *)));
    connect (list2,SIGNAL(rightClick(char *)),this,SLOT(slotRightClick(const char *)));
    connect (list2,SIGNAL(leftClick(char *)),this,SLOT(slotLeftClick(const char *)));

    gl = new QVBoxLayout( panner->child1());
    messwin=new KMReaderWin(panner->child1(),"messwin");
    messwin->setMsg(0);
    gl->addWidget( messwin, 1);
    QObject::connect(messwin,SIGNAL(urlClicked(const char *,int)),this,SLOT(openURL(const char*)));

    RmbPop *filter2=new RmbPop(messwin);
    delete (filter2->pop);
    filter2->pop=article;


    status=new KStatusBar(this);
    setStatusBar(status);
    status->insertItem ("", 1);

    acc=new QAccel (this);
    acc->insertItem(ALT + Key_Down, NEXT);
    acc->insertItem(ALT + Key_Up, PREV);
    acc->insertItem(CTRL+Key_F, FIND_ARTICLE);
    acc->insertItem(Key_Backspace,PAGE_UP_ARTICLE);
    acc->insertItem(Key_D,READ_SET);
    acc->insertItem(Key_Down, SCROLL_DOWN_ARTICLE);
    acc->insertItem(Key_F,FOLLOWUP);
    acc->insertItem(Key_G,ARTLIST);
    acc->insertItem(Key_L,EXPIRE_TOGGLE);
    acc->insertItem(Key_N,NEXT);
    acc->insertItem(Key_Next,PAGE_DOWN_ARTICLE);
    acc->insertItem(Key_P,PREV);
    acc->insertItem(Key_Prior,PAGE_UP_ARTICLE);
    acc->insertItem(Key_R,REP_MAIL);
    acc->insertItem(Key_S, FIND_ARTICLE);
    acc->insertItem(Key_Slash, FIND_ARTICLE);
    acc->insertItem(Key_Space,PAGE_DOWN_ARTICLE);
    acc->insertItem(Key_T,TAG_TOGGLE);
    acc->insertItem(Key_U,READ_UNSET);
    acc->insertItem(Key_Up, SCROLL_UP_ARTICLE);
    acc->insertItem(Key_X, EXPUNGE);
    acc->insertItem(SHIFT + Key_N,NEXT_THREAD);
    acc->insertItem(SHIFT + Key_P,PREV_THREAD);

    QObject::connect (acc,SIGNAL(activated(int)),this,SLOT(defaultActions(int)));
    QObject::connect (messwin,SIGNAL(statusMsg(const char*)),this,SLOT(updateCounter(const char*)));

    loadActions();

    conf->setGroup("Geometry");
    setGeometry(conf->readNumEntry("ArtX",100),
                conf->readNumEntry("ArtY",40),
                conf->readNumEntry("ArtW",400),
                conf->readNumEntry("ArtH",400));
    show();

    qApp->processEvents ();

    init(_group);
}


void Artdlg::init (NewsGroup *_group)
{
    if (group)
    {
        group->isVisible=0; //make old group know I'm not showing him
    }

    group=_group;
    group->isVisible=this;

    setCaption (group->name);
    groupname=group->name;
    statusBar()->changeItem("Reading Article List",1);
    qApp->processEvents ();

    if (server)
    {
        disconnect (server,SIGNAL(newStatus(const char *)),
                    this,SLOT(updateCounter(const char *)));
    }

    QObject::connect (server,SIGNAL(newStatus(const char *)),
                      this,SLOT(updateCounter(const char *)));

    list2->clear();

    if (server->isConnected())
    {
        actions(ARTLIST,0,true);
    }
    else
    {
        fillTree();
    }
}

void Artdlg::copyText(bool)
{
}

Artdlg::~Artdlg ()
{
    debug ("artdlg destructor, saving geometry");
    group->isVisible=0;
    conf->setGroup("Geometry");
    conf->writeEntry("ArtX",x());
    conf->writeEntry("ArtY",y());
    conf->writeEntry("ArtW",width());
    conf->writeEntry("ArtH",height());
    conf->sync();
}


void insertArtTree(ArtTreeNode *root,QListViewItem *parent,QListView *list);

void Artdlg::fillTree ()
{
    debug ("entered filltree");
    int minCoolness=minScore->getValue();

    //save current ID if there is one
    QString currID;
    ArticleItem *i=(ArticleItem *)(list2->currentItem());
    if (i)
        currID=i->ID;

    qApp->setOverrideCursor(waitCursor);
    block();
    statusBar()->changeItem("Reading Article List",1);
    qApp->processEvents ();

    list2->clear();

    QString s;

    if (unread)
    {
        s=" isread=false ";
    }

    if (showlocked)
    {
        if (s.length()>0)
            s+=" or ";
        s+=" expire=false ";
    }

    if (showcached)
    {
        if (s.length()>0)
            s+=" and ";
        s+=" cached=true ";
    }

    if (s.length()>0)
        s+=" and ";

    s+=" score > "+QString().setNum(minCoolness-1);

    group->getList(s.data());

    if (!threaded)
    {
        for (Article *iter=group->artList.first();iter!=0;iter=group->artList.next())
        {
            iter->item(list2);
        }
    }
    else
    {
        statusBar()->changeItem(klocale->translate("Threading..."),1);
        qApp->processEvents ();
        ArtTreeNodeList *treebase=group->artList.threaded();

        QListIterator <ArtTreeNode> it(*treebase);
        for (it.toFirst();it.current();++it)
        {
            insertArtTree(it.current(),0,list2);
        }
    }
    block(false);
    qApp->restoreOverrideCursor();
    statusBar()->changeItem("",1);
    qApp->processEvents ();
    group->artList.clear();

    if (!currID.isEmpty())
    {
        debug ("jumping to %s",currID.data());
        ArticleItem *item=list2->items.find(currID.data());
        if (item)
        {
            list2->jumpToID(item->ID);
        }
    }
    debug ("left filltree");
}

bool Artdlg::queryActions (int action,const char *query)
{
    if (action==SAVE_ARTICLE)
    {
        action=MULTI_SAVE;
        MultiSavePath="";
    }
    bool success=false;
    qApp->setOverrideCursor (waitCursor);
    block();

    //New way!
    dbCursor <Article> *mycursor=new dbCursor <Article>;
    QString q;
    q.sprintf ("exists i: (lists[i]=%d) and (%s)",list2->ID,query);
    debug ("queryActions : %s",q.data());
    int n=mycursor->select(q.data());
    debug ("Query found %d items",n);
    if (n)
    {
        Article *art=mycursor->first();
        while (art)
        {
            success=actions(action,art,false);
            list2->updateByID(art->ID);
            art=mycursor->next();
        }
    }
    mycursor->reset();
    strictdelete=false;
    delete mycursor;
    strictdelete=true;

    db.commit();

    block(false);
    qApp->restoreOverrideCursor ();
    if (action==DECODE_ARTICLE)
    {
        decode();
    }
    return success;
}

bool Artdlg::taggedActions (int action)
{
    return queryActions(action,"ismarked=true");
}

bool Artdlg::unTaggedActions (int action)
{
    return queryActions(action,"ismarked=false");
}

bool Artdlg::readActions (int action)
{
    return queryActions(action,"isread=true");
}

bool Artdlg::unreadActions (int action)
{
    return queryActions(action,"isread=false");
}

bool Artdlg::allActions (int action)
{
    return queryActions(action,"true");
}

void Artdlg::updateScores()
{
    debug ("entered updateScores");
    QString stat;
    QStack <ArticleItem> stack;
    int c=0;
    Rule::updateGlobals();
    //I'm sure I am not doing it the best possible way
    ArticleItem *myChild = (ArticleItem *)(list2->firstChild());
    while( myChild )
    {
        if (!(myChild->ID.isEmpty()))
        {
            Article *art=new Article(myChild->ID);
            myChild->update(art);
        }
        if (!(c%20))
        {
            stat.sprintf ("Done for %d articles",c);
            statusBar()->changeItem(stat.data(),1);
            qApp->processEvents();
        }
        if (myChild->childCount()) //Has children
        {
            stack.push(myChild);
            myChild=(ArticleItem *)(myChild->firstChild());
        }
        else //no children, go for siblings
        {
            myChild = (ArticleItem *)(myChild->nextSibling());
        }
        if (!myChild) //no siblings, go for parent
            while (stack.count())
            {
                myChild=stack.pop(); //parent
                //parent is already done, go for it's siblng
                myChild = (ArticleItem *)(myChild->nextSibling());
                if (myChild) //there is a sibling
                    break;
                //if no sibling, go for parent again
            }
        c++;
    }
    debug ("leaving updateScores");
}

bool Artdlg::defaultActions(int action)
{
    bool s=false;
    ArticleItem *i=(ArticleItem *)(list2->currentItem());
    //FIXME perhaps if ID is empty it should act on the whole thread?
    if (i && (!(i->ID.isEmpty())))
    {
        Article art(i->ID);
        s=actions(action,&art,true);
        switch (action) //Not all actions require an update of the item
        {
        case REP_MAIL:
        case FOLLOWUP:
        case ARTLIST:
        case PAGE_DOWN_ARTICLE:
        case PAGE_UP_ARTICLE:
        case DECODE_ARTICLE:
        case SCROLL_UP_ARTICLE:
        case SCROLL_DOWN_ARTICLE:
        case CONFIG_FONTS:
        case CONFIG_BEHAV:
        case NO_LOCKED:
        case NO_READ:
        case FIND_ARTICLE:
        case EXPUNGE:
        case POST:
        case NO_CACHED:
        case EDIT_RULES:
        case UPDATE_SCORES:
        case CONFIG_SORTING:
        case LOOKUP_ALTAVISTA:
        case QUIT:
        case SCOREFRAME:
        case FILL_TREE:
        case CLOSE_WINDOW:
        case MULTI_SAVE:
        case COMBO_CONTENTS:
        case PREV:
        case NEXT:
            break;

        case LOAD_ART:
        case TAG_SET:
        case TAG_UNSET:
        case TAG_TOGGLE:
        case SAVE_ARTICLE:
        case PRINT_ARTICLE:
        case DECODE:
        case EXPIRE_TOGGLE:
        case EXPIRE_SET:
        case EXPIRE_UNSET:
        case POSTANDMAIL:
        case FORWARD:
        case DOWNLOAD_ARTICLE:
        case READ_TOGGLE:
        case READ_SET:
        case READ_UNSET:
            {
                assert (i);
                i->update();
                break;
            }
        }
    }
    else //ONLY actions that don't require an article go here
    {
        switch(action)
        {
        case ARTLIST:
        case PAGE_DOWN_ARTICLE:
        case PAGE_UP_ARTICLE:
        case SCROLL_UP_ARTICLE:
        case SCROLL_DOWN_ARTICLE:
        case CONFIG_FONTS:
        case CONFIG_BEHAV:
        case NO_LOCKED:
        case NO_READ:
        case FIND_ARTICLE:
        case EXPUNGE:
        case POST:
        case NO_CACHED:
        case EDIT_RULES:
        case UPDATE_SCORES:
        case CONFIG_SORTING:
        case LOOKUP_ALTAVISTA:
        case QUIT:
        case SCOREFRAME:
        case FILL_TREE:
        case CLOSE_WINDOW:
        case MULTI_SAVE:
        case COMBO_CONTENTS:
        case PREV:
        case NEXT:
            {
                s=actions(action,0,true);
                break;
            }
        default:
            s=true;
            break;
        }
    }
    return s;
}


bool Artdlg::actions (int action,Article *art,bool commit)
{
    bool success=false;
    switch (action)
    {
    case FILL_TREE:
        {
            fillTree();
            break;
        }
    case UPDATE_SCORES:
        {
            updateScores();
            fillTree();
            break;
        }
    case CLOSE_WINDOW:
        {
            this->close();
            break;
        }
    case QUIT:
        {
            main_widget->close();
            break;
        }
    case LOOKUP_ALTAVISTA:
        {
            assert (art!=0);
            art->lookupAltavista();
            break;
        }
    case LOAD_ART:
        {
            assert (art!=0);
            slotLoadArt(art->ID);
            break;
        }
    case READ_TOGGLE:
        {
            assert (art!=0);
            art->setRead(!art->isread,commit);
            break;
        }
    case READ_SET:
        {
            assert (art!=0);
            art->setRead(true,commit);
            break;
        }
    case READ_UNSET:
        {
            assert (art!=0);
            art->setRead(false,commit);
            break;
        }
    case EDIT_RULES:
        {
            if (!RulesDlg)
                RulesDlg=new rulesDlg();
            qApp->setOverrideCursor (arrowCursor);
            if (RulesDlg->exec()==1)
            {
            }
            qApp->restoreOverrideCursor ();
            Rule::updateGlobals();
            break;
        }
    case CONFIG_SORTING:
        {
            if (!SortDlg)
                SortDlg=new sortDlg();
            qApp->setOverrideCursor (arrowCursor);
            if (SortDlg->exec()==1)
            {
                conf->setGroup("Sorting");
                threaded=conf->readNumEntry("Threaded",true);
                key1=conf->readNumEntry("key1",KEY_SUBJECT);
                key2=conf->readNumEntry("key2",KEY_SCORE);
                key3=conf->readNumEntry("key3",KEY_DATE);
                key4=conf->readNumEntry("key4",KEY_SENDER);
                block();
                list2->setSorting(-1);
                if (key1==KEY_SENDER)
                    list2->setSorting(0);
                else if (key1==KEY_DATE)
                    list2->setSorting(1);
                else if (key1==KEY_LINES)
                    list2->setSorting(2);
                else if (key1==KEY_SCORE)
                    list2->setSorting(3);
                else if (key1==KEY_SUBJECT)
                    list2->setSorting(4);
                else if (key1==KEY_NONE)
                    list2->setSorting(-1);
                block(false);
            }
            qApp->restoreOverrideCursor ();
            break;
        }
    case CONFIG_FONTS:
        {
            qApp->setOverrideCursor (arrowCursor);
            fontsDlg dlg;
            if(dlg.exec()==1)
            {
                messwin->readConfig();
            }
            qApp->restoreOverrideCursor ();
            break;
        }
    case CONFIG_BEHAV:
        {
            qApp->setOverrideCursor (arrowCursor);
            ArtDlgBehavDlg dlg;
            if(dlg.exec()==1)
            {
                loadActions();
            }
            qApp->restoreOverrideCursor ();
            break;
        }
    case PRINT_ARTICLE:
        {
            assert (art!=0);
            conf->setGroup("Printing");
            if (conf->readNumEntry("HTMLPrinting",true))
            {
                block();
                //To print this way the article must be shown
                //FIXME this should catch the errors somehow
                slotLoadArt(art->ID);
                messwin->printMsg();
                block(false);
            }
            else
            {
                QString cmd=qstrdup(conf->readEntry("CommandName","lpr"));
                cmd+=" \"";
                cmd+=cachepath;
                cmd+="/";
                cmd.replace(QRegExp("//"),"/");
                cmd+=art->ID;
                cmd+="\"";
                debug ("print command: %s",cmd.data());
                QString s;
                s.sprintf("Printing %s",art->ID);
                qApp->processEvents ();
                statusBar()->changeItem(s.data(),1);
                system(cmd.data());
            }
            break;
        }
    case ARTLIST:
        {
            emit needConnection();
            if (server->isConnected())
            {
                getSubjects();
                fillTree();
                success=true;
            }
            break;
        }
    case PREV:
        {
            ArticleItem *item=(ArticleItem *)(list2->currentItem());
            if (item)
            {
                item=(ArticleItem *)(list2->prevItem(item));
            }
            if (item)
            {
                list2->jumpToID(item->ID);
                slotLoadArt(item->ID);
                item->update();
                item=(ArticleItem *)(item->parent());
            }
            success=true;
            break;
        }
    case NEXT:
        {
            ArticleItem *item=(ArticleItem *)(list2->currentItem());
            if (item)
            {
                item=(ArticleItem *)(list2->nextItem(item));
            }
            else
            {
                item=(ArticleItem *)(list2->firstChild());
            }
            if (item)
            {
                list2->jumpToID(item->ID);
                slotLoadArt(item->ID);
                item->update();
                success=true;
            }
            else
            {
                success=false;
            }
            break;

        }

    case NEXT_THREAD:
        {
            ArticleItem *item=(ArticleItem *)(list2->currentItem());
            if (item)
            {
                while (item->parent())
                    item=(ArticleItem *)(item->parent());
                item=(ArticleItem *)(item->nextSibling());
                if (item)
                {
                    list2->jumpToID(item->ID);
                    slotLoadArt(item->ID);
                    item->update();
                }
            }
            break;
        }
    case PREV_THREAD:
        {
            ArticleItem *item=(ArticleItem *)(list2->currentItem());
            if (item)
            {
                while (item->parent())
                    item=(ArticleItem *)(item->parent());
                item=(ArticleItem *)(list2->prevItem(item));;
                if (item)
                {
                    list2->jumpToID(item->ID);
                    slotLoadArt(item->ID);
                    item->update();
                }
            }
            break;
        }

    case DECODE_ARTICLE:
        {
            decArt(art);
            break;
        }
    case DECODE:
        {
            decode();
            break;
        }
    case TAG_TOGGLE:
        {
            assert (art!=0);
            art->setMarked(!art->ismarked,commit);
            break;
        }
    case TAG_SET:
        {
            assert (art!=0);
            art->setMarked(true,commit);
            break;
        }
    case TAG_UNSET:
        {
            assert (art!=0);
            art->setMarked(false,commit);
            break;
        }
    case SAVE_ARTICLE:
        {
            assert (art!=0);
            saveArt(art->ID);
            break;
        }
    case MULTI_SAVE:
        {
            assert (art!=0);
            multiSaveArt(art->ID);
            break;
        }

    case NO_READ:
        {
            unread = !unread;
            conf->setGroup("ArticleListOptions");
            conf->writeEntry("ShowOnlyUnread",unread);
            conf->sync();
            options->setItemChecked(NO_READ, unread);
            fillTree();
            success = true;
            break;
        }
    case NO_CACHED:
        {
            showcached = !showcached;
            conf->setGroup("ArticleListOptions");
            conf->writeEntry("ShowCachedArticles",showcached);
            conf->sync();
            options->setItemChecked(NO_CACHED, showcached);
            fillTree();
            success = true;
            break;
        }
    case NO_LOCKED:
        {
            showlocked = !showlocked;
            conf->setGroup("ArticleListOptions");
            conf->writeEntry("ShowLockedArticles",showlocked);
            conf->sync();
            options->setItemChecked(NO_LOCKED, showlocked);
            fillTree();
            success = true;
            break;
        }
    case PAGE_UP_ARTICLE:
        {
            messwin->slotScrollPrior();
            break;
        }
    case SCROLL_UP_ARTICLE:
        {
            messwin->slotScrollUp();
            break;
        }
    case PAGE_DOWN_ARTICLE:
        {
            messwin->slotScrollNext();
            break;
        }
    case SCROLL_DOWN_ARTICLE:

        {
            messwin->slotScrollDown();
            break;
        }
    case POST:
        {
            int mShowHeaders = 0xe0;
            conf->setGroup("Composer");
            conf->writeEntry("headers",mShowHeaders);

            KMMessage *m=new KMMessage();
            m->initHeader();
            m->setGroups(groupname);

            KMComposeWin *comp=new KMComposeWin(m);
            comp->show();
            break;
        }
    case FOLLOWUP:
        {
            assert (art!=0);
            int mShowHeaders = 0xe0;
            conf->setGroup("Composer");
            conf->writeEntry("headers",mShowHeaders);

            KMMessage *mm=new KMMessage();
            QString ts;
            server->article(art->ID,ts);
            mm->fromString(ts.data());
            KMMessage *m=mm->createReply(true);
            //            m->initHeader();
            debug ("id1-->%s<--id2-->%s<--",
                   m->id().data(),
                   mm->id().data());
            QString refs=mm->references();
            refs+=" ";
            refs+=mm->id();
            m->setReferences(refs);
            m->setGroups(mm->groups());
            m->setTo("");
            delete mm;

            KMComposeWin *comp=new KMComposeWin(m);
            comp->show();
            break;
        }
    case REP_MAIL:
        {
            assert (art!=0);

            int mShowHeaders  = 0x2c;
            conf->setGroup("Composer");
            conf->writeEntry("headers",mShowHeaders);

            KMMessage *m=new KMMessage();
            QString ts;
            server->article(art->ID,ts);
            m->fromString(ts.data());
            KMMessage *mm=m->createReply();
            m->initHeader();
            mm->setGroups("");

            KMComposeWin *comp=new KMComposeWin(mm);
            comp->show();
            break;
        }
    case FORWARD:
        {
            assert (art!=0);

            int mShowHeaders = 0x2c;
            conf->setGroup("Composer");
            conf->writeEntry("headers",mShowHeaders);

            KMMessage *m=new KMMessage();
            QString ts;
            server->article(art->ID,ts);
            m->fromString(ts.data());

            KMMessage *mm=m->createForward();
            m->initHeader();
            mm->setGroups("");

            KMComposeWin *comp=new KMComposeWin(mm);
            comp->show();
            break;
        }
    case POSTANDMAIL:
        {
            assert (art!=0);

            int mShowHeaders=0x6c;
            conf->setGroup("Composer");
            conf->writeEntry("headers",mShowHeaders);

            KMMessage *mm=new KMMessage();
            QString ts;
            server->article(art->ID,ts);
            mm->fromString(ts.data());
            KMMessage *m=mm->createReply(true);
            QString refs=mm->references();
            refs+=" ";
            refs+=mm->id();
            m->setReferences(refs);
            m->setGroups(mm->groups());
            delete mm;

            KMComposeWin *comp=new KMComposeWin(m);
            comp->show();
            break;

        }

    case EXPUNGE:
        {
            unread=false;
            actions(NO_READ,0,true);
            break;
        }

    case EXPIRE_TOGGLE:
        {
            assert (art!=0);

            art->toggleExpire(commit);
            break;
        }
    case EXPIRE_SET:
        {
            assert (art!=0);
            art->setExpire(true,commit);
            break;
        }
    case EXPIRE_UNSET:
        {
            assert (art!=0);
            art->setExpire(false,commit);
            break;
        }
    case FIND_ARTICLE:
        {
            if (!FindDlg)
            {
                FindDlg=new findArtDlg(0);
            }
            disconnect(FindDlg);
            connect (FindDlg,SIGNAL(FindAll(const char *,const char*,bool,bool)),
                     this,SLOT(FindAll(const char *,const char*,bool,bool)));
            connect (this,SIGNAL(haveMatches(QStrList &)),
                     FindDlg,SLOT(gotMatches(QStrList&)));
            connect (FindDlg->results,SIGNAL(leftClick(char *)),
                     list2,SIGNAL(leftClick(char *)));
            connect (FindDlg->results,SIGNAL(midClick(char *)),
                     list2,SIGNAL(midClick(char *)));
            connect (FindDlg->results,SIGNAL(rightClick(char *)),
                     list2,SIGNAL(rightClick(char *)));
            connect (FindDlg->results,SIGNAL(doubleClick(char *)),
                     list2,SIGNAL(doubleClick(char *)));
            connect (FindDlg->results,SIGNAL(returnPressed(char *)),
                     list2,SIGNAL(returnPressed(char *)));
            FindDlg->show();
            break;
        }
    case DOWNLOAD_ARTICLE:
        {
            assert (art!=0);
            QString id=art->ID;
            if ((server->isCached(id.data())!=PART_ALL))
            {
                if (!server->isConnected()) //not cached and not connected
                {
                    emit needConnection();
                    if (!server->isConnected())
                    {
                        success=false;
                        break;
                    }
                }
                //                    block();
                QString s;
                server->article(id.data(),s);
                //                    block(false);
                break;
            }
            else //its cached
            {
                success=true;
                break;
            }
        }
    }
    return success;
}
void Artdlg::slotLoadArt (const char *ID)
{
    if (!ID || (strlen(ID)==0))
        return;
    Article art(ID);
    if (loadArt(art.ID))
    {
        list2->jumpToID(art.ID);
        art.setRead(true);
    }
}

bool Artdlg::loadArt (QString id)
{
    //FIXME use exceptions

    debug ("ID=%s",id.data());
    QString s;

    if (!(server->isCached(id.data())==PART_ALL))
    {
        debug ("not cached entirely");
        if (!server->isConnected())
        {
            debug ("not connected");
            block(); //slow get, so block
            emit needConnection();
            if (!server->isConnected())
            {
                debug ("didn't connect");
                block(false);
                return false;
            }
            server->article(id.data(),s);
            block(false);
        }
        else
        {
            block();
            server->article(id.data(),s);
            block(false);
        }
    }
    else //this is a quick get, we can get without blocking
    {
        debug ("getting (quick)");
        server->article(id.data(),s);
    }
    if (s.isEmpty())
    {
        debug ("entered get from web");
        QString buffer(2048);
        QString urldata("http://ww2.altavista.digital.com/cgi-bin/news.cgi?id@");
        debug ("id-->%s",id.data());
        id=id.mid(1,id.length()-2);
        //    KURL::encodeURL(id);
        urldata+=id;
        KURL url(urldata.data());
        buffer.sprintf("From: KRN\n"
                       "To: You\n"
                       "Date: now\n"
                       "Subject: Problem getting article\n"
                       "ID: <00@00>\n"
                       "\n"
                       "This article seems to have expired or be missing from both"
                       "your news server and Krn's local cache\n"
                       "Or for some reason I just can't get it now.\n"
                       "However, if you have a functional Internet connection, you may"
                       "be able to find it at Altavista following this link:\n"
                       "%s\n\n\n",url.url().data());

        //Now, lets create a phony article with this data.
        KMMessage *m=new KMMessage();
        m->fromString(qstrdup(buffer));
        messwin->setMsg(m);
        debug ("exited get from web");
        return false;
    }
    else
    {
        KMMessage *m=new KMMessage();
        m->fromString(QString(s.data()));
        messwin->setMsg(m);
    }
    return true;
}


void Artdlg::saveArt (QString id)
{
    if (!server->isConnected())
    {
        if (!(server->isCached(id.data())==PART_ALL))
        {
            emit needConnection();
            if (!server->isConnected())
            {
                qApp->restoreOverrideCursor ();
                return;
            }
        }
    }
    qApp->setOverrideCursor (waitCursor);
    QString s;
    server->article(id.data(),s);
    if (!s.isEmpty())
    {
        qApp->setOverrideCursor (arrowCursor);
        QString f=KFileDialog::getSaveFileName(0,"*",this);
        if (!f.isEmpty())
        {
            int i=QMessageBox::Yes;
            if (QFile::exists(f))
            {
                QMessageBox *box=new QMessageBox(klocale->translate("KRN - Existing File"),
                                                 klocale->translate("The File you selected already exists"),
                                                 QMessageBox::Information,
                                                 QMessageBox::Yes,
                                                 QMessageBox::No,
                                                 QMessageBox::Abort);
                box->setButtonText(QMessageBox::Yes,
                                   klocale->translate("OverWrite"));
                box->setButtonText(QMessageBox::No,
                                   klocale->translate("Append"));
                box->setButtonText(QMessageBox::Abort,
                                   klocale->translate("Cancel"));
                i=box->exec();
            }

            switch (i)
            {
            case QMessageBox::Yes:
                {
                    kStringToFile(*s,f,false,true);
                    break;
                }
            case QMessageBox::No:
                {
                    QFile fi(f);
                    if (fi.open(IO_WriteOnly | IO_Append))
                    {
                        fi.writeBlock(s.data(),s.length());
                        fi.close();
                    }
                    else
                    {
                        warning ("Can't open file for writing");
                    }
                    break;
                }
            }
        }
        qApp->restoreOverrideCursor ();
    }
    else
    {
        s=klocale->translate("From: Krn\nTo: You\n\nError getting article.\nServer said:\n");
        s.append(server->lastStatusResponse());
        KMMessage *m=new KMMessage();
        m->fromString(s.data());
        messwin->setMsg(m);
        qApp->restoreOverrideCursor ();
        return;
    }
    qApp->restoreOverrideCursor ();
    return;
}

void Artdlg::multiSaveArt (QString id)
{
    if (!server->isConnected())
    {
        if (!(server->isCached(id.data())==PART_ALL))
        {
            emit needConnection();
            if (!server->isConnected())
            {
                qApp->restoreOverrideCursor ();
                return;
            }
        }
    }
    qApp->setOverrideCursor (waitCursor);
    QString s;
    server->article(id.data(),s);
    if (!s.isEmpty())
    {
        qApp->setOverrideCursor (arrowCursor);
        QString f=MultiSavePath;
        if (f.isEmpty())
            f=KFileDialog::getSaveFileName(0,"*",this);
        if (!f.isEmpty())
        {
            MultiSavePath=f;
            if (QFile::exists(f))
            {
                QFile fi(f);
                if (fi.open(IO_WriteOnly | IO_Append))
                {
                    fi.writeBlock(s.data(),s.length());
                    fi.close();
                }
                else
                {
                    warning ("Can't open file for writing");
                }
            }
            else
            {
                kStringToFile(*s,f,false,true);
            }
        }
        qApp->restoreOverrideCursor ();
    }
    else
    {
        s=klocale->translate("From: Krn\nTo: You\n\nError getting article.\nServer said:\n");
        s.append(server->lastStatusResponse());
        KMMessage *m=new KMMessage();
        m->fromString(s.data());
        messwin->setMsg(m);
        qApp->restoreOverrideCursor ();
        return;
    }
    qApp->restoreOverrideCursor ();
    return;
}


void Artdlg::decArt (Article *art)
{
    QString s;
    if (!(server->isCached(art->ID)==PART_ALL))
    {
        if (!server->isConnected())
        {
            emit needConnection();
            if (!server->isConnected())
            {
                qApp->restoreOverrideCursor ();
                return;
            }
        }
        server->article(art->ID,s);
        if (!s.isEmpty())
        {
            QString temp( cachepath+"/");
            temp+=art->ID;
            temp+=".head";
            artsToDecode.append( temp.data());

            temp= cachepath+"/";
            temp+=art->ID;
            temp+=".body";

            artsToDecode.append( temp.data());
            art->setAvailable(true);
        }
        else
        {
            art->setAvailable(false);
        }
    }
    else //the article *is* cached
    {
        QString temp( cachepath+"/"+art->ID+".head" );
        artsToDecode.append( temp.data());
        temp= cachepath+"/"+art->ID+".body" ;
        artsToDecode.append( temp.data());
    }


    art->setRead(true);
}


void Artdlg::getSubjects()
{
    debug ("entered getsubjects");
    qApp->setOverrideCursor(waitCursor);
    statusBar ()->changeItem (klocale->translate("Getting Article List"), 1);
    qApp->processEvents ();

    group->getSubjects(*server);

    statusBar ()->changeItem ("", 1);
    qApp->processEvents ();
    qApp->restoreOverrideCursor();
    debug ("left getsubjects");
}
void Artdlg::updateCounter(const char *s)
{
    statusBar()->changeItem (s, 1);
    qApp->processEvents();
}


void Artdlg::FindAll (const char *expr,const char *field,
                      bool casesen,bool wildmode)
{
    debug ("entered Artdlg::FindAll");
    Rule rule("temprule",expr,field,casesen,wildmode);

    QRegExp regex(expr,casesen,wildmode);

    int p1=rule.missingParts();
    bool needsConn=false;

    QStrList matches;


    //Now make a cursor contains all articles in this list.
    dbCursor <Article> *cursor=new dbCursor <Article>;
    QString s;
    s.sprintf ("exists i: (lists[i]=%d)",list2->ID);
    cursor->select(s.data());


    Article *art=cursor->first();
    while (art)
    {
        int p2=server->isCached(art->ID);
        if ((p1&PART_HEAD) > (p2&PART_HEAD)
            ||
            (p1&PART_BODY) > (p2&PART_BODY))
            needsConn=true;

        if (needsConn && (!server->isConnected()))
            emit needConnection ();

        if (needsConn && (!server->isConnected()))
            break;

        if (rule.match(*art))
        {

            debug ("found one: %s",art->ID);
            matches.append(art->ID);
        }
        art=cursor->next();
    }
    emit haveMatches(matches);
    cursor->reset();
    strictdelete=false;
    delete cursor;
    strictdelete=true;
}

void Artdlg::openURL (const char *s)
{
    KURL url(s);
    if( url.isMalformed() )
    {
        warning("Invalid URL clicked!");
        return;
    };
    if(strcmp(url.protocol(),"news")==0)
    {
        if(strchr(url.path(),'@')!=NULL)
        {
            QString s=url.path();
            s="<"+s.right(s.length()-1)+">";
            slotLoadArt(s);
        }
        else emit spawnGroup(url.path());
        return;
    }
    if(strcmp(url.protocol(),"http")==0)
    {
        KFM fm;
        fm.openURL(s);
        return;
    }
    if(strcmp(url.protocol(),"ftp")==0)
    {
        KFM fm;
        fm.openURL(s);
        return;
    }
    if(strcmp(url.protocol(),"mailto")==0)
    {
        QString address(url.path());
        KMMessage *m=new KMMessage();
        QString buffer(2048);
        buffer.sprintf ("To: %s\n\n\n",address.data());
        m->fromString (buffer);
        KMComposeWin *comp=new KMComposeWin(m);
        comp->show();
    }
}


void Artdlg::sortHeaders(int column)
{
    key1=KEY_NONE;
    key2=KEY_NONE;
    key3=KEY_NONE;
    key4=KEY_NONE;
    threaded=false;

    switch (column)
    {
    case 0:
        {
            key1=KEY_SENDER;
            break;
        }
    case 1:
        {
            key1=KEY_DATE;
            break;
        }
    case 2:
        {
            key1=KEY_LINES;
            break;
        }
    case 3:
        {
            key1=KEY_SCORE;
            break;
        }
    case 4:
        {
            key1=KEY_SUBJECT;
            break;
        }
    }
    fillTree();
}

void Artdlg::setTarget(int target)
{
    QObject::disconnect (toolBar(1),0,0,0);
    QObject::disconnect (tagPopup,0,0,0);
    QObject::disconnect (lockPopup,0,0,0);
    if (target==0)
    {
        QObject::connect (toolBar(1), SIGNAL (clicked (int)), this, SLOT (defaultActions (int)));
        QObject::connect (tagPopup, SIGNAL (activated (int)), this, SLOT (defaultActions (int)));
        QObject::connect (lockPopup, SIGNAL (activated (int)), this, SLOT (defaultActions (int)));
    }
    else if (target==1)
    {
        QObject::connect (toolBar(1), SIGNAL (clicked (int)), this, SLOT (taggedActions (int)));
        QObject::connect (tagPopup, SIGNAL (activated (int)), this, SLOT (taggedActions (int)));
        QObject::connect (lockPopup, SIGNAL (activated (int)), this, SLOT (taggedActions (int)));
    }
    else if (target==2)
    {
        QObject::connect (toolBar(1), SIGNAL (clicked (int)), this, SLOT (unTaggedActions (int)));
        QObject::connect (tagPopup, SIGNAL (activated (int)), this, SLOT (unTaggedActions (int)));
        QObject::connect (lockPopup, SIGNAL (activated (int)), this, SLOT (unTaggedActions (int)));
    }
    else if (target==3)
    {
        QObject::connect (toolBar(1), SIGNAL (clicked (int)), this, SLOT (allActions (int)));
        QObject::connect (tagPopup, SIGNAL (activated (int)), this, SLOT (allActions (int)));
        QObject::connect (lockPopup, SIGNAL (activated (int)), this, SLOT (allActions (int)));
    }
    else if (target==4)
    {
        QObject::connect (toolBar(1), SIGNAL (clicked (int)), this, SLOT (readActions (int)));
        QObject::connect (tagPopup, SIGNAL (activated (int)), this, SLOT (readActions (int)));
        QObject::connect (lockPopup, SIGNAL (activated (int)), this, SLOT (readActions (int)));
    }
    else if (target==5)
    {
        QObject::connect (toolBar(1), SIGNAL (clicked (int)), this, SLOT (unreadActions (int)));
        QObject::connect (tagPopup, SIGNAL (activated (int)), this, SLOT (unreadActions (int)));
        QObject::connect (lockPopup, SIGNAL (activated (int)), this, SLOT (unreadActions (int)));
    }
    if (target==0)
    {
        KToolBar *t=toolBar(1);
        t->setItemEnabled (SAVE_ARTICLE,true);
        t->setItemEnabled (PRINT_ARTICLE,true);
        t->setItemEnabled (REP_MAIL,true);
        t->setItemEnabled (FOLLOWUP,true);
        t->setItemEnabled (POSTANDMAIL,true);
        t->setItemEnabled (FORWARD,true);
    }
    else
    {
        KToolBar *t=toolBar(1);
        t->setItemEnabled (SAVE_ARTICLE,false);
        t->setItemEnabled (PRINT_ARTICLE,false);
        t->setItemEnabled (REP_MAIL,false);
        t->setItemEnabled (FOLLOWUP,false);
        t->setItemEnabled (POSTANDMAIL,false);
        t->setItemEnabled (FORWARD,false);
    }
}

void Artdlg::closeEvent (QCloseEvent *e)
{
    conf->setGroup("Geometry");
    conf->writeEntry("ArtX",x());
    conf->writeEntry("ArtY",y());
    conf->writeEntry("ArtW",width());
    conf->writeEntry("ArtH",height());
    conf->sync();
    group->isVisible=0;
    KTMainWindow::closeEvent(e);
}

void Artdlg::block(bool b)
{
    if (blocked && !b)
        blocked--;
    if (b)
        blocked++;

    if (blocked)
    {
        QApplication::setOverrideCursor(waitCursor);
        setEnabled (false);
        acc->setEnabled(false);
        list2->setEnabled(false);
        list2->viewport()->setEnabled(false);
        messwin->setEnabled(false);
    }
    else
    {
        setEnabled (true);
        acc->setEnabled(true);
        list2->setEnabled(true);
        list2->viewport()->setEnabled(true);
        messwin->setEnabled(true);
        QApplication::restoreOverrideCursor();
    }
}

void Artdlg::slotDoubleClick (const char *ID)
{
    Article *art=new Article(ID);
    if (server->isConnected())
    {
        debug ("slotDoubleClick doing %d for %s",doubleClickAction,ID);
        actions(doubleClickAction,art,true);
    }
    else
    {
        debug ("slotDoubleClick doing %d for %s",doubleClickActionOffline,ID);
        actions(doubleClickAction,art,true);
    }
    delete art;
}

void Artdlg::slotRightClick (const char *ID)
{
    Article *art=new Article(ID);
    if (server->isConnected())
    {
        debug ("slotRightClick doing %d for %s",doubleClickAction,ID);
        actions(rightClickAction,art,true);
    }
    else
    {
        debug ("slotRightClick doing %d for %s",doubleClickActionOffline,ID);
        actions(rightClickAction,art,true);
    }
    delete art;
}

void Artdlg::slotLeftClick (const char *ID)
{
    Article *art=new Article(ID);
    if (server->isConnected())
    {
        debug ("slotLeftClick doing %d for %s",doubleClickAction,ID);
        actions(leftClickAction,art,true);
    }
    else
    {
        debug ("slotLeftClick doing %d for %s",doubleClickActionOffline,ID);
        actions(leftClickAction,art,true);
    }
    delete art;
}

void Artdlg::loadActions()
{
    conf->setGroup("ArtDlgBehaviour");
    doubleClickAction=conf->readNumEntry("DoubleClickAction",LOAD_ART);
    rightClickAction=conf->readNumEntry("RightClickAction",TAG_TOGGLE);
    leftClickAction=conf->readNumEntry("LeftClickAction",DO_NOTHING);

    doubleClickActionOffline=conf->readNumEntry("DoubleClickActionOffline",LOAD_ART);
    rightClickActionOffline=conf->readNumEntry("RightClickActionOffline",TAG_TOGGLE);
    leftClickActionOffline=conf->readNumEntry("LeftClickActionOffline",DO_NOTHING);
}

