//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// This file os part of KRN, a newsreader for the KDE project.              //
// KRN is distributed under the GNU General Public License.                 //
// Read the acompanying file COPYING for more info.                         //
//                                                                          //
// KRN wouldn't be possible without these libraries, whose authors have     //
// made free to use on non-commercial software:                             //
//                                                                          //
// MIME++ by Doug Sauder                                                    //
// Qt     by Troll Tech                                                     //
//                                                                          //
// This file is copyright 1997 by                                           //
// Roberto Alsina <ralsina@unl.edu.ar>                                      //
// Magnus Reftel  <d96reftl@dtek.chalmers.se>                               //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
#ifndef Artdlg_included
#define Artdlg_included

#include <qstrlist.h>
#include <ktopwidget.h>

class KPanner;
class KMReaderWin;
class KNumericSpinBox;
class QPopupMenu;
class QAccel;
class QVBoxLayout;
class KNumericSpinBox;
class NNTP;
class NewsGroup;
class ArtList;
class Article;

class Artdlg : public KTopLevelWidget
{
    Q_OBJECT
        
public:
    
    Artdlg (NewsGroup *_group);
    virtual ~Artdlg();
    
    KMReaderWin *messwin;
    bool unread;
    void loadActions();
    bool queryActions (int action,const char *query);
protected:
    virtual void closeEvent (QCloseEvent *e);

public slots:
    void updateCounter(const char *);
    void openURL(const char *);
    void init (NewsGroup *_group);
    void sortHeaders(int column);
    void slotLoadArt (const char *ID);
    void slotLeftClick (const char *ID);
    void slotDoubleClick (const char *ID);
    void slotRightClick (const char *ID);
    bool defaultActions(int);
    bool actions(int,Article *art,bool c);
    bool taggedActions(int);
    bool unTaggedActions(int);
    bool allActions(int);
    bool readActions(int);
    bool unreadActions(int);
    void fillTree();
    void getSubjects();
    bool loadArt (QString id);
    void decArt (Article *);
    void saveArt (QString id);
    void multiSaveArt (QString id);
    void copyText(bool b);
    void FindAll (const char *,const char *,bool casesen,bool wildmode);
    void updateScores ();
    void setTarget(int);
        
signals:
    void needConnection ();
    void spawnGroup (QString name);
    void haveMatches (QStrList&);

public:
    int blocked;
    void block(bool b=true);
    
private:
    ArtList *list2;
    char *groupname;
    QAccel *acc;
    NewsGroup *group;
    KMenuBar *menu;
    QPopupMenu *article;
    QPopupMenu *taggedArticle;
    QPopupMenu *options;
    QPopupMenu *tagPopup;
    QPopupMenu *lockPopup;
    KPanner *panner;
    QVBoxLayout *gl;
    KStatusBar *status;
    KNumericSpinBox *minScore;
    bool showlocked;
    bool showcached;
    bool threaded;
    int doubleClickAction;
    int rightClickAction;
    int leftClickAction;
    int doubleClickActionOffline;
    int rightClickActionOffline;
    int leftClickActionOffline;
};


#endif // Artdlg_included
