
#include <qpainter.h>
#include <qbitmap.h>
#include <kapp.h>
#include <kiconloader.h>

#include "articleitem.h"
#include "article.h"
#include "artlist.h"
#include "kmmessage.h"


int KEY_SUBJECT=0;
int KEY_SCORE=1;
int KEY_SENDER=2;
int KEY_DATE=3;
int KEY_LINES=4;
int KEY_NONE=5;


ArticleItem::ArticleItem (QListView *list,Article *art):
    QListViewItem(list)
{
    if (!art)
        return;
    if (art->ID)
    {
        ((ArtList *)list)->items.insert(art->ID,this);
        ID=art->ID;
    }
    //ArticleItems should only be inserted in ArtLists
    art->lists.append(((ArtList *)list)->ID);
    update(art,true);
}

ArticleItem::ArticleItem (QListViewItem *parent,Article *art):
QListViewItem(parent)
{
    if (art->ID)
    {
        ((ArtList *)(parent->listView()))->items.insert(art->ID,this);
        ID=art->ID;
    }
    //ArticleItems should only be inserted in ArtLists
    art->lists.append(((ArtList *)(parent->listView()))->ID);
    update(art,true);
}

void ArticleItem::update()
{
    if (!ID.isEmpty())
    {
        Article *art=new Article (ID);
        update(art);
        delete art;
    }
}

void ArticleItem::update(Article *art,bool triggered)
{
    static bool status_pic_created=false;
    static QPixmap READ_PIC=ICON("red-bullet.xpm");
    static QPixmap UNREAD_PIC=ICON("green-bullet.xpm");
    static QPixmap THREAD_PIC=ICON("thread.xpm");
    static QPixmap MESSAGE_PIC=ICON("followup.xpm");
    static QPixmap LOCKED_PIC=ICON("locked.xpm");
    static QPixmap TAGGED_PIC=ICON("tagged.xpm");
    static QPixmap STATUS_PIC[16];

    if (!status_pic_created)
    {
        for (int i=0;i<15;i++)
        {
            STATUS_PIC[i].resize(48,16);
            QPainter p(&STATUS_PIC[i]);

            p.fillRect(0,0,48,16,QColor(255,255,255));

            if (i%2) //The first bit is read/unread
                p.drawPixmap(0,0,READ_PIC);
            else
                p.drawPixmap(0,0,UNREAD_PIC);

            //Second bit is tagged/untagged

            if (i&2)
                p.drawPixmap(16,0,TAGGED_PIC);

            //Third bit is locked/unlocked
            if (!(i&4))
                p.drawPixmap(32,0,LOCKED_PIC);

            p.flush();
            STATUS_PIC[i].setMask(STATUS_PIC[i].createHeuristicMask());
        }
        status_pic_created=true;

    }

    QString s1,s2,s3,s4,s5;
    if (strlen(art->From)!=0)
        s1=KMMessage::stripEmailAddr(art->From);
    else
        s1="Unknown Address";
    s2.sprintf("%2d/%2d/%2d",art->Date.day(),art->Date.month(),art->Date.year());
    s3.setNum((long int)(art->Lines));
    s4.setNum(art->score());
    s5=art->Subject;

    setText(0,s5);
    setText(1,s2);
    setText(2,s3);
    setText(3,s4);

    setPixmap(4,STATUS_PIC[(art->isread%2)+(art->ismarked%2)*2+(art->expire%2)*4]);

    setText(5,s1);
    if (childCount())
        setPixmap(0,THREAD_PIC);
    else
        setPixmap(0,MESSAGE_PIC);
    art->save(false);

    //And update on other views if needed
    if (!triggered)
    {
        int l=art->lists.length();
        int listID=((ArtList *)listView())->ID;
        debug ("article %s seems to be in %d lists",ID.data(),l);
        for (int i=0;i<l;i++)
        {
            if (art->lists[i]!=listID)
            {
                debug ("updating in another list (%d)",art->lists[i]);
                ArtList *alist=ArtList::getArtListByID(art->lists[i]);
                if (alist)
                {
                    ArticleItem *item=alist->items.find(art->ID);
                    if (item)
                    {
                        item->update(art,true);
                        debug ("updated it on the other list!");
                    }
                }
                else
                {
                    debug ("List doesn't seem to exist");
                }
            }
            else
            {
                debug ("already updated here");
            }
        }
    }
}

void ArticleItem::insertItem ( QListViewItem * newChild )
{
    static QPixmap THREAD_PIC=ICON("thread.xpm");
    setPixmap(0,THREAD_PIC);
    QListViewItem::insertItem(newChild);
}

void ArticleItem::removeItem ( QListViewItem * newChild )
{
    static QPixmap MESSAGE_PIC=ICON("followup.xpm");
    QListViewItem::removeItem(newChild);
    if (!childCount())
        setPixmap(0,MESSAGE_PIC);
}

int key1=0,key2=1,key3=2,key4=3;

QString noRe(QString subject)
{
    if (subject.left(3)=="Re:")
        subject=subject.right(subject.length()-3);
    return subject.stripWhiteSpace().lower();
}


const char *ArticleItem::key ( int column, bool ascending ) const
{
//    debug ("entered ArticleItem::key (%d)",column);
    static QString data(1024);
    QString main;
    static QString keys[6];
    if (text(0))
        keys[KEY_SENDER]=text(5);
    if (text(1))
        keys[KEY_DATE]=text(1);
    if (text(2))
        keys[KEY_LINES].sprintf ("%8d",atoi(text(2)));
    if (text(3))
        keys[KEY_SCORE].sprintf ("%6d",atoi(text(3)));
    if (text(5))
    {
        keys[KEY_SUBJECT]=noRe(text(0));
    }
    keys[KEY_NONE]="";

    if (column==5)
        main=keys[KEY_SENDER];
    else if (column==3)
        main=keys[KEY_SCORE];
    else if (column==2)
        main=keys[KEY_LINES];
    else if (column==1)
        main=keys[KEY_DATE];
    else if (column==0)
        main=keys[KEY_SUBJECT];

    static QString result;
    result= main+keys[key1]+keys[key2]+keys[key3]+keys[key4];
    result=result.lower();

//    debug ("leaving ArticleItem::key (%d)",column);
    return result.data();
}

int ArticleItem::width(const QFontMetrics & fm, const QListView * lv, int c ) const
{
    if (c==0)
        return 150;
    else
        return QListViewItem::width(fm,lv,c);
}


ThreadItem::ThreadItem (QListView *list,const char *subject):
    ArticleItem(list,0)
{
    static QPixmap FOLDER_PIC=ICON("krnfolder.xpm");
    Subject=subject;
    setText(0,Subject);
    setPixmap (0,FOLDER_PIC);
}

void ThreadItem::insertItem ( QListViewItem * newChild )
{
    QListViewItem::insertItem(newChild);
}

void ThreadItem::removeItem ( QListViewItem * newChild )
{
    QListViewItem::removeItem(newChild);
}

const char *ThreadItem::key ( int column, bool ascending ) const
{
    //FIXME: Well, this is probably not right at all
    QListViewItem *c=firstChild();
    if (c)
        return c->key(column,ascending);
    else
        return ArticleItem::key(column,ascending);
}

