#include "krnsender.h"

#include <unistd.h>
#include <sys/utsname.h>
#include <stdlib.h>
#include <time.h>
#include <kmsgbox.h>
#include <kapp.h>
#include <qregexp.h>

#include "kfileio.h"
#include "kmmessage.h"


extern QString outpath;
extern NNTP *server;

bool KRNSender::send(KMMessage *aMsg, short sendnow=-1)
{
    readConfig();
    debug ("KRNSender::send");
    aMsg->cleanupHeader();
    if (sendnow==-1 && server->isConnected())
        sendnow=1;
    else if (sendnow==-1)
        sendnow=0;

    if (sendnow)
        return sendNow(aMsg);
    else
        return queue(aMsg);
}

bool KRNSender::doSendNNTP (KMMessage *msg)
{
    QString str, msgStr;
    assert(msg != NULL);
    msg->cleanupHeader();

    //Empty bodies make news servers and readers go insane
    if (msg->body().isEmpty()) //GNKSA 16a
    {
        qApp->setOverrideCursor (arrowCursor);
        if (1==KMsgBox::yesNo(0,klocale->translate("Krn-Question"),
                              klocale->translate("You are posting an empty article\n"
                                                 "That sucks. Are you forcing me to post it anyway?")))
        {
            msg->setBody("\r\n\r\n\r\n");
            qApp->restoreOverrideCursor ();
        }
        else
        {
            qApp->restoreOverrideCursor ();
            return false;
        }
    }

    QString t;
    srand((int)time(NULL));
    //    t.sprintf("<%d.%d@%s>",time(NULL),rand(),server->hostname.data());
    //    debug ("posting with ID=%s",t.data());
    //    msg->setHeaderField("Message-ID",t.data());
    if (server->isReadOnly())
    {
        qApp->setOverrideCursor (arrowCursor);
        KMsgBox::message(0,"KRN - Error",
                         klocale->translate("This server is read only"
                                            "you can't post here!"));
        qApp->restoreOverrideCursor ();
        return false;
    }
    int errcode=server->Post();
#warning check error
    debug ("post/errcode-->%d",errcode);
    if (!errcode)
    {
        warning ("The server closed the connection!");
        return false;
    }
    if (errcode!=340)
    {
        warning("error posting, I said POST, and the server said:\n%s",
                server->StatusResponse().data());
        return false;
    }
    msgStr = msg->asString();
    msgStr=msgStr.replace("\r","");
    msgStr=msgStr.replace("\n","\r\n");

    //So this is where I need to change the CR/LF stuff


    errcode=server->SendData((const char *)msgStr);
#warning check error
    debug ("senddata/errcode-->%d",errcode);
    if (!errcode)
    {
        warning ("The server closed the connection!");
        return false;
    }
    if (errcode>240)
    {
        warning("error posting, I said DATA, and the server said:\n%s",
                server->StatusResponse().data());
        return false;
    }
    return true;
}

bool KRNSender::sendNow(KMMessage *aMsg)
{
    setMethod(smSMTP);
    bool success=false;
    debug ("sending now!!!");
    if (aMsg->body().isEmpty()) //GNKSA 16a
    {
        qApp->setOverrideCursor (arrowCursor);
        if (1==KMsgBox::yesNo(0,klocale->translate("Krn-Question"),
                              klocale->translate("You are posting an empty article\n"
                                                 "That sucks. Are you forcing me to post it anyway?")))
        {
            aMsg->setBody("\r\n\r\n\r\n");
            qApp->restoreOverrideCursor ();
        }
        else
        {
            qApp->restoreOverrideCursor ();
            return false;
        }
    }
    if ((!aMsg->to().isEmpty()) ||
        (!aMsg->cc().isEmpty()) ||
        (!aMsg->bcc().isEmpty())) //It has an email recipient
    {
        debug ("sending by SMTP");
        KMSendSMTP *realSender = new KMSendSMTP(this);
        success=realSender->start();
        if (!success)
        {
            warning ("failed to send by SMTP");
            return success;
        }
        success=realSender->send(aMsg);
        if (!success)
        {
            warning ("failed to send by SMTP");
            return success;
        }
        success=realSender->finish();
        if (!success)
        {
            warning ("failed to send by SMTP");
            return success;
        }
        delete realSender;
    }
    if (!aMsg->groups().isEmpty())//It has destination groups
    {
        success=doSendNNTP(aMsg);
    }
    return success;
}

bool KRNSender::queue(KMMessage *aMsg)
{
    debug ("queuing now!!!");
    if (aMsg->body().isEmpty()) //GNKSA 16a
    {
        qApp->setOverrideCursor (arrowCursor);
        if (1!=KMsgBox::yesNo(0,klocale->translate("Krn-Question"),
                              klocale->translate("You are posting an empty article\n"
                                                 "That sucks. Are you forcing me to post it anyway?")))
        {
            qApp->restoreOverrideCursor ();
            return false;
        }
        qApp->restoreOverrideCursor ();
    }
    QFile f(outpath+aMsg->id());
    if (f.exists())
    {
        warning ("There exists another message with this ID!\n That shouldn't happen!!!");
        return FALSE;
    }
    if (!f.open (IO_WriteOnly))
    {
        warning ("I can't open for writing, so I can't spool this thing");
        return FALSE;
    }
    debug ("Spooling the message");
    QString msgStr = aMsg->asString();
    f.writeBlock(msgStr.data(),msgStr.length());
    f.close();

    return true;
}


bool KRNSender::sendQueued(const char *fname)
{
    bool success=false;
    KMMessage *mm=new KMMessage;
    mm->fromString(kFileToString(outpath+fname,TRUE,TRUE));
    success=sendNow(mm);
    delete mm;
    if (success)
        unlink(QString(outpath+fname).data());
    return success;
}
