/***************************************************************************
                          ksmsview.h  -  description
                             -------------------
    begin                : Mon Sep 20 20:07:18 MEST 1999
    copyright            : (C) 1999 by Olaf Loesken
    email                : oloesken@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KSMSVIEW_H
#define KSMSVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 


// include files for KDE
#include <knewpanner.h>

// include files for Qt
#include <qwidget.h>
#include <qmultilinedit.h>

class KSMSDoc;

/** The KSMSView class provides the view widget for the KSMSApp instance.	
	* The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KSMSView is part of the
	* docuement-view model, it needs a reference to the document object connected with it by the KSMSApp class to manipulate and display
	* the document structure provided by the KSMSDoc class.
 	* 	
 	* @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
	* @version KDevelop version 0.4 code generation
 	*/

class KSMSView : public KNewPanner
{
  Q_OBJECT

public:
  /** Constructor for the main view */
  KSMSView(QWidget* parent = 0, const char* name=0);
  /** Destructor for the main view */
  ~KSMSView();

	/** returns a pointer to the document connected to the view instance. Mind that this method requires a KSMSApp instance as a parent
		* widget to get to the window document pointer by calling the KSMSApp::getDocument() method.
		*
		* @see KSMSApp#getDocument
		*/
	KSMSDoc* getDocument() const;
	
  /** contains the implementation for printing functionality */
	void print(QPrinter* m_pPrinter);

	/** return the SMS buffer */
	QMultiLineEdit* getSMSMessageWindow();
  /** return the widget to print the result of the server in */
  QMultiLineEdit* getServerLogWindow();
		
private:
	/** message_data is the edit area for the SMS message */
  QMultiLineEdit *message_data;
  /** serverlog contains the result of the server */
  QMultiLineEdit* serverlog;
	
};


#endif // KSMSVIEW_H


































