#ifndef KWVDIAL_H 
#define KWVDIAL_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include "wvstring.h"
#include "wvdial/wvdialer.h"
#include "configfile/wvconf.h"

#include "kwvdialwidget.h"
#include "kwvdialgraph.h"
#include "kwvdialconfig.h"
#include "kwvdialdock.h"

#include <kapp.h>
#include <ktmainwindow.h>
#include <kwm.h>

#include <time.h>

#include "kwvdial.xpm"

class Kwvdial : public KTMainWindow
{
	Q_OBJECT
public:
	Kwvdial(QWidget *parent = 0, const char *name = 0);
	virtual ~Kwvdial();

        WvConf        cfg;
    
public slots:
        void wvconnect(int id);
        void wvdisconnect();
    
protected slots:
	void viewlog();
	void viewgraph();
	void viewiconic();
	void invokeHelp();
	void wvabout();
        void wvconfig();
        void wvtimer();
	void fillmenu();
    
private:
    KMenuBar   *menuBar;
    KStatusBar *statusBar;
    QPopupMenu *connect_menu;
    
    WvDialer     *dialer;
    WvStringList *sections;
    WvLog	 log;
    
    KwvdialWidget *logview;
    KwvdialGraph  *graphview;
    KwvdialDock   *KWVDock;
    KwvdialConfig *config;

    time_t	currenttime;
    time_t	connecttime;
    int		timeonline;
    
};

#endif // KWVDIAL_H 
