
/**************************************************************************
   * libXicq - Originally written by tnc (xtrophy@it.dk)                     *
   *'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
   * net.cpp                                                                 *
   * network functions                                                       *
   **************************************************************************/


#include "net.h"
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include "libXicq.h"

#ifdef USE_SOCKS5
#define SOCKS
#include<socks.h>
#endif

#define MAXWATCH 25
#define MAXCLIENTS 25

extern UNKNOWNS unknownSocket[ MAXCLIENTS ];
extern NET_INFORMATION net_information;

int tcpSequence = 1;

struct sockaddr_in client,          // Client and server address info
            server;
int recvd,           // Number of bytes recieved
sent;                                 // Number of bytes sent
int structlength;    // Length of sockaddr structure

unsigned short int lastRecvd[ MAXWATCH ];  // Last received sequences
unsigned short int lastTCPRecvd[ MAXWATCH ];  // Last received sequences
extern NET_INFORMATION net_information;
extern USER_CONFIGURATION user_config;
extern CALLBACK_FUNCTIONS callback;
struct TCP_CLIENT TCP_CLIENTS[ MAXCLIENTS ];
extern CONTACT contactList[ MAXCONTACT ];
extern int contactNum;


void setnonblocking( int sock )
{
    int opts;

    opts = fcntl( sock, F_GETFL );
    opts = ( opts | O_NONBLOCK );
    if ( fcntl( sock, F_SETFL, opts ) < 0 )
    {
        printf( "ERROR NONBLOCK\n" );
        exit( 1 );
    }
    return;
}

// ICQ to IP and IP to ICQ............

unsigned int ipToIcq( unsigned int l )
/* return IP address in a format suitable to be transmitted to ICQ via
   packet class. ICQ uses big endian format, packet class return little
   endian ints, so we need a conversion from little to big endian.
   IP is represented in native format and converted to big-endian by
   htonl();
   "aa.bb.cc.dd" must be passed to packet class as 0xddccbbaa
   on entry, l is in native format:
   0xaabbccdd on Sparcs (big endian)
   0xddccbbaa on Intels (little endian)
   after htonl(), l is in big-endian (net format)
   0xaabbccdd
   to pass to ICQ, l is converted to little endian) */
{
    l = htonl( l );
    return ( l << 24 ) | ( ( l & 0xff00 ) << 8 ) | ( ( l & 0xff0000 ) >> 8 ) | ( l >> 24 );
}


unsigned int icqToIp( unsigned int l )
/* return IP address in a format suitable to be used by socket from a int
   returned by packet class. ICQ uses big endian format, packet class return
   little endian ints, so we need a conversion from little to big endian.
   IP is returned in native format by ntohl();
   "aa.bb.cc.dd" is received from packet class as 0xddccbbaa.
   0xddccbbaa is converted to net format (big endian) and than back to host
   via ntohl(). */
{
    return ntohl( ( l << 24 ) | ( ( l & 0xff00 ) << 8 ) | ( ( l & 0xff0000 ) >> 8 ) | ( l >> 24 ) );
}



/*
   **
   ** Initializes network functions - Called from icq_init()
   ** Returns -1 if something goes wrong
*/
int net_init( USER_CONFIGURATION *user_cfg )
{
    //  printf("udp init\n");
#ifndef KXOFFLINE
    //  printf("%s:%d\n",user_cfg->serverAddr, user_cfg->serverPort);
    net_information.serverAddr = user_cfg->serverAddr;
    net_information.serverPort = user_cfg->serverPort;
    net_information.clientAddr = 0; ;
    net_information.clientPort = 0;
    net_tcpSetup();
    if ( KXDEBUG ) printf( "TCP Port : %d\n", net_information.clientPort );
    if ( net_information.sock > 0 )
    {
        close ( net_information.sock );
    }
    net_information.sock = net_udpGetSocket();

    for ( int i = 0; i < MAXWATCH; i++ )
        lastRecvd[ i ] = 0;

    if ( KXDEBUG )
    {
        char string[ BUFSIZE ];
        if ( net_information.sock != -1 )
            sprintf( string, "Network initialized - Got socket %d.", net_information.sock );
        else
            sprintf( string, "Could not initialize network." );
        misc_log( string );
    }


    if ( net_information.sock != -1 )
        return 0;
    else
        return - 1;
#else
    return 0;
#endif
}

int net_tcpSetup()
{
    struct sockaddr_in local;
    unsigned int sizeofSockaddr = sizeof( struct sockaddr );
    memset( &local.sin_zero, 0, 8 );
    local.sin_family = AF_INET;
    local.sin_port = 0;
    local.sin_addr.s_addr = htonl( INADDR_ANY );

    net_information.tcpsock = socket( AF_INET, SOCK_STREAM, 0 );
    fcntl( net_information.tcpsock, O_NONBLOCK );
    bind( net_information.tcpsock, ( struct sockaddr* ) &local, sizeof( struct sockaddr ) );
    getsockname( net_information.tcpsock, ( struct sockaddr* ) &local, &sizeofSockaddr );
    if ( ( listen( net_information.tcpsock, 10 ) ) < 0 )
    {
        net_information.clientPort = 0;
        return - 1;
    }
    net_information.clientPort = ntohs( local.sin_port );
    return 0;
}

/*
   **
   ** Finds a socket we can use for UDP transfers
   ** Returns the socket, or -1 if we didn't get one.
*/
int net_udpGetSocket()
{
    net_information.sock = -1;

    struct in_addr *addr;                // Internet address of server
    int sock;                            // Our socket that we will talk through

    struct hostent *host;
    static struct in_addr saddr;
    saddr.s_addr = inet_addr( net_information.serverAddr );
    if ( saddr.s_addr != ( unsigned int ) - 1 )
        addr = &saddr;
    else
    {
        host = gethostbyname( net_information.serverAddr );
        if ( host != NULL )
        {
            addr = ( struct in_addr * ) *host->h_addr_list;
            // free(host);
        }
        else
        {
            perror( "libXicq: lookup" );
            return - 1;
        }
    }

    sock = socket( AF_INET, SOCK_DGRAM, 0 );
    if ( sock < 0 )
    {
        perror( "libXicq: socket" );
        return - 1;
    }

    /* Set up the server info */
    memset( ( char * ) &server, 0, sizeof( server ) );
    server.sin_family = AF_INET;
    server.sin_addr.s_addr = addr->s_addr;
    server.sin_port = htons( net_information.serverPort ); //port;

    /* Set up another structure for our local socket */
    memset( ( char * ) &client, 0, sizeof( client ) );
    client.sin_family = AF_INET;
    client.sin_addr.s_addr = htonl( INADDR_ANY );
    client.sin_port = htons( 0 );
    if ( bind( sock, ( struct sockaddr * ) &client, sizeof( client ) ) < 0 )
        {
            perror( "libXicq: bind" );
            return - 1;
        }
    return sock;
}



/*
   **
   ** Sends an UDP packet to the server
   ** Returns the number of written bytes, or -1 if something goes wrong
*/
int net_udpSend( unsigned char *mesg, int length )
{
    if ( KXDEBUG ) printf( "------  send  --------\n" );
    sent = sendto( net_information.sock, mesg, length, 0,
                   ( struct sockaddr * ) &server, sizeof( server ) );
    if ( sent < length )
    {
        perror( "libXicq: sendto" );
        return - 1;
    }

    return sent;
}



/*
   **
   ** Receives an UDP packet from the server
   ** Returns the number of read bytes, or -1 if something goes wrong
*/
int net_udpRecv( unsigned char *mesg, int length )
{
    if ( KXDEBUG ) printf( "------receive--------\n" );
    recvd = recv( net_information.sock, mesg, length, 0 );
    if ( recvd < 0 )
    {
        perror( "libXicq: recvfrom" );
        return - 1;
    }

    // Remove dublicate packets - not acks - (Our ack got lost)
    unsigned short int *cmd = ( unsigned short int * ) ( mesg + 2 );
    if ( *cmd != S_ACK )
    {
        unsigned short int * seq = ( unsigned short int * ) ( mesg + 4 );
        for ( int i = 0; i < MAXWATCH; i++ )
            if ( *seq == lastRecvd[ i ] )
            {
                if ( KXDEBUG )
                    printf( "Got duplicate packet, acking(%d-[%02X]).\n", i, *seq );
                send_ack( *seq );
                return 0;
            }

        for ( int i = MAXWATCH; i > 0; i-- )
            lastRecvd[ i ] = lastRecvd[ i - 1 ];
        lastRecvd[ 0 ] = *seq;
    }
    return recvd;
}


int net_tcpRecv( int y )
{
    int seq = -1;
    if ( contactList[ y ].len <= 0 )
    {
        contactList[ y ].data = ( unsigned char * ) malloc( 5 );
        if ( read( contactList[ y ].sock, ( void * ) contactList[ y ].data, 1 ) <= 0 )
        {
            close( contactList[ y ].sock );
            contactList[ y ].sock = -1;
        }
        if ( ( recvd = read( contactList[ y ].sock, ( void * ) ( contactList[ y ].data + 1 ), 1 ) ) <= 0 )
        {
        }
        else
        {
            //	 printf("[%02x][%02x]\n",data[0], data[1]);
            unsigned short * tlen = ( unsigned short * ) ( contactList[ y ].data );
            contactList[ y ].len = *tlen;
        }
        free( contactList[ y ].data );
        contactList[ y ].data = NULL;
    }
    else
    {
        contactList[ y ].rpacket = ( unsigned char * ) malloc( contactList[ y ].len + 1 );
        if ( ( recvd = read( contactList[ y ].sock, ( char * ) ( contactList[ y ].rpacket ), contactList[ y ].len ) ) <= 0 )
        {
            close( contactList[ y ].sock );
            contactList[ y ].sock = -1;
        }
        else
            seq = parseTCP( contactList[ y ].rpacket, contactList[ y ].sock, contactList[ y ].len );
        contactList[ y ].len = 0;
        free( contactList[ y ].rpacket );
        contactList[ y ].rpacket = NULL;
    }
    //   printf("len recvd: %d (%s)\n",recvd, strerror(errno));



    // Remove dublicate packets - not acks - (Our ack got lost)
    if ( seq > -1 )
    {
        for ( int i = 0; i < MAXWATCH; i++ )
            if ( seq == lastTCPRecvd[ i ] && seq != 0 )
            {
                if ( KXDEBUG )
                    misc_log( "Got duplicate TCP packet, acking." );
                // sendTCPack(seq, y);
                return 0;
            }

        for ( int i = 0; i < MAXWATCH - 1; i++ )
            lastTCPRecvd[ i ] = lastTCPRecvd[ i + 1 ];
        lastTCPRecvd[ MAXWATCH - 1 ] = seq;
    }

    return recvd;
}


int net_newtcpRecv( int y )
{
    int seq = -1;
    if ( unknownSocket[ y ].len <= 0 )
    {
        unknownSocket[ y ].data = ( unsigned char * ) malloc( 5 );
        if ( read( unknownSocket[ y ].sock, ( void * ) unknownSocket[ y ].data, 1 ) <= 0 )
        {
            close( unknownSocket[ y ].sock );
            unknownSocket[ y ].sock = -1;
        }
        if ( ( recvd = read( unknownSocket[ y ].sock, ( void * ) ( unknownSocket[ y ].data + 1 ), 1 ) ) <= 0 )
        {
        }
        else
        {
            //	 printf("[%02x][%02x]\n",data[0], data[1]);
            unsigned short * tlen = ( unsigned short * ) ( unknownSocket[ y ].data );
            unknownSocket[ y ].len = *tlen;
        }
        free( unknownSocket[ y ].data );
        unknownSocket[ y ].data = NULL;
    }
    else
    {
        unknownSocket[ y ].rpacket = ( unsigned char * ) malloc( unknownSocket[ y ].len + 1 );
        if ( ( recvd = read( unknownSocket[ y ].sock, ( char * ) ( unknownSocket[ y ].rpacket ), unknownSocket[ y ].len ) ) <= 0 )
        {
            close( unknownSocket[ y ].sock );
            unknownSocket[ y ].sock = -1;
        }
        else
        {
            seq = parseTCP( unknownSocket[ y ].rpacket, unknownSocket[ y ].sock, unknownSocket[ y ].len );
            if ( seq == -2 )
            {
                unknownSocket[ y ].sock = 0;
                unknownSocket[ y ].data = NULL;
            }
        }
        unknownSocket[ y ].len = 0;
        free( unknownSocket[ y ].rpacket );
        unknownSocket[ y ].rpacket = NULL;
    }
    //   printf("len recvd: %d (%s)\n",recvd, strerror(errno));

    // Remove dublicate packets - not acks - (Our ack got lost)
    if ( seq > -1 )
    {
        for ( int i = 0; i < MAXWATCH; i++ )
            if ( seq == lastTCPRecvd[ i ] && seq != 0 )
            {
                if ( KXDEBUG )
                    misc_log( "Got duplicate packet, acking." );
                // sendTCPack(seq, y);
                //	return 0;
            }

        for ( int i = 0; i < MAXWATCH - 1; i++ )
            lastTCPRecvd[ i ] = lastTCPRecvd[ i + 1 ];
        lastTCPRecvd[ MAXWATCH - 1 ] = seq;
    }

    return recvd;
}


void tcp_openConnection( UIN uin )
{
    int y;
    // printf("tcp Uin %d (%d)\n",uin, contactNum);
    for ( y = 0; y <= contactNum; y++ )
    {
        if ( contactList[ y ].uin == uin )
        {
            // printf("SOCK: %d, port: %d\n",contactList[y].sock,contactList[y].port);
            if ( contactList[ y ].sock == -1 && contactList[ y ].port > 0 )
            {
                //   printf("toconnect...\n");
                contactList[ y ].sock = socket( AF_INET, SOCK_STREAM, 0 );
                fcntl( contactList[ y ].sock, O_NONBLOCK );
                //setnonblocking(contactList[y].sock);
                struct sockaddr_in local, remote;
                unsigned int sizeofSockaddr = sizeof( struct sockaddr );
                memset( &local.sin_zero, 0, 8 );
                local.sin_family = remote.sin_family = AF_INET;

                remote.sin_port = htons( contactList[ y ].port );
                remote.sin_addr.s_addr = ( contactList[ y ].ip );

                local.sin_port = 0;
                local.sin_addr.s_addr = htonl( INADDR_ANY );

                //	    printf("Port: %d\n",local.sin_port);
                //	    printf("IP:%x\n",local.sin_addr.s_addr);
                //	    printf("try...\n");


                //bind( contactList[ y ].sock, ( struct sockaddr * ) &local, sizeofSockaddr );
                getsockname( contactList[ y ].sock, ( struct sockaddr * ) &local, &sizeofSockaddr );
                //            setnonblocking(contactList[y].sock);
                if ( connect( contactList[ y ].sock, ( struct sockaddr * ) &remote, sizeofSockaddr ) < 0 )
                    {
                        //   printf("Connect error %s\n", strerror(errno));
                        contactList[ y ].sock = -1;
                    }
                else
                {
                    setnonblocking( contactList[ y ].sock );
                    //   printf("Connected !!!\n");
                    unsigned int tuin = ( unsigned int ) user_config.uin;
                    unsigned short int none = 0x00;
                    unsigned short int sequence = ( unsigned short int ) tcpSequence++;
                    char *tmp, *tmp1;
                    tmp = ( char * ) malloc( BUFSIZE );
                    tmp1 = tmp;
                    none = 0xff;
                    memcpy( tmp, &none, 1 ); tmp += 1;
                    none = 0x03;
                    memcpy( tmp, &none, 2 ); tmp += 2;
                    none = 0x00;
                    memcpy( tmp, &none, 2 ); tmp += 2;
                    memcpy( tmp, &none, 2 ); tmp += 2;
                    memcpy( tmp, &none, 2 ); tmp += 2;

                    unsigned int	ip	= ipToIcq( net_information.clientAddr );
                    unsigned int lip = LOCALHOST;
                    unsigned int port = net_information.clientPort;
                    none = 0x04;
                    memcpy( tmp, &tuin, 4 ); tmp += 4;
                    memcpy( tmp, &ip, 4 ); tmp += 4;
                    memcpy( tmp, &lip, 4 ); tmp += 4;
                    memcpy( tmp, &none, 1 ); tmp += 1;
                    memcpy( tmp, &port, 4 ); tmp += 4;
                    memcpy( tmp, &sequence, 4 ); tmp += 4;


                    unsigned short int len = 9 + 21;
                    char size[ 2 ];
                    size[ 0 ] = len & 0xFF;
                    size[ 1 ] = ( len >> 8 ) & 0xFF;
                    if ( send( contactList[ y ].sock, &size, 2, 0 ) <= 0 )
                    {
                        contactList[ y ].sock = -1;
                        free( tmp1 );
                        return;
                    }
                    else
                    {
                        if ( ( send( contactList[ y ].sock, tmp1, len, 0 ) ) <= 0 )
                        {
                            contactList[ y ].sock = -1;
                            free( tmp );
                            return;
                        }
                    }
                    free( tmp1 );
                    return;
                }
            }
            else
            {
                return;
            }
        }
    }
}

int net_tcpSend( unsigned char *mesg2, unsigned short type, int y, unsigned int command, unsigned int seq )
{
    unsigned short int version = ( unsigned short int ) 0x03;
    unsigned int sequence = seq == 0 ? ( unsigned int ) tcpSequence++ : ( unsigned int ) seq;
    unsigned int tuin = ( unsigned int ) user_config.uin;
    unsigned short int none = 0x00, read_away = 0;
    unsigned char *mesg;
    mesg = ( unsigned char * ) malloc( BUFSIZE * 2 );
    mesg[ 0 ] = 0;
    if ( mesg2[ 0 ] == 1 && mesg2[ 1 ] == 2 )
    {
        if ( user_config.awaymsg ) read_away = 1;
        mesg[ 0 ] = 0;
    }
    else
        if ( strlen( ( char * ) mesg2 ) > 0 )
        {
            strcpy( ( char * ) mesg, ( char * ) mesg2 );
        }


    unsigned char *tmp, *tmp1, *tmpo;
    tmpo = ( unsigned char * ) malloc( BUFSIZE * 2 );
    tmp1 = tmpo;
    tmp = tmpo;
    memcpy( tmp, &tuin, 4 ); tmp += 4;
    memcpy( tmp, &version, 2 ); tmp += 2;
    memcpy( tmp, &command, 2 ); tmp += 2;
    memcpy( tmp, &none, 2 ); tmp += 2;
    memcpy( tmp, &tuin, 4 ); tmp += 4;
    memcpy( tmp, &type, 2 ); tmp += 2;
    unsigned int TCPstatus;
    switch ( user_config.status )
    {
        case STATUS_ONLINE:
            TCPstatus = TCP_ONLINE;
            break;
        case STATUS_AWAY:
            TCPstatus = TCP_AWAY;
            if ( command == TCP_ACK || read_away ) if ( user_config.awaymsg ) strcpy( ( char * ) mesg, user_config.awaymsg );
            break;
        case STATUS_DND:
            TCPstatus = TCP_DND;
            if ( command == TCP_ACK || read_away ) if ( user_config.awaymsg ) strcpy( ( char * ) mesg, user_config.awaymsg );
            break;
        case STATUS_NA:
            TCPstatus = TCP_NA;
            if ( command == TCP_ACK || read_away ) if ( user_config.awaymsg ) strcpy( ( char * ) mesg, user_config.awaymsg );
            break;
        case STATUS_OCCUPIED:
            TCPstatus = TCP_OCC;
            if ( command == TCP_ACK || read_away ) if ( user_config.awaymsg ) strcpy( ( char * ) mesg, user_config.awaymsg );
            break;
        default:
            TCPstatus = TCP_AWAY;
            if ( command == TCP_ACK || read_away ) if ( user_config.awaymsg ) strcpy( ( char * ) mesg, user_config.awaymsg );
            break;
    }
    unsigned short int len = strlen( ( char * ) mesg ) + 1;
    memcpy( tmp, &len, 2 ); tmp += 2;
    memcpy( tmp, mesg, len ); tmp += len;
    unsigned int	ip	= ipToIcq( net_information.clientAddr );
    unsigned int lip = LOCALHOST;
    unsigned int port = net_information.clientPort;
    none = 0x04;
    memcpy( tmp, &ip, 4 ); tmp += 4;
    memcpy( tmp, &lip, 4 ); tmp += 4;
    memcpy( tmp, &port, 4 ); tmp += 4;
    memcpy( tmp, &none, 1 ); tmp += 1;
    none = 0x00;

    memcpy( tmp, &TCPstatus, 4 ); tmp += 4;
    //   memcpy(tmp, &none, 2);       tmp += 2;
    //   memcpy(tmp, &none, 2);       tmp += 2;
    memcpy( tmp, &sequence, 4 ); tmp += 4;

    len = tmp - tmp1;
    tmp = tmp1;
    char size[ 2 ];
    size[ 0 ] = len & 0xFF;
    size[ 1 ] = ( len >> 8 ) & 0xFF;
    if ( KXDEBUG )
    {
        for ( int r = 0; r < len; r++ )
        {
            printf( "[%02x] ", tmp[ r ] );
        }
    }
    free( mesg );
    if ( send( contactList[ y ].sock, &size, 2, 0 ) <= 0 )
    {
        close( contactList[ y ].sock );
        contactList[ y ].sock = -1;
        if ( KXDEBUG ) printf( "send size goes wrong\n" );
        free( tmpo );
        return - 1;
    }
    else
    {
        if ( ( send( contactList[ y ].sock, tmp, len, 0 ) ) <= 0 )
        {
            close( contactList[ y ].sock );
            contactList[ y ].sock = -1;
            if ( KXDEBUG ) printf( "send packet goes wrong\n" );
            free( tmpo );
            return - 1;
        }
    }
    if ( KXDEBUG ) printf( "send packet goes OKr\n" );
    free( tmpo );
    return 0;
}

int net_TcpChatAcceptSend( int y, unsigned int seq )
{
    struct sockaddr_in local;
    unsigned int sizeofSockaddr = sizeof( struct sockaddr );
    memset( &local.sin_zero, 0, 8 );
    local.sin_family = AF_INET;
    local.sin_port = 0;
    local.sin_addr.s_addr = htonl( INADDR_ANY );

    int sock = socket( AF_INET, SOCK_STREAM, 0 );
    fcntl( sock, O_NONBLOCK );
    bind( sock, ( struct sockaddr* ) &local, sizeof( struct sockaddr ) );
    getsockname( sock, ( struct sockaddr* ) &local, &sizeofSockaddr );
    if ( ( listen( sock, 100 ) ) < 0 )
    {
        return - 1;
    }
    if ( contactList[ y ].chatsock > 0 )
        close( contactList[ y ].chatsock );
    contactList[ y ].chatsock = sock;
    //printf("port: %d-%d\n",sock, contactList[y].chatsock);
    //printf("port:: %d",ntohs(local.sin_port));
    contactList[ y ].chatport = ntohs( local.sin_port );
    contactList[ y ].server = 2;
    contactList[ y ].active = 0;
    if ( contactList[ y ].listensock )
        close( contactList[ y ].listensock );
    contactList[ y ].listensock = -1;
    /*
          //----------------------
     
          struct sockaddr_in local;
          unsigned int sizeofSockaddr = sizeof(struct sockaddr);
          memset(&local.sin_zero, 0, 8);
          local.sin_family = AF_INET;
          local.sin_port  = 0;
          local.sin_addr.s_addr = htonl(INADDR_ANY );
     
          net_information.tcpsock= socket(AF_INET, SOCK_STREAM, 0);
          fcntl(net_information.tcpsock, O_NONBLOCK);
          bind(net_information.tcpsock, (struct sockaddr*)&local, sizeof(struct sockaddr));
          getsockname(net_information.tcpsock, (struct sockaddr*)&local, &sizeofSockaddr);
          if ((listen(net_information.tcpsock, 10))<0)
          {
          net_information.clientPort=0;
          return -1;
          }
          net_information.clientPort=ntohs(local.sin_port);
     
          //----------------------
    */
    unsigned short int version = ( unsigned short int ) 0x03;
    unsigned int sequence = ( unsigned int ) seq;
    unsigned int tuin = ( unsigned int ) user_config.uin;
    unsigned long int none = 0x00;
    unsigned short int command = 0x07da, type = 0x02;
    unsigned char *tmp, *tmp1, *tmpo;

    tmpo = ( unsigned char * ) malloc( BUFSIZE * 2 );
    tmp1 = tmpo;
    tmp = tmpo;
    unsigned int TCPstatus;
    switch ( user_config.status )
    {
        case STATUS_ONLINE:
            TCPstatus = TCP_ONLINE;
            break;
        case STATUS_AWAY:
            TCPstatus = TCP_AWAY;
            break;
        case STATUS_DND:
            TCPstatus = TCP_DND;
            break;
        case STATUS_NA:
            TCPstatus = TCP_NA;
            break;
        case STATUS_OCCUPIED:
            TCPstatus = TCP_OCC;
            break;
        default:
            TCPstatus = TCP_AWAY;
            break;
    }
    unsigned int	ip	= ipToIcq( net_information.clientAddr );
    unsigned int lip = LOCALHOST;
    unsigned int port = net_information.clientPort;

    memcpy( tmp, &tuin, 4 ); tmp += 4;
    memcpy( tmp, &version, 2 ); tmp += 2;
    memcpy( tmp, &command, 2 ); tmp += 2;
    none = 0;
    memcpy( tmp, &none, 2 ); tmp += 2;
    memcpy( tmp, &tuin, 4 ); tmp += 4;
    memcpy( tmp, &type, 2 ); tmp += 2;

    none = 0x0001;                            // replace megs !!
    memcpy( tmp, &none, 2 ); tmp += 2;
    none = 0x00;
    memcpy( tmp, &none, 1 ); tmp += 1;

    memcpy( tmp, &ip, 4 ); tmp += 4;
    memcpy( tmp, &lip, 4 ); tmp += 4;
    memcpy( tmp, &port, 4 ); tmp += 4;
    none = 0x04;
    memcpy( tmp, &none, 1 ); tmp += 1;
    memcpy( tmp, &TCPstatus, 4 ); tmp += 4;
    none = 0x0001;
    memcpy( tmp, &none, 2 ); tmp += 2;
    none = 0x00;
    memcpy( tmp, &none, 1 ); tmp += 1;
    //   memcpy(tmp, &none, 2);       tmp += 2;
    //   memcpy(tmp, &none, 2);       tmp += 2;
    int nport = ntohs( local.sin_port );
    char tport[ 3 ];
    tport[ 1 ] = ( ( char * ) ( &nport ) ) [ 1 ];
    tport[ 0 ] = ( ( char * ) ( &nport ) ) [ 0 ];
    tport[ 2 ] = 0;
    char back[ 3 ];
    back[ 1 ] = ( ( char * ) ( &nport ) ) [ 0 ];
    back[ 0 ] = ( ( char * ) ( &nport ) ) [ 1 ];
    back[ 2 ] = 0;

    none = 0x0000;

    memcpy( tmp, &back[ 0 ], 1 ); tmp += 1;
    memcpy( tmp, &back[ 1 ], 1 ); tmp += 1;
    memcpy( tmp, &none, 2 ); tmp += 2;

    memcpy( tmp, &tport[ 0 ], 1 ); tmp += 1;
    memcpy( tmp, &tport[ 1 ], 1 ); tmp += 1;
    memcpy( tmp, &none, 2 ); tmp += 2;

    memcpy( tmp, &sequence, 4 ); tmp += 4;

    unsigned short int len = tmp - tmp1;
    tmp = tmp1;
    char size[ 2 ];
    size[ 0 ] = len & 0xFF;
    size[ 1 ] = ( len >> 8 ) & 0xFF;
    if ( KXDEBUG )
    {
        for ( int r = 0; r < len; r++ )
        {
            printf( "[%02x] ", tmp[ r ] );
        }
    }

    if ( send( contactList[ y ].sock, &size, 2, 0 ) <= 0 )
    {
        close( contactList[ y ].sock );
        contactList[ y ].sock = -1;
        if ( KXDEBUG ) printf( "send size goes wrong\n" );
        free( tmpo );
        return - 1;
    }
    else
    {
        if ( ( send( contactList[ y ].sock, tmp, len, 0 ) ) <= 0 )
        {
            close( contactList[ y ].sock );
            contactList[ y ].sock = -1;
            if ( KXDEBUG ) printf( "send packet goes wrong\n" );
            free( tmpo );
            return - 1;
        }
    }
    if ( KXDEBUG ) printf( "send chat accept packet goes OKr\n" );
    free( tmpo );

    return 0;
}

int net_ChatServer( int y )
{
    //  int seq=-1;
    if ( contactList[ y ].chatlen <= 0 )
    {
        if ( KXDEBUG ) printf( "reading TCP len\n" );
        char data[ 6 ];
        if ( read( contactList[ y ].listensock, ( void * ) data, 1 ) <= 0 )
        {
            close( contactList[ y ].listensock );
            contactList[ y ].listensock = -1;
        }
        if ( ( recvd = read( contactList[ y ].listensock, ( void * ) ( data + 1 ), 1 ) ) <= 0 )
        {
        }
        else
        {
            //	 printf("[%02x][%02x]\n",data[0], data[1]);
            unsigned short * tlen = ( unsigned short * ) ( data );
            contactList[ y ].chatlen = *tlen;
        }
        if ( KXDEBUG ) printf( "done reading TCP len\n" );
        if ( KXDEBUG ) printf( "msg len wating: %d\n", contactList[ y ].chatlen );
    }
    else
    {
        if ( KXDEBUG ) printf( "gedding TCP stuff\n" );
        contactList[ y ].chatrpacket = ( unsigned char * ) malloc( contactList[ y ].chatlen + 1 );
        if ( ( recvd = read( contactList[ y ].listensock, ( char * ) ( contactList[ y ].chatrpacket ), contactList[ y ].chatlen ) ) <= 0 )
        {
            close( contactList[ y ].listensock );
            contactList[ y ].listensock = -1;
            contactList[ y ].status = 0;
            contactList[ y ].server = 0;
        }
        else
        {
            if ( KXDEBUG ) printf( "parse TCP stuff(%d, %d )\n", contactList[ y ].server, contactList[ y ].status );
            if ( contactList[ y ].server == 1 )
            {
                parse_ChatFunctions( y );
            }
            else if ( contactList[ y ].server == 2 )
            {
                if ( KXDEBUG ) printf( "send chat functions....\n" );
                if ( contactList[ y ].active == 0 )
                {
                    if ( net_sendChatFunctions( y ) != 0 )
                    {
                        contactList[ y ].chatlen = 0;
                        free( contactList[ y ].chatrpacket );
                        contactList[ y ].chatrpacket = NULL;
                        return - 1;
                    }
                    contactList[ y ].active = 2;
                }
            }
        }
        contactList[ y ].chatlen = 0;
        free( contactList[ y ].chatrpacket );
        contactList[ y ].chatrpacket = NULL;
    }
    //   printf("len recvd: %d (%s)\n",recvd, strerror(errno));
    return recvd;
}


int net_sendChatColors( int y )  // sending chat info packet for requests....
{
    unsigned int port = ( unsigned int ) contactList[ y ].chatport;
    unsigned int none = 0x00, Uin = user_config.uin;
    unsigned char *tmp, *tmp1, *tmpo;

    tmpo = ( unsigned char * ) malloc( BUFSIZE );
    tmp1 = tmpo;
    tmp = tmpo;
    none = 0x64;
    memcpy( tmp, &none, 4 ); tmp += 4;
    memcpy( tmp, &Uin, 4 ); tmp += 4;
    char nick[ 25 ];
    strcpy( nick, user_config.nick );
    int fsize = strlen( nick ) + 1;
    //printf("Nick: %s, %d\n",nick, fsize);
    memcpy( tmp, &fsize, 2 ); tmp += 2;
    memcpy( tmp, &nick, fsize ); tmp += fsize;
    none = 0x00FFFFFF;
    memcpy( tmp, &none, 4 ); tmp += 4;
    none = 0x00000000;
    memcpy( tmp, &none, 4 ); tmp += 4;
    none = 0x3;
    memcpy( tmp, &none, 4 ); tmp += 4;
    memcpy( tmp, &port, 4 ); tmp += 4;
    unsigned int lip = LOCALHOST;
    memcpy( tmp, &lip, 4 ); tmp += 4;
    memcpy( tmp, &lip, 4 ); tmp += 4;
    none = 0x04;
    memcpy( tmp, &none, 1 ); tmp += 1;

    none = 0x5A75;
    memcpy( tmp, &none, 2 ); tmp += 2;
    char fontn[ 8 ];
    strcpy( fontn, "Arial" );
    int fonts = 12;
    memcpy( tmp, &fonts, 2 ); tmp += 2;
    none = 0x00000000;
    memcpy( tmp, &none, 4 ); tmp += 4;
    memcpy( tmp, &none, 2 ); tmp += 2;
    fontn[ 5 ] = 0;
    fsize = strlen( fontn ) + 1;
    memcpy( tmp, &fsize, 2 ); tmp += 2;
    memcpy( tmp, &fontn, fsize ); tmp += fsize;
    none = 0x00000000;
    memcpy( tmp, &none, 2 ); tmp += 2;

    unsigned short int len = tmp - tmp1;
    tmp = tmp1;
    char size[ 2 ];
    size[ 0 ] = len & 0xFF;
    size[ 1 ] = ( len >> 8 ) & 0xFF;
    if ( KXDEBUG )
    {
        printf( "sending Chat color functions-----------------\n" );
        for ( int r = 0; r < len; r++ )
        {
            printf( "[%02x] ", tmp[ r ] );
        }
    }

    if ( send( contactList[ y ].listensock, &size, 2, 0 ) <= 0 )
    {
        close( contactList[ y ].listensock );
        contactList[ y ].listensock = -1;
        if ( KXDEBUG ) printf( "send size goes wrong\n" );
        free( tmpo );
        return - 1;
    }
    else
    {
        if ( ( send( contactList[ y ].listensock, tmp, len, 0 ) ) <= 0 )
        {
            close( contactList[ y ].listensock );
            contactList[ y ].listensock = -1;
            if ( KXDEBUG ) printf( "send packet goes wrong\n" );
            free( tmpo );
            return - 1;
        }
    }
    if ( KXDEBUG ) printf( "color Chat Functions goes OKr\n" );
    free( tmpo );
    return 0;
}


int net_ChatRead( int y, int len )
{
    char * data;
    len = 0;
    data = ( char * ) malloc( BUFSIZE + 1 );
    if ( KXDEBUG ) printf( "get chat commando (len: %d)\n", len );
    if ( ( len = read( contactList[ y ].listensock, data, BUFSIZE ) ) <= 0 )
    {
        ( *callback.closeChat ) ( contactList[ y ].uin );
        close( contactList[ y ].listensock );
        contactList[ y ].listensock = -1;
        contactList[ y ].clas = NULL;
        contactList[ y ].server = 0;
        contactList[ y ].active = 0;
        free( data );
        return - 1;
    }
    if ( KXDEBUG ) printf( "get commando: %02X\n", data[ 0 ] );
    if ( contactList[ y ].clas )
    {
        ( *callback.putChar ) ( contactList[ y ].uin, data, len );
    }
    return 0;
}

int net_send2chat( int sock, char *data, int len )
{
    if ( KXDEBUG )
    {
        for ( int r = 0; r < len; r++ )
        {
            printf( "[%02x] ", data[ r ] );
        }
    }
    return send( sock, data, len, 0 );
}

int net_sendRequest( int y, char *mesg )
{
    unsigned short int version = ( unsigned short int ) 0x03;
    unsigned int sequence = ( unsigned int ) tcpSequence++;
    unsigned int tuin = ( unsigned int ) user_config.uin, none = 0x00;
    unsigned short int command = TCP_START, type = TCP_CHAT;

    unsigned char *tmp, *tmp1, *tmpo;
    tmpo = ( unsigned char * ) malloc( BUFSIZE );
    tmp1 = tmpo;
    tmp = tmpo;
    memcpy( tmp, &tuin, 4 ); tmp += 4;
    memcpy( tmp, &version, 2 ); tmp += 2;
    memcpy( tmp, &command, 2 ); tmp += 2;
    memcpy( tmp, &none, 2 ); tmp += 2;
    memcpy( tmp, &tuin, 4 ); tmp += 4;
    memcpy( tmp, &type, 2 ); tmp += 2;

    unsigned short int len = strlen( ( char * ) mesg ) + 1;

    memcpy( tmp, &len, 2 ); tmp += 2;
    memcpy( tmp, mesg, len ); tmp += len;
    unsigned int	ip	= ipToIcq( net_information.clientAddr );
    //unsigned int lip = LOCALHOST;
    unsigned int port = net_information.clientPort;
    none = 0x04;
    memcpy( tmp, &ip, 4 ); tmp += 4;
    memcpy( tmp, &ip, 4 ); tmp += 4;
    memcpy( tmp, &port, 4 ); tmp += 4;
    memcpy( tmp, &none, 1 ); tmp += 1;
    none = 0x00;
    unsigned int TCPstatus;
    switch ( user_config.status )
    {
        case STATUS_ONLINE:
            TCPstatus = TCP_ONLINE;
            break;
        case STATUS_AWAY:
            TCPstatus = TCP_AWAY;
            break;
        case STATUS_DND:
            TCPstatus = TCP_DND;
            break;
        case STATUS_NA:
            TCPstatus = TCP_NA;
            break;
        case STATUS_OCCUPIED:
            TCPstatus = TCP_OCC;
            break;
        default:
            TCPstatus = TCP_AWAY;
            break;
    }
    TCPstatus = 0x10010000;
    memcpy( tmp, &TCPstatus, 4 ); tmp += 4;

    none = 0x0001;
    memcpy( tmp, &none, 4 ); tmp += 4;
    none = 0;
    memcpy( tmp, &none, 4 ); tmp += 4;
    memcpy( tmp, &none, 3 ); tmp += 3;
    memcpy( tmp, &sequence, 4 ); tmp += 4;

    len = tmp - tmp1;
    tmp = tmp1;
    char size[ 2 ];
    size[ 0 ] = len & 0xFF;
    size[ 1 ] = ( len >> 8 ) & 0xFF;
    if ( KXDEBUG )
    {
        for ( int r = 0; r < len; r++ )
        {
            printf( "[%02x] ", tmp[ r ] );
        }
    }

    if ( send( contactList[ y ].sock, &size, 2, 0 ) <= 0 )
    {
        close( contactList[ y ].sock );
        contactList[ y ].sock = -1;
        if ( KXDEBUG ) printf( "send size goes wrong\n" );
        free( tmpo );
        return - 1;
    }
    else
    {
        if ( ( send( contactList[ y ].sock, tmp, len, 0 ) ) <= 0 )
        {
            close( contactList[ y ].sock );
            contactList[ y ].sock = -1;
            if ( KXDEBUG ) printf( "send packet goes wrong\n" );
            free( tmpo );
            return - 1;
        }
    }
    if ( KXDEBUG ) printf( "send packet goes OKr\n" );
    free( tmpo );
    return 0;
}

int net_doChatClient( int i )
{
    unsigned int none;
    unsigned int tuin = ( unsigned int ) user_config.uin;
    unsigned short int len;

    contactList[ i ].listensock = socket( AF_INET, SOCK_STREAM, 0 );
    fcntl( contactList[ i ].listensock, O_NONBLOCK );
    //setnonblocking(contactList[i].sock);
    struct sockaddr_in local, remote;
    unsigned int sizeofSockaddr = sizeof( struct sockaddr );
    memset( &local.sin_zero, 0, 8 );
    local.sin_family = remote.sin_family = AF_INET;

    remote.sin_port = htons( contactList[ i ].chatport );
    remote.sin_addr.s_addr = ( contactList[ i ].ip );

    local.sin_port = htons( 0 );
    local.sin_addr.s_addr = htonl( INADDR_ANY );

    //   bind(contactList[i].listensock, (struct sockaddr *)&local, sizeofSockaddr);
    //   getsockname(contactList[i].listensock, (struct sockaddr *)&local, &sizeofSockaddr);
    //            setnonblocking(contactList[i].sock);
    if ( connect( contactList[ i ].listensock, ( struct sockaddr * ) &remote, sizeofSockaddr ) < 0 )
        {
            //   printf("Connect error %s\n", strerror(errno));
            contactList[ i ].listensock = -1;
            if ( KXDEBUG ) printf( "chat connect goes wrong.. \n" );
        }
    else
    {
        char size[ 5 ];
        setnonblocking( contactList[ i ].listensock );

        unsigned char *tmp, *tmp1, *tmpo;
        tmpo = ( unsigned char * ) malloc( BUFSIZE );
        tmp1 = tmpo;
        tmp = tmpo;

        none = 0xFF;
        memcpy( tmp, &none, 1 ); tmp += 1;
        none = 0x04;
        memcpy( tmp, &none, 4 ); tmp += 4;
        none = ( UIN ) contactList[ i ].chatport;
        memcpy( tmp, &none, 4 ); tmp += 4;
        memcpy( tmp, &tuin, 4 ); tmp += 4;
        unsigned int	ip	= ipToIcq( net_information.clientAddr );
        unsigned int lip = LOCALHOST;

        memcpy( tmp, &ip, 4 ); tmp += 4;
        memcpy( tmp, &lip, 4 ); tmp += 4;

        none = 0x04;
        memcpy( tmp, &none, 1 ); tmp += 1;
        none = ( UIN ) contactList[ i ].chatport;
        memcpy( tmp, &none, 4 ); tmp += 4;

        len = tmp - tmp1;
        tmp = tmp1;
        size[ 0 ] = len & 0xFF;
        size[ 1 ] = ( len >> 8 ) & 0xFF;

        if ( KXDEBUG )
        {
            for ( int r = 0; r < len; r++ )
            {
                printf( "[%02x] ", tmp[ r ] );
            }
        }

        if ( send( contactList[ i ].listensock, &size, 2, 0 ) <= 0 )
        {
            close( contactList[ i ].listensock );
            contactList[ i ].listensock = -1;
            if ( KXDEBUG ) printf( "send chat handshake size goes wrong\n" );
            free( tmpo );
            return - 1;
        }
        else
        {
            if ( ( send( contactList[ i ].listensock, tmp, len, 0 ) ) <= 0 )
            {
                close( contactList[ i ].listensock );
                contactList[ i ].listensock = -1;
                if ( KXDEBUG ) printf( "send chat handshake goes wrong\n" );
                free( tmpo );
                return - 1;
            }
        }
        if ( KXDEBUG ) printf( "send chat handshake goes OK...\n" );
        free( tmpo );

        tmpo = ( unsigned char * ) malloc( BUFSIZE );
        tmp1 = tmpo;
        tmp = tmpo;


        none = 0x64;
        memcpy( tmp, &none, 4 ); tmp += 4;
        none = 0xFFFFFFFC;
        memcpy( tmp, &none, 4 ); tmp += 4;
        memcpy( tmp, &tuin, 4 ); tmp += 4;

        char nick[ 25 ];
        strcpy( nick, user_config.nick );
        int fsize = strlen( nick ) + 1;
        //printf("Nick: %s, %d\n",nick, fsize);
        memcpy( tmp, &fsize, 2 ); tmp += 2;
        memcpy( tmp, &nick, fsize ); tmp += fsize;

        char back[ 3 ];
        back[ 1 ] = ( ( char * ) ( &contactList[ i ].chatport ) ) [ 0 ];
        back[ 0 ] = ( ( char * ) ( &contactList[ i ].chatport ) ) [ 1 ];
        back[ 2 ] = 0;
        memcpy( tmp, &back[ 0 ], 1 ); tmp += 1;
        memcpy( tmp, &back[ 1 ], 1 ); tmp += 1;

        none = 0x00FFFFFF;
        memcpy( tmp, &none, 4 ); tmp += 4;
        none = 0x00000000;
        memcpy( tmp, &none, 4 ); tmp += 4;
        none = 0x00;
        memcpy( tmp, &none, 1 ); tmp += 1;


        len = tmp - tmp1;
        tmp = tmp1;

        size[ 0 ] = len & 0xFF;
        size[ 1 ] = ( len >> 8 ) & 0xFF;
        if ( KXDEBUG )
        {

            for ( int r = 0; r < len; r++ )
            {
                printf( "[%02x] ", tmp[ r ] );
            }
        }

        if ( send( contactList[ i ].listensock, &size, 2, 0 ) <= 0 )
        {
            close( contactList[ i ].listensock );
            contactList[ i ].listensock = -1;
            if ( KXDEBUG ) printf( "send chat packet1 size goes wrong\n" );
            free( tmpo );
            return - 1;
        }
        else
        {
            if ( ( send( contactList[ i ].listensock, tmp, len, 0 ) ) <= 0 )
            {
                close( contactList[ i ].listensock );
                contactList[ i ].listensock = -1;
                if ( KXDEBUG ) printf( "send chat packet1 goes wrong\n" );
                free( tmpo );
                return - 1;
            }
        }
        if ( KXDEBUG ) printf( "send chat packet1 goes OKr\n" );
        //      contactList[i].server=2;
        free( tmpo );
        return 0;
    }
    return - 1;
}

int net_sendChatFunctions( int y )
{
    if ( KXDEBUG ) printf( "send chat functions....\n" );
    unsigned int version = ( unsigned short int ) 0x04;
    unsigned int port = contactList[ y ].chatport;
    unsigned int none = 0x00;
    unsigned char *tmp, *tmp1, *tmpo;
    tmpo = ( unsigned char * ) malloc( BUFSIZE );
    tmp1 = tmpo;
    tmp = tmpo;

    memcpy( tmp, &version, 4 ); tmp += 4;
    memcpy( tmp, &port, 4 ); tmp += 4;

    unsigned int	ip	= ipToIcq( net_information.clientAddr );
    unsigned int lip = LOCALHOST;

    memcpy( tmp, &ip, 4 ); tmp += 4;
    memcpy( tmp, &lip, 4 ); tmp += 4;
    none = 0x04;
    memcpy( tmp, &none, 1 ); tmp += 1;
    none = 0x5a75;  //net_information.serverPort;
    memcpy( tmp, &none, 2 ); tmp += 2;
    none = 0x0C;
    memcpy( tmp, &none, 4 ); tmp += 4;
    none = FONT_PLAIN;
    memcpy( tmp, &none, 4 ); tmp += 4;
    char *fontn = "Arial";
    int fsize = strlen( fontn ) + 1;
    memcpy( tmp, &fsize, 2 ); tmp += 2;
    memcpy( tmp, &fontn, fsize ); tmp += fsize;
    none = 0x0001;
    memcpy( tmp, &none, 2 ); tmp += 2;

    unsigned short int len = tmp - tmp1;
    tmp = tmp1;
    char size[ 2 ];
    size[ 0 ] = len & 0xFF;
    size[ 1 ] = ( len >> 8 ) & 0xFF;
    if ( KXDEBUG )
    {
        printf( "sending Chat functions...\n" );
        for ( int r = 0; r < len; r++ )
        {
            printf( "[%02x] ", tmp[ r ] );
        }
    }

    if ( send( contactList[ y ].listensock, &size, 2, 0 ) <= 0 )
    {
        close( contactList[ y ].listensock );
        contactList[ y ].listensock = -1;
        if ( KXDEBUG ) printf( "send chat functions size goes wrong\n" );
        free( tmpo );
        return - 1;
    }
    else
    {
        if ( ( send( contactList[ y ].listensock, tmp, len, 0 ) ) <= 0 )
        {
            close( contactList[ y ].listensock );
            contactList[ y ].listensock = -1;
            if ( KXDEBUG ) printf( "send chat functions goes wrong\n" );
            free( tmpo );
            return - 1;
        }
    }
    if ( KXDEBUG ) printf( "Chat Functions goes OKr\n" );
    free( tmpo );
    if ( KXDEBUG ) printf( "hier ? \n" );
    return 0;
}

int net_sendChatCancel( int y )
{
    unsigned short int version = ( unsigned short int ) 0x03;
    unsigned int sequence = ( unsigned int ) contactList[ y ].chatseq;
    unsigned int tuin = ( unsigned int ) user_config.uin;
    unsigned long int none = 0x00;
    unsigned short int command = 0x07da, type = 0x02;
    unsigned char *tmp, *tmp1, *tmpo;

    tmpo = ( unsigned char * ) malloc( BUFSIZE );
    tmp1 = tmpo;
    tmp = tmpo;
    unsigned int TCPstatus = TCP_REFUSE;

    unsigned int	ip	= ipToIcq( net_information.clientAddr );
    unsigned int lip = LOCALHOST;
    unsigned int port = net_information.clientPort;

    memcpy( tmp, &tuin, 4 ); tmp += 4;
    memcpy( tmp, &version, 2 ); tmp += 2;
    memcpy( tmp, &command, 2 ); tmp += 2;
    none = 0;
    memcpy( tmp, &none, 2 ); tmp += 2;
    memcpy( tmp, &tuin, 4 ); tmp += 4;
    memcpy( tmp, &type, 2 ); tmp += 2;

    none = 0x0001;                            // replace megs !!
    memcpy( tmp, &none, 2 ); tmp += 2;
    none = 0x00;
    memcpy( tmp, &none, 1 ); tmp += 1;

    memcpy( tmp, &ip, 4 ); tmp += 4;
    memcpy( tmp, &lip, 4 ); tmp += 4;
    memcpy( tmp, &port, 4 ); tmp += 4;
    none = 0x04;
    memcpy( tmp, &none, 1 ); tmp += 1;
    memcpy( tmp, &TCPstatus, 4 ); tmp += 4;
    none = 0x0001;
    memcpy( tmp, &none, 4 ); tmp += 4;
    none = 0x00;
    memcpy( tmp, &none, 4 ); tmp += 4;
    none = 0x00;
    memcpy( tmp, &none, 2 ); tmp += 2;
    none = 0x00;
    memcpy( tmp, &none, 1 ); tmp += 1;

    //   memcpy(tmp, &none, 2);       tmp += 2;
    //   memcpy(tmp, &none, 2);       tmp += 2;

    memcpy( tmp, &sequence, 4 ); tmp += 4;

    unsigned short int len = tmp - tmp1;
    tmp = tmp1;
    char size[ 2 ];
    size[ 0 ] = len & 0xFF;
    size[ 1 ] = ( len >> 8 ) & 0xFF;
    if ( KXDEBUG )
    {
        for ( int r = 0; r < len; r++ )
        {
            printf( "[%02x] ", tmp[ r ] );
        }
    }

    if ( send( contactList[ y ].sock, &size, 2, 0 ) <= 0 )
    {
        close( contactList[ y ].sock );
        contactList[ y ].sock = -1;
        if ( KXDEBUG ) printf( "send size goes wrong\n" );
        free( tmpo );
        return - 1;
    }
    else
    {
        if ( ( send( contactList[ y ].sock, tmp, len, 0 ) ) <= 0 )
        {
            close( contactList[ y ].sock );
            contactList[ y ].sock = -1;
            if ( KXDEBUG ) printf( "send packet goes wrong\n" );
            free( tmpo );
            return - 1;
        }
    }
    if ( KXDEBUG ) printf( "send chat cancel packet goes OKr\n" );
    free( tmpo );
    return 0;
}
