/*
$Id: dialogs.h,v 2.25.4.2.2.1 1998/12/18 18:22:34 herwinjs Exp $
*/


#ifndef _MAIL_DLG_H_
#define _MAIL_DLG_H_

#include <qgrpbox.h>
#include <qchkbox.h>
#include <qdialog.h>
#include <qlined.h>
#include <qpushbt.h>
#include <qpainter.h>
#include <qlabel.h>
#include <qframe.h>
#include <qmlined.h>
#include <qtabdialog.h>
#if defined( Status )
#undef Status
#endif
#include "kurllabel.h"
#include "kxicq.h"
#include "mledit.h"
#include "message.h"

//////////////////////////////////////////////

class Read : public QDialog
{
        Q_OBJECT
    public:
        Read( UIN u, mainWin *parent = 0, const char *name = 0 );
        ~Read();

    private:
        QTabDialog *tabbar;
        UIN uin;
        MSG *pntMsg;
        int found, wait, view;
        mainWin *p;
        QFrame *msgView, *urlView, *addView, *buttonView;

        QPushButton *okButton, *cancelButton, *replyButton, *whoisButton;
        QPushButton *nextButton, *prevButton;
        QPushButton *nextUButton, *prevUButton;
        QPushButton *lastButton, *firstButton;
        QPushButton *addButton;
        QPushButton *authButton;
        QButtonGroup *msgGroup, *urlGroup, *addGroup;

        MLEditWrap *msgViewMsg, *urlViewMsg, *authText;
        KURLLabel *urlViewUrl;
        QLabel *msgViewUin, *msgViewNick, *msgViewTime, *msgViewDate;
        QLabel *urlViewUin, *urlViewNick, *urlViewTime, *urlViewDate;
        QLabel *addViewUin, *addViewNick, *addViewTime, *addViewDate;
        QLabel *addViewFirst, *addViewLast, *addViewEmail, *addViewrNick;
        QLabel *msgViewCount, *urlViewCount, *addViewCount;
        int aant, count;


        QCheckBox *msgViewRead, *urlViewRead, *addViewRead;

        QButtonGroup *addBg;

        void showMsg();
        void lastMsg();
        void firstMsg();
        void nextMsg();
        void prevMsg();
        void nextUMsg();
        void prevUMsg();
        unsigned long countMsg();
    protected:


    private slots:
        void addUser();
        void newMsg();
        void processURL( const char * );
        void ok_slot();
        void cancel_slot();
        void reply_slot();
        void whois_slot();
        void next_slot();
        void prev_slot();
        void next_u_slot();
        void prev_u_slot();
        void first_slot();
        void last_slot();
        void auth_slot();


};

class viewSearch : public KTabListBox
{
        Q_OBJECT
    public:
        viewSearch( QWidget *parent = 0, const char *name = 0 );
        ~viewSearch();

        unsigned short int seq;
        QPopupMenu *pm;
        int pos;
        int addItem( UIN uin, const char *email, const char *nick, const char *first, const char *last );
    private:
        void closeEvent( QCloseEvent * );
        bool eventFilter( QObject *, QEvent *event );
        void doMousePressEvent( QMouseEvent * );
        

    private slots:
        void mouseDoubleClick( int, int );
        void addUser();
        void doSearch();

};


class searchDialog : public QDialog
{
        Q_OBJECT

    public:

        searchDialog
        (
            QWidget* parent = NULL,
            const char* name = NULL
        );
        virtual ~searchDialog();


        QLineEdit* qtarch_LineEdit_2;
        QLineEdit* qtarch_LineEdit_3;
        QLineEdit* qtarch_LineEdit_4;
        QLineEdit* qtarch_LineEdit_5;
        QLineEdit* qtarch_LineEdit_1;

    public slots:


    protected slots:

        void startSearch();

    protected:

        void closeEvent( QCloseEvent * );
};


class userInfo : public QDialog
{
        Q_OBJECT

    public:

        userInfo
        (
            QWidget* parent = 0,
            const char* name = 0
        );

        virtual ~userInfo();
        void insertInfo( SEARCH_RESULT *result );
        void insertExtInfo( EXT_SEARCH_RESULT *result );


        QLineEdit* qtarch_uin;
        QLineEdit* qtarch_nick;
        QLineEdit* qtarch_firstName;
        QLineEdit* qtarch_lastName;
        QLineEdit* qtarch_phone;
        QLineEdit* qtarch_homePage;
        QLineEdit* qtarch_email;
        QLineEdit* qtarch_city;
        QCheckBox* qtarch_auth;
        QLineEdit* qtarch_ccode;
        QLineEdit* qtarch_state;
        QLineEdit* qtarch_age;
        QLineEdit* qtarch_sex;
        QLineEdit* qtarch_about;


    public slots:


    protected slots:

        virtual void okSlot();
        virtual void addUserSlot();

    protected:

        void closeEvent( QCloseEvent * );

};


class registerDialog : public QDialog
{
        Q_OBJECT

    public:

        registerDialog
        (
            QWidget* parent = NULL,
            const char* name = NULL
        );

        virtual ~registerDialog();

        QLineEdit* qtarch_uin;
        QLineEdit* qtarch_nick;
        QLineEdit* qtarch_firstName;
        QLineEdit* qtarch_lastName;
        QLineEdit* qtarch_email;
        QLineEdit* qtarch_password;
        void closeEvent( QCloseEvent * );
        void getInfo( UIN *uin, char **nick, char **firstName, char **lastName, char **email , char **password );

    public slots:


    protected slots:

        virtual void doRegister();

    protected:

};

class awayDialog : public QDialog
{
        Q_OBJECT

    public:

        awayDialog
        (
            QWidget* parent = NULL,
            const char* name = NULL
        );
        QMultiLineEdit* qtarch_Message;
        virtual ~awayDialog();

    public slots:


    protected slots:

        virtual void setMsg();

    protected:

};

class Chat : public KTopLevelWidget
{
        Q_OBJECT
    public:
        Chat( UIN uin, QWidget *p = NULL, char *n = NULL );
        ~Chat();

        UIN cuin;
        MLEditWrap *remotec, *local;
        QSplitter *split;
        void getRecv( char *data, int len );
        UIN getUin() {
            return cuin; }
        void closeChat();

        QColor fg, bg;
        int stop;
    public slots:
        void setFGColor( int );
        void setBGColor( int );
        void closeSlot( int );

    protected:
        void resizeEvent( QResizeEvent *e );
    public slots:
        void sendKey( QKeyEvent *e );
        void closeEvent( QCloseEvent *t = NULL );
};



#endif
