/**********************************************************************


 *********************************************************************/

#include "mainView.h"
#include "mainView.moc"
#define Inherited QDialog

#include "downloadDlg.h"

#include <qpushbt.h>
#include <qlined.h>
#include <qmlined.h>

#include <kapp.h>
#include <kurl.h>
#include <stdio.h>

mainView::mainView
(
	QWidget* parent,
	const char* name
) 	: QWidget(parent, name)
{
  dlgedit_LineEdit_1 = new QLineEdit (this, "LineEdit_1");
  dlgedit_LineEdit_1->setGeometry (10, 300, 220, 30);
  dlgedit_LineEdit_1->setMinimumSize (10, 10);
  dlgedit_LineEdit_1->setMaximumSize (32767, 32767);
  dlgedit_LineEdit_1->setText ("");
  dlgedit_LineEdit_1->setMaxLength (32767);
  dlgedit_LineEdit_1->setEchoMode (QLineEdit::Normal);
  dlgedit_LineEdit_1->setFrame (TRUE);

  dlgedit_LineEdit_1->setText ("file:/linux-2.1.110.tar.gz");
  /* Drag 'n Drop */
  KDNDDropZone *dnd = new KDNDDropZone (this, DndURL);
  connect (dnd, SIGNAL (dropAction (KDNDDropZone *)),
	   this, SLOT (dropslot (KDNDDropZone *)));

  dlgedit_MultiLineEdit_1 = new QMultiLineEdit (this, "MultiLineEdit_1");
  dlgedit_MultiLineEdit_1->setGeometry (10, 350, 670, 230);
  dlgedit_MultiLineEdit_1->setMinimumSize (10, 10);
  dlgedit_MultiLineEdit_1->setMaximumSize (32767, 32767);
  dlgedit_MultiLineEdit_1->insertLine ("");
  dlgedit_MultiLineEdit_1->setReadOnly (FALSE);
  dlgedit_MultiLineEdit_1->setOverwriteMode (FALSE);

  dlgedit_PushButton_1 = new QPushButton (this, "PushButton_1");
  dlgedit_PushButton_1->setGeometry (250, 300, 100, 30);
  dlgedit_PushButton_1->setMinimumSize (10, 10);
  dlgedit_PushButton_1->setMaximumSize (32767, 32767);
  dlgedit_PushButton_1->setText (i18n("GET!"));
  dlgedit_PushButton_1->setAutoRepeat (FALSE);
  dlgedit_PushButton_1->setAutoResize (FALSE);
  dlgedit_PushButton_1->setDefault (TRUE);
  dlgedit_PushButton_1->setFocus ();
  connect (dlgedit_PushButton_1, SIGNAL (released ()),
	   this, SLOT (searchFTPEngines ())
    );

  setupListBox ();

}
/* Our KTabListBox */
void
mainView::setupListBox()
{
  ListBox = new KTabListBox (this, "test", 7);
  ListBox->setGeometry (10, 4, 640, 100);

  ListBox->setSeparator (' ');
  ListBox->setColumn (0, i18n("File"), 140);
  ListBox->setColumn (1, i18n("Done"), 40);
  ListBox->setColumn (2, i18n("Size"), 40);
  ListBox->setColumn (3, i18n("EstTime"), 60);
  ListBox->setColumn (4, i18n("Description"), 120);
  ListBox->setColumn (5, i18n("Servers"), 140);
  ListBox->setColumn (6, i18n("Status"), 20);
  connect (ListBox,
	   SIGNAL (highlighted (int, int)),
	   this,
	   SLOT (selection (int, int))
  );

}
/* Signal Section */

void 
mainView::selection(int index, int column)
{
  printf ("%i %i\n", index, column);

  //QString file = QString("file:/");
  //KTabListBoxItem *item = ListBox->getItem(index);
  QString file = ListBox->text (index, 5);
  dlgedit_LineEdit_1->setText (file.data ());

}
/* maybe we have to test for protokol file:// too, i don't kno
   if kconfig handles urls like ftp://
   FIXME filename contains should better check for .kdelnk on the end of the
   string
 */
/* 
 * convertKdelnk	Test if it is a kdelnk -> Get the URL in the KDELnk */
	
int
mainView::convertKdelnk(KURL &url)
{
  QString filename = QString (url.filename ());

  if (filename.contains ((char *) ".kdelnk")) {
    KConfig *kc = new KConfig (url.path (), 0L);
    kc->setGroup ("KDE Desktop Entry");
    const char *test = kc->readEntry ("URL");
    if (test != 0L) {
      url = KURL (test);
      return (TRUE);
    }
  }
  return (FALSE);
}


void mainView::dropslot(KDNDDropZone *z)
{
  int type, rc;
  type = z->getDataType ();
  KURL url;
  if (type == DndURL) {
    url = KURL (z->getData ());
    if (url.isMalformed ()) {
      dlgedit_MultiLineEdit_1->append ("url isMalformed!");
      return;
    }

    QString query;
    convertKdelnk (url);
    query = QString (url.url ());
    dlgedit_LineEdit_1->setText (query.data ());
    url = KURL (query.data ());
    QString test;
    test = QString (url.filename ());
    if (!test.isEmpty ()) {
      test += QString (" 00% 00K 99:99 nothing ");
      test += url.url ().data ();
      //FIXME test for duplicate Entries
      ListBox->insertItem (test.data ());
    }
  }

}


void
mainView::searchFTPEngines()
{

  QString url = QString (dlgedit_LineEdit_1->text ());
  KURL url2 = KURL (dlgedit_LineEdit_1->text ());

  /* We do not accept malformed URLs */
  if (url2.isMalformed ()) {
    dlgedit_MultiLineEdit_1->append ("url isMalformed!");
    return;
  }

  dlgedit_MultiLineEdit_1->append (url2.protocol ());
  dlgedit_MultiLineEdit_1->append (url2.host ());
  dlgedit_MultiLineEdit_1->append (url2.path ());
  dlgedit_MultiLineEdit_1->append (url2.filename ());

  /* Open downloadDlg */

  downloadDlg *dlg = new downloadDlg (this);
  dlg->fileURL->setText (dlgedit_LineEdit_1->text ());
  KURL url3 = KURL (dlgedit_LineEdit_1->text ());
  dlg->ListBox->insertItem ((const char *) url3.host ());
  dlg->list->append (new QString (url3.url ().data ()));
  // printf (">> %s <<", url2.filename ());
  dlg->searchSlave->clearArguments ();
  *dlg->searchSlave << "kzilla.search.slave";
  *dlg->searchSlave << url2.filename ();
  dlg->searchSlave->start (KProcess:: NotifyOnExit, KProcess::Stdout);
  dlg->exec ();

}


void
mainView::resizeEvent( QResizeEvent *)
{
  if (dlgedit_LineEdit_1 != 0)
    dlgedit_LineEdit_1->setGeometry (10, 8 + this->height () / 2, 220, 30);
  if (dlgedit_PushButton_1 != 0)
    dlgedit_PushButton_1->setGeometry (300, 8 + this->height () / 2, 220, 30);
  if (ListBox != 0)
    ListBox->setGeometry (10, 4, this->width () - 20, this->height () / 2);

  if (dlgedit_MultiLineEdit_1 != 0)
    dlgedit_MultiLineEdit_1->setGeometry (
					   10,
	 this->dlgedit_LineEdit_1->y () + 4 + dlgedit_LineEdit_1->height (),
					   this->width () - 20,
					   this->height () / 2);

}
mainView::~mainView()
{
}
