/***************************************************************************
                          article.h  -  description                              
                             -------------------                                         
    begin                : Tue Jun 15 1999                                           
    copyright            : (C) 1999 by Roberto Alsina                         
    email                : ralsina@unl.edu.ar                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef ARTICLE_H
#define ARTICLE_H

#include <qstring.h>
#include <qlist.h>
#include "fastdb/fastdb.h"
#include "util.h"

/**
  *@author Roberto Alsina
  */

class Article
{
public:
    //FIXME fix constructors
    Article (const char *data,int OffsetID,int OffsetFrom=1,
             int OffsetSubject=0,int OffsetLines=2,int OffsetDate=4,
             int OffsetRef=5,int OffsetRead=6);
    Article (const char *ID);
    Article () {};   // Just to make DB library happy
    void parseData (const char *data,int OffsetID=3,int OffsetFrom=1,
                    int OffsetSubject=0,int OffsetLines=2,int OffsetDate=4,
                    int OffsetRef=5,int OffsetRead=6);
    void save();
    ~Article();
    char *From;
    char *ID;
    char *Subject;
    char *Date;
    char *Ref;
    bool Read;
    int8 Lines;

    CLASS_DESCRIPTOR (Article,(
                               KEY(Read,INDEXED),
                               KEY(From,INDEXED),
                               KEY(ID,INDEXED|HASHED),
                               KEY(Subject,INDEXED),
                               KEY(Date,INDEXED),
                               KEY(Ref,INDEXED),
                               FIELD(Lines)));

};

class GroupItem
{
public:
    char *ID;
    char *Server;
    char *Group;
    int4 Number;
    CLASS_DESCRIPTOR (GroupItem,(
                                 KEY(ID,INDEXED|HASHED),
                                 KEY(Server,INDEXED),
                                 KEY(Group,INDEXED),
                                 FIELD(Number)));
};


struct ArtTreeNode;

typedef QList <ArtTreeNode> ArtTreeNodeList;


struct ArtTreeNode
{
    Article *art;
    ArtTreeNodeList children;
    ArtTreeNode *parent;
    QString subject;
};

typedef QList<Article> ArticleListT;

class ArticleList: public ArticleListT
{
public:
    ArtTreeNodeList *threaded();
    
};

#endif


