//-< FILE.CPP >------------------------------------------------------*--------*
// FastDB                    Version 1.0         (c) 1999  GARRET    *     ?  *
// (Main Memory Database Management System)                          *   /\|  *
//                                                                   *  /  \  *
//                          Created:     20-Nov-98    K.A. Knizhnik  * / [] \ *
//                          Last update: 10-Dec-98    K.A. Knizhnik  * GARRET *
//-------------------------------------------------------------------*--------*
// System independent intrface to mapped on memory file
//-------------------------------------------------------------------*--------*

#ifndef __FILE_H__
#define __FILE_H__

class dbFile { 
  protected:
#ifdef _WIN32
    HANDLE fh;
    HANDLE mh;
#else
    int    fd;
#endif
    char*  mmapAddr;
    size_t mmapSize;

  public:
    enum { 
	ok = 0
    };
    //
    // Create backup file
    //
    int    create(char const* name);
    //
    // Open database file and create file mapping object 
    //
    int    open(char const* fileName, char const* sharedName,
		bool readonly, size_t initSize);
    
    void*  getAddr() const { return mmapAddr; }
    size_t getSize() const { return mmapSize; } 
    int    setSize(char const* sharedName, size_t size);
    int    flush();
    int    close();
    int    write(void const* ptr, size_t& writtenBytes, size_t size);
    int    read(void* ptr, size_t& readBytes, size_t size);

    static char* errorText(int code, char* buf, size_t bufSize);
};


#endif
