/***************************************************************************
 serversroot.cpp  -  description                              
 -------------------                                         
 begin                : Wed Jun 9 1999                                           
 copyright            : (C) 1999 by Roberto Alsina                         
 email                : ralsina@unl.edu.ar                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "serversroot.h"
#include "connmgrwidget.h"
#include "resource.h"
#include "util.h"
#include "kfileio.h"
#include "basegroup.h"
#include "group.h"
#include <qdir.h>
#include <qdict.h>
#include <qstrlist.h>
#include <qpopupmenu.h>
#include <kapp.h>
#include <kiconloader.h>
#include <pth.h>

QPixmap *FOLDER_PIXMAP=0;
QPixmap *FOLDER_OPEN_PIXMAP=0;

QObjectLVI::QObjectLVI(QListView *parent):QObject (parent), QListViewItem(parent), BusyThing()
{
    __busy=0;
}
QObjectLVI::QObjectLVI(QObjectLVI *parent):QObject (parent), QListViewItem(parent), BusyThing()
{
    __busy=0;
}
QObjectLVI::~QObjectLVI()
{
}
void QObjectLVI::busy()
{
    __busy++;
    repaint();
}
void QObjectLVI::idle()
{
    if(__busy)
        __busy--;
    repaint();
}

QPopupMenu *QObjectLVI::contextMenu()
{
    return 0;
}

void QObjectLVI::paintCell ( QPainter * p, const QColorGroup & cg, int column, int width, int align )
{
    p->setPen(cg.base());
    if (isBusy())
        p->setBrush(cg.background());
    else
        p->setBrush(cg.base());
    //		p->setBrush(green);
    p->drawRect(0,0,width,height());
    p->setPen(cg.foreground());
    int imw=0;
    if (column==0 && pixmap(0))
    {
        int imh=pixmap(0)->height();
        p->drawPixmap(0,(height()-imh)/2,*pixmap(0));
        imw=pixmap(0)->width();
    }
    p->drawText(imw+2,1,width-6-imw,height()-2,AlignVCenter|AlignLeft,text(column));
    if (isSelected())
    {
        p->setBrush(NoBrush);
        p->setPen(red);
        p->drawLine(0,0,width,0);
        p->drawLine(0,height()-1,width,height()-1);
    }
    p->setPen(cg.midlight());
    p->drawLine(width-1,0,width-1,height()-1);
}

void QObjectLVI::paintFocus ( QPainter * p, const QColorGroup & cg, const QRect &r )
{
    // Keyboard focus is not visible.
}


ServersRoot::ServersRoot(QListView *parent): QObjectLVI(parent)
{
    __busy=0;
    setText(0,"Servers");
    if (!FOLDER_PIXMAP)
        FOLDER_PIXMAP=new QPixmap(ICON("folder.xpm"));
    if (!FOLDER_OPEN_PIXMAP)
        FOLDER_OPEN_PIXMAP=new QPixmap(ICON("folder_open.xpm"));
    setPixmap(0,*FOLDER_PIXMAP);
}
ServersRoot::~ServersRoot()
{
}

QPopupMenu *ServersRoot::contextMenu()
{
    QPopupMenu *popup=new QPopupMenu();
    popup->insertItem("New Server",ID_NEW_SERVER);
    return popup;
}

void ServersRoot::setOpen(bool open)
{
    if(!open)
    {
        QListViewItem * myChild = firstChild();
        while( myChild )
        {
            ((QObjectLVI *)myChild)->destroy();
            myChild = myChild->nextSibling();
        }
    }
    else
    {
        QDir d=QDir(KApplication::localkdedir()+"/share/apps/newkrn/servers/");
        d.setFilter(QDir::Files);
        const QStrList *l=d.entryList();
        QStrListIterator it(*l);
        for ( ; it.current(); ++it )
        {
            new ServerItem(this,it.current());
        }
    }
    QListViewItem::setOpen(open);
    if (!open)
        setExpandable (true);
}


ServerItem::ServerItem(ServersRoot *parent,const char *_servname): QObjectLVI(parent)
{
    __busy=0;
    setExpandable(true);
    servname=_servname;
    setPixmap(0,ICON("mini-display.xpm"));
    setText(0,servname);
}
ServerItem::~ServerItem()
{
}

QPopupMenu *ServerItem::contextMenu()
{
    QPopupMenu *popup=new QPopupMenu();
    popup->insertItem("Get Active File",ID_GET_ACTIVE);
    popup->insertItem("Add Newsgroup(s)",ID_ADD_GROUP);
    popup->insertItem("Delete Server",ID_DELETE_SERVER);
    popup->insertItem("Properties...",ID_SERVER_PROPERTIES);
    if (isOpen())
    {
        popup->insertItem("Close",ID_SERVER_CLOSE);
    }
    else
    {
        popup->insertItem("Open",ID_SERVER_OPEN);
    }
    if (isBusy())
    {
        popup->setItemEnabled (ID_GET_ACTIVE,false);
        popup->setItemEnabled (ID_ADD_GROUP,false);
        popup->setItemEnabled (ID_SERVER_OPEN,false);
    }

    return popup;
}

void *thr_ServerItemOpen(void *arg)
{
    debug ("entered thr_ServerItemOpen");
    ServerItem *item=(ServerItem *)arg;

    QString subspath=KApplication::localkdedir()+"/share/apps/newkrn/subscribed";
    if (QFile::exists(subspath))
    {
        QString subsdata=kFileToString(subspath);
        QStrList subslines;
        QStringSplit(subsdata,'\n',subslines);
        QStrListIterator sit(subslines);
        for (;sit.current();++sit)
        {
            new ServerGroup(item,item->servname,sit.current());
        }
    }

    QObjectLVI *allgr=new QObjectLVI(item);
    allgr->busy();
    allgr->setText(0,"Newsgroups");

    debug ("reading group list");
    QString path=KApplication::localkdedir()+"/share/apps/newkrn/servers.active/"+item->text(0);
    if (!QFile::exists(path))
    {
        item->idle();
        debug ("leaving thr_ServerItemOpen (no file)");
        return NULL;
    }
    QString data=kFileToString(path);
    QStrList groups;
    QStringSplit(data,'\n',groups);
    QStrListIterator it(groups);
    QDict <char> prefixes;
    char *prefend;
    char *pref;
    debug ("listing groups");
    if (groups.count()<25) //short list, make it flat
    {
        for (;it.current();++it)
        {
            new ServerGroup(allgr,item->servname,it.current());
        }
    }
    else
    {
        for (;it.current();++it)
        {
            prefend=strchr(it.current(),'.');
            if (prefend)
            {
                (*prefend)=0;
                pref=prefixes.find(it.current());
                if (!pref)
                {
                    prefixes.insert(it.current()," ");
                    new ServerBranch(allgr,item->servname,it.current());
                    pth_yield(NULL);
                }
                (*prefend)='.';
            }
            else
            {
                new ServerGroup(allgr,item->servname,it.current());
            }
        }
    }
    allgr->idle();
    debug ("leaving thr_ServerItemOpen");
    return NULL;
}

void ServerItem::setOpen(bool open)
{
    //FIXME block the item using a mutex instead of isBusy()

    if (isBusy()) //I am opening/getting active/some other bad mojo
    {
        return;
    }
    debug ("entered ServerItem::setOpen");
    busy();
    QListViewItem * myChild = firstChild();
    while( myChild )
    {
        ((QObjectLVI *)myChild)->destroy();
        myChild = myChild->nextSibling();
    }
    idle();
    if (open)
    {
        pth_spawn(attr,thr_ServerItemOpen,this);
    }
    QListViewItem::setOpen(open);
    debug ("leaving ServerItem::setOpen");
}


ServerBranch::ServerBranch(QObjectLVI *parent,const char *_servname,const char *_prefix): QObjectLVI(parent)
{
    __busy=0;
    prefix=QString(_prefix)+".";
    servname=_servname;
    setExpandable(true);
    setPixmap(0,*FOLDER_PIXMAP);
    setText(0,prefix);
}

ServerBranch::~ServerBranch()
{
}

QPopupMenu *ServerBranch::contextMenu()
{
    QPopupMenu *popup=new QPopupMenu();
    if (isOpen())
    {
        popup->insertItem("Close",ID_SERVER_CLOSE);
    }
    else
    {
        popup->insertItem("Open",ID_SERVER_OPEN);
    }
    if (isBusy())
    {
        popup->setItemEnabled (ID_SERVER_OPEN,false);
    }
    popup->insertItem("See FAQS",ID_GET_FAQ);
    return popup;
}

void *thr_ServerBranchOpen(void *arg)
{
    debug ("entered thr_ServerBranchOpen");
    ServerBranch *item=(ServerBranch *)arg;
    debug ("reading group list");
    QString path=KApplication::localkdedir()+"/share/apps/newkrn/servers.active/"+item->servname;
    if (!QFile::exists(path))
    {
        item->idle();
        debug ("leaving thr_ServerBranchOpen (no file)");
        debug (path.data());
        return NULL;
    }
    QString data=kFileToString(path);
    QStrList groups;
    QStringSplit(data,'\n',groups);
    QStrListIterator it(groups);
    QDict <char> prefixes;
    char *prefend;
    char *pref;
    debug ("listing groups");
    int i;
    int l=item->prefix.length();
    char *prefix_data=item->prefix.data();
    QStrList leaves;
    for (;it.current();++it)
    {
        //First check for inherited prefix
        i=strncmp(it.current(),prefix_data,l);
        if (!i)
        {
            leaves.append(it.current());
            continue;
        }
    }
    it=QStrListIterator (leaves);
    if (it.count()<25) //short list make it flat
    {
        for (;it.current();++it)
        {
            new ServerGroup(item,item->servname,it.current());
        }
    }
    else
    {
        for (;it.current();++it)
        {
            //See if it has more '.' than prefix
            prefend=strchr(it.current()+l+2,'.');
            if (prefend) //it's a branch
            {
                (*prefend)=0;
                pref=prefixes.find(it.current());
                if (!pref)
                {
                    prefixes.insert(it.current()," ");
                    new ServerBranch(item,item->servname,it.current());
                    pth_yield(NULL);
                }
                (*prefend)='.';
            }
            else //it's a leaf
            {
                new ServerGroup(item,item->servname,it.current());
            }
        }
    }
    item->idle();
    debug ("leaving thr_ServerBranchOpen");
    return NULL;
}



void ServerBranch::setOpen(bool open)
{
    if (isBusy()) //I am opening/getting active/some other bad mojo
    {
        return;
    }
    busy();
    QListViewItem * myChild = firstChild();
    while( myChild )
    {
        ((QObjectLVI *)myChild)->destroy();
        myChild = myChild->nextSibling();
    }

    if (open)
    {
        setPixmap(0,*FOLDER_OPEN_PIXMAP);
        pth_spawn(attr,thr_ServerBranchOpen,this);
    }
    else
    {
        idle();
        setPixmap(0,*FOLDER_PIXMAP);
    }
    QListViewItem::setOpen(open);
}

ServerGroup::ServerGroup(QObjectLVI *parent,const char *_server,const char *_name): QObjectLVI(parent)
{
    __busy=0;
    server=_server;
    name=_name;
    setExpandable(false);
    setText(0,name);
}

ServerGroup::~ServerGroup()
{
}

QPopupMenu *ServerGroup::contextMenu()
{
    QPopupMenu *popup=new QPopupMenu();
    popup->insertItem("Open",ID_GROUP_OPEN);
    popup->insertItem("Subscribe",ID_GROUP_SUBSCRIBE);
    popup->insertItem("Get Headers",ID_GET_HEADERS);
    popup->insertItem("See FAQ",ID_GET_FAQ);
    if (isBusy())
    {
        popup->setItemEnabled (ID_GROUP_OPEN,false);
        popup->setItemEnabled (ID_GET_HEADERS,false);
    }

    return popup;
}

BaseGroup *ServerGroup::groupObject()
{
    Group *g;
    try
    {
        g= new Group(server,name);
    }
    catch (int n)
    {
        g=0;
    }
    return g;
}

const char *ArticleItem::key ( int column, bool ascending ) const
{
    if (column==0) //Subject
    {
        QString data=text(0);
        data=data.lower();
        //This way responses are right after original posts
        if (!strncmp (data.data(),"re: ",4))
            return qstrdup(data.right(data.length()-4)+" ");
        else
            return qstrdup(data.data());
    }
    return text(column);
}

LocalFolder::LocalFolder (QListView *parent,const char *_path): QObjectLVI(parent)
{
    path=_path;
    setText(0,path.right(path.length()-path.findRev('/')-1));
    if (!FOLDER_PIXMAP)
        FOLDER_PIXMAP=new QPixmap(ICON("folder.xpm"));
    if (!FOLDER_OPEN_PIXMAP)
        FOLDER_OPEN_PIXMAP=new QPixmap(ICON("folder_open.xpm"));
    setPixmap(0,*FOLDER_PIXMAP);
    setExpandable(true);
}

LocalFolder::LocalFolder (QObjectLVI *parent,const char *_path): QObjectLVI(parent)
{
    path=_path;
    setText(0,path.right(path.length()-path.findRev('/')-1));
    setPixmap(0,*FOLDER_PIXMAP);
    setExpandable(true);
}
LocalFolder::~LocalFolder()
{
}
void LocalFolder::setOpen(bool open)
{
    if(!open)
    {
        QListViewItem * myChild = firstChild();
        while( myChild )
        {
            ((QObjectLVI *)myChild)->destroy();
            myChild = myChild->nextSibling();
        }
    }
    else
    {
        QDir d=QDir(path);
        d.setFilter(QDir::Dirs);
        const QStrList *l=d.entryList();
        QStrListIterator it(*l);
        for ( ; it.current(); ++it )
        {
            if (it.current()[0]!='.')
                new LocalFolder(this,path+"/"+it.current());
        }
    }
    QListViewItem::setOpen(open);
    if (!open)
        setExpandable (true);
}

/**  */
QPopupMenu * LocalFolder::contextMenu()
{
    QPopupMenu *popup=new QPopupMenu (0);
    popup->insertItem("New Folder",ID_NEW_FOLDER);
    popup->insertItem("Remove",ID_REMOVE_FOLDER);
    if (isOpen())
        popup->insertItem("Close",ID_CLOSE_FOLDER);
    else
        popup->insertItem("Open",ID_OPEN_FOLDER);
    return popup;
}

