/***************************************************************************
 serversroot.h  -  description                              
 -------------------                                         
 begin                : Wed Jun 9 1999                                           
 copyright            : (C) 1999 by Roberto Alsina                         
 email                : ralsina@unl.edu.ar                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef SERVERSROOT_H
#define SERVERSROOT_H


#include <qobject.h>
#include <qlistview.h>
#include "busything.h"

/**
 *@author Roberto Alsina
 */

class QPopupMenu;
class ConnMgrWidget;
class KMTNntpClient;
class BaseGroup;
class QPainter;

class QObjectLVI : public QObject , public QListViewItem,public BusyThing
{
    Q_OBJECT
public:
    QObjectLVI(QListView *parent);
    QObjectLVI(QObjectLVI *parent);
    ~QObjectLVI();
    virtual QPopupMenu *contextMenu();
    virtual void paintCell ( QPainter * p, const QColorGroup & cg, int column, int width, int align );
    virtual void paintFocus ( QPainter * p, const QColorGroup & cg, const QRect &r );
    virtual void busy();
    virtual void idle();
};

class ArticleItem : public QObjectLVI
{
    Q_OBJECT
public:
    ArticleItem (QListView *parent, const char *_ID):QObjectLVI (parent)
    {
        __busy=0;
        ID=_ID;
    };
    ArticleItem (ArticleItem *parent, const char *_ID):QObjectLVI (parent)
    {
        __busy=0;
        ID=_ID;
    };
    virtual const char * key ( int column, bool ascending ) const;
    QString ID;
};


class ServersRoot : public QObjectLVI
{
    Q_OBJECT
public:
    ServersRoot(QListView *parent);
    ~ServersRoot();
    QPopupMenu *contextMenu();
    virtual void setOpen(bool);
};

class ServerItem : public QObjectLVI
{
    Q_OBJECT
public:
    ServerItem(ServersRoot *parent,const char *servname);
    ~ServerItem();
    QPopupMenu *contextMenu();
    virtual void setOpen(bool);
    QString servname;
};

class ServerBranch : public QObjectLVI
{
    Q_OBJECT
public:
    ServerBranch(QObjectLVI *parent,const char *servname,const char *prefix);
    ~ServerBranch();
    QPopupMenu *contextMenu();
    virtual void setOpen(bool);
    QString servname;
    QString prefix;
};

class ServerGroup : public QObjectLVI
{
    Q_OBJECT
public:
    ServerGroup(QObjectLVI *parent,const char *server,const char *name);
    ~ServerGroup();
    QPopupMenu *contextMenu();
    BaseGroup *groupObject();
    QString server;
    QString name;
};

class LocalFolder : public QObjectLVI
{
    Q_OBJECT
public:
    LocalFolder (QListView *parent,const char *path);
    /**  */
    QPopupMenu * contextMenu();
    LocalFolder (QObjectLVI *parent,const char *path);
    ~LocalFolder();
    virtual void setOpen(bool);
    QString path;
};

#endif


















