/**************************************************************************
 * $Id: DeviceDlg.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef DeviceDlg_included
#define DeviceDlg_included

#include "dlg/DeviceDlgData.h"
#include "devices.h"
#include "DeviceOptions.h"
#include "DeviceType.h"
#include "DeviceSerial.h"
#include "DeviceGPIB.h"

class DeviceDlg : public DeviceDlgData
{
    Q_OBJECT

public:

   DeviceDlg( QWidget* parent = NULL, const char* name = NULL);
   virtual ~DeviceDlg();
   
   bool setFile(const char *);
 
 protected:
   DeviceType *dtype;
   DeviceOptions *dopt;
   DeviceSerial *dser;
   DeviceGPIB *dgpib;
   QList<SamplinDevice> *devices;
   SamplinDevice *d;
   QString filename;

   int load(void);
   int save(void);  
   void loadBack(void);
   void setEnabled(int);
   SamplinDevice *findDevice(int index);
   SamplinDevice *findDevice(const char *);
   int findItem(const char *);

 protected slots:
   virtual void ok();
   virtual void cancel();
   virtual void copySlot();
   virtual void renameSlot();
   virtual void deleteSlot();
   virtual void newSlot();

   virtual void highlightedSlot(const char *);
   virtual void typeSlot(int);
   
};
#endif // DeviceDlg_included
