/**************************************************************************
 * $Id: GraphWindow.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef GraphWindow_included
#define GraphWindow_included

#include "GraphPanel.h"
#include "MainWidget.h"

#define ID_OBJECT 1
#define ID_POSITION 2
#define ID_COMMON 3

class GraphWindow : public MainWidget
{
    Q_OBJECT

 protected:
   
   void  resizeEvent( QResizeEvent * );

   KToolBar *toolbar;
   KStatusBar *statusbar;
   KMenuBar *menubar;
   GraphPanel *graphpanel;
   QTimer *timer;
   
   int acq_flag;

   uint win_id;
   
 public:

    GraphWindow
    (
        QWidget* parent = NULL,
        const char* name = NULL,
        uint id = 0
    );

   virtual ~GraphWindow();

   void setId(uint id){win_id=id;}
   int  getId(void){return(win_id);}

   GraphPanel *graph(void){return(graphpanel);}
   
   bool insertCurve(uint key, const char *n, int xAxis = xBottom, int yAxis = yLeft ){
            return graphpanel->insertCurve(key,n,xAxis,yAxis);
   }
   uint insertCurve(const char *n, int xAxis = xBottom, int yAxis = yLeft){
      return graphpanel->insertCurve(n,xAxis,yAxis);
   }
   bool removeCurve(uint key){
      return graphpanel->removeCurve(key);
   }
   void mapCurve(uint key, int axis){
      graphpanel->mapCurve(key,axis);
   }
   bool setCurveRawData(uint key, double *x, double *y, int size){
      return graphpanel->setCurveRawData(key,x,y,size);
   }
   bool setCurveRawData(uint key, double begin, double step, double *y, int size){
      return graphpanel->setCurveRawData(key,begin,step,y,size);
   }
   bool setCurveRawData(uint key, double *x, double begin, double step, int size){
      return graphpanel->setCurveRawData(key,x,begin,step,size);
   }
  bool setCurveData(uint key, double *x, double *y, int size){   
     return graphpanel->setCurveData(key,x,y,size);
  }
   bool setCurveData(uint key, double begin, double step, double *y, int size){
      return graphpanel->setCurveData(key,begin,step,y,size);
   }
   bool setCurveData(uint key, double *x, double begin, double step, int size){
      return graphpanel->setCurveData(key,x,begin,step,size);
   }
   bool setCurveStyle(uint key, SamplinCurveData::CurveStyle s){
      return graphpanel->setCurveStyle(key,s);
   }
   bool setCurvePen(uint key, const QPen &pen){
      return graphpanel->setCurvePen(key, pen);
   }
   bool setCurveSymbol(uint key, const QwtSymbol &s){
      return graphpanel->setCurveSymbol(key,s);
   }
   bool setCurveSplineType(uint key, int t){
      return graphpanel->setCurveSplineType(key,t);
   }
   bool setCurveSplineSize(uint key, int s){
      return graphpanel->setCurveSplineSize(key,s);
   }
   QString curveName(uint key){
      return graphpanel->curveName(key);
   }
   uint curveKey(const char *n){
      return graphpanel->curveKey(n);
   }
   void replot(void)
     {
	graphpanel->replot();
     }
   void setTitle(const char *t){
      graphpanel->setTitle(t);
   }
   void setAxisTitle(int axis, const char *t){
      graphpanel->setAxisTitle(axis, t);
   }
   
   
 protected:
   void closeEvent( QCloseEvent * );
   void paintEvent( QPaintEvent * );
   void updateCaption(void);

 public slots:

 protected slots:
   
   virtual void closeGraph();
   virtual void printGraph();
   virtual void loadGraph();
   virtual void saveGraph();
   virtual void saveAsGraph();
   virtual void loadTempl();
   virtual void saveTempl();
   virtual void exportData();
   virtual void exportPic();
   virtual void editCopy();
   virtual void editCut();
   virtual void editPaste();   
   virtual void editRename();   
   void pointShowSlot(int, float, float);
   void objectSlot(int, uint);
   
   signals:
   void closeSignal(uint id);
};
#endif // GraphWindow_included

