/**************************************************************************
 * $Id: SamplinScaleBox.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3 beta $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "SamplinScaleBox.h"
#include <qwt_math.h>

SamplinScaleBox::SamplinScaleBox( Orientation ori, const char *title)
{
   d_scaleOffset[0] = 0;
   d_scaleOffset[1] = 0;
   d_borderDist = 4;
   d_titleOffset = 0;
   d_titleXDist=10;
   d_titleYDist = 6;
   if ((ori > 0) && (ori > Right))
     ori = Bottom;
   setGeometry(0,0,10,ori);
   d_title=title;
   d_titlecolor=black;
   d_titlefont=QFont("Helvetica",10,QFont::Bold);
}


SamplinScaleBox::~SamplinScaleBox()
{
}

void SamplinScaleBox::setTitle(const char *title)
{
    d_title = QString(title);
    scaleChanged();
}

void SamplinScaleBox::setTitleFont(const QFont &f)
{
    d_titlefont = f;
    scaleChanged();
}

void SamplinScaleBox::setTitleColor(const QColor &c)
{
    d_titlecolor = c;
    scaleChanged();
}

void SamplinScaleBox::setScaleOffset(int start, int end)
{
      d_scaleOffset[0] = start;
      d_scaleOffset[1] = end;
      scaleChanged();
}

void SamplinScaleBox::setBorderDist(int bd)
{
    d_borderDist = qwtMax(0,bd);
    scaleChanged();
}

void SamplinScaleBox::draw(QPainter &p, QRect &r)
{
   int th, ta, ttop;

    // draw scale
   resizeScale(&p,&r);
   SamplinScaleBar::draw(&p);

//   p.setBrush(NoBrush);
//   p.drawRect(r.x(),r.y(),sizeHint(p).width(),sizeHint(p).height());
   
   if(!d_title.isEmpty()){
      // draw title
      p.setFont(d_titlefont);
      p.setPen(d_titlecolor);
      QFontMetrics fm=p.fontMetrics();
      ta = p.fontMetrics().ascent();
      th = p.fontMetrics().height();
      ttop = ta + d_titleOffset;
//      printf("axis a:%i, h%i, w:%i\n",ta,th,p.fontMetrics().width(d_title));
      
      switch(orientation())
     {
      case Left:
	p.rotate(-90.0);
	ttop = qwtMin(ttop + (r.width() - ttop) / 4, r.width());
	p.drawText(-r.bottom(), r.right() - ttop,
	   r.height(), 2*th,AlignHCenter|AlignTop, d_title);
	p.rotate(90.0);
	break;
      case Right:
	
	p.rotate(90.0);
	ttop = qwtMin(ttop + (r.width() - ttop) / 4, r.width());
	p.drawText(r.top(), -r.left() - ttop,
		    r.height(), 2*th, AlignHCenter|AlignTop, d_title);
	p.rotate(-90.0);
	break;
      case Top:
	p.drawText(r.x(), r.bottom() - ttop,
		    r.width(), 2*th,
		    AlignHCenter|AlignTop ,d_title);
	break;
      case Bottom:
//	QFontMetrics mfm(d_titlefont);
//	printf("->minRightBearing:%i, metrics RB:%i\n",fm.minRightBearing(),mfm.minRightBearing());
//	printf("Bottom: x:%i, top:%i, w:%i, h:%i\n",r.x(),r.top()+d_titleOffset,r.width(),2*th);
		p.drawText(r.x(), r.top() + d_titleOffset,
		    r.width(), 2*th,
		    AlignHCenter|AlignTop,d_title);

	
/*	p.drawText(r.x()+(r.width()-fm.width(d_title))/2,
		   r.top() + d_titleOffset+fm.ascent(),
		   d_title);*/
	break;
     }

   }
}

void SamplinScaleBox::resizeScale(QPainter *p, QRect *r)
{
    switch(orientation())
    {
    case Bottom:
       setGeometry(r->x() + d_scaleOffset[0],
			    r->y() + d_borderDist,
			    r->width() - d_scaleOffset[1] - d_scaleOffset[0],
			    Bottom);

       d_titleOffset = d_titleYDist + d_borderDist + maxHeight(p);
       break;
	
    case Top:
	setGeometry(r->x() + d_scaleOffset[0],
			    r->bottom() - d_borderDist,
			    r->width() - d_scaleOffset[1] - d_scaleOffset[0],
			    Top);
	d_titleOffset =  d_titleYDist + d_borderDist + maxHeight(p);
	break;
	
    case Left:
	setGeometry(r->right() - d_borderDist,
			    r->y() + d_scaleOffset[0],
			    r->height() - d_scaleOffset[0] - d_scaleOffset[1],
			    Left);
	d_titleOffset = d_borderDist + d_titleXDist + maxWidth(p,FALSE);
	break;
	
    case Right:
	setGeometry(r->x() + d_borderDist,
			    r->y() + d_scaleOffset[0],
			    r->height() - d_scaleOffset[0] - d_scaleOffset[1],
			    Right);
	d_titleOffset = d_borderDist + d_titleXDist + maxWidth(p,FALSE);
	break;
	
    }
    
}

QSize SamplinScaleBox::sizeHint(QPainter &p) const
{
   int th=0,ta=0, tw=0;
   bool title_enabled;
   
   title_enabled=!d_title.isEmpty();

   if(title_enabled){
      p.setFont(d_titlefont);
      QFontMetrics fm = p.fontMetrics();
      
      th = fm.height();
      ta = fm.ascent();
      tw = fm.width(d_title);
   }
    
   QSize rv;
   switch(orientation())
     {
      case Left:
      case Right:
	rv.setWidth(maxWidth(&p,FALSE) + 3*d_borderDist + th*title_enabled);
	rv.setHeight(maxHeight(&p)+2*d_borderDist);
	break;
      case Top:
      case Bottom:
	rv.setHeight(maxHeight(&p) + 3*d_borderDist + (th + d_titleYDist)*title_enabled);
	rv.setWidth(maxWidth(&p,FALSE) + 2*d_borderDist);
	break;
     }
   return rv;
   
}

int SamplinScaleBox::minScaleOffset(QPainter &p) const
{
    int rv = 0;

   p.setFont(d_font);
   QFontMetrics fm = p.fontMetrics();

    switch(orientation())
    {
    case Left:
    case Right:
	rv = (fm.ascent() + fm.descent() + 1) / 2;
	break;
    case Top:
    case Bottom:
	rv = (maxLabelWidth(&p,FALSE) + 1) / 2 + d_borderDist;
	break;
    }
    
    return rv;
    
}

void SamplinScaleBox::scaleChanged()
{
   
   
}

QDataStream &operator<<( QDataStream &s, const SamplinScaleBox &box )
{
   char b;
   
   s << box.title();
   s << box.titleFont();
   s << box.titleColor();
   s << box.font();
   s << box.pen();
   b = box.autoScale();
   s << b;
   s << box.scaleMin();
   s << box.scaleMax();
   s << box.scaleStep();
   s << box.scaleRef();
   s << box.maxMinor();
   s << box.maxMajor();
   s << box.options();
/*
 printf("<< min:%f,max:%f,step:%f, ",box.scaleMin(),box.scaleMax(),box.scaleStep());
 printf("ref:%f,",box.scaleRef());
 printf("min:%i,",box.maxMinor());
 printf("maj:%i,",box.maxMajor());
 printf("opt:%i\n",box.options());
 */
   return(s);
}


QDataStream &operator>>( QDataStream &s, SamplinScaleBox &box )
{
   int i;
   char a;
   QPen p;
   QColor c;
   QString str;
   QFont f;
   double d,min,max,step;

   box.setOptions(0);
   box.setAutoScale(FALSE);
   
   s >> str;
   box.setTitle(str);
   f.initialize();
   s >> f;
   box.setTitleFont(f);
   s >> c;
   box.setTitleColor(c);
   s >> f;
   box.setFont(f);
   s >> p;
   box.setPen(p);
   s >> a;

   s >> min;
   s >> max;
   s >> step;
//   printf(">> min:%f,max:%f,step:%f, ",min,max,step);
   box.setScale(min,max,step);
   s >> d;
//   printf("ref:%f,",d);
   box.setReference(d);
   s >> i;
//   printf("min:%i,",i);
   box.setMaxMinor(i);
   s >> i;
//   printf("maj:%i,",i);
   //   box.setMaxMajor(i);
   s >> i;
   box.setOptions(i);
//   printf("opt:%i\n",i);
   
   box.setAutoScale(a);
   
   return(s);
}
