/**************************************************************************
 * $Id: SamplinMain.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef Samplin_main_included
#define Samplin_main_included

#include <script.h>
#include "devices.h"
#include "GraphWindow.h"
#include "edit.h"
#include <ktopwidget.h>
#include "SamplinEdit.h"
//#include <keditcl.h>


#define ID_STATUS 1
#define ID_LINE_COLUMN 2
#define ID_INS_OVR 3
#define ID_CHANGED 4

//extern struct configstruct cnf;

class Samplin_main : public KTopLevelWidget
{
    Q_OBJECT

 public:

    Samplin_main
    ();

   virtual ~Samplin_main();

   void externEdit(const char *);
   
   Edit *messagewin;
   SamplinScript *compiler;
   SamplinEdit *editor;
   
 private:
   QPopupMenu m_graphs;
   
 protected:
   void  resizeEvent( QResizeEvent * );
   void closeEvent( QCloseEvent *);
   
   KStatusBar *statusbar;
   KToolBar *toolbar;
   KTreeList *tree;
   KMenuBar *menubar;
   QString scriptname;
   bool text_changed;
   bool text_changed_warn;
   bool prog_active;
   
 protected slots:
   
   virtual void helpContents();
   virtual void helpAbout();
   virtual void editDevices();
   virtual void openGraph();
   virtual bool closeAllGraphs();
   virtual void closeMe();

 public slots:
   void editOpen();
   void editSave();
   void editSaveAs();
   void editCopy();
   void editPaste();
   void editCut();
   void editSelectAll();
   void editInsert();
   void editFind();
   void editFindAgain();
   void editReplace();
   void editGoto();
   
   virtual void updateCaption();
   virtual void closeGraphSlot(uint id);
   virtual void openGraphSlot(uint, GraphWindow *);

   void cursorPositionSlot();
   void toggleOverwriteSlot();
   void textChangedSlot();
   
 public slots:
   virtual int compileScript();
   virtual void runScript();
   virtual void stopScript();
   virtual void resetScript();
   virtual void gotoScript();
   virtual void stepScript();
 protected slots:

   virtual void externEdit();
   virtual void newScript();
   virtual void setupScript();
   virtual void stateScript(int state);   
 signals:
   void stopSignal();

   
};
#endif // Samplin_main_included
