/**************************************************************************
 * $Id: main.cpp 1.2 Thu, 18 Feb 1999 16:48:37 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "main.h"
#include "script.h"
#include <unistd.h>
#include <fcntl.h>

SamplinScript *compiler;

main( int argc, char ** argv )
{
   QFile testfile;

   int ret;
   
   clipboard_curve=NULL;
   
//   printf("*** samplin interpreter ***\n");

//   fprintf(stderr,"this message goes to stderr\n");
//   fprintf(stdout,"and this message goes to stdout\n");
//   write(STDERR_FILENO,"this message goes to stderr\n",28);
//   write(STDOUT_FILENO,"and this message goes to stdout\n",32);
//   fflush(stderr);
//   fflush(stdout);
   
   
   if(argc==2){
   if(!strcmp(argv[1],"--help")){
      printf("SampLin %s interpreter\nSyntax:samplin [scriptname]\n", SAMPLIN_VERSION);
      exit(0);
   }
   if(!strcmp(argv[1],"--version")){
      printf("SampLin %s\n", SAMPLIN_VERSION);
      exit(0);
   }
   }

   signal(SIGFPE,signal_handler);
//   signal(SIGSEGV,signal_handler);
   signal(SIGPIPE,signal_handler);
  
//   signal(SIGINT,signal_handler);
//   signal(SIGQUIT,signal_handler);
//   signal(SIGABRT,signal_handler);
//   signal(SIGTERM,signal_handler);
  

   
   KApplication a( argc, argv, PACKAGE );
   
   readConfig();
   writeConfig();
   createDirs();

   QString openfile(argv[1]);
   
   if(argc==2){
      QString sfile;

      sfile=openfile;
      
      testfile.setName(openfile);
      if(testfile.exists()==FALSE){
	 openfile+=SCRIPT_EXT;
	 testfile.setName(openfile);
	 if(testfile.exists()==FALSE){

	    openfile=cnf.root_dir+cnf.scripts_dir+argv[1];
	    testfile.setName(openfile);
	    if(testfile.exists()==FALSE){
	       openfile+=SCRIPT_EXT;
	       testfile.setName(openfile);
	       if(testfile.exists()==FALSE){
		  printf("Error: Can't open script file %s\n",sfile.data());
//		  QMessageBox::warning(NULL,"Error","Can't open script file "+sfile);
		  exit(1);  
	       }
	    }
	 }
      }
   }
   
   compiler = new SamplinScript(NULL);

   //   if(compiler->setDevicesFile(cnf.cnf_dir+cnf.devices_file)==-1){
   //      QMessageBox::warning(NULL,"Warning","Can't open device list file "+cnf.cnf_dir+cnf.devices_file);	 
   //   }

   if(fcntl(128,F_GETFL)==-1){
     if(argc!=2)printf("*** SampLin interpreter version %s ***\n",SAMPLIN_VERSION);   
   }
   else {
//      debug("started from UI");
      compiler->childflag=TRUE;
   }
   fflush(stdout);
   fflush(stderr);
   
   if(argc==2){
      compiler->setQuitFlag(TRUE);
      compiler->setFile(openfile);
      if((compiler->compile())==0)
	compiler->execute(-1);
      else exit(2);
   }      

   else {
      compiler->setQuitFlag(FALSE); 
//      ::fcntl(0,F_SETFL,O_NONBLOCK);
   }


   
   ret=a.exec();
   return ret; 
}

void signal_handler(int sig)   /* handle signals */
{
     switch (sig) {
      case SIGFPE:
	compiler->error(FATAL,"Floating point exception, cannot proceed.");
	exit(1);
      case SIGSEGV:
	compiler->error(FATAL,"Segmentation violation, cannot proceed.");
	exit(1);
//      case SIGINT:
//	compiler->error(FATAL,"Segmentation violation, cannot proceed.");
//	exit(1);
      case SIGPIPE:
	compiler->error(WARNING,"Broken pipe.");
//	exit(1);
      default:
	    break;
     }
   debug("Got signal: %i",sig);
}
