/**************************************************************************
 * $Id: scriptdlg.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include <qpainter.h>
#include <qbrush.h>
#include <qpen.h>
#include <qcolor.h>
#include <qdrawutl.h>
#include <kiconloader.h>
#include "scriptdlg.h"

#include "scriptdlg.moc"

#define Inherited QDialog


ScriptDlg::ScriptDlg
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
   KIconLoader IconLoader;
   
//   IconLoader.insertDirectory(0,QString("./Icons/"));
   setIcon( IconLoader.loadIcon("SampLin.xpm") );

}


ScriptDlg::~ScriptDlg()
{
   dlg->dlg=NULL;
}

void ScriptDlg::closeEvent(QCloseEvent *e)
{
   e->accept();
//   dlg->dlg=NULL;
   delete this;
}


ScriptPushButton::ScriptPushButton
(
	QWidget* parent,
	const char* name
)
	:
	QPushButton( parent, name )
{

   widget=NULL;
   connect(this,SIGNAL(clicked()), this, SLOT(clickedSlot()));
}


ScriptPushButton::~ScriptPushButton()
{
}

void ScriptPushButton::clickedSlot()
{
      emit widgetSignal(widget);  
}

ScriptCheckBox::ScriptCheckBox
(
	QWidget* parent,
	const char* name
 )
	:
	QCheckBox( parent, name )
{
   widget=NULL;
//   connect(this,SIGNAL(toggled(bool)), this, SLOT(toggledSlot(bool)));
   connect(this,SIGNAL(clicked()), this, SLOT(clickedSlot()));
   timer = new QTimer(this);
   timer->start(0,FALSE);
   connect(timer,SIGNAL(timeout()), this, SLOT(timerSlot()));
   value=NULL;
}


ScriptCheckBox::~ScriptCheckBox()
{
   timer->stop();
   delete timer;
}

void ScriptCheckBox::toggledSlot(bool state)
{
   if(value!=NULL)*value=state;
   emit widgetSignal(widget);  
   
}

void ScriptCheckBox::clickedSlot()
{
   if(value!=NULL)*value=isOn();
   emit widgetSignal(widget);  
   
}

void ScriptCheckBox::timerSlot()
{
   bool new_state;
   if(value==NULL)return;

   new_state=(*value==0) ? FALSE:TRUE;

   if(isChecked()!=new_state)
     setChecked(new_state);
   
}

ScriptKnob::ScriptKnob
(
	QWidget* parent,
	const char* name
 )
	:
	QwtKnob( parent, name )
{
   widget=NULL;
   var=NULL;
   connect(this,SIGNAL(valueChanged(double)), this, SLOT(changedSlot(double)));
   timer = new QTimer(this);
   timer->start(0,FALSE);
   connect(timer,SIGNAL(timeout()), this, SLOT(timerSlot()));

}


ScriptKnob::~ScriptKnob()
{
   timer->stop();
   delete timer;
}

void ScriptKnob::changedSlot(double v)
{
   if(var!=NULL)*var=v;
//   emit widgetSignal(widget);  
   
}

void ScriptKnob::timerSlot()
{

   double new_state;
   if(var==NULL)return;

   new_state=*var;

   if(value()!=new_state)
     setValue(new_state);
 
}

ScriptSlider::ScriptSlider
(
	QWidget* parent,
	const char* name,
        Orientation orient, 
        ScalePos scalePos
 )
	:
	QwtSlider( parent, name, orient, scalePos )
{
   widget=NULL;
   var=NULL;
   connect(this,SIGNAL(valueChanged(double)), this, SLOT(changedSlot(double)));
   timer = new QTimer(this);
   timer->start(0,FALSE);
   connect(timer,SIGNAL(timeout()), this, SLOT(timerSlot()));

}


ScriptSlider::~ScriptSlider()
{
   timer->stop();
   delete timer;
}

void ScriptSlider::changedSlot(double v)
{
   if(var!=NULL)*var=v;
//   emit widgetSignal(widget);  
   
}

void ScriptSlider::timerSlot()
{

   double new_state;
   if(var==NULL)return;

   new_state=*var;

   if(value()!=new_state)
     setValue(new_state);
 
}


ScriptLevel::ScriptLevel
(
	QWidget* parent,
	const char* name
 )
	:
	QwtThermo( parent, name )
{
   ScriptLevel::ScalePos aaa;
   
   timer = new QTimer(this);
   timer->start(0,FALSE);
   connect(timer,SIGNAL(timeout()), this, SLOT(timerSlot()));
   val=NULL;
}


ScriptLevel::~ScriptLevel()
{
   timer->stop();
   delete timer;
}

void ScriptLevel::timerSlot()
{
   double new_state;
   if(val==NULL)return;

   new_state=*val;

   if(value()!=new_state)
     setValue(new_state);
  
}

ScriptLCD::ScriptLCD
(
	QWidget* parent,
	const char* name
 )
	:
	LCDisplay( parent, name )
{
   timer = new QTimer(this);
   timer->start(0,FALSE);
   connect(timer,SIGNAL(timeout()), this, SLOT(timerSlot()));
   val=NULL;
}


ScriptLCD::~ScriptLCD()
{
   timer->stop();
   delete timer;
}

void ScriptLCD::timerSlot()
{
   if(val==NULL)return;

   if(value()!=*val)
     display(*val);
   
}



ScriptLED::ScriptLED(QWidget *parent) : QFrame(parent),
  lwidth( 16 ), lheight( 8 ), dx( 4 )
{
   s= Off;
   timer = new QTimer(this);
   timer->start(0,FALSE);
   connect(timer,SIGNAL(timeout()), this, SLOT(timerSlot()));
   value=NULL;
   
//   setFrameStyle(Sunken | Box);
   setGeometry(0,0,lwidth,lheight);
   color=yellow;
}

void ScriptLED::drawContents(QPainter *painter)
{
   int w,h,x,y;
   QBrush lightBrush(color);
   QBrush darkBrush(QColor(60,60,0));
   QPen pen(QColor(40,40,0));
//   QPen pen(QColor(140,140,140));
   
   w=width();
   h=height();
   y=(h-lheight)/2;
   x=0;
  
   qDrawShadeRect(painter,x,y,lwidth,lheight,colorGroup(),TRUE,1,1);
   painter->drawText(7+lwidth,0,w-lwidth-20,h,AlignVCenter|AlignLeft,text);
   
   switch(s) {
    case On:
      painter->setBrush(lightBrush);
      painter->drawRect(x+1,y+1,lwidth-2, lheight-2);
      break;
    case Off:
      painter->setBrush(darkBrush);
      painter->drawRect(x+1,y+1,lwidth-2, lheight-2);
      painter->setPen(pen);
      painter->drawLine(x+2,y+2,x+lwidth-2, y+2);
      painter->drawLine(x+2,y+lheight-2,x+lwidth-2,y+lheight-2);
      // Draw verticals
//      int i;
//      for (i= 2; i < width-1; i+= dx)
//	   painter->drawLine(i,2,i,height-2);
      break;
    default:
      fprintf(stderr, "KLedLamp: INVALID State (%d)\n", s);
   }
}

ScriptLED::~ScriptLED()
{
   timer->stop();
   delete timer;
}

void ScriptLED::timerSlot()
{
   enum State new_state;
   if(value==NULL)return;

   new_state=(*value==0) ? Off:On;

   if(state()!=new_state)
     setState(new_state);
   
}

ScriptComboBox::ScriptComboBox
(
	bool rw, QWidget* parent,
	const char* name
 )
	:
	QComboBox( rw, parent, name )
{
   widget=NULL;
   connect(this,SIGNAL(activated(int)), this, SLOT(selectedSlot(int)));
   timer = new QTimer(this);
   timer->start(0,FALSE);
   connect(timer,SIGNAL(timeout()), this, SLOT(timerSlot()));
   value=NULL;
}


ScriptComboBox::~ScriptComboBox()
{
   timer->stop();
   delete timer;
}

void ScriptComboBox::selectedSlot(int index)
{
   if(value!=NULL)*value=index;
   emit widgetSignal(widget);  
   
}

void ScriptComboBox::timerSlot()
{
   int new_index;

   if(value==NULL)return;

   new_index=(int)*value;

   if(currentItem()!=new_index)
     setCurrentItem(new_index);
   
}

ScriptLineEdit::ScriptLineEdit
(
	QWidget* parent,
	const char* name
 )
	:
	QLineEdit( parent, name )
{
   widget=NULL;
   pointer=NULL;
   connect(this,SIGNAL(textChanged(const char *)), this, SLOT(changedSlot(const char *)));
   timer = new QTimer(this);
   timer->start(0,FALSE);
   connect(timer,SIGNAL(timeout()), this, SLOT(timerSlot()));
}


ScriptLineEdit::~ScriptLineEdit()
{
   timer->stop();
   delete timer;
}

void ScriptLineEdit::changedSlot(const char *new_str)
{
   if(pointer!=NULL){
      if(strcmp(*pointer, new_str) || strlen(new_str)!=strlen(*pointer)){
	 free(*pointer);
	 *pointer=strdup(new_str);
      }
      
   }
     //*value=index;
   emit widgetSignal(widget);  
   
}

void ScriptLineEdit::timerSlot()
{
/*
   int new_index;

   if(value==NULL)return;

   new_index=(int)*value;

   if(currentItem()!=new_index)
     setCurrentItem(new_index);
  */ 
}

//----------------------------------
ScriptLabel::ScriptLabel
(
	QWidget* parent,
	const char* name
 )
	:
	QLabel( parent, name )
{
   widget=NULL;
   pointer=NULL;
//   timer = new QTimer(this);
//   timer->start(0,FALSE);
//   connect(timer,SIGNAL(timeout()), this, SLOT(timerSlot()));
}


ScriptLabel::~ScriptLabel()
{
//   timer->stop();
//   delete timer;
}

void ScriptLabel::timerSlot()
{
/*
   int new_index;

   if(value==NULL)return;

   new_index=(int)*value;

   if(currentItem()!=new_index)
     setCurrentItem(new_index);
  */ 
}
