/**************************************************************************
 * $Id: SerialDlg.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/


#ifndef SerialDlg_included
#define SerialDlg_included

#include "dlg/SerialDlgData.h"

class SerialDlg : public SerialDlgData
{
    Q_OBJECT

public:

    SerialDlg
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~SerialDlg();

   void setBaud(const int bd){input_baud->setCurrentItem(bd);
   }
   void setData(const int bd){input_data->setCurrentItem(bd);
   }
   void setStop(const int bd){input_stop->setCurrentItem(bd);
   }
   void setParity(const int bd){input_parity->setCurrentItem(bd);
   }

   int getBaud(void){return(input_baud->currentItem());
   }
   int getData(void){return(input_data->currentItem());
   }
   int getStop(void){return(input_stop->currentItem());
   }
   int getParity(void){return(input_parity->currentItem());
   }
   
   
};
#endif // SerialDlg_included
