/**************************************************************************
 * $Id: rgpib_lib.c 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "ib.h"
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <rpc/rpc.h>
#include <rgpib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

void init_gpib_request(gpib_request *req)
{
   memset(req,0,sizeof(gpib_request));
   req->client="";
}


CLIENT *ibCreateRemote (const char *server){


   CLIENT *cl=NULL;
   char hostname[MAXNETNAMELEN];
   
   gethostname(hostname,sizeof(hostname));
   cl=clnt_create(server,RGPIBPROG,RGPIBVERS,"tcp");
   if(cl==NULL){
      iberr=ENWE;
      return(NULL);
   }
   cl->cl_auth = authunix_create(hostname,getuid(),getgid(),0,NULL );

   return cl;
}
   
int ibOpenRemote(CLIENT *cl, const char *device, int pad){

   int *ret,handle;
   struct gpib_request req;   
   
   if(cl==NULL)return ERR;
   
   //   printf("Remote req for device %s\n",device);
   
   init_gpib_request(&req);
   req.buf.buf_val = device;
   req.buf.buf_len = strlen(req.buf.buf_val)+1;
   req.request=REQ_OPEN;
   req.pad=pad;
   ret = rgpib_gethandle_1( &req , cl );
   if( ret == NULL ) {
     ibsta |= CMPL | ERR;
     iberr = ENWE;
     ibcnt = errno;
     return ERR;
   } 

   handle=*ret;
   if( handle & ERR ){
     ibsta |= CMPL | ERR ;
     iberr = ENWE;
     ibcnt = errno;
     return ERR;
   }

   return handle;
}
   
int ibCloseRemote(CLIENT *cl, int handle, int pad){

   int *ret;
   struct gpib_request req;   
   
   if(cl==NULL)return ERR;

   init_gpib_request(&req);
   req.request=REQ_CLOSE;
   req.handle=handle;
   req.pad=pad;
   ret = rgpib_gethandle_1( &req , cl );
   if( ret == NULL ) {
     ibsta |= CMPL | ERR;
     iberr = ENWE;
     ibcnt = errno;
     return ERR;
   } 
   if( *ret & ERR ){
     ibsta |= CMPL | ERR ;
     iberr = ENWE;
     ibcnt = errno;
     return ERR;
   }

   clnt_destroy(cl);
   return 0;
}

int ibFuncRemote (CLIENT *cl, int handle, int code, int arg, char *buf, int cnt)
{
   gpib_request request, *result;
   
   init_gpib_request(&request);
   request.handle  = handle;
   request.request = code;
   request.arg     = arg;
   request.ibcnt   = cnt;
   request.count   = cnt;

//   if ((code==IBWRT || code==DVWRT) && buf!=NULL){
   if(buf!=NULL){
      request.buf.buf_val = buf;
      request.buf.buf_len = cnt;
   }
   
   result = rgpib_dorequest_1 ( &request, cl );
   
   if( result == NULL ) {
      ibsta |= CMPL | ERR;
      iberr = ENWE;
      ibcnt = errno;
      //    ibPutMsg("Network Error during request %d (%s) ",code,ibVerbCode(code));
   } 
   else {
      ibsta = result->ibsta;
      iberr = result->iberr;
      ibcnt = result->ibcnt;
      
      if( result->ibsta & ERR ){
	 //      ibPutMsg("Network Request Error: '%s' resulted with an error ",ibVerbCode(code));
      } 
      else switch (code) {
       case IBRD:
       case DVRD:
	 memset(buf,0,cnt);
       case IBAPRSP:
       case IBRPP:
       case DVRSP:
	 memcpy(buf,result->buf.buf_val,ibcnt);
	 break;
      }
      
   }
   return ibsta;
}
