/**************************************************************************
 * $Id: GraphGrid.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef GraphGrid_included
#define GraphGrid_included

#include "dlg/GraphGridData.h"
#include <SamplinPlot.h>

class GraphGrid : public GraphGridData
{
    Q_OBJECT

friend class GraphOptions;
   
public:

    GraphGrid
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

   virtual ~GraphGrid();
   
   void setData(SamplinPlot *);
   
 protected:
   
   SamplinPlot *series;
   
   QPen d_majpen, d_minpen;
   int d_xgrid, d_ygrid,d_majx,d_majy,d_minx,d_miny;
   bool d_axisenable[axisCnt];

   void loadBack(void);
   void loadOld(void);

   
};
#endif // GraphGrid_included
