/**************************************************************************
 * $Id: Graph_axis.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "Graph_axis.h"

#define Inherited Graph_axisData
#include <kfontdialog.h>
#include <stdlib.h>

#include "Graph_axis.moc"

Graph_axis::Graph_axis
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{

   button_ok->setDefault(TRUE);
   connect(inp_auto,SIGNAL(clicked()),this,SLOT(updateEnabled()));

}


Graph_axis::~Graph_axis()
{
}

void Graph_axis::setData(SamplinScaleBox *data)
{
   QString s;
   scale=data;
   
   switch(data->orientation()){
    case SamplinScaleBox::Left:
      s="Left axis properties";
      break;
    case SamplinScaleBox::Right:
      s="Right axis properties";
      break;
    case SamplinScaleBox::Bottom:
      s="Bottom axis properties";
      break;
    case SamplinScaleBox::Top:
      s="Top axis properties";
      break;
   }
   setCaption( s );  

   d_title=scale->title();
   d_tfont=scale->titleFont();
   d_ntfont=d_tfont;
   d_font=scale->font();
   d_nfont=d_font;
   d_tcolor=scale->titleColor();
   d_pen=scale->pen();
   d_min=scale->scaleMin();
   d_max=scale->scaleMax();
   d_step=scale->scaleStep();
   d_ref=scale->scaleRef();
   d_prec=scale->labelPrec();
   d_format=scale->labelFormat();
   d_mincnt=scale->maxMinor();
   d_opt=scale->options();
   d_auto=scale->autoScale();
   
   inp_title->setText(d_title);
   inp_titlecolor->setColor(d_tcolor);
   inp_color->setColor(d_pen.color());
   s.sprintf("%.*g",d_prec,d_min);
   inp_min->setText(s);
   s.sprintf("%.*g",d_prec,d_max);
   inp_max->setText(s);
   s.sprintf("%.*g",d_prec,d_step);
   inp_step->setText(s);
   s.sprintf("%.*g",d_prec,d_ref);
   inp_ref->setText(s);   
   s.sprintf("%i",d_mincnt);
   inp_minor->setText(s);
   s.sprintf("%i",d_prec);
   inp_prec->setText(s);
   inp_format->setCurrentItem(d_format);
   
   inp_auto->setChecked(d_auto);
   inp_log->setChecked(d_opt&QwtAutoScale::Logarithmic);
   inp_sym->setChecked(d_opt&QwtAutoScale::Symmetric);
   inp_inc->setChecked(d_opt&QwtAutoScale::IncludeRef);
   inp_inv->setChecked(d_opt&QwtAutoScale::Inverted);
   inp_fl->setChecked(d_opt&QwtAutoScale::Floating);
   updateEnabled();
}

void Graph_axis::selectFont()
{
   KFontDialog *fdlg;
   
   fdlg = new KFontDialog(this,"Select font",TRUE);
   fdlg->setFont(d_nfont);
   fdlg->show();
   if(fdlg->result()==QDialog::Accepted)
     d_nfont=fdlg->font();
   
   delete fdlg;
}

void Graph_axis::selectTitleFont()
{
   KFontDialog *fdlg;
   
   fdlg = new KFontDialog(this,"Select font",TRUE);
   fdlg->setFont(d_ntfont);
   fdlg->show();
   if(fdlg->result()==QDialog::Accepted)
     d_ntfont=fdlg->font();
   
   delete fdlg;
}
void Graph_axis::loadBack(void)
{
   int o;
   
   scale->setTitle(inp_title->text());
   scale->setTitleFont(d_ntfont);
   scale->setTitleColor(inp_titlecolor->color());
   scale->setPen(inp_color->color());
   scale->setFont(d_nfont);
   scale->setScale(atof(inp_min->text()),atof(inp_max->text()),atof(inp_step->text()));
   scale->setReference(atof(inp_ref->text()));
   scale->setMaxMinor(atoi(inp_minor->text()));
   scale->setLabelFormat((SamplinScaleBox::Format)inp_format->currentItem(),atoi(inp_prec->text()));
   
   o=0;
   o+=inp_log->isChecked()*QwtAutoScale::Logarithmic;
   o+=inp_sym->isChecked()*QwtAutoScale::Symmetric;
   o+=inp_inc->isChecked()*QwtAutoScale::IncludeRef;
   o+=inp_inv->isChecked()*QwtAutoScale::Inverted;
   o+=inp_fl->isChecked()*QwtAutoScale::Floating;
   scale->setOptions(o);
   scale->setAutoScale(inp_auto->isChecked());
}

void Graph_axis::ok()
{
      if(scale!=NULL){
	       loadBack();
	       emit update();
      }
      accept();
}

void Graph_axis::apply()
{
      if(scale!=NULL){
	       loadBack();
	       emit update();
      }
}

void Graph_axis::cancel()
{
   
      if(scale!=NULL){
	 scale->setTitle(d_title);
	 scale->setTitleFont(d_tfont);
	 scale->setTitleColor(d_tcolor);
	 scale->setPen(d_pen);
	 scale->setFont(d_font);
	 scale->setScale(d_min,d_max,d_step);
	 scale->setReference(d_ref);
	 scale->setMaxMinor(d_mincnt);
	 scale->setLabelFormat((SamplinScaleBar::Format)d_format, d_prec);
	 scale->setOptions(d_opt);
	 scale->setAutoScale(d_auto);
	 
	 emit update();
      }
   
      reject();
}

void Graph_axis::updateEnabled()
{
   bool set=inp_auto->isChecked();
   
   inp_min->setEnabled(!set);
   inp_max->setEnabled(!set);
   inp_step->setEnabled(!set);

   inp_sym->setEnabled(set);
   inp_inc->setEnabled(set);
   inp_inv->setEnabled(set);
   inp_fl->setEnabled(set);

}
