/**************************************************************************
 * $Id: SamplinCurve.h 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3 beta $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#ifndef SAMPLIN_CURVE_H
#define SAMPLIN_CURVE_H

#include <qpen.h>
#include <qstring.h>
#include <qrect.h>
#include <qcolor.h>
#include <qpntarry.h>
#include <qarray.h>
#include <qpixmap.h>

#include "qwt_dimap.h"
#include "qwt_spline.h"
#include "qwt_symbol.h"
#include "qwt.h"

#include "parser.h"

class QPainter;


class SamplinCurveData
{
    
 public:
   
   // *STRUCTORS
   SamplinCurveData(double *xval, double *yval, int nValues, const char *name = 0);
   SamplinCurveData(const char *name = 0);
   //    SamplinCurveData(const SamplinCurveData &c);
   virtual ~SamplinCurveData();
   
 
 public:

    enum DataStyle {XandY,Yonly,Xonly};
    enum { Auto = 0, Yfx = 1, Xfy = 2, Parametric = 4, Periodic = 8};
    enum CurveStyle{ NoCurve, Lines, Sticks, Steps, Dots, Spline, Fit };

   //static members
   
   static int curveStyle(const char *);
   static int lineStyle(const char *);
   static int symbolStyle(const char *);
   
   Parser d_parser;
   
protected:

//   int    d_ix,d_fman;
//   QString d_function;
//   double d_range1, d_range2, d_fmin, d_fmax, d_vmin, d_vmax;
   
//   int *refcnt;
   
   QwtDiMap d_xMap;
   QwtDiMap d_yMap;
   QwtSymbol d_sym;
   QwtSpline d_spx;
   QwtSpline d_spy;
 
//   QRect clipRect;
   QPen d_pen;
   QString d_name;
   QPointArray d_pa;
   
   QArray<double> d_x;
   QArray<double> d_y;
   
   int d_splineType;
   int d_splineSize;
   
   double d_begin, d_step;

   double rx1, rx2, ry1, ry2;
   
   int d_xoff,d_yoff;
   
   CurveStyle d_style;
   DataStyle d_dataStyle;

   bool d_xraw;
   bool d_yraw;

   int d_xAxis;
   int d_yAxis;
   uint d_key;
   QString d_legend;

   QColor bcolor;
   
   void init(const char *name);

   bool d_visible;

   virtual void update(){}
   
 public:
   bool visible(void) const {
      return d_visible;
   }

   const char *messages(void){return d_parser.messages();}
   
   // MANIPULATORS
   void setVisible(bool vis);
   void setStyle(CurveStyle cs);
   void setSymbol(const QwtSymbol &s);
   void setPen(const QPen &p);

   void setData(double *x, double *y, int size);
   void setData(double begin, double step, double *y, int size);
   void setData(double *x, double begin, double step, int size);

   void putPoint(int index, double x, double y);
   void removePoint(int index);
   
   void setRawData(double *x, double *y, int size);
   void setRawData(double begin, double step, double *y, int size);
   void setRawData(double *x, double begin, double step, int size);
   
   void setSplineType(int t);
   void setSplineSize(int s);

   void setOffset(int x, int y);
   int xOffset(void);
   int yOffset(void);
   
   void setName(const char *name);
   double minXValue() const;
   double maxXValue() const;
   double minYValue() const;
   double maxYValue() const;
   
   uint size() const;
   bool isEmpty() const;
   
    double x(int i) { return d_x[i]; }
    double y(int i) { return d_y[i]; }
    
    const QPen& pen() const { return d_pen; }
    const QwtSymbol& symbol() const { return d_sym; }
    int splineType() const { return d_splineType; }
    int splineSize() const { return d_splineSize; }
    const QString &name() const { return d_name; } 
    CurveStyle style() const { return d_style; }

   DataStyle dataStyle() const {return d_dataStyle; }
   double begin() const {return d_begin;}
   double step() const {return d_step;}
   
   void setLegend(const char *s){d_legend=s;}
   QString &legend(){return d_legend;}
   int xAxis(){return(d_xAxis);}
   int yAxis(){return(d_yAxis);}
   int xSAxis(){return((d_xoff==0 && d_yoff==0)? d_xAxis:xBottom);}
   int ySAxis(){return((d_xoff==0 && d_yoff==0)? d_yAxis:yLeft);}
   void setxAxis(int a){d_xAxis=a;}
   void setyAxis(int a){d_yAxis=a;}
   void setKey(uint key){d_key=key;}
   uint key(void){return d_key;}

   int setFunction(const char *s);
   const char *function(void){return d_parser.function();}
/*
   void setFunctionRange(double r1,double r2){
      d_range1=r1;d_range2=r2;
//      updateFunctionRange();
   }
   double functionRange1(void){return d_range1;}
   double functionRange2(void){return d_range2;}
   void updateFunctionRange(void);
   int functionMan(void){return d_fman;}
   void setFunctionMan(int a){
      d_fman=a;
      updateFunctionRange();
   }
  */ 
   virtual void updatePixmap(void){
   };
   void setBackgroundColor(const QColor &bg);   
   
   //remove
   
   int pointDist(QPoint &pt, const QwtDiMap &mx, const QwtDiMap& my);
   void setMap(const QwtDiMap &mx, const QwtDiMap& my);
   void setRect(const QRect &r);   
   void setRange(double x1, double x2, int xlog, double y1, double y2, int ylog);
 protected:
   void transform(double x, double y, double &u, double &v);
};

QDataStream &operator<<( QDataStream &, SamplinCurveData &);
QDataStream &operator>>( QDataStream &, SamplinCurveData &);

class SamplinCurve : public SamplinCurveData
{
 public:
//   SamplinCurve(double *xval, double *yval, int nValues, const char *name = 0)
//     :SamplinCurveData( xval, yval, nValues, name) {};
//   SamplinCurve(const char *name = 0)
//     :SamplinCurveData(name){};
   //    SamplinCurveData(const SamplinCurveData &c);
//   virtual ~SamplinCurve();
   
 private:

    // PRIVATE DRAWING FUNCTIONS
   void drawLines(QPainter &p);
   void drawSticks(QPainter &p);
   void drawDots(QPainter &p);
    void drawSteps(QPainter &p);
   void drawSymbols(QPainter &p);
   void drawSpline(QPainter &p);
   void drawFit(QPainter &p);

   void drawClipLine(QPainter &p, double x1, double y1, double x2, double y2);
//   QPoint intersect( QRect &r, QPoint &p1, QPoint &p2, bool *valid=0);
   
public:
    
    // MANIPULATORS
    
   void draw(QPainter *p, const QwtDiMap &xMap, const QwtDiMap &yMap);
   void draw(QPainter *p, const QRect &r);
   void draw(QPainter *p);

   virtual void updatePixmap();
   QPixmap &pixmap(void);
   void drawIcon(QPainter &p, const QRect &r);
   
 protected:
   QPixmap pix;

   virtual void update(void);
};


#endif




