//	Die Funktion parse tokenisiert den als String bergebenen 
//	Funktionsterm im Speicherbereich ab mem.
//
//						KDM  2.5.95 

#ifndef parser_included
#define parser_included

#include "fitter.h"

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <qstring.h>
#include <qmsgbox.h>
#include <qintdict.h>
#include <qarray.h>
#include <qdatastream.h>

// Voreinstellungen bei Verwendung des Standardkonstruktors :

#define	MEMSIZE		200	// Speichergre fr Token 
#define	STACKSIZE	50	// Stacktiefe 


//	Token-Liste :

#define KONST	0               // es folgt ein double-Wert
#define	XWERT	1               // x-Wert holen
#define PARAM   2		// Funktionsparameter holen
#define	PUSH	3               // Wert auf Stack
#define	PLUS	4               // Addition
#define	MINUS	5               // Subtraktion
#define	MULT	6               // Multiplikation
#define	DIV	7               // Division
#define	POW	8               // Potenzieren
#define NEG	9		// Negieren
#define FKT	10		// es folgt eine Funktionsadresse
#define	ENDE	11              // Funktionsende

#define	FANZ	19		// Anzahl der math. Funktionen 
				// in mfkttab[]


double	sqr(double x),
	arsinh(double x),
	arcosh(double x),
        artanh(double x),
        sgn(double x)
;
      
	
class Parser : public Fitter
{
//   friend class SamplinCurveData;
//   Q_OBJECT
   
 public:
   
//   Parser();
   Parser(QString name="", int m_size=MEMSIZE, int s_size=STACKSIZE);

   int setFunction(QString name, bool force=FALSE);
   virtual double function(double);
   const QString &function(void) const {return fstr;}
   double eval(QString);
   bool isParsed(void) const {return parsed;}
   int parNum(void) const {return fparnum;}
   double parTbl(int index) const {return fpartbl[index];}
   void setparTbl(int index, double val){if(index<fparnum && index >=0)fpartbl[index]=val;}

   void setRange(bool Man, double low=0.0, double high=1.0);
   double rangeLow(void) const {return d_range1;}
   double rangeHigh(void) const {return d_range2;};
   bool rangeMan(void) const {return d_fman;}
   double xMin(void) const {return d_vmin;}
   double xMax(void) const {return d_vmax;}
   double yMin(void) const {return d_fmin;}
   double yMax(void) const {return d_fmax;}

   void updateFunctionRange(void);
   
   int errmsg();
		
   ~Parser();
	
   int	err,		// Fehlercode:
   // 	0 => parse erfolgreich
   //	1 => Syntaxfehler
   //	2 => fehlende Klammer
   //	3 => Funktion nicht bekannt
   //	4 => ungltige Funktionsvariable
   //	5 => zu viele Funktionen
   //	6 => Speicherberlauf
   //	7 => Stackberlauf
   errpos;		// Fehlerposition
			
 protected:
   double d_fmin,d_fmax,d_vmin,d_vmax,d_range1,d_range2;
   bool d_fman;
   
   unsigned char *mem,	// Zeiger auf Tokenspeicher
   *mptr;		// Zeiger auf Token
   QString fname,	// Funktionsname
   fvar,		// Funktionsvariable
   fstr;		// Funktionsterm
   int	memsize,	// Gre des Tokenspeichers
   stacksize;	        // Gre des Stack

   QIntDict<QString> fpardict;
//   QArray<double> fpartbl;
   int fparnum;
   bool parsed;
   
   struct Mfkt{
      char 	*mfstr;
      double 	(*mfadr)(double);
   };
   static Mfkt mfkttab[FANZ];
   const char *parName(int i);
   
 private:
   
   void ps_init(QString, int, int);
   void heir1();
   void heir2();
   void heir3();
   void heir4();
   void primary();
   void addtoken(unsigned char);
   void addwert(double);
   void addint(int);
   void addfptr(double(*)(double));
   int  match(const char*);	    
   int 	matchstr(const char*);	    
    
   unsigned char evalflg;		// 0 => String wird tokenisiert
					// 1 => String wird direkt ausgewertet
   const char    *lptr;			// Zeiger fr Funktions-String
   double	*stack,			// Zeiger auf Stackanfang
		*stkptr;		// Stackpointer 

};

QDataStream &operator<<( QDataStream &, Parser &);
QDataStream &operator>>( QDataStream &, Parser &);


#endif	// parser_included
/* $Extended$File$Info$
 */
