#ifndef QWT_SCLDRAW_H
#define QWT_SCLDRAW_H

#include <qstring.h>
#include <qwt_dimap.h>
#include <qwt_scldiv.h>
#include <qfont.h>
#include <qrect.h>
#include <qcolor.h>

class QPainter;
class QwtAutoScale;

class QwtScaleDraw
: public QwtDiMap
{
	
public:
	enum Orientation { Bottom, Top, Left, Right, Round };

private:

	QwtScaleDiv d_scldiv;
	
 protected:
	
	static const int minLen;
	
	Orientation d_orient;
	
	int d_xorg;
	int d_yorg;
	int d_len;
	
	int d_hpad;
	int d_vpad;
	
	int d_medLen;
	int d_majLen;
	int d_minLen;

	int d_minAngle;
	int d_maxAngle;

	char d_fmt;
	int d_prec;
   QFont d_font;
   
 private:

	void drawTick(QPainter *p, double val, int len) const;
	void drawBackbone(QPainter *p) const;
	void drawLabel(QPainter *p, double val) const;
	void calcTicks();
	
 public:

	// *STRUCTORS
	QwtScaleDraw();

	// MANIPULATORS

   void setFont(const QFont &f);
   
   void setScale(double vmin, double vmax, int maxMajIntv, int maxMajIntv,
		 double step = 0.0, int logarithmic = 0);
   void setScale(const QwtScaleDiv &s);
   void setGeometry(int xorigin, int yorigin, int length, Orientation o);
   void setAngleRange(double angle1, double angle2);
   void setLabelFormat(char f, int prec);
   char labelFormat(void){return d_fmt;}
   int labelPrec(void){return d_prec;}
   
   const QwtScaleDiv& scalediv() const { return d_scldiv; }
   const QwtScaleDiv& scaleDiv() const;

   int orientation() const { return d_orient; }
	
   QRect maxBoundingRect(QPainter *p) const;
   int maxWidth(QPainter *p, bool worst = TRUE) const;
   int maxHeight(QPainter *p) const;
   int maxLabelWidth(QPainter *p, int worst) const;

   virtual void draw(QPainter *p) const;

};


//------------------------------------------------------------
//
//.S	QwtScaleDraw::scaleDiv
//
//
//.s	Parameters
//.p	
//
//.s	Return Type
//		const QwtScaleDiv &
//
//.s	Return Value
//
//.s	Description
//
//.s	Syntax
//.f	const QwtScaleDiv & QwtScaleDraw::scaleDiv()
//
//------------------------------------------------------------
inline const QwtScaleDiv & QwtScaleDraw::scaleDiv() const
{
    return d_scldiv;
}
#endif







