/**************************************************************************
 * $Id: PrefDirs.cpp 1.1 Thu, 03 Dec 1998 12:49:42 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "PrefDirs.h"

#include <cnflib.h>

#include "PrefDirs.moc"

#define Inherited PrefDirsData

PrefDirs::PrefDirs
(
	QWidget* parent,
	const char* name
)
	:
	Inherited( parent, name )
{
}


PrefDirs::~PrefDirs()
{
}

void PrefDirs::setData(struct configstruct *cfg)
{
   cnf=cfg;
   
   input_root->setText(cnf->root_dir);
   input_data->setText(cnf->data_dir);
   input_script->setText(cnf->scripts_dir);
   input_devices->setText(cnf->devices_file);
//   input_ext->setChecked(cnf->ext_editor);
   input_interpreter->setText(cnf->interpreter);
}

void PrefDirs::apply()
{
   cnf->root_dir=input_root->text();
   cnf->data_dir=input_data->text();
   cnf->scripts_dir=input_script->text();
   cnf->devices_file=input_devices->text();
//   cnf->ext_editor=input_ext->isChecked();
   cnf->interpreter=input_interpreter->text();
}

