/**************************************************************************
 * $Id: SamplinMain.cpp 1.2 Thu, 18 Feb 1999 16:48:37 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include "SamplinMain.h"
#include "main.h"
#include "PrefDirs.h"
#include "PrefComp.h"
#include "DeviceDlg.h"
#include "About.h"
#include <fcntl.h>
#include <unistd.h>
#include <termios.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <qdir.h>
#include <qsplitter.h>
#include <qtabdlg.h>
#include <signal.h>
#include <cnflib.h>

#include "SamplinMain.moc"


void SamplinMain::devConfig()
{
   if(devs_pid>0)return;
   
   devs_pid=fork();
   if(devs_pid==-1)return;
   if(devs_pid==0){
      
      execlp("SampLinDevices",NULL);
      exit(0);
      }
}

void SamplinMain::scriptConfig()
{
   QTabDialog *dlg;
   PrefDirs *w1;
   PrefComp *w2;
   
   dlg=new QTabDialog(this,"Configure SampLin",TRUE);
   w1=new PrefDirs(dlg,"Paths");
   w2=new PrefComp(dlg,"Interpreter");
   w1->setData(&cnf);
   w2->setData(&cnf);
   dlg->setCaption("Configure SampLin");
   dlg->addTab(w2,"Interpreter");
   dlg->addTab(w1,"Paths");
   dlg->setCancelButton();
   dlg->setOkButton();
   connect(dlg,SIGNAL(applyButtonPressed()), w1,SLOT(apply()));
   connect(dlg,SIGNAL(applyButtonPressed()), w2,SLOT(apply()));   
   dlg->setFixedSize(400,330);
   dlg->show();
   ::writeConfig();
}

/*
void SamplinMain::externEdit(const char *filename)
{
   int ret;

   int pid,i;
   char *argv[64], *ptr;
   
   pid=fork();
   if(pid==-1)return;
   if(pid==0){
      
      ptr=cnf.edit_command.data();
      argv[0]=strtok(ptr," ");
      i=0;
      do{
	 ++i;
	 argv[i]=strtok(NULL," ");
	 
	 if(!strcmp("%f",argv[i]) && strlen(argv[i])==strlen("%f"))
	   argv[i]=(char *)filename;
      }while(argv[i]!=NULL && i<63);
      argv[i]=NULL;
      
      chdir(cnf.root_dir+cnf.scripts_dir);
      execvp(argv[0],argv);
      exit(0);
      }
   else {
      usleep(250000);
      ret=waitpid(pid,NULL,WNOHANG);
      if(ret==-1)
	QMessageBox::warning(NULL,"Error", "Could not execute command '"+cnf.edit_command+"'");
   }
}
*/
 
void SamplinMain::scriptState(int state)
{
   
   if(state!=script_status){

      if(state==FINISHED && child_errorlevel<=ERROR){
	 kWrite->markLine(-1);
	 kWrite->markLine(child_lineno-1,QColor(230,110,110));
	 kWrite->setCursorPosition(child_lineno-1,0);
	 
      }
      if(state==RUNNING){
	 tewidget->setFocus();
//	 temul->setMode(MODE_Cursor);
      }
      else{
	 kWrite->setFocus();
//	 temul->resetMode(MODE_Cursor);
      }
      
      switch(state){
	 
       case COMPILING:
	 statusBar()->changeItem("Compiling", ID_SCRIPT);
	 toolBar()->setItemEnabled(BUTTON_START,FALSE);
	 toolBar()->setItemEnabled(BUTTON_STOP,FALSE);
	 toolBar()->setItemEnabled(BUTTON_STEP,FALSE);
	 toolBar()->setItemEnabled(BUTTON_RESET,FALSE);
	 
	 menuBar()->setItemEnabled(BUTTON_START,FALSE);
	 menuBar()->setItemEnabled(BUTTON_STOP,FALSE);
	 menuBar()->setItemEnabled(BUTTON_STEP,FALSE);
	 menuBar()->setItemEnabled(BUTTON_RESET,FALSE);
	 menuBar()->setItemEnabled(BUTTON_GOTO,FALSE);
	 kWrite->markLine(-1);
	 break;
       case RUNNING:
	 statusBar()->changeItem("Running", ID_SCRIPT);
	 toolBar()->setItemEnabled(BUTTON_START,FALSE);
	 toolBar()->setItemEnabled(BUTTON_STOP,TRUE);
	 toolBar()->setItemEnabled(BUTTON_STEP,FALSE);
	 toolBar()->setItemEnabled(BUTTON_RESET,TRUE);

	 menuBar()->setItemEnabled(BUTTON_START,FALSE);
	 menuBar()->setItemEnabled(BUTTON_STOP,TRUE);
	 menuBar()->setItemEnabled(BUTTON_STEP,FALSE);
	 menuBar()->setItemEnabled(BUTTON_RESET,TRUE);
	 menuBar()->setItemEnabled(BUTTON_GOTO,FALSE);
	 kWrite->markLine(-1);
	 break;      
       case FINISHED:
	 statusBar()->changeItem("Idle", ID_SCRIPT);
	 toolBar()->setItemEnabled(BUTTON_START,TRUE);
	 toolBar()->setItemEnabled(BUTTON_STOP,FALSE);
	 toolBar()->setItemEnabled(BUTTON_STEP,TRUE);
	 toolBar()->setItemEnabled(BUTTON_RESET,FALSE);
	 
	 menuBar()->setItemEnabled(BUTTON_START,TRUE);
	 menuBar()->setItemEnabled(BUTTON_STOP,FALSE);
	 menuBar()->setItemEnabled(BUTTON_STEP,TRUE);
	 menuBar()->setItemEnabled(BUTTON_RESET,FALSE);
	 menuBar()->setItemEnabled(BUTTON_GOTO,TRUE);

	 if(child_errorlevel>ERROR)kWrite->markLine(-1);
	 break;      
       case STOPPED:
	 statusBar()->changeItem("Stopped", ID_SCRIPT);
	 toolBar()->setItemEnabled(BUTTON_START,TRUE);
	 toolBar()->setItemEnabled(BUTTON_STOP,FALSE);
	 toolBar()->setItemEnabled(BUTTON_STEP,TRUE);
	 toolBar()->setItemEnabled(BUTTON_RESET,TRUE);

	 menuBar()->setItemEnabled(BUTTON_START,TRUE);
	 menuBar()->setItemEnabled(BUTTON_STOP,FALSE);
	 menuBar()->setItemEnabled(BUTTON_STEP,TRUE);
	 menuBar()->setItemEnabled(BUTTON_RESET,TRUE);
	 menuBar()->setItemEnabled(BUTTON_GOTO,TRUE);

	 kWrite->markLine(child_lineno-1,QColor(210,200,170));
	 kWrite->setCursorPosition(child_lineno-1,0);
	 break;      
       case COMPILED:
	 statusBar()->changeItem("Compiled", ID_SCRIPT);
	 toolBar()->setItemEnabled(BUTTON_START,TRUE);
	 toolBar()->setItemEnabled(BUTTON_STOP,FALSE);
	 toolBar()->setItemEnabled(BUTTON_STEP,TRUE);
	 toolBar()->setItemEnabled(BUTTON_RESET,TRUE);

	 
	 menuBar()->setItemEnabled(BUTTON_START,TRUE);
	 menuBar()->setItemEnabled(BUTTON_STOP,FALSE);
	 menuBar()->setItemEnabled(BUTTON_STEP,TRUE);
	 menuBar()->setItemEnabled(BUTTON_RESET,TRUE);
	 menuBar()->setItemEnabled(BUTTON_GOTO,TRUE);
	 kWrite->markLine(-1);
	 break;      
      }
      script_status=state;
   }
   
}

void SamplinMain::stopScript()
{
   QString tmp;

   if(child_running){
      tmp="STOP\n";
      write(child_fd_in,tmp.data(),strlen(tmp.data()));      
   }
}


int SamplinMain::startScript()
{
   QString tmp;
   
   int ret=0;

   if(kWrite->isModified() && warn_modified &&
      (script_status==COMPILED || script_status==STOPPED)){
      QMessageBox::information(NULL,"SampLin", "Source file changed\nLine numbers may not match");     
      warn_modified=FALSE;
   }
   
   
   if(script_status!=STOPPED && kWrite->isModified()){

      if(cnf.auto_save)kWrite->save();
      else
	switch( QMessageBox::information( this, "SampLin",
					 "Source file not saved"
					 "Do you want to save it before compiling ?",
					 "&Yes", "&No","&Cancel",
					 0 ) ) {
	 case 0:   kWrite->save();
	break;
	 case 1: 
	   break;
	 case 2: return(-1);
	   break;
	}
   }

   if(!child_running)forkScript();
   if(!child_running)return(-1);
   
   if(child_running && script_status!=STOPPED){
      tmp="SETFILE "+filename+"\n";
      write(child_fd_in,tmp.data(),strlen(tmp.data()));
   }
   if(child_status!=STOPPED)temul->clear();
   
   return ret;
}


void SamplinMain::resetScript()
{
   QString tmp;

   if(child_running){
      tmp="RESET\n";
      write(child_fd_in,tmp.data(),strlen(tmp.data()));      
   }
}
void SamplinMain::stepScript()
{
   QString tmp;
   
   if(startScript()==-1)return;
   
   if(child_running){
      tmp="STEP\n";
      write(child_fd_in,tmp.data(),strlen(tmp.data()));      
   }
}

void SamplinMain::gotoScript()
{
   QString tmp;
   
   if(startScript()==-1)return;
   
   if(child_running){
      tmp.sprintf("GOTO %i\n",kWrite->currentLine()+1);
      write(child_fd_in,tmp.data(),strlen(tmp.data()));      
   }
}

void SamplinMain::killScript()
{
   if(child_running==TRUE){
      ::kill(child_pid,SIGKILL);
   }

}

void SamplinMain::runScript()
{
   QString tmp;
   
   if(startScript()==-1)return;
   
   if(child_running){
      tmp="RUN\n";
      write(child_fd_in,tmp.data(),strlen(tmp.data()));      
   }
}

void SamplinMain::forkScript()
{
   int fd_in[2];
   int fd_out[2];
   int fd_stdout[2];
   int fd_stderr[2];
   int ret;
   int i;
   char *argv[64], *ptr;
   
   if(child_running==TRUE)return;
   
   // fork child
   
   ::pipe(fd_in);
   ::pipe(fd_out);
   
   child_log=FALSE;
   
   if(cnf.mesg_win==TRUE){
      ::pipe(fd_stdout);
      ::pipe(fd_stderr);
      child_log=TRUE;
   }
   
   
   child_pid=fork();
   if(child_pid==-1){
      perror("fork");
      return;
   }
   if(child_pid==0){
      ::close(fd_in[1]);
      ::dup2(fd_in[0],0);
      ::close(fd_in[0]);
      ::close(fd_out[0]);
      if(fd_out[1]!=128)::dup2(fd_out[1],128/*2*/);
      ::close(fd_out[1]);

      if(child_log==TRUE){
	 ::close(fd_stdout[0]);
	 ::dup2(fd_stdout[1],1);
	 ::close(fd_stdout[1]);
	 
 	 ::close(fd_stderr[0]);
	 ::dup2(fd_stderr[1],2);
	 ::close(fd_stderr[1]);
      }
      
   argv[0]="../script/SampLinExec";
      argv[1]=NULL;
      if(::execvp(argv[0],argv)==-1){
	 argv[0]=cnf.interpreter;
	 argv[1]=NULL;
	 if(::execvp(argv[0],argv)==-1){
	 }
      };
      exit(128);
   }
   else {
      ::close(fd_in[0]);      
      child_fd_in=fd_in[1];
      ::close(fd_out[1]);
      child_fd_out=fd_out[0];
      fcntl(child_fd_out,F_SETFL,O_NONBLOCK);
      notifier3=new QSocketNotifier(child_fd_out,QSocketNotifier::Read);
      connect(notifier3,SIGNAL(activated(int)),SLOT(notifier3Handler()));
      
      if(child_log==TRUE){
	 ::close(fd_stderr[1]);
	 child_fd_stderr=fd_stderr[0];
	 ::close(fd_stdout[1]);
	 child_fd_stdout=fd_stdout[0];
	 fcntl(child_fd_stdout,F_SETFL,O_NONBLOCK);
	 fcntl(child_fd_stderr,F_SETFL,O_NONBLOCK);

	 notifier1=new QSocketNotifier(child_fd_stdout,QSocketNotifier::Read);
	 notifier2=new QSocketNotifier(child_fd_stderr,QSocketNotifier::Read);
	 connect(notifier1,SIGNAL(activated(int)),SLOT(notifier1Handler()));
	 connect(notifier2,SIGNAL(activated(int)),SLOT(notifier2Handler()));
      }
      child_running=TRUE;
      scriptState(RUNNING);
      toolBar()->setItemEnabled(BUTTON_KILL,TRUE);
      menuBar()->setItemEnabled(BUTTON_KILL,TRUE);
   }   
   
}

void SamplinMain::timerHandler()
{
   int status,xstatus;
   int ret;
   char msg[255];
   
   if(child_running==TRUE){
      if((ret=waitpid(child_pid,&status,WNOHANG))!=0){
	 if(ret==-1)
	   sprintf(msg,"Could not execute interpreter 'SampLinExec'\n");	 
	 else if(WIFEXITED(status)){
	    xstatus=WEXITSTATUS(status);
	    if(xstatus==128)
	      sprintf(msg,"Could not execute interpreter 'SampLinExec'\n");
	    else {
	       sprintf(msg,"Interpreter exited with return code %i\n",xstatus);
	    }
	 }
	 else if(WIFSIGNALED(status)){
	    sprintf(msg,"Oops, interpreter has been killed by signal %i\n",WTERMSIG(status));
	 }
	 else{
	    sprintf(msg,"Unknown error (waitpid): pid %i, ret %i, status:%i\n",child_pid,ret,status);
	 }

	 message(msg);
	 ::close(child_fd_in);      
	 ::close(child_fd_out);	 
	 delete notifier3;
	 if(child_log==TRUE){
	    ::close(child_fd_stderr);      
	    ::close(child_fd_stdout);	 
	    delete notifier1;
	    delete notifier2;
	 }
	 child_running=FALSE;
	 toolBar()->setItemEnabled(BUTTON_KILL,FALSE);
	 menuBar()->setItemEnabled(BUTTON_KILL,FALSE);
	 scriptState(FINISHED);
      }
   }

   if(devs_pid>0)
     if((ret=waitpid(devs_pid,&status,WNOHANG))!=0){
	if(ret==-1)devs_pid=0;
	else if(WIFEXITED(status) || WIFSIGNALED(status)){
	   devs_pid=0;
	}
     }
}
   
void SamplinMain::notifier1Handler()
{
   QString hilfe;
   int len;//,iter=0;
   static char out_buffer[255];
   static int out_nbytes=0;

//   printf("notifier1 !!!\n");

//   while(read(child_fd_stdout,out_buffer+out_nbytes,1)!=1);
//   ++out_nbytes;
   
//   printf("notifier1 (%c) !!!\n",*out_buffer);
   
   while(out_nbytes<250 && (len=read(child_fd_stdout,out_buffer+out_nbytes,1))==1){
      ++out_nbytes;
      if(out_buffer[out_nbytes-1]=='\n')break;
   }
      
      //	 printf("nbytes=%i, rep=%i\n",out_nbytes,iter);
   out_buffer[out_nbytes]=0;
   hilfe+=out_buffer;
   out_nbytes=0;
   out_buffer[0]=0;
   len=0;

   //messagewin->insertAtEnd(hilfe.data());
//   printf("has a message: %s\n",hilfe.data());
   message(hilfe.data());
}

void SamplinMain::notifier2Handler()
{
   static char err_buffer[255];
   static int err_nbytes=0;


   
   while(err_nbytes<250 && read(child_fd_stderr,err_buffer+err_nbytes,1)==1){
      ++err_nbytes;
      if(err_buffer[err_nbytes-1]=='\n')break;
   }
      
   if(err_nbytes>=250 || (err_nbytes && err_buffer[err_nbytes-1]=='\n')){
      err_buffer[err_nbytes]=0;
      message(err_buffer);
      err_nbytes=0;
      err_buffer[0]=0;
   }
}

void SamplinMain::notifier3Handler()
{
   static char buffer[255];
   static int bytes=0;

   while(nbytes<250 && read(child_fd_out,buffer+nbytes,1)==1){
      ++nbytes;
      if(buffer[nbytes-1]=='\n')break;
   }
      
   if(nbytes>=250 || (nbytes && buffer[nbytes-1]=='\n')){
      buffer[nbytes]=0;
      if(buffer[0]=='S'){
	 sscanf(buffer+1,"%i %i %i",&child_status,&child_errorlevel,&child_lineno);
//	 printf("Got state: %s\n",buffer);
	 scriptState(child_status);
      }
      nbytes=0;
      buffer[0]=0;
   }
}

void SamplinMain::helpAbout()
{
   
      SamplinAbout *about;
   
      about = new SamplinAbout(this, "About", FALSE);
      about->show();
   
      delete about;
}

void SamplinMain::helpContents()
{
      kapp->invokeHTMLHelp("","");
}

void SamplinMain::message(const char *msg)
{

  temul->onRcvBlock(msg,strlen(msg));
   
}

void SamplinMain::receiveChar(const char *s, int n)
{
   char ch;
   
   ch=*s;
   if(ch=='\r')ch='\n';

   temul->onRcvBlock(&ch,1);
   if(child_running)
     write(child_fd_in,&ch,1);      
}


// Doesn't work !!! Why ?
void SamplinMain::focusInEvent(QFocusEvent *e)
{
   
   if(child_running && script_status==RUNNING){
      tewidget->setFocus();
   }
   else kWrite->setFocus();
   
   KTMainWindow::focusInEvent(e);

}

