/**************************************************************************
 * $Id: main.cpp 1.2 Thu, 18 Feb 1999 16:48:37 +0100 samo $
 * $ReleaseVersion: 1.3.1 $
 *
 * This file is part of SampLin data acquisition software
 * Copyright (C) 1997,98 Samuel Kvasnica
 *
 * SampLin is free software; you can redistribute it and/or modify it
 * under the terms of the version 2 of GNU General Public License as
 * published by the Free Software Foundation.
 *
 * SampLin is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License
 * (see the file LICENSE) along with SampLin package; if not, write to the
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **************************************************************************/

#include <samplin.h>

#include <GraphWindow.h>
#include "main.h"
#include <cnflib.h>

#include <signal.h>

#include <qdir.h>


//SamplinCurve *clipboard_curve;

main( int argc, char ** argv )
{
   QFile testfile;
   GraphWindow *gw;
   
   int ret;
   
   clipboard_curve=NULL;
   
   if(argc>2){
      printf("SampLin %s\nSyntax:SamplinGraph [graphname]\n", SAMPLIN_VERSION);
      exit(0);
   }
     
   KApplication a( argc, argv, PACKAGE);

   readConfig();
   writeConfig();
   createDirs();
   
   gw = new GraphWindow(NULL/*,"",0*/);
//   iw->setMinimumSize(400,88);
   gw->show();
//   a.setMainWidget(gw);      

   if(argc==2){
      QString openfile(argv[1]);
      
      testfile.setName(openfile);
      if(testfile.exists()==FALSE){
	 openfile+=GRAPH_EXT;
	 testfile.setName(openfile);
	 if(testfile.exists()==FALSE){
	    chdir(cnf.root_dir+cnf.data_dir);
	    openfile=cnf.root_dir+cnf.data_dir+argv[1];
	    testfile.setName(openfile);
	    if(testfile.exists()==FALSE){
	       openfile+=GRAPH_EXT;
	       testfile.setName(openfile);
	       if(testfile.exists()==FALSE){
		  openfile=argv[1];
	       }
	    }
	 }
      }
      gw->load(openfile);
   }
   else chdir(cnf.root_dir+cnf.data_dir);

   ret=a.exec();
   return ret; 
}

