/***************************************************************************
                          banzpar.cpp  -  description
                             -------------------
    begin                : Sun Jan 2 2000
    copyright            : (C) 2000 by Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// application specific includes

#include "banzpar.h"
#include <qstring.h>
#include <qpushbt.h>
#include <ktabctl.h>


#include "bhebinp.h"
#include "bibview.h"
#include "resource.h"

BAnzPar::BAnzPar(QWidget *parent, const char *name ) : QWidget(parent,name) {

  	extern BitanaApp *bitana;
		QFont hebfont(bitana->getHebFont1());

	// Gruppe Ausschnitt
  QButtonGroup* aus;
  aus = new QButtonGroup( this, "aus" );
  aus->setGeometry( 0, 5, 200, 65 );
  aus->setFrameStyle( 49 );
//  aus->setTitle( "Ausschnitt" );

  waus = new QCheckBox(i18n("Textcutout"), this, "wdar");
  waus->setGeometry(10, 10, 180, 30);
	
 	QLabel *bb = new QLabel(this);
  bb->setText(i18n("Linelength:"));
  bb->setGeometry(10, 40, 80, 20);

  ab = new QSpinBox(1, 1000, 1, this, "ab");
  ab->setGeometry( 100, 40, 70, 20);
  ab->setValue(70);

 // Gruppe Darstellung
  QButtonGroup* dar;
  dar = new QButtonGroup( this, "dar" );
  dar->setGeometry( 210, 5, 120, 65 );
  dar->setFrameStyle( 49 );
//  dar->setTitle( "Darstellung" );

	wdar = new QCheckBox(i18n("Textshowing"), this, "wdar");
  wdar->setGeometry(220, 10, 100, 30);


	// Gruppe Abbildung
  QButtonGroup* abb;
  abb = new QButtonGroup( this, "abb" );
  abb->setGeometry( 0, 80, 330, 150 );
  abb->setFrameStyle( 49 );
//  abb->setTitle( "Abbildung" );

	wabb = new QCheckBox(i18n("Textimage"), this, "wabb");
  wabb->setGeometry(10, 85, 100, 30);

 	wana = new QCheckBox(i18n("with wordanalysis"), this, "wana");
  wana->setGeometry(160, 85, 150, 30);

  QPushButton *but;
	
	but  = new QPushButton(this, "w");
	but->setGeometry( 10, 125, 40, 30 );
	but->setText( "W>" );
	abb->insert(but);
	
  abbwort = new QLabel(this, "l1");
  abbwort->setGeometry( 55, 125, 200, 30 );
	abbwort->setFont( hebfont );
	abbwort->setFrameStyle( 49 );
	abbwort->setText("");

 	connect(abb, SIGNAL(clicked(int)), this, SLOT(slotPressW(int)));

 	QLabel *l2 = new QLabel(this);
  l2->setText(i18n("Startposition:"));
  l2->setGeometry(10, 160, 90, 30);

  wbeg = new QSpinBox(1, 500000, 1, this, "wbeg");
  wbeg->setGeometry(100, 165, 70, 20);
  wbeg->setValue(100);


 	QLabel *l3 = new QLabel(this);
  l3->setText(i18n("ELS Sequense:"));
  l3->setGeometry(10, 195, 90, 30);

  ww = new QSpinBox(1, 1000, 1, this, "ww");
  ww->setGeometry(100, 200, 70, 20);
  ww->setValue(1);


}


/** Wort Button gedrckt */
void BAnzPar::slotPressW(int x){

  KTabCtl* tab = (KTabCtl*)parentWidget();
	BibView* v   = (BibView*)tab->parentWidget();
	BHebInp* i = v->inp;
	abbwort->setText( (i->readInput()).rightJustify(16, ' '));

}



BAnzPar::~BAnzPar(){
}

// Parameter Aus- Eingaben

int BAnzPar::liesAusBr() {
  QString tmp;
	tmp = ab->text();
	return (tmp.toInt());
}

QString BAnzPar::liesAbbWort() {

	QString t;
	t = abbwort->text();
	return( t.stripWhiteSpace());	
}

int BAnzPar::liesAbbBeg() {
  QString t;
	t = wbeg->text();
	return (t.toInt());
}

int BAnzPar::liesAbbIntWeite() {
  QString t;
	t = ww->text();
	return (t.toInt());
}

void BAnzPar::setAusBr(int br) {
	ab->setValue(br);
}

void BAnzPar::setAbbWort(QString wo) {
	abbwort->setText(wo.rightJustify(16, ' '));
}

void BAnzPar::setAbbBeg(int beg) {
	wbeg->setValue(beg);
}

void BAnzPar::setAbbIntWeite(int iw) {
	ww->setValue(iw);
}

bool BAnzPar::liesAus() {
	return( waus->isChecked());
}

bool BAnzPar::liesDar(){
	return( wdar->isChecked());
}

bool BAnzPar::liesAbb(){
	return(wabb->isChecked());
}

bool BAnzPar::liesWordAna(){
	return(wana->isChecked());
}

void BAnzPar::setAus(bool but){
	waus->setChecked(but);
}

void BAnzPar::setDar(bool but){
	wdar->setChecked(but);
}

void BAnzPar::setAbb(bool but){
	wabb->setChecked(but);
}

void BAnzPar::setWordAna(bool but){
	wana->setChecked(but);
}
















