/***************************************************************************
                          bhebbuch.cpp  -  description
                             -------------------
    begin                : Tue Nov 30 1999
    copyright            : (C) 1999 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <qprogressbar.h>
#include <qobject.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qfile.h>

#include "bhebbuch.h"
#include "bhebidx.h"
#include "bitana.h"

#include "iostream.h"

BHebBuch::BHebBuch()
{
 _name=" ";
}

BHebBuch::~BHebBuch()
{

  extern BitanaApp *bitana;
  disconnect(bitana, SIGNAL(signalStop()), this, SLOT(slotStop()));

 delete _daten;
 _f1.close();
}

bool BHebBuch::lesText(QString buch, int pos, int lng)
{
 text="";
 bool ok=_openBuch(buch);
 if(!ok) return FALSE;
 if((uint)(pos+lng)>_f1.size())
 {
  int k=(uint)pos+lng-_f1.size();
  if((lng-k)<0)
  {
   QMessageBox::warning(0,i18n("Error"),
                          i18n("Datasection to long\n or beginposition to large"));
   return FALSE;
  }
  else
  {
   switch (QMessageBox::information(0,i18n("Warning"),
                          i18n("Datasection to long\nsetting to bookend???"),
                          i18n("&Yes"),i18n("&No/Cancel"), 0, 1))
   {
    case 0:
      lng=lng-k;
      break;
    case 1: return FALSE;
   }
  }
 }
 for(int i=pos;i<pos+lng-1;i++) text+=_daten[i];
 return TRUE;
}

bool BHebBuch::lesTextRevers(QString buch, int pos, int lng)
{
 text="";
 bool ok=_openBuch(buch);
 if(!ok) return FALSE;
 if((uint)(pos+lng)>_f1.size())
 {
  int k=(uint)pos+lng-_f1.size();
  if((lng-k)<0)
  {
   QMessageBox::warning(0,i18n("Error"),
                          i18n("Datasection to long\n Beginposition to large"));
   return FALSE;
  }
  else
  {
   switch (QMessageBox::information(0,i18n("Warning"),
                          i18n("Datasection to long\nsetting of bookend???"),
                          i18n("&Yes"),i18n("&No/Cancel"), 0, 1))
   {
    case 0:
      lng=lng-k;
      break;
    case 1: return FALSE;
   }
  }
 }
 for(int i=pos+lng-1;i>=pos;i--) text+=_daten[i];
 return TRUE;
}

uchar BHebBuch::lesBuchst(QString buch, int pos)
{
 bool ok=_openBuch(buch);
 if(!ok) return (0);
 return (_daten[pos]);
}

uint BHebBuch::lngBuch(QString buch)
{
 bool ok=_openBuch(buch);
 if(ok) return _f1.size();
 else return 0;
}

bool BHebBuch::modifiText(QString buch)
{
 bool ok=_openBuch(buch);
 if(ok)
 {
  uint lng=_f1.size();
  for(uint i=0;i<lng;i++)
  {
   if(_daten[i]==-22) _daten[i]++;
   if(_daten[i]==-19) _daten[i]++;
   if(_daten[i]==-17) _daten[i]++;
   if(_daten[i]==-13) _daten[i]++;
   if(_daten[i]==-11) _daten[i]++;
  }
  return TRUE;
 }
 return FALSE;
}

void BHebBuch::modifiWort(QString wort)
{
 int lng=wort.length();
 for(int i=0;i<lng;i++)
 {
  if(wort[i]==-22) wort[i]++;
  if(wort[i]==-19) wort[i]++;
  if(wort[i]==-17) wort[i]++;
  if(wort[i]==-13) wort[i]++;
  if(wort[i]==-11) wort[i]++;
 }
}

QString BHebBuch::textUmkehr(QString text)
{
 QString t="";
 if((uint)text.length()>0) for(uint i=text.length();i>0;i--) t+=text.at(i-1);
 return t;
}

float BHebBuch::intervallErwart(QString buch, QString wort,
                                int bpos, int epos,
                                int bint, int eint, int rich)
{
 uint  i;
 int   j;
 uchar bu;

 bool ok=_openBuch(buch);
 if(ok)
 {
  uint wlng=wort.length();
  uint sulng=epos-bpos+1;
  _zaehlBuchst(bpos, epos);
  j=sulng/(wlng-1);
  if(j<eint) eint=j;
  float wert=1.0;
  for(i=0;i<wlng;i++)
  {
   bu=wort.at(i);
   if(_anz[bu-224]<=0) return 0.0;      // Zero letters
   if(bu>223 && bu<251) wert=wert*(float(_anz[bu-224])/sulng);
  }
  float erg=0.0;
  for(int j=bint;j<=eint;j++) erg=erg+(sulng-((wlng-1)*j));

  if(rich==0) erg=erg*2;               // while forward and backward ELS
  erg=erg*wert;
  return erg;
 }
 return 0.0;
}

int BHebBuch::listeIntervall(QString buch, QString wort,
                             int bpos, int epos,
                             int bint, int eint,
                             int richt,
                             QString name)
{

extern BitanaApp *bitana;
 _stop = false;
 connect(bitana, SIGNAL(signalStop()), this, SLOT(slotStop()));

 QFile a1;
 QDir d=QDir::root();
 if (d.cd(bitana->getTmpDir())) a1.setName(d.filePath(name));
 else
 {
  QMessageBox::warning(0,i18n("Cannot find working directory"),
                         bitana->getTmpDir());
  return -1;
 }
 if (!a1.open(IO_WriteOnly))
 {
   QMessageBox::warning(0,i18n("Cannot create the file"),
                          i18n("Tempfile dat.zwd"));
  return -1;
 }

 bool ok=_openBuch(buch);
 if(ok)
 {
  int wlng=wort.length();
  int sulng=1+epos-bpos;
  int aktpos=bpos;
  int endpos=epos-wlng;
  int lfdpos,lfd,lfdbu;
  int maxint,lfdiv,lfdir;
  int anz=0;
  struct STRAUS
  {
   int  apos;                          // Startposition ELS
   int  epos;                          // Endposition ELS
   int  inter;                         // Sequenz ELS
   int  richt;                         // Route (0=forward 1=backward)
  };

  union UNIAUS
  {
   STRAUS saus;
   char   caus[sizeof(STRAUS)];
  };

  UNIAUS aus;

  bitana->progressStart(epos-bpos, i18n("Searching  ELS ..."));

// Search ELS
  while(aktpos<=endpos)
  {
   if(_stop)
   {
    bitana->progressEnd();
    return -1;
   }
	 while(_daten[aktpos]!=wort.at(0) && aktpos<=endpos) aktpos++;
   if(richt<2)
   {

// Search forward
    maxint=(sulng-(aktpos-bpos))/(wlng-1);
    if(maxint>eint) maxint=eint;
    lfdpos=aktpos+bint;
    while(lfdpos<=endpos)
    {
     while(_daten[lfdpos]!=wort.at(1) && lfdpos<=endpos) lfdpos++;
     lfdiv=lfdpos-aktpos;
     if(lfdiv>maxint) break;
     if(lfdpos<=endpos && lfdiv<=maxint)
     {

      lfdbu=1;
      lfd=lfdpos;
      while(_daten[lfd]==wort.at(lfdbu) && lfd<=epos && lfdbu<wlng)
      {
       lfdbu++;
       if(lfdbu==wlng)
       {
        aus.saus.apos=aktpos;
        aus.saus.epos=lfd;
        aus.saus.inter=lfdiv;
        aus.saus.richt=0;
        a1.writeBlock(aus.caus,(uint)sizeof(STRAUS));
        anz++;
        break;
       }
       lfd+=lfdiv;
      }
     }
     lfdpos++;
    }
   }
   if(richt==0 || richt ==2)
   {

// Search backward
    maxint=(aktpos-bpos)/(wlng-1);
    if(maxint>eint) maxint=eint;
    lfdpos=aktpos-bint;
    while(lfdpos>=bpos)
    {
     while(_daten[lfdpos]!=wort.at(1) && lfdpos>bpos) lfdpos--;
     lfdir=aktpos-lfdpos;
     if(lfdir>maxint) break;
     if(lfdpos>bpos && lfdir<=maxint)
     {
      lfdbu=1;
      lfd=lfdpos;
      while(_daten[lfd]==wort.at(lfdbu) && lfd>=bpos && lfdbu<wlng)
      {
       lfdbu++;
       if(lfdbu==wlng)
       {
        aus.saus.apos=aktpos;
        aus.saus.epos=lfd;
        aus.saus.inter=lfdir;
        aus.saus.richt=1;
        a1.writeBlock(aus.caus,(uint)sizeof(STRAUS));
        anz++;
        break;
       }
       lfd-=lfdir;
      }
     }
     lfdpos--;
    }
   }
   aktpos++;
   if(_stop)
   {
    bitana->progressEnd();
    return -1;
   }
   bitana->progressStep(aktpos-bpos);
  }
  bitana->progressEnd();
  a1.close();
  return anz;
 }
 return -1;
}

bool BHebBuch::_openBuch(QString buch)
{
 extern BitanaApp *bitana;
 int l=0;
 QString verz;

 if(strcmp(_name,buch))
 {
  if(_f1.isOpen())
  {
   delete _daten;
   _f1.close();
  }
  _name=" ";

  verz=bitana->getBookDir();
/*
  do
  {
   verz=verz.left(verz.length()-1);
  } while(verz.at(verz.length()-1)!='/');
  verz.append("he/");
*/
  QDir d=QDir::root();
  if (d.cd(verz))
  {
   _f1.setName( d.filePath(buch+".cod"));
   if (_f1.open(IO_ReadOnly))
   {
    _daten=new char[_f1.size()];
    l=_f1.readBlock(_daten,_f1.size());
   }
   else
   {
    QMessageBox::warning(0,i18n("Cannot find the file"),
                               _f1.name());
    return false;
   }
   if(l<=0)
   {
    QMessageBox::warning(0,i18n("(3) File is corrupt"),
                          _f1.name());
    return false;
   }
  }
  else
  {
   QMessageBox::warning(0,i18n("Cannot find the book directory"),
                         verz);
   return false;
  }
  _name=buch;
 }
 return true;
}

int BHebBuch::_findBuchst(char bu, uint pos)
{
 while(_daten[pos]!=bu && pos<_f1.size()) pos++;
 if(pos<_f1.size()) return pos;
 else return -1;
}

void BHebBuch::_zaehlBuchst(int bpos, int epos)
{
 uchar bu;

 for(int i=0;i<28;i++) _anz[i]=0;
 int akt=bpos;
 while(akt<=epos)
 {
  bu=_daten[akt];
  _anz[bu-224]++;
  akt++;
 }

 return;
}

void BHebBuch::slotStop()
{
  _stop = true;
}



















































