/***************************************************************************
                          bhebbuch.h  -  description
                             -------------------
    begin                : Tue Nov 30 1999
    copyright            : (C) 1999 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef BHEBBUCH_H
#define BHEBBUCH_H

/**
  *@author Heinz Schumann

 The class off BHebBuch make all methods with the code-file off hebrew book,
 is run as children process. The class working intern. By the method
 "listeIntervall" use the class the progressbar off the mainwindow. This
 class use the files by extension "*.cod" and load the code in main memory.
 For comunication with the ovner-prozess is the public-string 'text'
 connected. The method "listeIntervall" make an file with name off default
 parameter.
*/

#include <qobject.h>
#include <qfile.h>

class BHebBuch : public QObject
{
 Q_OBJECT

 public:

/**
 The datastructure of text for hebr.bibletext to communication with the
 ovner prozess
*/
  QString text;

	BHebBuch();
	~BHebBuch();

/**
 This method 'lesText" read the text in the hebrew book with begining and
 length by parameter. The text is standby in public field 'text'.
 Parameters the methode is:
 1. Name of biblebook
 2. Startposition
 3. Length of text
*/
 bool lesText(QString, int, int);

/**
 This method 'lesTextRevers" read the text in the book with begining and
 length by parameter. The text is of hebrew style of writing
 (of rigth to left) with no blank letter. The text is standby in public
 field 'text'.
 Parameters the methode is:
 1. Name of biblebook
 2. Startposition
 3. Length of text
*/
  bool lesTextRevers(QString, int, int);

/**
 This method 'lesBuchst' read out in the book the letter of position
 by parameter and given standby with return.
 Parameters the methode is:
 1. Name of biblebook
 2. Position
*/
  uchar lesBuchst(QString, int);

/**
 This method 'lngBuch' standby the length on byte off the biblebook.
 Parameter's:
 1. Name of biblebook
*/
  uint  lngBuch(QString);

/**
 This method 'intervallErwart' calculate the statistic pending off the
 default parameters.

 @see Algorithm of statisitc pending (Handbook)

 Return is the result of calculate anderwise zero.

 Parameters the methode is:
 1. Name of biblebook
 2. Hebrew word
 3. Startposition data area
 4. Endposition data area
 5. Begining seqenz of ELS
 6. End seqenz of ELS
 7. ELS-Route (0=double-sided, 1=forward, 2=backward)
*/
  float intervallErwart(QString, QString, int, int, int, int, int);

/**
 This method 'listeIntervall' serch all ELS in the text of the default
 parameter. The result given output as file with name of parameter. The
 sumary all ELS given standby with return.

 Parameters the methode is:
 1. Name of biblebook
 2. Hebrew word
 3. Startposition data area
 4. Endposition data area
 5. Begining seqenz of ELS
 6. End seqenz of ELS
 7. ELS-Route (0=double-sided, 1=forward, 2=backward)
 8. Name off output-file
*/
  int listeIntervall(QString, QString, int, int, int, int, int, QString);

/**
 This method 'modifiText' recast all end-letter's in standart-letter's off
 the biblebook. Return is TRUE by successful anderwise FALSE.
 Parameters the methode is:
 1. Name of biblebook
*/
  bool  modifiText(QString);

/**
 This method 'modifiWort' recast all end-letter's in standart-letter's off
 word in parameter.
 Parameters the methode is:
 1. Name of text-field
*/
  void  modifiWort(QString);

/**
 This method 'textUmkehr' write the text in style by hebrew and given
 standby by return.
 Parameters the methode is:
 1. Name of text-field
*/
  QString textUmkehr(QString);

 public slots:

 void slotStop();

 private:

  bool _openBuch(QString);
  int _findBuchst(char, uint);
  void _zaehlBuchst(int, int);

/**
 Working variable
*/
  QString _name;                        // File name of biblebook
  int _anz[28];                         // Datastructure for sumary letters
  QFile _f1;                            // File off biblebook
  char *_daten;                         // Pointer of hebrew bibletext
  bool _stop;                           // Market stop
};

#endif

































































