/***************************************************************************
                          bibdoc.cpp  -  description
                             -------------------
    begin                : Mit Dez 29 13:12:29 MET 1999
    copyright            : (C) 1999 by Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>

// include files for KDE
#include <kapp.h>
#include <kmsgbox.h>

// application specific includes
#include "bibdoc.h"
//#include "bitana.h"
#include "bibview.h"
#include "bibtext.h"

QList<BibView>* BibDoc::viewList = 0L;

BibDoc::BibDoc(QWidget *parent, const char* name):QObject(parent, name)
{
	if( !viewList )
		viewList = new QList<BibView>;
	viewList->setAutoDelete(true);
}

BibDoc::~BibDoc()
{
}


BibView* BibDoc::getView() const
{
	BitanaApp* theApp=(BitanaApp*)parent();
	return theApp->getView();
}


const QString& BibDoc::getPathName() const
{
	return m_path;
}

/*
void BibDoc::slotUpdateAllViews(BibView* pSender)
{
	BibView* w;
	if(viewList)
	{
		for( w = viewList->first(); w; w = viewList->next() )
		{ if( w != pSender)
				w->repaint();
		}
	}

}
*/

void BibDoc::pathName( const char* path_name)
{
	m_path=path_name;
}
void BibDoc::title( const char* title)
{
	m_title=title;
}

const QString& BibDoc::getTitle() const
{
	return m_title;
}

bool BibDoc::saveModified()
{

//	if(m_title != "Untitled")
  if(b_modified)
	{
		BitanaApp* win=(BitanaApp*) parent();
  	int want_save = KMsgBox::yesNoCancel(win,
  									i18n("Warning"),	i18n("Do you want to save\nthe actual search parameters?"));
   	switch(want_save)
    {
    	case 1:
    		if(m_title == "Untitled")
   				win->slotFileSaveAs();
    		else
	     		saveDocument(getPathName()+getTitle());
        return true;
        break;
  		case 2:
    		setModified(false);
  			return true;
  			break;	
  		case 3:
  			return false;
  			break;
  		default:
  			return false;
  			break;
  	}
	}
	else
		return true;

}

void BibDoc::closeDocument()
{
	deleteContents();
}

bool BibDoc::newDocument()
{
	
	/////////////////////////////////////////////////
	// TODO: Add your document initialization code here
	/////////////////////////////////////////////////

	m_path=QDir::homeDirPath() + "/";
	m_title="Untitled";

	view = getView();
// Anzeige
	view->setAusBr(50);
  view->setAbbWort("");
  view->setAbbBeg(1);
  view->setAbbIntWeite(1);

	view->setAnzAus(false);
	view->setAnzAbb(false);
	view->setAnzDar(true);
	view->setAnzWordAna(false);
	
// Intervall
	view->setIntWort("");
  view->setAnalyse(false);
  view->setRichtung(1);
  view->setSortierung(true);
  view->setIntwVon(1);
  view->setIntwBis(100);

// Nachbar Words;
	view->setNbrWort(0, "");
  view->setNbrWort(1, "");
  view->setNbrWort(2, "");
  view->setNbrWort(3, "");
  view->setNbrWort(4, "");

// Booktext
/*
	if (config->hasKey("Directory"))		// Examles without directory
		win->bibtext->setBuchDir(config->readEntry("Directory", win->getBookDir()));
	win->bibtext->setBuchName(config->readEntry("Book"));
	win->bibtext->setKapVersVon(config->readEntry("CapVers-from"));
	win->bibtext->setKapVersBis(config->readEntry("CapVers-to"));
	win->bibtext->setPosVon(config->readNumEntry("Pos-from"));
	win->bibtext->setPosBis(config->readNumEntry("Pos-to"));
*/
  view->selectTab(0);
 	b_modified=true;
	return true;
}

bool BibDoc::openDocument(const char* filename, const char* format)
{
	QFileInfo fileInfo(filename);
	m_title=fileInfo.fileName();
	m_path=fileInfo.dirPath(true) + "/";  	// absolute	dir

  BitanaApp* win=(BitanaApp*) parent();
  view = getView();
  config = new KSimpleConfig(filename, true);

 	config->setGroup("Anzeige");
	view->setAusBr(config->readNumEntry("AusBreite"));
  view->setAbbWort(config->readEntry("AbbWord"));
  view->setAbbBeg(config->readNumEntry("AbbBegin"));
  view->setAbbIntWeite(config->readNumEntry("AbbIntWeite"));

	view->setAnzAus(config->readBoolEntry("Ausschnitt",true));
	view->setAnzAbb(config->readBoolEntry("Abbildung", true));
	view->setAnzDar(config->readBoolEntry("Darstellung",true));
	view->setAnzWordAna(config->readBoolEntry("Wordanalyse", false));
	
	config->setGroup("Intervall");
	view->setIntWort(config->readEntry("Intervallwort"));
  view->setAnalyse(config->readBoolEntry("Analyse", false));
  view->setRichtung(config->readNumEntry("Richtung"));
  view->setSortierung(config->readBoolEntry("SortPos"));
  view->setIntwVon(config->readNumEntry("IntVon"));
//  view->inv->setIntwVon(config->readNumEntry("IntVon"));
// inv->setIntwBis(wb);

 view->setIntwBis(config->readNumEntry("IntBis"));

	config->setGroup("Nachbar Words");
	view->setNbrWort(0, config->readEntry("Word1"));
  view->setNbrWort(1, config->readEntry("Word2"));
  view->setNbrWort(2, config->readEntry("Word3"));
  view->setNbrWort(3, config->readEntry("Word4"));
  view->setNbrWort(4, config->readEntry("Word5"));

  config->setGroup("Booktext");
	if (config->hasKey("Directory"))		// Examles without directory
		win->bibtext->setBuchDir(config->readEntry("Directory", win->getBookDir()));
	win->bibtext->setBuchName(config->readEntry("Book"));
	win->bibtext->setKapVersVon(config->readEntry("CapVers-from"));
	win->bibtext->setKapVersBis(config->readEntry("CapVers-to"));
	win->bibtext->setPosVon(config->readNumEntry("Pos-from"));
	win->bibtext->setPosBis(config->readNumEntry("Pos-to"));
  view->selectTab(config->readNumEntry("TabId"));
 	b_modified=true;
	return true;
}

bool BibDoc::saveDocument(const char* filename, const char* format)
{
	
  view = getView();
  BitanaApp* win=(BitanaApp*) parent();

  if(m_title == "Untitled") {
		win->slotFileSaveAs();
    return(true);
	}

  config = new KSimpleConfig(filename);
 	config->setGroup("Anzeige");
	config->writeEntry("AusBreite", view->lesAusBr());
  config->writeEntry("AbbWord", view->lesAbbWort());
  config->writeEntry("AbbBegin", view->lesAbbBeg());
  config->writeEntry("AbbIntWeite", view->lesAbbIntWeite());

	config->writeEntry("Ausschnitt", view->lesAnzAus());
	config->writeEntry("Abbildung", view->lesAnzAbb());
	config->writeEntry("Darstellung", view->lesAnzDar());
	config->writeEntry("Wordanalyse", view->lesAnzWordAna());
	
  config->setGroup("Intervall");
	config->writeEntry("Intervallwort", view->lesIntWort());
  config->writeEntry("Analyse", view->lesAnalyse());
  config->writeEntry("Richtung", view->lesRichtung());
  config->writeEntry("SortPos", view->lesSortierung());
  config->writeEntry("IntVon", view->lesIntwVon());
  config->writeEntry("IntBis", view->lesIntwBis());

	config->setGroup("Nachbar Words");
	config->writeEntry("Word1", (view->lesNbrWorte())[0]);
	config->writeEntry("Word2", (view->lesNbrWorte())[1]);
  config->writeEntry("Word3", (view->lesNbrWorte())[2]);
  config->writeEntry("Word4", (view->lesNbrWorte())[3]);
	config->writeEntry("Word5", (view->lesNbrWorte())[4]);


	config->setGroup("Booktext");
	config->writeEntry("Directory",win->bibtext->lesBuchDir());
	config->writeEntry("Book",win->bibtext->lesBuchName());
	config->writeEntry("CapVers-from",win->bibtext->lesKapVersVon());
	config->writeEntry("CapVers-to",win->bibtext->lesKapVersBis());
	config->writeEntry("Pos-from", win->bibtext->lesVonPos());
	config->writeEntry("Pos-to",win->bibtext->lesBisPos());
  config->writeEntry("TabId", view->tabSelected());

  config->sync();
	delete config;
	b_modified=false;
	return true;
}

void BibDoc::deleteContents()
{
  view = getView();
  BitanaApp* win=(BitanaApp*) parent();

// Anzeige
	view->setAusBr(49);
  view->setAbbWort("");
  view->setAbbBeg(0);
  view->setAbbIntWeite(0);

	view->setAnzAus(false);
	view->setAnzAbb(false);
	view->setAnzDar(false);
	view->setAnzWordAna(false);
	
// Intervall;
	view->setIntWort("");
  view->setAnalyse(false);
  view->setRichtung(1);
  view->setSortierung(true);
  view->setIntwVon(1);
  view->setIntwBis(100);

// Nachbar Words;
	view->setNbrWort(0, "");
  view->setNbrWort(1, "");
  view->setNbrWort(2, "");
  view->setNbrWort(3, "");
  view->setNbrWort(4, "");

// Booktext;
	win->bibtext->setBuchName("");
	
}










































