/***************************************************************************
                          bitana.cpp  -  the main widgets and initialisation
                             -------------------
    begin                : Mit Dez 29 13:12:29 MET 1999
    copyright            : (C) 1999 by  Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qapplication.h>
#include <qdir.h>
#include <qstrlist.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qfiledialog.h>

// include files for KDE
#include <klocale.h>
#include <kiconloader.h>
#include <kiconloader.h>
#include <kmsgbox.h>
#include <kcombo.h>

// application specific includes
#include "bitana.h"
#include "bibtext.h"
#include "bibview.h"
#include "bibdoc.h"
#include "btextdarst.h"
#include "btextabbild.h"
#include "btxtausschn.h"
#include "bnachbar.h"
#include "banalyse.h"
#include "bintervall.h"
#include "resource.h"

//#include "iostream.h"
//#include <kfontdialog.h>

BitanaApp::BitanaApp() {
}

/** The initialisation is moved in this method because the extern pointer to bitana is avalible
after creating the objekt  and something methods for initialisation use it.  */
void BitanaApp::initBitana(){

	
	// Spachversion feststellen
	KLocale *locale = new KLocale();
	locale = kapp->getLocale();
  lang =  locale->languages().left(locale->languages().find(':'));

  exampdir =  kapp->kde_datadir() + "/bitana/examples/";

 	config=kapp->getConfig();
	config->setGroup("General Options");

// Font initialisation
// How can I install a font into the X-Server with QT ??
// programmer wantet ;-)

  QString s;
	int i = 1;

	if (config->hasKey("HebFont1")) {
		hfont1 = config->readFontEntry("HebFont1");
  }
 	else {
		while (config->hasKey("HebXFont1." + s.setNum(i))) {
			QFont f1(config->readEntry("HebXFont1." + s.setNum(i)));
			f1.setRawMode( TRUE );
  		if ( f1.exactMatch() ) {
				i = 999;
				hfont1 = f1;
				break;
			}
			i++;
		}
		if (i < 999) {
	    QString t;
      t = i18n("Can't find hebrew Font1 in the X - Server!\nplease install a iso8859-8 Font");
			QMessageBox::warning(0, i18n("Error"), t);
			close();
		}
	}

	i = 1;
	if (config->hasKey("HebFont2")) {
		hfont2 = config->readFontEntry("HebFont2");
  }
 	else {
		while (config->hasKey("HebXFont2." + s.setNum(i))) {
			QFont f2(config->readEntry("HebXFont2." + s.setNum(i)));
			f2.setRawMode( TRUE );
  		if ( f2.exactMatch() ) {
				hfont2 = f2; 	
    		i = 999;
				break;
			}
			i++;
		}
		if (i < 999) {
 			QString t;
      t = i18n("Can't find hebrew Font2 in the X - Server!\nplease install a iso8859-8 Font");
			QMessageBox::warning(0, i18n("Error"), t);
			close();
		}
	}


  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initStatusBar();
  initMenuBar();
  initToolBar();
	initBookBar();
  initKeyAccel();
  initDocument();
	initView();
  readOptions();
  view->markFileItem("");
	initExampleFiles("");
	show();
	view->selectTab(tabid);


///////////////////////////////////////////////////////////////////
//  disable menu and toolbar items at startup
//  disableCommand(ID_FILE_SAVE);
//  disableCommand(ID_FILE_SAVE_AS);

  disableCommand(ID_FILE_PRINT);
	disableCommand(ID_STOP);
	slotStatusMsg(i18n("Ready."));
}

BitanaApp::~BitanaApp()
{

}

void BitanaApp::initKeyAccel()
{
	key_accel = new KAccel( this );
	
	// file_menu accelerators
	key_accel->connectItem( KAccel::New, this, SLOT( slotFileNew() ) );
	key_accel->connectItem( KAccel::Open, this, SLOT( slotFileOpen() ) );
	key_accel->connectItem( KAccel::Save, this, SLOT( slotFileSave() ) );
	key_accel->connectItem( KAccel::Close, this, SLOT( slotFileClose() ) );
	key_accel->connectItem( KAccel::Print, this, SLOT( slotFilePrint() ) );
	key_accel->connectItem( KAccel::Quit, this, SLOT( slotFileQuit() ) );
	key_accel->connectItem( KAccel::Help, kapp, SLOT( appHelpActivated() ) );
			
	key_accel->changeMenuAccel(	file_menu, ID_FILE_NEW, KAccel::New );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_OPEN, KAccel::Open );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_SAVE, KAccel::Save );
	key_accel->changeMenuAccel( file_menu, ID_FILE_CLOSE, KAccel::Close );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_PRINT, KAccel::Print );
	key_accel->changeMenuAccel(	file_menu, ID_FILE_QUIT, KAccel::Quit );

  key_accel->readSettings();	
}

void BitanaApp::initMenuBar()
{

  ///////////////////////////////////////////////////////////////////
  // MENUBAR

  recent_files_menu = new QPopupMenu();
  connect( recent_files_menu, SIGNAL(activated(int)), SLOT(slotFileOpenRecent(int)) );

  example_files_menu = new QPopupMenu();
  connect( example_files_menu, SIGNAL(activated(int)), SLOT(slotFileOpenExample(int)) );
  ///////////////////////////////////////////////////////////////////
  // menuBar entry file_menu
  file_menu = new QPopupMenu();
  file_menu->insertSeparator();

//  file_menu->insertItem(Icon("filenew.xpm"), i18n("&New"), ID_FILE_NEW );
  file_menu->insertItem(Icon("fileopen.xpm"), i18n("&Open..."), ID_FILE_OPEN );
	file_menu->insertItem(i18n("Open &example"), example_files_menu, ID_FILE_OPEN_EXAMPLE);
  file_menu->insertItem(i18n("Open &recent"), recent_files_menu, ID_FILE_OPEN_RECENT );

 // file_menu->insertItem(i18n("&Close"), ID_FILE_CLOSE );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("filefloppy.xpm") ,i18n("&Save"), ID_FILE_SAVE );
  file_menu->insertItem(i18n("Save &As..."), ID_FILE_SAVE_AS );
  file_menu->insertSeparator();
  file_menu->insertItem(Icon("fileprint.xpm"), i18n("&Print..."), ID_FILE_PRINT );
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"), ID_FILE_QUIT );
	
  ///////////////////////////////////////////////////////////////////
  // menuBar entry book_menu
  book_menu = new QPopupMenu();
  book_menu->insertItem(Icon(""), i18n("Dir"), ID_BOOK_DIR );
  book_menu->insertSeparator();
	book_menu->insertItem(Icon("editcopy.xpm"), i18n("Pos2Chap"), ID_BOOK_P2K );
  book_menu->insertItem(Icon("editcopy.xpm"), i18n("Chap2Pos"), ID_BOOK_K2P );



  ///////////////////////////////////////////////////////////////////
  // menuBar entry view_menu
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);
  view_menu->insertItem(i18n("&Toolbar"), ID_VIEW_TOOLBAR);
	view_menu->insertItem(i18n("&Bookbar"), ID_VIEW_BOOKBAR);
  view_menu->insertItem(i18n("&Statusbar"), ID_VIEW_STATUSBAR );
	view_menu->insertSeparator();
  view_menu->insertItem(i18n("&Inputwindow"), ID_VIEW_INPUTS);

 ///////////////////////////////////////////////////////////////////
  // menuBar entry search_menu
  search_menu = new QPopupMenu();
  search_menu->insertItem(i18n("Textshowing"), ID_SEARCH_TDAR);
	search_menu->insertItem(i18n("Textimage"), ID_SEARCH_TABB);
  search_menu->insertItem(i18n("Textcutout"), ID_SEARCH_TAUS );
	search_menu->insertSeparator();
	search_menu->insertItem(i18n("Interval"), ID_SEARCH_INT);
	search_menu->insertItem(i18n("Analysis"), ID_SEARCH_ANA);
	search_menu->insertSeparator();
  search_menu->insertItem(i18n("Neighbour"), ID_SEARCH_NBR);

  ///////////////////////////////////////////////////////////////////
  // menuBar entry help_menu
  QString aboutstring=kapp->appName()+" "+VERSION+
		i18n("\nBitana - Bible text analysis\n\n\
Heinz Schumann, Hans-Jrgen Schumann\n <info@bitana.de>\n\n<http://www.bitana.de>");

  help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, aboutstring );

  ///////////////////////////////////////////////////////////////////
  // MENUBAR CONFIGURATION
  // insert your popup menus with the according menubar entries in the order
  // they will appear later from left to right
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertItem(i18n("&Book"), book_menu);
  menuBar()->insertItem(i18n("&View"), view_menu);
	menuBar()->insertItem(i18n("&Search"), search_menu);

  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

  ///////////////////////////////////////////////////////////////////
  // CONNECT THE MENU SLOTS WITH SIGNALS
  // for execution slots and statusbar messages

  connect(file_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(file_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

//  connect(edit_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
//  connect(edit_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(book_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(book_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

  connect(view_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(view_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

 	connect(search_menu,SIGNAL(activated(int)),SLOT(commandCallback(int)));
  connect(search_menu,SIGNAL(highlighted(int)),SLOT(statusCallback(int)));

}

void BitanaApp::initToolBar()
{

  ///////////////////////////////////////////////////////////////////
  // TOOLBAR
  toolBar()->insertButton(Icon("filenew.xpm"), ID_FILE_NEW, true, i18n("New parameter file") );
  toolBar()->insertButton(Icon("fileopen.xpm"), ID_FILE_OPEN, true, i18n("Open parameter file") );
  toolBar()->insertButton(Icon("filefloppy.xpm"), ID_FILE_SAVE, true, i18n("Save parameter file") );
  toolBar()->insertButton(Icon("fileprint.xpm"), ID_FILE_PRINT, true, i18n("Print") );
  toolBar()->insertSeparator();
  toolBar()->insertButton(ICON("file_properties.xpm"), ID_VIEW_INPUTS, true, i18n("View Inputs") );
  toolBar()->setButton(ID_VIEW_INPUTS, true);

	toolBar()->insertSeparator();
 	toolBar()->insertSeparator();

  toolBar()->insertButton(ICON("make.xpm"), ID_BOOK_SEARCH, true, i18n("go") );
  toolBar()->insertButton(ICON("dbgstop.xpm"), ID_STOP, SIGNAL(clicked()),
							this, SIGNAL(signalStop()), true, i18n("stop") );

  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("exit.xpm"), ID_FILE_QUIT, true, i18n("Exit") );

  toolBar()->insertButton(Icon("help.xpm"), ID_HELP_CONTENTS, SIGNAL(clicked() ),
  				kapp, SLOT( appHelpActivated() ), true,i18n("Help"));


  ///////////////////////////////////////////////////////////////////
  // CONNECT THE TOOLBAR SLOTS WITH SIGNALS - add new created toolbars by their according number
	// connect for invoking the slot actions
  connect(toolBar(), SIGNAL(clicked(int)), SLOT(commandCallback(int)));
	// connect for the status help on holing icons pressed with the mouse button
  connect(toolBar(), SIGNAL(pressed(int)), SLOT(statusCallback(int)));

}

void BitanaApp::initBookBar()
{

  ///////////////////////////////////////////////////////////////////
  // the second ToolBar (choice the book) = BookBar


	bibtext = new BibText(this);

	toolBar(ID_BOOK_BAR)->insertButton(Icon("openbook.xpm"), ID_BOOK_DIR,
		SIGNAL(clicked (int)), bibtext, SLOT(slotOpenBookDir(int)), true, i18n("open book dir") );

	toolBar(ID_BOOK_BAR)->insertCombo("", ID_BOOK_CHOICE, false,
			SIGNAL(activated(int)), this, SLOT(slotChoiceBook(int)), true,
			i18n("choice the book"), 100);

	toolBar(ID_BOOK_BAR)->insertSeparator();
 	toolBar(ID_BOOK_BAR)->insertSeparator();

	toolBar(ID_BOOK_BAR)->insertLined("01,01", ID_BOOK_KVON,
		SIGNAL( returnPressed()), bibtext, SLOT(slotReturnPressed()),  true, i18n("Chp,Vers-from"), 60);//, -1);
//    SIGNAL( textChanged ( const char * ) ), bibtext, SLOT(slotTextChanged ( const char * )),
 	
	toolBar(ID_BOOK_BAR)->insertButton(Icon("forward.xpm"), ID_BOOK_TO, false, i18n("to") );

	toolBar(ID_BOOK_BAR)->insertLined("10,99", ID_BOOK_KBIS,
		SIGNAL( returnPressed()), bibtext, SLOT(slotReturnPressed()),  true, i18n("Chap,Vers-to"), 60, -1);

		toolBar(ID_BOOK_BAR)->insertButton(Icon("undo.xpm"), ID_BOOK_P2K, true, i18n("Chap<-Pos") );
  	toolBar(ID_BOOK_BAR)->insertButton(Icon("redo.xpm"), ID_BOOK_K2P, true, i18n("Chap->Pos") );

	toolBar(ID_BOOK_BAR)->insertLined("0", ID_BOOK_PVON,
		SIGNAL( returnPressed()), bibtext, SLOT(slotReturnPressed()),  true, i18n("Pos-from"), 50, -1);

  toolBar(ID_BOOK_BAR)->insertButton(Icon("forward.xpm"), ID_BOOK_TO, false, i18n("to") );

	toolBar(ID_BOOK_BAR)->insertLined("200", ID_BOOK_PBIS,
		SIGNAL( returnPressed()), bibtext, SLOT(slotReturnPressed()),  true, i18n("Pos-to"), 50, -1);

 	bibtext->initBar(toolBar(ID_BOOK_BAR));

}



void BitanaApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
	// TODO: add your own items you need for displaying current application status.

	bitana_progress = new QProgressBar(statusBar());
  bitana_progress->hide();
	QString smsg = i18n("initialisation bitana.");
  statusBar()->insertItem(smsg.leftJustify(50), ID_STATUS_MSG );
	statusBar()->insertWidget(bitana_progress, 200, ID_STATUS_PROGRESS);
	statusBar()->insertItem(" ", ID_STATUS_PROTEXT);
  statusBar()->repaint();
	progress_run = false;
}

void BitanaApp::initDocument()
{
  doc = new BibDoc(this);
//  doc->newDocument();
}

void BitanaApp::initView()
{ 
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.

  view = new BibView(this);
  setView(view);
}

void BitanaApp::enableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // enable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,true);
  toolBar()->setItemEnabled(id_,true);
}

void BitanaApp::disableCommand(int id_)
{
  ///////////////////////////////////////////////////////////////////
  // disable menu and toolbar functions by their ID's
  menuBar()->setItemEnabled(id_,false);
  toolBar()->setItemEnabled(id_,false);
}

void BitanaApp::addRecentFile(const char* file)
{
  if(recent_files.find(file) == -1){
    if( recent_files.count() < 8)
      recent_files.insert(0,file);
    else{
      recent_files.remove(7);
      recent_files.insert(0,file);
    }
    recent_files_menu->clear();
    for ( int i =0 ; i < (int)recent_files.count(); i++){
      recent_files_menu->insertItem(recent_files.at(i));
    }
	}
}

void BitanaApp::initExampleFiles(const char* file)
{
	QDir ed;
	QFileInfo *ef;

	example_files.clear();
  example_files_menu->clear();

 	if (!ed.exists(exampdir))	return;	// Kein Verzeichnis mit Beispielen vorhanden
	 ed.setPath(exampdir);
  const QFileInfoList *list = ed.entryInfoList("*");
  QFileInfoListIterator it(*list);

  while ((ef = it.current()) != 0) {
		if ((ef->fileName()!= ".") && (ef->fileName()!= ".."))
			example_files.insert(0, ef->fileName());
    ++it;
	}		
  for ( int i =0 ; i < (int)example_files.count(); i++){
      example_files_menu->insertItem(example_files.at(i));
  }
}

void BitanaApp::openDocumentFile(const char* _cmdl)
{
  slotStatusMsg(i18n("Opening parameter file..."));
	doc->openDocument(_cmdl);
  slotStatusMsg(i18n("Ready."));
}


BibDoc* BitanaApp::getDocument() const
{
	return doc;
}

BibView* BitanaApp::getView() const
{
	return view;
}

QString BitanaApp::getInputLine() const
{
	return (view->inp)->readInput();
}

void BitanaApp::saveOptions()
{	
	config->setGroup("General Options");
	config->writeEntry("Geometry", size() );
  config->writeEntry("Show Toolbar", toolBar()->isVisible());
	config->writeEntry("Show Bookbar", toolBar(ID_BOOK_BAR)->isVisible());
  config->writeEntry("Show Statusbar",statusBar()->isVisible());
  config->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  config->writeEntry("ToolBarPos",  (int)toolBar()->barPos());
	config->writeEntry("Recent Files", recent_files);
	config->writeEntry("last Document", doc->getPathName()+doc->getTitle());

//	config->writeEntry("Book Dir", bookdir);
	config->writeEntry("TmpDir", tempdir);

//	config->writeEntry("HebFont 1", hebxfont1);
//	config->writeEntry("HebFont 2", hebxfont2);

	config->writeEntry("HebFont1", getHebFont1());
  config->writeEntry("HebFont2", getHebFont2());


	config->setGroup("Anzeige");
  config->writeEntry("AusBreite", view->lesAusBr());
  config->writeEntry("AbbWord", view->lesAbbWort());
  config->writeEntry("AbbBegin", view->lesAbbBeg());
  config->writeEntry("AbbIntWeite", view->lesAbbIntWeite());

  config->writeEntry("Ausschnitt", view->lesAnzAus());
  config->writeEntry("Abbildung", view->lesAnzAbb());
  config->writeEntry("Darstellung", view->lesAnzDar());
  config->writeEntry("Wordanalyse", view->lesAnzWordAna());

  config->setGroup("Intervall");
  config->writeEntry("Intervallwort", view->lesIntWort());
  config->writeEntry("Analyse", view->lesAnalyse());
  config->writeEntry("Richtung", view->lesRichtung());
  config->writeEntry("SortPos", view->lesSortierung());
  config->writeEntry("IntVon", view->lesIntwVon());
  config->writeEntry("IntBis", view->lesIntwBis());

  config->setGroup("Nachbar Words");
  config->writeEntry("Word1", (view->lesNbrWorte())[0]);
  config->writeEntry("Word2", (view->lesNbrWorte())[1]);
  config->writeEntry("Word3", (view->lesNbrWorte())[2]);
  config->writeEntry("Word4", (view->lesNbrWorte())[3]);
  config->writeEntry("Word5", (view->lesNbrWorte())[4]);

  config->setGroup("Booktext");
  config->writeEntry("Directory",bibtext->lesBuchDir() );
  config->writeEntry("Book",bibtext->lesBuchName() );
  config->writeEntry("CapVers-from", bibtext->lesKapVersVon());
  config->writeEntry("CapVers-to",bibtext->lesKapVersBis());
  config->writeEntry("Pos-from", bibtext->lesVonPos());
  config->writeEntry("Pos-to", bibtext->lesBisPos());
  config->writeEntry("TabId", view->tabSelected());

	config->setGroup("Input");
	config->writeEntry("Stack", *(view->lesInputStack()));

}


void BitanaApp::readOptions()
{
	
	config->setGroup("General Options");

	// bar status settings
	bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
	view_menu->setItemChecked(ID_VIEW_TOOLBAR, bViewToolbar);
	if(!bViewToolbar)
		enableToolBar(KToolBar::Hide);

	bool bViewBookbar = config->readBoolEntry("Show Bookbar", true);
	view_menu->setItemChecked(ID_VIEW_BOOKBAR, bViewBookbar);
	if(!bViewBookbar)
		enableToolBar(KToolBar::Hide, ID_BOOK_BAR);
		
  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
	view_menu->setItemChecked(ID_VIEW_STATUSBAR, bViewStatusbar);
	if(!bViewStatusbar)
		enableStatusBar(KStatusBar::Hide);
	
	bool bViewInput = config->readBoolEntry("Show Inputs", true);
	view_menu->setItemChecked(ID_VIEW_INPUTS, bViewInput);

	// bar position settings
	KMenuBar::menuPosition menu_bar_pos;
	menu_bar_pos=(KMenuBar::menuPosition)config->readNumEntry("MenuBarPos", KMenuBar::Top);

  KToolBar::BarPosition tool_bar_pos;
  tool_bar_pos=(KToolBar::BarPosition)config->readNumEntry("ToolBarPos", KToolBar::Top);

//  KToolBar::BarPosition tool_bar_pos;
//  tool_bar_pos=(KToolBar::BarPosition)config->readNumEntry("ToolBarPos", KToolBar::Top);

	menuBar()->setMenuBarPos(menu_bar_pos);
  toolBar()->setBarPos(tool_bar_pos);
	
  // initialize the recent file list
	recent_files.setAutoDelete(TRUE);
	config->readListEntry("Recent Files",recent_files);
	
	uint i;
	for ( i =0 ; i < recent_files.count(); i++){
    recent_files_menu->insertItem(recent_files.at(i));
  }

  QSize size=config->readSizeEntry("Geometry");
	if(!size.isEmpty())
		resize(size);

//  bibtext->setBuchDir(config->readEntry("BookDir", BOOKDIR));

	if (config->hasKey("TmpDir")) {
		tempdir = config->readEntry("TmpDir");
	}
	else {
    tempdir =  kapp->localkdedir() + "/share/apps/bitana/tmp/";
		QString s =  i18n("The working Directory don't exist\nDo you want to set it to:\n");
		s += tempdir;
		int an = KMsgBox::yesNoCancel(this,
  									i18n("Bitana - initialisation"), s);
   	if (an == 1) { // cout << "Yes" << endl;
			QDir d( kapp->localkdedir());

			if (!d.exists("share")) {
				d.mkdir("share");
			}
			d.cd("share");
			if (!d.exists("apps")) {
				d.mkdir("apps");
			}
			d.cd("apps");
			
			if (!d.exists("bitana")) {
				d.mkdir("bitana");
			}
			d.cd("bitana");
			
      if (!d.exists("tmp")) {
				d.mkdir("tmp");
			}
		}
		if (an == 2) {// cout << "No" << endl;
     		QString newdir =
					QFileDialog::getExistingDirectory(tempdir,
							 this, i18n("select working Directory..."));
				if(!newdir.isEmpty()) tempdir = newdir + "/";
    }
		if (an == 3) exit(1); // cout << "Cancel" << endl;
	}

/*
	if (config->hasKey("last Document")) {
		doc->openDocument(config->readEntry("last Document"));
		QString caption=kapp->getCaption();	
  	setCaption(caption+": "+doc->getTitle());
	}
	else
		doc->newDocument();
*/
	config->setGroup("Anzeige");
  view->setAusBr(config->readNumEntry("AusBreite", 50));
  view->setAbbWort(config->readEntry("AbbWord"));
  view->setAbbBeg(config->readNumEntry("AbbBegin"));
  view->setAbbIntWeite(config->readNumEntry("AbbIntWeite"));

   view->setAnzAus(config->readBoolEntry("Ausschnitt",false));
   view->setAnzAbb(config->readBoolEntry("Abbildung", false));
   view->setAnzDar(config->readBoolEntry("Darstellung",true));
   view->setAnzWordAna(config->readBoolEntry("Wortanalyse", false));

  config->setGroup("Intervall");
  view->setIntWort(config->readEntry("Intervallwort"));
  view->setAnalyse(config->readBoolEntry("Analyse", false));
  view->setRichtung(config->readNumEntry("Richtung"));
  view->setSortierung(config->readBoolEntry("SortPos", true));
  view->setIntwVon(config->readNumEntry("IntVon", 2));
  view->setIntwBis(config->readNumEntry("IntBis", 100));

  config->setGroup("Nachbar Words");
  view->setNbrWort(0, config->readEntry("Word1"));
  view->setNbrWort(1, config->readEntry("Word2"));
  view->setNbrWort(2, config->readEntry("Word3"));
  view->setNbrWort(3, config->readEntry("Word4"));
  view->setNbrWort(4, config->readEntry("Word5"));

   config->setGroup("Booktext");
   bibtext->setBuchDir(config->readEntry("Directory", kapp->kde_datadir()+"/bitana/books/"));
   bibtext->setBuchName(config->readEntry("Book", "genesis"));
   bibtext->setKapVersVon(config->readEntry("CapVers-from","1:1"));
   bibtext->setKapVersBis(config->readEntry("CapVers-to","1:31"));
   bibtext->setPosVon(config->readNumEntry("Pos-from", 0));
   bibtext->setPosBis(config->readNumEntry("Pos-to", 1670));
	 tabid = config->readNumEntry("TabId", 1);

 	config->setGroup("Input");
	QStrList inpst;
	inpst.setAutoDelete(true);
	inpst.clear();
	config->readListEntry("Stack", inpst);
	view->setInputStack(&inpst);
}

void BitanaApp::saveProperties(KConfig* )
{
	if( doc->getTitle() != "Untitled" && !doc->isModified()){
		return;
	}
	else{
		QString filename=doc->getPathName()+doc->getTitle();	
    config->writeEntry("filename",filename);
    config->writeEntry("modified",doc->isModified());
		
		const char* tempname = kapp->tempSaveName(filename);
		doc->saveDocument(tempname);
	}
}


void BitanaApp::readProperties(KConfig*)
{
	QString filename = config->readEntry("filename","");
	bool modified = config->readBoolEntry("modified",false);
  if( modified ){
  	bool b_canRecover;
		QString tempname = kapp->checkRecoverFile(filename,b_canRecover);
  	
  	if(b_canRecover){
   			doc->openDocument(tempname);
   			doc->setModified();
   			QFileInfo info(filename);
   			doc->pathName(info.absFilePath());
   			doc->title(info.fileName());
   			QFile::remove(tempname);
		}
	}
 	else if(!filename.isEmpty()){
		doc->openDocument(filename);
	}
  QString caption=kapp->getCaption();	
  setCaption(caption+": "+doc->getTitle());
}		

bool BitanaApp::queryClose()
{
	saveOptions();
	return true;
//	return doc->saveModified();
}

bool BitanaApp::queryExit()
{
	saveOptions();
	return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void BitanaApp::slotFileNew()
{
  slotStatusMsg(i18n("Creating new parameter File..."));
	
	if(!doc->saveModified())
		return;
	
	doc->newDocument();		
  QString caption=kapp->getCaption();	
  setCaption(caption+": "+doc->getTitle());

  slotStatusMsg(i18n("Ready."));
}

void BitanaApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening parameter file..."));
	
	if(!doc->saveModified())
		return;

	QString fileToOpen=QFileDialog::getOpenFileName(QDir::homeDirPath(), "", this, i18n("Open parameter File..."));
	if(!fileToOpen.isEmpty()){
		doc->openDocument(fileToOpen);
    QString caption=kapp->getCaption();	
    setCaption(caption+": "+doc->getTitle());
		addRecentFile(fileToOpen);
	}

  slotStatusMsg(i18n("Ready."));
}

void BitanaApp::slotFileOpenRecent(int id_)
{
  slotStatusMsg(i18n("Opening parameter file..."));
	
	if(!doc->saveModified())
		return;

  doc->openDocument(recent_files.at(id_));
  QString caption=kapp->getCaption();	
  setCaption(caption+": "+doc->getTitle());

  slotStatusMsg(i18n("Ready."));
}

void BitanaApp::slotFileOpenExample(int id_)
{
  slotStatusMsg(i18n("Opening examplefile..."));
	
	if(!doc->saveModified())
		return;

  doc->openDocument(exampdir + example_files.at(id_));
  QString caption=kapp->getCaption();	
  setCaption(caption+": "+doc->getTitle());
	doc->setModified(false);

  slotStatusMsg(i18n("Ready."));
}

void BitanaApp::slotFileSave()
{
  slotStatusMsg(i18n("Saving parameter file..."));
	
	doc->saveDocument(doc->getPathName()+doc->getTitle());

  slotStatusMsg(i18n("Ready."));
}

void BitanaApp::slotFileSaveAs()
{
  slotStatusMsg(i18n("Saving parameter file under new filename..."));

	QString newName=QFileDialog::getSaveFileName(QDir::currentDirPath(), "", this, i18n("Save As..."));
	if(!newName.isEmpty()){
		QFileInfo saveAsInfo(newName);
		doc->title(saveAsInfo.fileName());
		doc->pathName(saveAsInfo.absFilePath());
		doc->saveDocument(newName);
		addRecentFile(newName);
    QString caption=kapp->getCaption();	
    setCaption(caption+": "+doc->getTitle());
	}

  slotStatusMsg(i18n("Ready."));
}

void BitanaApp::slotFileClose()
{
  slotStatusMsg(i18n("Closing parameter file..."));
	
	close();
}

void BitanaApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  if (printer.setup(this)){
			view->print(&printer);
	}

  slotStatusMsg(i18n("Ready."));
}

void BitanaApp::slotFileQuit()
{
	saveOptions();
	// close the first window, the list makes the next one the first again.
	// This ensures that queryClose() is called on each window to ask for closing
	KTMainWindow* w;
	if(memberList){
		for(w=memberList->first(); w; w=memberList->first()){
			// only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
			// the window and the application stay open.
			if(!w->close())
				break;
		}
	}	
}


void BitanaApp::slotViewToolBar()
{
///////////////////////////////////////////////////////////////////
// turn Toolbar on or off
	if( view_menu->isItemChecked(ID_VIEW_TOOLBAR))
	  view_menu->setItemChecked(ID_VIEW_TOOLBAR, false);
	else
		view_menu->setItemChecked(ID_VIEW_TOOLBAR, true);
		
 	enableToolBar();

  slotStatusMsg(i18n("Ready."));
}

void BitanaApp::slotChoiceBook(int i)
{
}

void BitanaApp::slotViewBookBar()
{
  ///////////////////////////////////////////////////////////////////
  // turn Bookbar on or off
	if( view_menu->isItemChecked(ID_VIEW_BOOKBAR)) {
	  view_menu->setItemChecked(ID_VIEW_BOOKBAR, false);
    enableToolBar(KToolBar::Hide, ID_BOOK_BAR);
	}
	else {
		view_menu->setItemChecked(ID_VIEW_BOOKBAR, true);
		enableToolBar(KToolBar::Show, ID_BOOK_BAR);	
  }

  slotStatusMsg(i18n("Ready."));
}

void BitanaApp::slotViewStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
	if( view_menu->isItemChecked(ID_VIEW_STATUSBAR))
	  view_menu->setItemChecked(ID_VIEW_STATUSBAR, false);
	else
		view_menu->setItemChecked(ID_VIEW_STATUSBAR, true);

  enableStatusBar();

  slotStatusMsg(i18n("Ready."));
}


void BitanaApp::slotStatusMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG );
}


void BitanaApp::slotStatusHelpMsg(const char *text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message of whole statusbar temporary (text, msec)
  statusBar()->message(text, 3000);
}

void BitanaApp::slotViewInputs()
{
  ///////////////////////////////////////////////////////////////////
  //turn Inputview on or off
	if( view_menu->isItemChecked(ID_VIEW_INPUTS)) {
	  view_menu->setItemChecked(ID_VIEW_INPUTS, false);
		toolBar()->setButton(ID_VIEW_INPUTS, false);
	}	else {
		view_menu->setItemChecked(ID_VIEW_INPUTS, true);
		toolBar()->setButton(ID_VIEW_INPUTS, true);
  	}
  view->toggleView();
}


void BitanaApp::slotSeTextDar() {

	slotStatusMsg(i18n("Textshowing ..."));
	BTextDarst *tdar = new BTextDarst();

//	tdar->lesText(bibtext);	
	if (tdar->lesText(bibtext->lesBuchName(), bibtext->lesVonPos(), bibtext->lesBisPos(), 0));
	view->markFileItem("dar1.lst");
	slotStatusMsg(i18n("Ready..."));

}

void BitanaApp::slotSeTextAbb() {

	 	slotStatusMsg(i18n("Textimage..."));
		BTextAbbild *tabb = new BTextAbbild();

//  Mit Parameter Word Analyse
		if (tabb->abbild(bibtext->lesBuchName(), view->lesAbbWort(), view->lesAbbBeg(),
	 		view->lesAbbIntWeite(), view->lesAnzWordAna()));
		view->markFileItem("abb1.lst");
	 	delete tabb;	
		slotStatusMsg(i18n("Ready..."));
}


void BitanaApp::slotSeTextAus() {

	slotStatusMsg(i18n("Textcutout..."));
	BTxtAusschn *taus = new BTxtAusschn();
	
//	taus->berText(bibtext, view->liesAusBr());
	if (taus->berText(bibtext->lesBuchName(), bibtext->lesVonPos(), bibtext->lesBisPos(),
		 view->lesAusBr()));
	view->markFileItem("aus1.lst");
	slotStatusMsg(i18n("Ready..."));

}

void BitanaApp::slotSeInter() {

 	slotStatusMsg(i18n("Interval..."));
	BIntervall *sint = new BIntervall();
//	sint->suchIntervall(bibtext, view->lesIntWort(),
	if (sint->suchIntervall(bibtext->lesBuchName(),view->lesIntWort(),bibtext->lesVonPos(), bibtext->lesBisPos(),
		view->lesIntwVon(), view->lesIntwBis(),	view->lesRichtung(), view->lesSortierung()))
		if (view->lesAnalyse()) slotSeAnalyse();	
	view->markFileItem("int1.lst");
	slotStatusMsg(i18n("Ready..."));
}

void BitanaApp::slotSeAnalyse() {
	slotStatusMsg(i18n("Intervalanalysis..."));
	BAnalyse *sana = new BAnalyse();

//	sana->intervallAnalyse(bibtext, view->lesIntWort(),
	if (sana->intervallAnalyse(bibtext->lesBuchName(), view->lesIntWort(),
		view->lesIntwVon(), view->lesIntwBis(),view->lesRichtung()));
//	view->markFileItem("ana1.lst");
	slotStatusMsg(i18n("Ready..."));
}

void BitanaApp::slotSeNabar() {

	slotStatusMsg(i18n("searching neighbour..."));
	BNachbar *nbr = new BNachbar();

	if (nbr->suchNachbar(bibtext->lesBuchName(), view->lesNbrWorte(),
		 bibtext->lesVonPos(), bibtext->lesBisPos()));
	view->markFileItem("nbr1.lst");
  slotStatusMsg(i18n("Ready..."));
}


// Command Callback

void BitanaApp::commandCallback(int id_){
  switch (id_){
    case ID_FILE_NEW:
    	slotFileNew();
    	break;
    case ID_FILE_OPEN:
    	slotFileOpen();
    	break;
    case ID_FILE_SAVE:
    	slotFileSave();
    	break;
    case ID_FILE_SAVE_AS:
    	slotFileSaveAs();
    	break;
    case ID_FILE_CLOSE:
    	slotFileClose();
    	break;
    case ID_FILE_PRINT:
    	slotFilePrint();
    	break;
    case ID_FILE_QUIT:
    	slotFileQuit();
    	break;
   case ID_VIEW_TOOLBAR:
    	slotViewToolBar();
    	break;
		case ID_VIEW_BOOKBAR:
    	slotViewBookBar();
    	break;
    case ID_VIEW_STATUSBAR:
    	slotViewStatusBar();
    	break;
		case ID_VIEW_INPUTS:
			slotViewInputs();
			break;

		case ID_BOOK_SEARCH:
		  searchStart();
			bibtext->slotReturnPressed();			// Aktualisierung der Eingabewerte
			switch (view->tabSelected()){
				case 0:
					if (view->lesAnzAbb()) slotSeTextAbb();
				  if (view->lesAnzAus()) slotSeTextAus();
					if (view->lesAnzDar()) slotSeTextDar();
					break;
				case 1:
					slotSeInter();
					break;
				case 2:
					slotSeNabar();
					break;	
	    }
			searchStop();
   		break;

		case ID_SEARCH_TDAR:
			searchStart();
			slotSeTextDar();
			searchStop();
			break;
	 	case ID_SEARCH_TABB:
			searchStart();
			slotSeTextAbb();
			searchStop();
			break;
		case ID_SEARCH_TAUS:
			searchStart();
			slotSeTextAus();
			searchStop();
			break;
		case ID_SEARCH_INT:
			searchStart();
			slotSeInter();
			searchStop();
			break;
		case ID_SEARCH_ANA:
			searchStart();
			slotSeAnalyse();
			searchStop();
			break;
		case ID_SEARCH_NBR:
			searchStart();
			slotSeNabar();
			searchStop();
			break;
	
    default:
    	break;
	
  }
}

void BitanaApp::statusCallback(int id_){
  switch (id_){
    case ID_FILE_NEW_WINDOW:
    	slotStatusHelpMsg(i18n("Opens a new application window"));
    	break;
    case ID_FILE_NEW:
 	  	slotStatusHelpMsg(i18n("Creates new search parameter"));
 	  	break;
     case ID_FILE_OPEN:
                slotStatusHelpMsg(i18n("Opens an existing seach parameters"));
                break;
    case ID_FILE_OPEN_RECENT:
                slotStatusHelpMsg(i18n("Opens a recently used search parameters"));
                break;
    case ID_FILE_SAVE:
                slotStatusHelpMsg(i18n("Save the actual search paramaters"));
                break;
    case ID_FILE_SAVE_AS:
                slotStatusHelpMsg(i18n("Save the search parameters as..."));
                break;
    case ID_FILE_CLOSE:
        slotStatusHelpMsg(i18n("Closes the actual file"));
        break;
    case ID_FILE_PRINT:
        slotStatusHelpMsg(i18n("Prints the current document"));
        break;
    case ID_FILE_QUIT:{
        QString caption=kapp->getCaption();
        slotStatusHelpMsg(i18n("Exits "+ caption));
        break;
    }

    case ID_VIEW_TOOLBAR:
        slotStatusHelpMsg(i18n("Enables / disables the actual Toolbar"));
        break;
    case ID_VIEW_BOOKBAR:
        slotStatusHelpMsg(i18n("Enables / disables the actual Bookbar"));
        break;
    case ID_VIEW_STATUSBAR:
        slotStatusHelpMsg(i18n("Enables / disables the actual Statusbar"));
        break;
    default:
        break;
  }
}

void BitanaApp::progressStart(int value, QString text)
{

    if (progress_run) {
      QString t;
      t = i18n(" - Can't open progress\nalready is running aprogress ;-(");
			text =+ t;
			QMessageBox::warning(0, i18n("Error"), t);
    	return;
    }
    bitana_progress->show();
    bitana_progress->setTotalSteps(value);
    bitana_progress->setProgress(0);
  	progress_run = true;
  	statusBar()->changeItem(text, ID_STATUS_PROTEXT);
 // kapp->processEvents();

}


void BitanaApp::progressStep(int akt)
{
        bitana_progress->setProgress(akt);
        kapp->processEvents();
}


void BitanaApp::progressEnd()
{

        bitana_progress->reset();
        statusBar()->changeItem("", ID_STATUS_PROTEXT);
        progress_run = false;
        statusBar()->repaint();
        kapp->processEvents();
        bitana_progress->hide();
}


 /** return the actual directory where the biblebooks are saved */
QString  BitanaApp::getBookDir()
{
//      return(bibtext->lesBuchDir() + "he/");
        return(bibtext->lesBuchDir());
}

 /** return the actual directory where the biblebooks in a userlanguage are saved */
QString  BitanaApp::getBookLangDir()
{
        QDir ldir( bibtext->lesBuchDir() + lang + "/" );
        if (ldir.exists()) return(ldir.absPath() + "/");
				        else return(bibtext->lesBuchDir() + "en/");
}

/* return the actual tmp-directory where stored the resultlists
 * of serarching
 */
QString  BitanaApp::getTmpDir()
{
         return(tempdir);
}


/** return the hebrew font-1 for buttons and widgetstitles */
QFont  BitanaApp::getHebFont1()
{
	return(hfont1);
}

/** return the hebrew font-2 for text and multilinewindows */
QFont  BitanaApp::getHebFont2()
{
  return(hfont2);
}

void BitanaApp::searchStart() {

	disableCommand(ID_FILE_NEW);
	disableCommand(ID_FILE_OPEN);
	disableCommand(ID_FILE_OPEN_EXAMPLE);
	disableCommand(ID_FILE_OPEN_RECENT);
	disableCommand(ID_FILE_SAVE);
	disableCommand(ID_FILE_SAVE_AS);
  disableCommand(ID_FILE_QUIT);
	disableCommand(ID_VIEW_INPUTS);

  disableCommand(ID_BOOK_SEARCH);
	disableCommand(ID_SEARCH_TDAR);
	disableCommand(ID_SEARCH_TABB);
	disableCommand(ID_SEARCH_TAUS);
	disableCommand(ID_SEARCH_INT);
	disableCommand(ID_SEARCH_ANA);
	disableCommand(ID_SEARCH_NBR);
	
	enableCommand(ID_STOP);

}


void BitanaApp::searchStop() {

	enableCommand(ID_FILE_NEW);
	enableCommand(ID_FILE_OPEN);
	enableCommand(ID_FILE_OPEN_EXAMPLE);
	enableCommand(ID_FILE_OPEN_RECENT);
	enableCommand(ID_FILE_SAVE);
	enableCommand(ID_FILE_SAVE_AS);
  enableCommand(ID_FILE_QUIT);
  enableCommand(ID_VIEW_INPUTS);

  enableCommand(ID_BOOK_SEARCH);

	enableCommand(ID_SEARCH_TDAR);
	enableCommand(ID_SEARCH_TABB);
	enableCommand(ID_SEARCH_TAUS);
	enableCommand(ID_SEARCH_INT);
	enableCommand(ID_SEARCH_ANA);
	enableCommand(ID_SEARCH_NBR);
	
	disableCommand(ID_STOP);

}
