/***************************************************************************
                          		bitana.h
                             -------------------
    begin                : Mit Dez 29 13:12:29 MET 1999
    copyright            : (C) 1999 by Hans-Jrgen Schumann
    email                : hans@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BITANA_H
#define BITANA_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <qprogressbar.h>

#include <qfont.h>

// include files for KDE 
#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>

//#include "bibtext.h"

// forward declaration of the Bitana classes
class BibDoc;
class BibView;
class BibText;

/**
  * The base class for Bitana application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, 2*toolbar
  * and statusbar. An creates your view.
  * The pointer to the bitana object 	ist defined as global variable.
	* You can use all public members in all methods of the
	*	project with extern BitanaApp *bitana; declaration.
	* Usefull for hebfonts and ohter global options.
	* BitanaApp reimplements the methods that KTMainWindow provides for main window
	* handling and supports keyboard accelerator configuration by using KAccel.
	* @see KTMainWindow
	* @see KApplication
	* @see KConfig
	* @see KAccel
	*
	* @author Automatically Generated by KDevelop, (c) The KDevelop Team.Used and modifyed by Hans-Jrgen Schumann
	* @version
  */
class BitanaApp : public KTMainWindow
{
  Q_OBJECT

  friend class BibView;
	friend class BibDoc;

public:
  /** constructor of BitanaApp, calls all init functions to create the application.
    * @see initMenuBar() initToolBar() ...
    */
  BitanaApp();
  /** The initialisation is moved in this method becourse the extern pointer
		* to bitana is evalible after creating the objekt  and something methods
		* for initialisation use it.
  	*/
  void initBitana();

  ~BitanaApp();
	/** start the progress; example:
	
	<pre>
			extern BitanaApp *bitana;
			...
			bitana->progressStart(100, "new progress");
			for (i=0; i++; i<100)
			{
			....
			  	bitana->progressStep(i);
			....
			}
				  bitana->progressEnd();
	</pre>

	  @param text the text are dispayed in the status bar after progress item
		@param value initial value @see QProgress::setTotalSteps(int)
			*/
	void progressStart(int value, QString text);
	/** runs the progress
		* @param step the value between 0 and value @see progressStart()
		* @see QProgress::progress(int)
		*/
  void progressStep(int step);
	/** the progress is stopped and reset */
  void progressEnd();

  /** returns the actual directory where the biblebooks are stored */
	QString getBookDir();
  /** returns the actual directory where the biblebooks in a userlanguage are stored */
	QString getBookLangDir();
		/** returns the actual tmp-directory where saved the resultlists
		* of serarching
		*/
	QString getTmpDir();
	/** returns the hebrew font-1 for buttons, widgets and titles */
	QFont getHebFont1();
	/** returns the hebrew font-2 for text in multilinewindows or other outputs*/
	QFont getHebFont2();
  /** returns the the current inputline from the hebrew input-help-window
		*/
	QString getInputLine() const;
private:
  /** enables menuentries/toolbar items
  	*/
  void enableCommand(int id_);
  /** disables menuentries/toolbar items
  	*/
  void disableCommand(int id_);
  /** disable commands while starting search */
	void searchStart();
  /** enable commands while starting search */
	void searchStop();
  /** add a opened file to the recent file list and update recent_file_menu
	 */
	void addRecentFile(const char* file);
	/** init the example files, list and update example_file_menu
		*/
	void initExampleFiles(const char* file);
	/** opens a file specified by commandline option
		*/
	void openDocumentFile(const char* _cmdl);
	/** returns a pointer to the current document connected to the KTMainWindow instance and is used by
		* the View class to access the document object's methods
		*/	
  BibDoc* getDocument() const;
	/** returns a pointer to the current view instance and is used by the Doc class
		*/	
  BibView* getView() const;
	/** the configuration object of the application */
	KConfig* config;
	/** the key accelerator container */
	KAccel* key_accel;
  /** file_menu contains all items of the menubar entry "File" */
  QPopupMenu *file_menu;
	/** the recent file menu containing the last five opened files */
	QPopupMenu *recent_files_menu;
	/** the examples file menu containg the examle file in .../bitana/examle/dir */
	QPopupMenu *example_files_menu;
	/** contains the recently used filenames */
	QStrList recent_files;
	/** contains the examle used filenames */
	QStrList example_files;
	
  /** book_menu contains all items of the menubar entry "Book" */
  QPopupMenu *book_menu;
  /** view_menu contains all items of the menubar entry "View" */
  QPopupMenu *view_menu;
	/** search_menu contains all items of the member entry "search" */
	QPopupMenu *search_menu;
  /** help_menu contains all items of the menubar entry "Help" */
  QPopupMenu *help_menu;
  /** view is the main widget which represents your working area. The View
    * class should handle all events of the view widget.  It is kept empty so
    * you can create your view according to your application's needs by
    * changing the view class. */
  BibView *view;
  /** doc represents your actual document and is created only once. It keeps
    * information such as filename and does the serialization of your files.
    */
  BibDoc *doc;
	
	BibText *bibtext;
  QProgressBar *bitana_progress;
	bool progress_run;
//  QString bookdir;
	QString tempdir;
	QString exampdir;
	QString lang;
	int tabid;
	/** Heb-Font1 for Buttons and widgetstitels / menus */
	QFont hfont1;
	/** Heb-Font2 for Text / Matrix and Multilinewindow */
  QFont hfont2;

private slots:
  /** switch argument for slot selection by menu or toolbar ID */
  void commandCallback(int id_);
  /** switch argument for Statusbar help entries on slot selection. Add your ID's help here for toolbars and menubar entries. */
  void statusCallback(int id_);
  /** clears the document in the actual view to reuse it as the new document */
  void slotFileNew();
  /** open a file and load it into the document*/
  void slotFileOpen();
	/** opens a file from the recent files menu */
	void slotFileOpenRecent(int id_);
	/** opens a exafile from file menu */
	void slotFileOpenExample(int d);
  /** save a document */
  void slotFileSave();
  /** save a document by a new filename*/
  void slotFileSaveAs();
  /** asks for saving if the file is modified, then closes the actual file and window*/
  void slotFileClose();
  /** print the actual file */
  void slotFilePrint();
  /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
  	* If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
  	*/
  void slotFileQuit();
  /** put the marked text/object into the clipboard and remove
    *	it from the document
    */

  /** put the marked text/object into the clipboard
  	*/

  /** paste the clipboard into the document
  	*/

  /** toggles the toolbar
  	*/
  void slotViewToolBar();
  /** toggles the bookbar
  	*/
  void slotViewBookBar();
  /** toggles the statusbar
  	*/
  void slotViewStatusBar();
  /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
  	* @param text the text that is displayed in the statusbar
  	*/
  void slotStatusMsg(const char *text);
  /** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
		* statusbar messages that give information about actions for toolbar icons and menuentries.
  	* @param text the text that is displayed in the statusbar
   	*/
  void slotStatusHelpMsg(const char *text);
	/** changes the main view between edit and only output view
		*/
	void slotViewInputs();

	void slotChoiceBook(int i);

// Ausgabe/Suchobjekte

	void slotSeTextDar();
	void slotSeTextAbb();
	void slotSeTextAus();
	void slotSeInter();
	void slotSeAnalyse();
	void slotSeNabar();


public slots:

 signals:
  /** This signal is emited if the stop button is pressed.
		*	The search mehtods must connected to this signal if the programm
		* runs and runs and ...
		*/
	void signalStop();

 	
protected:
 	/** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
		* file
		*/ 	
	void saveOptions();
	/** read general Options again and initialize all variables like the recent file list
	  */
	void readOptions();
	/** initKeyAccel creates the keyboard accelerator items for the available slots and changes the menu accelerators.
		* @see KAccel
		*/
	void initKeyAccel();
  /** initMenuBar creates the menubar and inserts the menupopups as well as creating the helpMenu.
  	* @see KApplication#getHelpMenu
  	*/
  void initMenuBar();
  /** this creates the toolbars.
    */
  void initToolBar();
 /** this creates the Bookbar.
    */
  void initBookBar();
  /** sets up the statusbar for the main window by initialzing a statuslabel.
  	*/
   void initStatusBar();
	/** initializes the document object of the main window that is connected to the view in initView().
		* @see initView();
		*/
	void initDocument();
  /** creates the centerwidget of the KTMainWindow instance and sets it as the view
  	*/
  void initView();
	/** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
		* default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
		* be saved if Modified; on cancel the closeEvent is rejected.
		* @see KTMainWindow#queryClose
		* @see KTMainWindow#closeEvent
		*/
	virtual bool queryClose();
	/** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
		* Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
		* properties.
		* @see KTMainWindow#queryExit
		* @see KTMainWindow#closeEvent
		*/
	virtual bool queryExit();
  /** saves the window properties for each open window during session end to the session config file, including saving the currently
		* opened file by a temporary filename provided by KApplication.
   	* @see KTMainWindow#saveProperties
   	*/
  virtual void saveProperties(KConfig* );
  /** reads the session config file and restores the application's state including the last opened files and documents by reading the
		* temporary files saved by saveProperties()
   	* @see KTMainWindow#readProperties
  	*/
  virtual void readProperties(KConfig* );

};
 
#endif // BITANA_H
