/***************************************************************************
                          blexikon.cpp  -  description
                             -------------------
    begin                : Mon May 1 2000
    copyright            : (C) 2000 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfile.h>
#include <qdir.h>
#include <qmessagebox.h>

#include "blexikon.h"
#include "bitana.h"
#include "resource.h"

#define STRSEP " \t"

BLexikon::BLexikon()
{
 _sprache=999;
}

BLexikon::~BLexikon()
{
 _dat.close();
}

bool BLexikon::listWort(QString wort)
{
 int sprache;
 int a,c,n,m,x;
 QString zeile("");
 QString wo("");

 extern BitanaApp *bitana;

// Achtung bei kyrillischen Zeichensatz.
 c=wort.at(0);
 if(c>0) sprache=1;               // Word is not hebrew
 else sprache=0;

// Create the output file and delete the old version
 QFile a1;
 QDir d=QDir::root();
 if(d.cd(bitana->getTmpDir())) a1.setName(d.filePath("lex1.lst"));
 else
 {
  QMessageBox::warning(0,i18n("Error"),
                         i18n("Cannot find the directory\n")+bitana->getTmpDir());
  return false;
 }
 a1.remove();
 if (!a1.open(IO_WriteOnly))
 {
   QMessageBox::warning(0,i18n("Cannot create the file"),
                         a1.name());
  return false;
 }
 QTextStream as(&a1);

// Make headline for files
 as<<"# Tabelle"<<endl;
 as<<i18n("# \t2\t        Searchword\t295\t        Translated text\t295")<<endl;
 as<<i18n("# Dictionary translate text for ")<<wort<<endl;


// Modify word and revers heb word
 wo=txtUmkehr(wort);

 for(uint i=0;i<wort.length();i++)
 {
  if(wo.at(0)<0)
  {
   if(wo[i]==-22) wo[i]++;
   if(wo[i]==-19) wo[i]++;
   if(wo[i]==-17) wo[i]++;
   if(wo[i]==-13) wo[i]++;
   if(wo[i]==-11) wo[i]++;
   if(wo[i]==45) wo[i]=-33;
  }
  else
  {
   if(wo[i]==45) wo[i]=28;
   if(wo[i]==39) wo[i]=27;
  }
 }

 zeile=findWort(wo,sprache);
 c=0;
 while(c<8)
 {
  x=zeile.at(0);
  if(x!=49 && x!=50 && x!=51)           // Create list line
  {
   m=0;
   for(n=0;n<(int)zeile.length();n++) if(zeile.at(n)==10) m++; // Number of words
   a=0;
   while(zeile.at(a)!=10) a++;
   wort="";
   for(n=0;n<a;n++) wort.insert(n,zeile.at(n));    // Reconstruct searchcolum word
   wo=txtUmkehr(wort);
   if(!sprache) wo=wo.rightJustify(35,' ');
   as<<wo;
   m--;
   while(m>0)
   {
    while(zeile.at(0)!=10) zeile=zeile.right(zeile.length()-1);
    zeile=zeile.right(zeile.length()-1);
    a=0;
    while(zeile.at(a)!=10) a++;
    wort="";
    for(n=0;n<a;n++) wort.insert(n,zeile.at(n));    // Reconstruct findcolum words
    wo=txtUmkehr(wort);
    if(sprache) wo=wo.rightJustify(35,' ');
    as<<STRSEP<<wo<<endl;
    m--;
   }
  }
  else
  {
   as<<i18n("       Word not find, next word is ")<<endl;
   if(x==51) as<<i18n("       End of vocabulary")<<endl;
  }
  if(x!=51) zeile=nextWort();
  else c=8;
  c++;
 }
 a1.close();
 return true;
}

QString BLexikon::findWort(QString wort, int sp)
{
 int i;
 int j[3];
 int a,x;
 bool nf,ok=false;
 QString zeile("");

 ok=false;
 zeile="";
 if(!sp) wort.append("\n");

 if(_sprache!=sp) nf=_ladIndex(sp);
 if(!nf)
 {
  zeile.append("4");
  return false;
 }
 // Create index for access
 for(i=0;i<3;i++) j[i]=0;

 if(wort[0]==10 || wort[0]==32)
 {
  zeile.append("3");                     // End of vokabulary
  return zeile;
 }

 for(i=0;i<3;i++)
 {
  x=wort[i];
  if(x==32) break;
  if(sp)
  {
   if(x>64 && x<91) x-=64;
   if(x>96 && x<123) x-=96;
  }
  else  if(x>-33) x+=33;
  if(x==39) x=27;
  if(x==45) x=28;
  if(x<0 || x>28) x=0;
  j[i]=x;
 }

 if(_tab.idx[j[0]][j[1]][j[2]]>=_dat.size())
 {
  zeile.append("3");                     // End of vokabulary
  return zeile;
 }
 else ok=true;
 _dat.at(_tab.idx[j[0]][j[1]][j[2]]);

 nf=false;
 while(ok)
 {
  _aktidx=_dat.at();
  a=_lesWort();                            // Read word for compare
  if(a<0)
  {
   zeile.append("3");                     // End of vokabulary
   return zeile;
  }
  if(sp) while(_vgl[0]<=32 || _vgl[0]<0)
  {
   a=_lesWort(); // Hebrew words ignore
   if(a<0)
   {
    zeile.append("3");                     // End of vokabulary
    return zeile;
   }
  }
  else  while(_vgl[0]>0)
  {
   a=_lesWort();     // English words ignore
   if(a<0)
   {
    zeile.append("3");                     // End of vokabulary
    return zeile;
   }
  }
  if(sp) for(i=0;i<SPBRT;i++) if(_vgl[i]==32 || _vgl[i]==10 || _vgl[i]==0)
                              {
                               x=_vgl[i];
                               _vgl[i]=0;
                               break;
                              }
  if(strncmp(wort,_vgl,wort.length())<=0) ok=false;     // Compare word
  if(strcmp(wort,_vgl)==0) nf=true;
  if(sp) _vgl[i]=x;
 }

 if(nf)
 {
  while(nf)
  {
   if(_vgl[0]<0)
   {
    for(i=0;i<a-1;i++) if(_vgl[i]==-33) _vgl[i]=45;
    zeile.append(_vgl);                           // Write hebrew word
   }
   else
   {
    for(i=0;i<a-1;i++)
    {
     if(_vgl[i]==27) _vgl[i]=39;
     if(_vgl[i]==28) _vgl[i]=45;
    }
    zeile.append(_vgl);                           // Write english word
   }
   if(sp && _vgl[0]<0) ok=true;
   if(!sp && _vgl[0]>0) ok=true;
   for(a=0;a<SPBRT;a++) _vgl[a]=' ';
   a=_lesWort();
   if(a<0) nf=false;
   if(!sp && _vgl[0]<0) nf=false;
   if(sp && _vgl[0]>0) nf=false;
  }
 }
 else
 {
  x=strncmp(wort,_vgl,wort.length());
  if(x!=0 || _tab.idx[j[0]][j[1]][j[2]]>=_dat.size()) zeile.append("2");
  else zeile.append("1");
 }
 return zeile;
}

QString BLexikon::nextWort()
{
 int a,i;
 bool nf=false;
 QString zeile("");

 _dat.at(_aktidx);
 a=_lesWort();                      // Read word for compare
 if(a>0) nf=true;
 else
 {
  zeile.append("3");                     // End of vokabulary
  return zeile;
 }

 if(nf)
 {
  while(nf)
  {
   if(_vgl[0]<0)
   {
    for(i=0;i<a-1;i++) if(_vgl[i]==-33) _vgl[i]=45;
    zeile.append(_vgl);                           // Write hebrew word
   }
   else
   {
    for(i=0;i<a-1;i++)
    {
     if(_vgl[i]==27) _vgl[i]=39;
     if(_vgl[i]==28) _vgl[i]=45;
    }
    zeile.append(_vgl);                           // Write english word
   }
   for(a=0;a<SPBRT;a++) _vgl[a]=' ';
   a=_lesWort();
   if(a<0) nf=false;
   if(!_sprache && _vgl[0]<0) nf=false;
   if(_sprache && _vgl[0]>0) nf=false;
  }
 }
 return zeile;
}

bool BLexikon::_ladIndex(int sprache)
{
 QFile e;

 extern BitanaApp *bitana;

 if(_sprache!=sprache)
 {
  QDir d=QDir::root();
  if (d.cd(bitana->getBookLangDir()))
  {
   if(sprache) e.setName(d.filePath("traheb.idx"));
   else  e.setName(d.filePath("hebtra.idx"));
  }
  else
  {
   QMessageBox::warning(0,i18n("Error"),
                          i18n("Cannot find the directory\n")+bitana->getBookLangDir());
   return false;
  }
  QString name=e.name();
  if (e.open(IO_ReadOnly))
  {
   e.readBlock(_tab.idxca,e.size());
  }
  else
  {
   QMessageBox::warning(0,i18n("Error"),
                          i18n("Cannot find the file \n")+name);
   return false;
  }
  if(sprache) _dat.setName(d.filePath("traheb.lex"));
  else  _dat.setName(d.filePath("hebtra.lex"));
  if (!_dat.open(IO_ReadOnly))
  {
   name=_dat.name();
   QMessageBox::warning(0,i18n("Error"),
                          i18n("Cannot find the file \n")+name);
   return false;
  }
  _sprache=sprache;
  e.close();
 }
 return true;
}

QString BLexikon::txtUmkehr(QString wort)
{
 QString wo("");
 if(wort.length()>0 && wort.at(0)<0) for(int i=wort.length();i>0;i--) wo+=wort.at(i-1);
 else wo=wort;
 return wo;
}

int BLexikon::_lesWort()
{
 for(int i=0;i<SPBRT;i++) _vgl[i]=0;
 _aktidx=_dat.at();
 int n=_dat.readLine(_vgl,SPBRT);
 return n;
}

