/***************************************************************************
                          btextdarst.cpp  -  description
                             -------------------
    begin                : Tue Nov 30 1999
    copyright            : (C) 1999 by Heinz Schumann
    email                : heinz@bitana.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <kapp.h>
#include <qmessagebox.h>
#include <qdir.h>
#include <qfile.h>

#include "btextdarst.h"
#include "btxtbuch.h"
#include "bhebidx.h"
#include "bgematria.h"
#include "bitana.h"

#define SPBRT  36
#define STRSEP "\t"

BTextDarst::BTextDarst()
{

 // Make a instance for KHebIdx, KBooks and KGematria
 gem=new BGematria();                  // Gematria
 ger=new BTxtBuch();                   // Ger or engl text
 heb=new BHebIdx();                    // Hebrew text
}

BTextDarst::~BTextDarst()
{
 delete gem;
 delete ger;
 delete heb;
}

bool BTextDarst::lesText(QString book, int bpos, int epos, int lagu)
{
 int i,j,k=0;
 int lnh,lng=0;
 int lg,lh;
 bool ok;
 char zlh[SPBRT+1];
 char zlg[SPBRT+1];
 QFile a1, a2;
 extern BitanaApp *bitana;

 _stop = false;

 connect(bitana, SIGNAL(signalStop()), this, SLOT(slotStop()));

// Open the files to write
 QDir d=QDir::root();
 if (d.cd(bitana->getTmpDir())) a1.setName(d.filePath("dar1.lst"));
 else
 {
  QMessageBox::warning(0,i18n("Cannot find the working directory"),
                          bitana->getTmpDir());
  return FALSE;
 }
 a2.setName(d.filePath("dar2.lst"));

// Read the first vers on hebrew text to control
 i=heb->lesVers(book, bpos);
 if(i==0)
 {
  QMessageBox::warning(0,i18n("Error"),
                 i18n("File of index is corrupt or \n chapter/verse not present"));
  return FALSE;
 }


// Read the first verse on german or english text to control
 ok=ger->lesText(book, heb->versdat.kap,heb->versdat.vers);
 if(!ok) return FALSE;

// Craete file head line
 if (!a1.open(IO_WriteOnly))
 {
   QMessageBox::warning(0,i18n("Cannot create the file"),
                         a1.name());
 }

 QString zeile;
 QString tmp=book.upper();

 QTextStream as(&a1);

 if (!a2.open(IO_WriteOnly))
 {
   QMessageBox::warning(0,i18n("Cannot create the file"),
                         a2.name());
 }

 QString     tabstr;
 QTextStream tab(&a2);

// Make headline for files
 as<<"# Tabelle"<<endl;
 tab<<"# Tabelle"<<endl;
//   as<<"# 2            Bibeltext350            Hebraeischer Text350"<<endl;
 as<<i18n("# \t2\t          Text of Kingsbible\t350\t       Hebrew text\t350")<<endl;
// tabstr="# 9Kap:Vers80Worte50Buchst50Absolute80Revers80Reduziert80Ordinal80Quadrat80Atbasch80";
 tabstr=i18n("# \t9\tChap:Vers\t80\tWords\t50\tLetters\t50\tAbsolute\t80\tRevers\t80\tReduced\t80\tOrdinal\t80\tSquared\t80\tAtbach\t80");
 tab<<tabstr<<endl;
 tmp=book.upper();
 as<<i18n("# Textshowing ")<<tmp;
 tab<<i18n("# Gematric for textshowing ")<<tmp;
 heb->posKap(book, bpos);
 tmp=heb->versdat.kapvers;
 as<<i18n(" from")<<tmp.left(6);
 tab<<i18n(" from")<<tmp.left(6);
 heb->posKap(book, epos);
 tmp=heb->versdat.kapvers;
 as<<i18n(" to")<<tmp.left(6)<<endl;
 tab<<i18n(" to")<<tmp.left(6)<<endl;

// Begin of read Text
 bitana->progressStart(epos-bpos, i18n("Create text ..."));
 j=bpos;
 while(j<epos)
 {
  if(_stop)
  {
   bitana->progressEnd();
   a1.close();
   a2.close();
   a1.remove();
   a2.remove();
   return false;
  }
  bitana->progressStep(j-bpos);
  i=heb->lesVers(book,j);                 // Read hebrew text
  ok=ger->lesText(book, heb->versdat.kap,heb->versdat.vers); // Read language text
  if(i==0 || !ok) return FALSE;
  gem->berGematria(heb->text);       // Calculate gematria


// Create gematria line
  tabstr=heb->versdat.kapvers;
  for(k=0;k<8;k++)
  {
   tmp.setNum(gem->gemsum[k]);
   tabstr +=SEP+tmp;
  }
  tab<<tabstr<<endl;

// Begin make lines text
  j=i+1;
  lnh=heb->text.length();
  lng=ger->text.length();
  lg=lh=0;
  ok=TRUE;


  while(lh<lnh || lg<lng)
  {
   zeile="";
   for(k=0;k<SPBRT;k++) zlh[k]=' ';
   for(k=0;k<SPBRT;k++) zlg[k]=' ';
   if(ok) zeile.append(heb->versdat.kapvers);
   else zeile.fill(' ',8);
   ok=false;

// Make german line
   if(lg<lng)
   {
    for(k=0;k<SPBRT;k++) if((k+lg)<lng) zlg[k]=ger->text.at(k+lg);
    while(zlg[k]!=' ' && k>0)
    {
     zlg[k]=' ';
     k--;
    }
    lg=lg+k;
   }
   zlg[SPBRT]='\0';
   zeile.append(zlg);

   zeile.append(STRSEP);
   zeile.append("|");

// Make hebrew line
   if(lh<lnh)
   {
    for(k=0;k<SPBRT;k++) if((k+lh)<lnh) zlh[SPBRT-k-1]=heb->text.at(k+lh);
    while((k+lh)<lnh && heb->text.at(k+lh)!=' ')
    {
     zlh[SPBRT-k-1]=' ';
     k--;
    }
    lh=lh+k;
   }
   zlh[SPBRT]='\0';
   zeile.append(zlh);
   as<<zeile<<endl;                        // Write line at file
  }
 }
 bitana->progressEnd();

// Closed the files
 a1.close();
 a2.close();
 return true;
}

void BTextDarst::slotStop()
{
  _stop = true;
}


















































































